/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.indexing.shared.download.SharedIndexAuthHolder;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.io.HttpRequests;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.tukaani.xz.XZInputStream;

@Service
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0007R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexDownloadJson;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "downloadJsonXz", "Lcom/fasterxml/jackson/databind/node/ObjectNode;", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "url", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "intellij.indexing.shared"})
public final class SharedIndexDownloadJson {
    private final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    @Nullable
    public final ObjectNode downloadJsonXz(@NotNull SharedIndexLookupRequest request, @NotNull String url, @NotNull ProgressIndicator indicator) {
        Object object;
        byte[] byArray;
        boolean bl;
        block27: {
            Intrinsics.checkNotNullParameter((Object)request, (String)"request");
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
            this.LOG.debug("Checking " + url + " for " + request + "...");
            boolean $i$f$service = false;
            Class<SharedIndexAuthHolder> serviceClass$iv = SharedIndexAuthHolder.class;
            Object object2 = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object2 == null) {
                throw (Throwable)new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ')');
            }
            Map<String, String> headers = ((SharedIndexAuthHolder)object2).resolveHeaders(url, request, indicator);
            Logger LOG$iv = this.LOG;
            boolean $i$f$handleHttpDownloadExceptions = false;
            try {
                bl = false;
                byArray = HttpRequests.request((String)url).productNameAsUserAgent().accept("application/octet-stream, application/xz").tuner(new HttpRequests.ConnectionTuner(url, headers, indicator){
                    final /* synthetic */ String $url$inlined;
                    final /* synthetic */ Map $headers$inlined;
                    final /* synthetic */ ProgressIndicator $indicator$inlined;
                    {
                        this.$url$inlined = string2;
                        this.$headers$inlined = map;
                        this.$indicator$inlined = progressIndicator;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    public final void tune(@NotNull URLConnection tuner) {
                        Intrinsics.checkNotNullParameter((Object)tuner, (String)"tuner");
                        Map $this$forEach$iv = this.$headers$inlined;
                        boolean $i$f$forEach = false;
                        Map map = $this$forEach$iv;
                        boolean bl = false;
                        Iterator<Map.Entry<K, V>> iterator = map.entrySet().iterator();
                        while (iterator.hasNext()) {
                            void k;
                            Map.Entry<K, V> element$iv;
                            Map.Entry<K, V> $dstr$k$v = element$iv = iterator.next();
                            boolean bl2 = false;
                            Map.Entry<K, V> entry = $dstr$k$v;
                            boolean bl3 = false;
                            String string2 = (String)entry.getKey();
                            entry = $dstr$k$v;
                            bl3 = false;
                            String v = (String)entry.getValue();
                            tuner.addRequestProperty((String)k, v);
                        }
                    }
                }).throwStatusCodeException(true).readBytes(indicator);
                break block27;
            }
            catch (ConnectException e$iv) {
                LOG$iv.debug("Cannot connect to the host for " + url + " for " + request + ". " + e$iv.getMessage());
            }
            catch (UnknownHostException e$iv) {
                LOG$iv.debug("Cannot resolve host for " + url + " for " + request + ". " + e$iv.getMessage());
            }
            catch (SocketTimeoutException e$iv) {
                LOG$iv.debug("Connection expired by timeout at " + url + " for " + request + ". " + e$iv.getMessage());
            }
            catch (HttpRequests.HttpStatusException e$iv) {
                if (e$iv.getStatusCode() < 500) {
                    LOG$iv.debug("No data available for " + url + " for " + request + ". " + e$iv.getStatusCode());
                } else {
                    LOG$iv.info("No data available for " + url + " for " + request + ". " + e$iv.getStatusCode());
                }
            }
            catch (IOException e$iv) {
                LOG$iv.debug("Failed to download " + url + " for " + request + ". " + e$iv.getMessage());
            }
            catch (Throwable t$iv) {
                if (t$iv instanceof ControlFlowException) {
                    throw t$iv;
                }
                LOG$iv.warn("Failed to download " + url + " for " + request + ". " + t$iv.getMessage());
            }
            byArray = null;
        }
        if (byArray == null) {
            return null;
        }
        byte[] rawDataXZ = byArray;
        try {
            byte[] byArray2;
            object = new ByteArrayInputStream(rawDataXZ);
            bl = false;
            boolean bl2 = false;
            Throwable throwable = null;
            try {
                byte[] byArray3;
                ByteArrayInputStream input = (ByteArrayInputStream)object;
                boolean bl3 = false;
                Closeable closeable = (Closeable)new XZInputStream((InputStream)input);
                boolean bl4 = false;
                boolean bl5 = false;
                Throwable throwable2 = null;
                try {
                    XZInputStream it = (XZInputStream)closeable;
                    boolean bl6 = false;
                    byArray3 = ByteStreamsKt.readBytes((InputStream)((InputStream)it));
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                byArray2 = byArray3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
            object = byArray2;
        }
        catch (Throwable e) {
            this.LOG.warn("Failed to unpack data from " + url + " for " + request + ". " + e.getMessage());
            return null;
        }
        Object rawData = object;
        try {
            JsonNode jsonNode = new ObjectMapper().readTree((byte[])rawData);
            if (jsonNode == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.fasterxml.jackson.databind.node.ObjectNode");
            }
            object = (ObjectNode)jsonNode;
        }
        catch (Throwable e) {
            this.LOG.warn("Failed to read JSON from " + url + " for " + request + ". " + e.getMessage());
            return null;
        }
        return object;
    }

    public SharedIndexDownloadJson() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexDownloadJson.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
    }
}

