/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.download;

import com.intellij.indexing.shared.download.SharedIndexAuthException;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtension;
import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtensionKt;
import com.intellij.indexing.shared.download.SharedIndexLookupRequest;
import com.intellij.indexing.shared.download.SharedIndexLookupResult;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ*\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rR\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/indexing/shared/download/SharedIndexAuthHolder;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "resolveHeaders", "", "", "fullRequestUrl", "request", "Lcom/intellij/indexing/shared/download/SharedIndexLookupRequest;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "response", "Lcom/intellij/indexing/shared/download/SharedIndexLookupResult;", "intellij.indexing.shared"})
public final class SharedIndexAuthHolder {
    private final Logger LOG;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Map<String, String> resolveHeaders(@NotNull String fullRequestUrl, @NotNull SharedIndexLookupRequest request, @NotNull ProgressIndicator indicator) {
        Map<String, String> map;
        Intrinsics.checkNotNullParameter((Object)fullRequestUrl, (String)"fullRequestUrl");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        String authId = request.getAuthId();
        if (authId == null) {
            boolean bl = false;
            return MapsKt.emptyMap();
        }
        SharedIndexDownloadAuthExtension it = SharedIndexDownloadAuthExtensionKt.resolveIndexDownloadAuthExtension(authId);
        if (it == null) {
            throw (Throwable)new SharedIndexAuthException("Failed to find the shared index auth extension '" + authId + '\'', null, 2, null);
        }
        ProgressIndicator $this$withPushPop$iv = indicator;
        boolean $i$f$withPushPop = false;
        boolean wasIndeterminate$iv = $this$withPushPop$iv.isIndeterminate();
        $this$withPushPop$iv.pushState();
        try {
            Map<String, String> map2;
            boolean bl = false;
            try {
                map2 = it.tryGenerateToken(fullRequestUrl, indicator);
            }
            catch (Throwable t) {
                this.LOG.warn("Failed to get shared indexes request headers " + "from the auth extension '" + authId + "' for " + fullRequestUrl + ' ' + "and " + request + ". " + t.getMessage(), t);
                map2 = null;
            }
            map = map2;
        }
        finally {
            $this$withPushPop$iv.setIndeterminate(wasIndeterminate$iv);
            $this$withPushPop$iv.popState();
        }
        Map<String, String> headers = map;
        if (headers == null) {
            throw (Throwable)new SharedIndexAuthException("Failed to get shared indexes request headers " + "from the auth extension '" + authId + "' for " + fullRequestUrl + ' ' + "and " + request, null, 2, null);
        }
        return headers;
    }

    @NotNull
    public final Map<String, String> resolveHeaders(@NotNull String fullRequestUrl, @NotNull SharedIndexLookupResult response, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)fullRequestUrl, (String)"fullRequestUrl");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        return this.resolveHeaders(fullRequestUrl, response.getRequest(), indicator);
    }

    public SharedIndexAuthHolder() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(SharedIndexAuthHolder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        this.LOG = logger;
    }
}

