/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce.login;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.impl.GenericNotifierImpl;
import com.intellij.openapi.vcs.ui.VcsBalloonProblemNotifier;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.perforce.ConnectionId;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionProblemsNotifier;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class Notifier {
    @NonNls
    public static final String INSPECT = "inspect";
    @NonNls
    public static final String FIX = "fix";
    @NonNls
    public static final String RETRY = "retry";
    @NonNls
    public static final String OFFLINE = "offline";
    private final Project myProject;
    private final PerforceSettings mySettings;
    private final MyInnerNotifier myInnerNotifier;

    public Notifier(Project project, PerforceLoginManager loginManager, PerforceSettings perforceSettings) {
        this.myProject = project;
        this.mySettings = perforceSettings;
        this.myInnerNotifier = new MyInnerNotifier(this.myProject, loginManager);
    }

    public void ensureNotify(P4Connection connection) {
        if (!this.mySettings.ENABLED || !this.mySettings.USE_LOGIN) {
            return;
        }
        this.myInnerNotifier.ensureNotify(connection);
    }

    public void removeLazyNotification(P4Connection connection) {
        this.myInnerNotifier.removeLazyNotification(connection);
    }

    public void showPasswordWasOk(boolean value) {
        if (value) {
            new VcsBalloonProblemNotifier(this.myProject, PerforceBundle.message((String)"login.successful", (Object[])new Object[0]), MessageType.INFO).run();
        } else {
            new VcsBalloonProblemNotifier(this.myProject, PerforceBundle.message((String)"login.not.logged.into.p4", (Object[])new Object[0]), MessageType.ERROR).run();
        }
    }

    public boolean isEmpty() {
        return this.myInnerNotifier.isEmpty();
    }

    public void clear() {
        this.myInnerNotifier.clear();
    }

    private static final class MyInnerNotifier
    extends GenericNotifierImpl<P4Connection, ConnectionId> {
        private final PerforceLoginManager myLoginManager;

        private MyInnerNotifier(Project project, PerforceLoginManager loginManager) {
            super(project, "Perforce", PerforceBundle.message((String)"login.not.logged.in.title", (Object[])new Object[0]), NotificationType.ERROR);
            this.myLoginManager = loginManager;
        }

        @NotNull
        @NlsContexts.NotificationContent
        protected String getNotificationContent(P4Connection connection) {
            String string = PerforceBundle.message((String)"login.error.notification", (Object[])new Object[]{connection.getWorkingDirectory(), Notifier.FIX, Notifier.INSPECT});
            if (string == null) {
                MyInnerNotifier.$$$reportNull$$$0(0);
            }
            return string;
        }

        protected boolean ask(P4Connection obj, String description) {
            if (Notifier.FIX.equals(description)) {
                return this.myLoginManager.checkAndRepair(obj);
            }
            if (Notifier.INSPECT.equals(description)) {
                PerforceConnectionProblemsNotifier.showConnectionState(this.myProject, true);
                return false;
            }
            return false;
        }

        @NotNull
        protected ConnectionId getKey(P4Connection obj) {
            ConnectionId connectionId = obj.getId();
            if (connectionId == null) {
                MyInnerNotifier.$$$reportNull$$$0(1);
            }
            return connectionId;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "org/jetbrains/idea/perforce/perforce/login/Notifier$MyInnerNotifier";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNotificationContent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getKey";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }
}

