/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.perforce;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsConnectionProblem;
import com.intellij.openapi.vcs.VcsException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.MessageManager;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.login.PerforceLoginManager;

public class PerforceAuthenticationException
extends VcsConnectionProblem {
    private final P4Connection myConnection;
    private final Project myProject;

    public PerforceAuthenticationException(@Nls String message, @NotNull P4Connection connection, Project project) {
        if (connection == null) {
            PerforceAuthenticationException.$$$reportNull$$$0(0);
        }
        super(message);
        this.myConnection = connection;
        this.myProject = project;
    }

    public PerforceAuthenticationException(PerforceAuthenticationException cause) {
        super((VcsConnectionProblem)cause);
        this.myConnection = cause.myConnection;
        this.myProject = cause.myProject;
    }

    public boolean attemptQuickFix(boolean mayDisplayDialogs) {
        PerforceSettings settings = PerforceSettings.getSettings(this.myProject);
        if (!settings.USE_LOGIN && this.getMessage().contains("Perforce password (P4PASSWD) invalid or unset")) {
            if (mayDisplayDialogs && PerforceAuthenticationException.askEnableLogin(PerforceBundle.message((String)"login.password.invalid.or.unset", (Object[])new Object[0]), this.myProject) && PerforceLoginManager.getInstance(this.myProject).checkAndRepair(this.myConnection)) {
                return true;
            }
            PerforceLoginManager.getInstance(this.myProject).ensureNotifyAboutDisabledLogin(this.myConnection);
            return false;
        }
        if (mayDisplayDialogs) {
            return PerforceLoginManager.getInstance(this.myProject).checkAndRepair(this.myConnection);
        }
        PerforceVcs.getInstance(this.myProject).runBackgroundTask(PerforceBundle.message((String)"connection.verifying", (Object[])new Object[0]), PerformInBackgroundOption.ALWAYS_BACKGROUND, () -> {
            try {
                PerforceLoginManager.getInstance(this.myProject).check(this.myConnection, true);
            }
            catch (VcsException e) {
                PerforceLoginManager.getInstance(this.myProject).getNotifier().ensureNotify(this.myConnection);
            }
        });
        return false;
    }

    public static boolean askEnableLogin(@NlsContexts.DialogMessage String msg, Project project) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return false;
        }
        int dialogResult = MessageManager.showDialog(project, msg, PerforceBundle.message((String)"dialog.title.perforce", (Object[])new Object[0]), new String[]{CommonBundle.getYesButtonText(), CommonBundle.getNoButtonText(), PerforceBundle.message((String)"connection.go.offline", (Object[])new Object[0])}, 0, Messages.getQuestionIcon());
        if (dialogResult == 0) {
            PerforceSettings.getSettings((Project)project).USE_LOGIN = true;
            PerforceConnectionManager.getInstance(project).updateConnections();
            return true;
        }
        if (dialogResult == 2) {
            PerforceSettings.getSettings(project).disable(true);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/perforce/PerforceAuthenticationException", "<init>"));
    }
}

