/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.changesBrowser;

import com.intellij.DynamicBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.SelectFromListDialog;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.versionBrowser.ChangeBrowserSettings;
import com.intellij.openapi.vcs.versionBrowser.StandardVersionFilterComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.changesBrowser.PerforceChangeBrowserSettings;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceVersionFilterComponent
extends StandardVersionFilterComponent<PerforceChangeBrowserSettings> {
    private TextFieldWithBrowseButton myUserField;
    private TextFieldWithBrowseButton myClientField;
    private JCheckBox myUseUserFilter;
    private JCheckBox myUseClientFilter;
    private JPanel myPanel;
    private final Project myProject;
    private JPanel myStandardPanel;
    private final P4Connection myConnection;

    public PerforceVersionFilterComponent(Project project, P4Connection connection, boolean showDateFilter) {
        super(showDateFilter);
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myStandardPanel.setLayout(new BorderLayout());
        this.myStandardPanel.add(super.getStandardPanel(), "Center");
        this.myConnection = connection;
        this.init(new PerforceChangeBrowserSettings());
    }

    protected void init(@NotNull PerforceChangeBrowserSettings settings) {
        if (settings == null) {
            PerforceVersionFilterComponent.$$$reportNull$$$0(0);
        }
        super.init((ChangeBrowserSettings)settings);
        this.installBrowseClientsAction();
        this.installBrowseUsersAction();
    }

    private void installBrowseUsersAction() {
        this.myUserField.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    List<String> clients = PerforceRunner.getInstance(PerforceVersionFilterComponent.this.myProject).getUsers(PerforceVersionFilterComponent.this.myConnection);
                    if (clients.isEmpty()) {
                        Messages.showMessageDialog((String)PerforceBundle.message((String)"message.text.cannot.find.user", (Object[])new Object[0]), (String)PerforceBundle.message((String)"dialog.title.select.user", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                        return;
                    }
                    SelectFromListDialog selectDialog = new SelectFromListDialog(PerforceVersionFilterComponent.this.myProject, clients.toArray(), Object::toString, PerforceBundle.message((String)"dialog.title.select.user", (Object[])new Object[0]), 0);
                    if (selectDialog.showAndGet()) {
                        PerforceVersionFilterComponent.this.myUserField.setText(selectDialog.getSelection()[0].toString());
                    }
                }
                catch (VcsException e1) {
                    Messages.showErrorDialog((String)PerforceBundle.message((String)"message.text.cannot.load.users", (Object[])new Object[]{e1.getLocalizedMessage()}), (String)PerforceBundle.message((String)"dialog.title.select.user", (Object[])new Object[0]));
                }
            }
        });
    }

    private void installBrowseClientsAction() {
        this.myClientField.getButton().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    List<String> clients = PerforceRunner.getInstance(PerforceVersionFilterComponent.this.myProject).getClients(PerforceVersionFilterComponent.this.myConnection);
                    if (clients.isEmpty()) {
                        Messages.showMessageDialog((String)PerforceBundle.message((String)"message.text.cannot.find.client", (Object[])new Object[0]), (String)PerforceBundle.message((String)"dialog.title.select.client", (Object[])new Object[0]), (Icon)Messages.getInformationIcon());
                        return;
                    }
                    SelectFromListDialog selectDialog = new SelectFromListDialog(PerforceVersionFilterComponent.this.myProject, clients.toArray(), Object::toString, PerforceBundle.message((String)"dialog.title.select.client", (Object[])new Object[0]), 0);
                    if (selectDialog.showAndGet()) {
                        PerforceVersionFilterComponent.this.myClientField.setText(selectDialog.getSelection()[0].toString());
                    }
                }
                catch (VcsException e1) {
                    Messages.showErrorDialog((String)PerforceBundle.message((String)"message.text.cannot.load.clients", (Object[])new Object[]{e1.getLocalizedMessage()}), (String)PerforceBundle.message((String)"dialog.title.select.client", (Object[])new Object[0]));
                }
            }
        });
    }

    protected void installCheckBoxListener(@NotNull ActionListener filterListener) {
        if (filterListener == null) {
            PerforceVersionFilterComponent.$$$reportNull$$$0(1);
        }
        super.installCheckBoxListener(filterListener);
        this.myUseClientFilter.addActionListener(filterListener);
        this.myUseUserFilter.addActionListener(filterListener);
    }

    protected void initValues(@NotNull PerforceChangeBrowserSettings settings) {
        if (settings == null) {
            PerforceVersionFilterComponent.$$$reportNull$$$0(2);
        }
        super.initValues((ChangeBrowserSettings)settings);
        this.myUseClientFilter.setSelected(settings.USE_CLIENT_FILTER);
        this.myUseUserFilter.setSelected(settings.USE_USER_FILTER);
        this.myClientField.setText(settings.CLIENT);
        this.myUserField.setText(settings.USER);
    }

    public void saveValues(@NotNull PerforceChangeBrowserSettings settings) {
        if (settings == null) {
            PerforceVersionFilterComponent.$$$reportNull$$$0(3);
        }
        super.saveValues((ChangeBrowserSettings)settings);
        settings.USE_CLIENT_FILTER = this.myUseClientFilter.isSelected();
        settings.USE_USER_FILTER = this.myUseUserFilter.isSelected();
        settings.CLIENT = this.myClientField.getText();
        settings.USER = this.myUserField.getText();
    }

    protected void updateAllEnabled(@Nullable ActionEvent e) {
        super.updateAllEnabled(e);
        PerforceVersionFilterComponent.updatePair((JCheckBox)this.myUseUserFilter, (JComponent)this.myUserField, (ActionEvent)e);
        PerforceVersionFilterComponent.updatePair((JCheckBox)this.myUseClientFilter, (JComponent)this.myClientField, (ActionEvent)e);
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            PerforceVersionFilterComponent.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterListener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/changesBrowser/PerforceVersionFilterComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/changesBrowser/PerforceVersionFilterComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "installCheckBoxListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initValues";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "saveValues";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JCheckBox jCheckBox;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JCheckBox jCheckBox2;
        JPanel jPanel2;
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 3, null, null, null));
        this.myUseUserFilter = jCheckBox2 = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox2, DynamicBundle.getBundle((String)"messages/PerforceBundle", PerforceVersionFilterComponent.class).getString("label.browse.changes.filter.user"));
        jPanel3.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myUserField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myUseClientFilter = jCheckBox = new JCheckBox();
        this.$$$loadButtonText$$$(jCheckBox, DynamicBundle.getBundle((String)"messages/PerforceBundle", PerforceVersionFilterComponent.class).getString("label.browse.changes.filter.client"));
        jPanel3.add((Component)jCheckBox, new GridConstraints(0, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myClientField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 0, null, new Dimension(100, -1), null));
        this.myStandardPanel = jPanel = new JPanel();
        jPanel2.add((Component)jPanel, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }
}

