/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.ide.IdeBundle;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.EditFileProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.ReadonlyStatusIsVisibleActivationCheck;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.TreeDiffProvider;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsExceptionsHotFixer;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.annotate.AnnotationProvider;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsHistoryProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.actions.BrowseShelfAction;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.OpenedResultProcessor;
import org.jetbrains.idea.perforce.application.PerforceAnnotationProvider;
import org.jetbrains.idea.perforce.application.PerforceBaseInfoWorker;
import org.jetbrains.idea.perforce.application.PerforceChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceCheckinEnvironment;
import org.jetbrains.idea.perforce.application.PerforceCommittedChangesProvider;
import org.jetbrains.idea.perforce.application.PerforceDiffProvider;
import org.jetbrains.idea.perforce.application.PerforceExceptionsHotFixer;
import org.jetbrains.idea.perforce.application.PerforceIntegrateEnvironment;
import org.jetbrains.idea.perforce.application.PerforceManager;
import org.jetbrains.idea.perforce.application.PerforceNumberNameSynchronizer;
import org.jetbrains.idea.perforce.application.PerforceOfflineChangeProvider;
import org.jetbrains.idea.perforce.application.PerforceOfflineRollbackEnvironment;
import org.jetbrains.idea.perforce.application.PerforceOnlyRevisionNumber;
import org.jetbrains.idea.perforce.application.PerforceRollbackEnvironment;
import org.jetbrains.idea.perforce.application.PerforceTreeDiffProvider;
import org.jetbrains.idea.perforce.application.PerforceUpdateEnvironment;
import org.jetbrains.idea.perforce.application.PerforceVFSListener;
import org.jetbrains.idea.perforce.application.PerforceVcsHistoryProvider;
import org.jetbrains.idea.perforce.application.PerforceVcsRevisionNumber;
import org.jetbrains.idea.perforce.application.ShelvedChange;
import org.jetbrains.idea.perforce.merge.PerforceMergeProvider;
import org.jetbrains.idea.perforce.operations.P4EditOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.FStat;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManager;
import org.jetbrains.idea.perforce.perforce.connections.PerforceConnectionManagerI;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;

public final class PerforceVcs
extends AbstractVcs {
    @NlsSafe
    public static final String NAME = "Perforce";
    private static final VcsKey ourKey = PerforceVcs.createKey((String)"Perforce");
    private PerforceCheckinEnvironment myPerforceCheckinEnvironment;
    private PerforceUpdateEnvironment myPerforceUpdateEnvironment;
    private PerforceIntegrateEnvironment myPerforceIntegrateEnvironment;
    private RollbackEnvironment myPerforceRollbackEnvironment;
    private RollbackEnvironment myOfflineRollbackEnvironment;
    private PerforceCommittedChangesProvider myCommittedChangesProvider;
    private final ChangeListManager myChangeListManager;
    private final MyEditFileProvider myMyEditFileProvider;
    private PerforceChangeProvider myChangeProvider;
    private ChangeProvider myOfflineChangeProvider;
    private PerforceVcsHistoryProvider myHistoryProvider;
    private PerforceAnnotationProvider myAnnotationProvider;
    private PerforceDiffProvider myDiffProvider;
    private PerforceTreeDiffProvider myTreeDiffProvider;
    private final PerforceSettings mySettings;
    private PerforceVFSListener myVFSListener;
    private MergeProvider myMergeProvider;
    private final Set<VirtualFile> myAsyncEditFiles;
    private final Map<ConnectionKey, List<PerforceJob>> myDefaultAssociated;
    private final PerforceExceptionsHotFixer myHotFixer;
    private final PerforceRunner myPerforceRunner;
    private final PerforceBaseInfoWorker myPerforceBaseInfoWorker;
    private final ReentrantReadWriteLock myP4Lock;

    public PerforceVcs(@NotNull Project project) {
        if (project == null) {
            PerforceVcs.$$$reportNull$$$0(0);
        }
        super(project, NAME);
        this.myAsyncEditFiles = new HashSet<VirtualFile>();
        this.myDefaultAssociated = new HashMap<ConnectionKey, List<PerforceJob>>();
        this.myP4Lock = new ReentrantReadWriteLock();
        this.myPerforceRunner = PerforceRunner.getInstance(project);
        this.myPerforceBaseInfoWorker = (PerforceBaseInfoWorker)project.getService(PerforceBaseInfoWorker.class);
        this.myChangeListManager = project.isDefault() ? null : ChangeListManager.getInstance((Project)project);
        this.mySettings = PerforceSettings.getSettings(this.myProject);
        this.myMyEditFileProvider = new MyEditFileProvider();
        this.myHotFixer = new PerforceExceptionsHotFixer(project);
        NotificationsConfigurationImpl.remove((String[])new String[]{"PerforceId", "ourP4ConfigNotFoundGroupId"});
    }

    @NotNull
    public String getDisplayName() {
        return NAME;
    }

    @Nls
    @NotNull
    public String getShortNameWithMnemonic() {
        String string = PerforceBundle.message((String)"perforce.name.with.mnemonic", (Object[])new Object[0]);
        if (string == null) {
            PerforceVcs.$$$reportNull$$$0(1);
        }
        return string;
    }

    public Configurable getConfigurable() {
        return null;
    }

    @Nullable
    private <T> T validProvider(T initialValue) {
        return (T)(this.mySettings.ENABLED ? initialValue : null);
    }

    public boolean allowsRemoteCalls(@NotNull VirtualFile file) {
        if (file == null) {
            PerforceVcs.$$$reportNull$$$0(2);
        }
        return this.mySettings.ENABLED;
    }

    public boolean isTrackingUnchangedContent() {
        return true;
    }

    @NotNull
    public EditFileProvider getEditFileProvider() {
        MyEditFileProvider myEditFileProvider = this.myMyEditFileProvider;
        if (myEditFileProvider == null) {
            PerforceVcs.$$$reportNull$$$0(3);
        }
        return myEditFileProvider;
    }

    @NotNull
    public PerforceCheckinEnvironment getCheckinEnvironment() {
        if (this.myPerforceCheckinEnvironment == null) {
            this.myPerforceCheckinEnvironment = new PerforceCheckinEnvironment(this.myProject, this);
        }
        PerforceCheckinEnvironment perforceCheckinEnvironment = this.myPerforceCheckinEnvironment;
        if (perforceCheckinEnvironment == null) {
            PerforceVcs.$$$reportNull$$$0(4);
        }
        return perforceCheckinEnvironment;
    }

    public RollbackEnvironment getRollbackEnvironment() {
        if (PerforceSettings.getSettings((Project)this.myProject).ENABLED) {
            if (this.myPerforceRollbackEnvironment == null) {
                this.myPerforceRollbackEnvironment = new PerforceRollbackEnvironment(this.myProject);
            }
            return this.myPerforceRollbackEnvironment;
        }
        if (this.myOfflineRollbackEnvironment == null) {
            this.myOfflineRollbackEnvironment = new PerforceOfflineRollbackEnvironment(this.myProject);
        }
        return this.myOfflineRollbackEnvironment;
    }

    private void autoEditVFile(VirtualFile[] vFiles) {
        ApplicationManager.getApplication().runWriteAction(() -> {
            for (VirtualFile file : vFiles) {
                PerforceVFSListener.updateLastUnchangedContent(file, this.myChangeListManager);
                try {
                    ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)file, (boolean)false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.startAsyncEdit(vFiles);
        ArrayList<P4EditOperation> operations = new ArrayList<P4EditOperation>();
        for (VirtualFile vFile : vFiles) {
            LocalChangeList list = this.myChangeListManager.getChangeList(vFile);
            if (list == null) {
                list = this.myChangeListManager.getDefaultChangeList();
            }
            operations.add(new P4EditOperation(list.getName(), vFile));
        }
        VcsOperationLog.getInstance(this.myProject).queueOperations(operations, PerforceBundle.message((String)"progress.title.perforce.edit", (Object[])new Object[0]), VcsConfiguration.getInstance((Project)this.myProject).getEditOption());
    }

    @Nullable
    public FStat getFstatSafe(P4File p4File) throws VcsException {
        if (this.myProject.isDisposed()) {
            return null;
        }
        return p4File.getFstat(this.myPerforceBaseInfoWorker, this.myChangeListManager, this.myPerforceRunner, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startAsyncEdit(VirtualFile ... vFiles) {
        Set<VirtualFile> set = this.myAsyncEditFiles;
        synchronized (set) {
            Collections.addAll(this.myAsyncEditFiles, vFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<VirtualFile> getAsyncEditedFiles() {
        Set<VirtualFile> set = this.myAsyncEditFiles;
        synchronized (set) {
            return new HashSet<VirtualFile>(this.myAsyncEditFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncEditCompleted(VirtualFile file) {
        Set<VirtualFile> set = this.myAsyncEditFiles;
        synchronized (set) {
            this.myAsyncEditFiles.remove(file);
        }
    }

    public static PerforceVcs getInstance(Project project) {
        return (PerforceVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME);
    }

    @NotNull
    public UpdateEnvironment getUpdateEnvironment() {
        if (this.myPerforceUpdateEnvironment == null) {
            this.myPerforceUpdateEnvironment = new PerforceUpdateEnvironment(this.myProject);
        }
        PerforceUpdateEnvironment perforceUpdateEnvironment = this.myPerforceUpdateEnvironment;
        if (perforceUpdateEnvironment == null) {
            PerforceVcs.$$$reportNull$$$0(5);
        }
        return perforceUpdateEnvironment;
    }

    public PerforceSettings getSettings() {
        return this.mySettings;
    }

    @Nullable
    public static String getFileNameComplaint(P4File file) {
        String filename = file.getLocalPath();
        if (StringUtil.containsAnyChar((String)filename, (String)"@#%*")) {
            return PerforceBundle.message((String)"file.wildcards.restricted", (Object[])new Object[]{filename});
        }
        return null;
    }

    public boolean fileIsUnderVcs(FilePath filePath) {
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        try {
            if (virtualFile.isDirectory()) {
                return PerforceManager.getInstance(this.getProject()).isUnderPerforceRoot(virtualFile);
            }
            P4File p4File = P4File.create(virtualFile);
            return PerforceRunner.getInstance(this.myProject).have(p4File);
        }
        catch (VcsException e) {
            return false;
        }
    }

    public boolean fileExistsInVcs(FilePath filePath) {
        VirtualFile virtualFile = filePath.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        PerforceManager perforceManager = PerforceManager.getInstance(this.getProject());
        if (!this.mySettings.ENABLED) {
            return true;
        }
        if (virtualFile.isDirectory()) {
            try {
                return perforceManager.isUnderPerforceRoot(virtualFile);
            }
            catch (VcsException e) {
                return false;
            }
        }
        FileStatus fileStatus = ChangeListManager.getInstance((Project)this.myProject).getStatus(virtualFile);
        if (FileStatus.ADDED.equals(fileStatus) && Boolean.TRUE.equals(virtualFile.getUserData(OpenedResultProcessor.BRANCHED_FILE))) {
            return true;
        }
        return fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.ADDED;
    }

    public VcsHistoryProvider getVcsHistoryProvider() {
        if (this.myHistoryProvider == null) {
            this.myHistoryProvider = new PerforceVcsHistoryProvider(this);
        }
        return this.validProvider(this.myHistoryProvider);
    }

    public VcsHistoryProvider getVcsBlockHistoryProvider() {
        return this.getVcsHistoryProvider();
    }

    public AnnotationProvider getAnnotationProvider() {
        if (this.myAnnotationProvider == null) {
            this.myAnnotationProvider = new PerforceAnnotationProvider(this.myProject);
        }
        return (AnnotationProvider)this.validProvider(this.myAnnotationProvider);
    }

    public DiffProvider getDiffProvider() {
        if (this.myDiffProvider == null) {
            this.myDiffProvider = new PerforceDiffProvider(this.myProject);
        }
        return (DiffProvider)this.validProvider(this.myDiffProvider);
    }

    @NotNull
    public ChangeProvider getChangeProvider() {
        if (this.mySettings.ENABLED) {
            PerforceChangeProvider perforceChangeProvider = this.getOnlineChangeProvider();
            if (perforceChangeProvider == null) {
                PerforceVcs.$$$reportNull$$$0(6);
            }
            return perforceChangeProvider;
        }
        if (this.myOfflineChangeProvider == null) {
            this.myOfflineChangeProvider = new PerforceOfflineChangeProvider(this.myProject);
        }
        ChangeProvider changeProvider = this.myOfflineChangeProvider;
        if (changeProvider == null) {
            PerforceVcs.$$$reportNull$$$0(7);
        }
        return changeProvider;
    }

    public PerforceChangeProvider getOnlineChangeProvider() {
        this.initChangeProvider();
        return this.myChangeProvider;
    }

    private void initChangeProvider() {
        if (this.myChangeProvider == null) {
            this.myChangeProvider = new PerforceChangeProvider(this);
        }
    }

    public UpdateEnvironment getIntegrateEnvironment() {
        if (this.myPerforceIntegrateEnvironment == null) {
            this.myPerforceIntegrateEnvironment = new PerforceIntegrateEnvironment(this.myProject);
        }
        return this.validProvider(this.myPerforceIntegrateEnvironment);
    }

    public void activate() {
        if (this.myVFSListener == null) {
            this.myVFSListener = PerforceVFSListener.createInstance(this.myProject);
        }
        PerforceManager.getInstance(this.myProject).startListening((Disposable)this.myVFSListener);
        ((PerforceConnectionManager)PerforceConnectionManager.getInstance(this.myProject)).startListening((Disposable)this.myVFSListener);
        PerforceNumberNameSynchronizer.getInstance(this.myProject).startListening((Disposable)this.myVFSListener);
        PerforceSettings.getSettings(this.myProject).ensureOfflineNotify();
        ReadonlyStatusIsVisibleActivationCheck.check((Project)this.myProject, (String)NAME);
        this.initChangeProvider();
        this.myChangeProvider.activate((Disposable)this.myVFSListener);
    }

    public void deactivate() {
        if (this.myVFSListener != null) {
            Disposer.dispose((Disposable)this.myVFSListener);
            this.myVFSListener = null;
        }
        PerforceManager.getInstance(this.myProject).stopListening();
        this.myChangeProvider.deactivate();
    }

    @NotNull
    public PerforceCommittedChangesProvider getCommittedChangesProvider() {
        if (this.myCommittedChangesProvider == null) {
            this.myCommittedChangesProvider = new PerforceCommittedChangesProvider(this.myProject);
        }
        PerforceCommittedChangesProvider perforceCommittedChangesProvider = this.myCommittedChangesProvider;
        if (perforceCommittedChangesProvider == null) {
            PerforceVcs.$$$reportNull$$$0(8);
        }
        return perforceCommittedChangesProvider;
    }

    public void runBackgroundTask(@NlsContexts.ProgressTitle String title, @NotNull PerformInBackgroundOption option, final Runnable runnable) {
        if (option == null) {
            PerforceVcs.$$$reportNull$$$0(9);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            runnable.run();
        } else {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, title, false, option){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    runnable.run();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/perforce/application/PerforceVcs$1", "run"));
                }
            });
        }
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(String revisionNumberString) {
        long revision;
        try {
            revision = Long.parseLong(revisionNumberString);
        }
        catch (NumberFormatException ex) {
            return null;
        }
        return new PerforceOnlyRevisionNumber(revision);
    }

    public String getRevisionPattern() {
        return "\\d+";
    }

    @NotNull
    public MergeProvider getMergeProvider() {
        if (this.myMergeProvider == null) {
            this.myMergeProvider = new PerforceMergeProvider(this.myProject);
        }
        MergeProvider mergeProvider = this.myMergeProvider;
        if (mergeProvider == null) {
            PerforceVcs.$$$reportNull$$$0(10);
        }
        return mergeProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ConnectionKey, List<PerforceJob>> getDefaultAssociated() {
        Map<ConnectionKey, List<PerforceJob>> map = this.myDefaultAssociated;
        synchronized (map) {
            return new HashMap<ConnectionKey, List<PerforceJob>>(this.myDefaultAssociated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultAssociated(Map<ConnectionKey, List<PerforceJob>> jobs) {
        Map<ConnectionKey, List<PerforceJob>> map = this.myDefaultAssociated;
        synchronized (map) {
            this.myDefaultAssociated.clear();
            this.myDefaultAssociated.putAll(jobs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearDefaultAssociated() {
        Map<ConnectionKey, List<PerforceJob>> map = this.myDefaultAssociated;
        synchronized (map) {
            this.myDefaultAssociated.clear();
        }
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        try {
            return PerforceManager.getInstance(this.myProject).isUnderPerforceRoot(dir);
        }
        catch (VcsException e) {
            return false;
        }
    }

    public VcsExceptionsHotFixer getVcsExceptionsHotFixer() {
        return this.myHotFixer;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public Collection<Pair<P4Connection, Collection<VirtualFile>>> getRootsByConnections() throws VcsException {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        PerforceConnectionManagerI connectionManager = PerforceConnectionManager.getInstance(this.myProject);
        VirtualFile[] roots = vcsManager.getRootsUnderVcs((AbstractVcs)this);
        MultiMap rootsByConnections = new MultiMap();
        HashMap<ConnectionKey, P4Connection> connMap = new HashMap<ConnectionKey, P4Connection>();
        for (VirtualFile root : roots) {
            P4Connection connection = connectionManager.getConnectionForFile(root);
            if (connection == null) continue;
            PerforceManager.ensureValidClient(this.myProject, connection);
            ConnectionKey key = connection.getConnectionKey();
            connMap.put(key, connection);
            rootsByConnections.putValue((Object)key, (Object)root);
        }
        LinkedList<Pair<P4Connection, Collection<VirtualFile>>> result = new LinkedList<Pair<P4Connection, Collection<VirtualFile>>>();
        for (ConnectionKey key : rootsByConnections.keySet()) {
            P4Connection connection = (P4Connection)connMap.get(key);
            result.add((Pair<P4Connection, Collection<VirtualFile>>)Pair.create((Object)connection, (Object)rootsByConnections.get((Object)key)));
        }
        return result;
    }

    protected TreeDiffProvider getTreeDiffProviderImpl() {
        if (this.myTreeDiffProvider == null) {
            this.myTreeDiffProvider = new PerforceTreeDiffProvider(this);
        }
        return this.myTreeDiffProvider;
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_TREE_PROVIDER;
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return new AbstractVcs.RootsConvertor(){

            @NotNull
            public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> result) {
                if (result == null) {
                    2.$$$reportNull$$$0(0);
                }
                Map<VirtualFile, P4Connection> allConnections = PerforceConnectionManager.getInstance(PerforceVcs.this.myProject).getAllConnections();
                Set<VirtualFile> minRoots = allConnections.keySet();
                ArrayList<VirtualFile> filtered = new ArrayList<VirtualFile>(minRoots);
                filtered.retainAll(result);
                ArrayList<VirtualFile> arrayList = filtered;
                if (arrayList == null) {
                    2.$$$reportNull$$$0(1);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "result";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceVcs$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceVcs$2";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convertRoots";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convertRoots";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    public static boolean revisionsSame(@NotNull VcsRevisionNumber number1, @NotNull VcsRevisionNumber number2) {
        if (number1 == null) {
            PerforceVcs.$$$reportNull$$$0(11);
        }
        if (number2 == null) {
            PerforceVcs.$$$reportNull$$$0(12);
        }
        long revision1 = PerforceVcs.extractNumber(number1);
        long revision2 = PerforceVcs.extractNumber(number2);
        return revision1 > 0L && revision1 == revision2;
    }

    private static long extractNumber(@NotNull VcsRevisionNumber number) {
        if (number == null) {
            PerforceVcs.$$$reportNull$$$0(13);
        }
        if (number instanceof VcsRevisionNumber.Long) {
            return ((VcsRevisionNumber.Long)number).getLongValue();
        }
        if (number instanceof PerforceVcsRevisionNumber) {
            return ((PerforceVcsRevisionNumber)number).getChangeNumber();
        }
        if (number instanceof PerforceOnlyRevisionNumber) {
            return ((PerforceOnlyRevisionNumber)number).getNumber();
        }
        return -1L;
    }

    @NotNull
    public ThreeState mayRemoveChangeList(@NotNull LocalChangeList list, boolean explicitly) {
        List<ShelvedChange> shelvedChanges;
        if (list == null) {
            PerforceVcs.$$$reportNull$$$0(14);
        }
        if (!(shelvedChanges = PerforceManager.getInstance(this.myProject).getShelf().getShelvedChanges(list)).isEmpty()) {
            if (!explicitly) {
                ThreeState threeState = ThreeState.NO;
                if (threeState == null) {
                    PerforceVcs.$$$reportNull$$$0(15);
                }
                return threeState;
            }
            String message = PerforceBundle.message((String)"changelist.shelved.changes.delete", (Object[])new Object[]{list.getName()});
            int rc = Messages.showDialog((Project)this.myProject, (String)message, (String)PerforceBundle.message((String)"changelist.shelved.changes.found", (Object[])new Object[0]), (String[])new String[]{PerforceBundle.message((String)"shelf.browse.mnemonic", (Object[])new Object[0]), IdeBundle.message((String)"button.remove", (Object[])new Object[0]), Messages.getCancelButton()}, (int)0, (Icon)Messages.getQuestionIcon());
            if (rc == 1) {
                BrowseShelfAction.deleteFromShelf(shelvedChanges, this.myProject);
                ThreeState threeState = ThreeState.YES;
                if (threeState == null) {
                    PerforceVcs.$$$reportNull$$$0(16);
                }
                return threeState;
            }
            if (rc == 0) {
                BrowseShelfAction.browseShelf(this.myProject, shelvedChanges);
            }
            ThreeState threeState = ThreeState.NO;
            if (threeState == null) {
                PerforceVcs.$$$reportNull$$$0(17);
            }
            return threeState;
        }
        ThreeState threeState = ThreeState.UNSURE;
        if (threeState == null) {
            PerforceVcs.$$$reportNull$$$0(18);
        }
        return threeState;
    }

    public AccessToken readLockP4() {
        final ReentrantReadWriteLock.ReadLock lock = this.myP4Lock.readLock();
        lock.lock();
        return new AccessToken(){

            public void finish() {
                lock.unlock();
            }
        };
    }

    public AccessToken writeLockP4() {
        final ReentrantReadWriteLock.WriteLock lock = this.myP4Lock.writeLock();
        lock.lock();
        return new AccessToken(){

            public void finish() {
                lock.unlock();
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceVcs";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number1";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number2";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "number";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceVcs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortNameWithMnemonic";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditFileProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckinEnvironment";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getUpdateEnvironment";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangeProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommittedChangesProvider";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergeProvider";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "mayRemoveChangeList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "allowsRemoteCalls";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "runBackgroundTask";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "revisionsSame";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "extractNumber";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "mayRemoveChangeList";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class MyEditFileProvider
    implements EditFileProvider {
        private MyEditFileProvider() {
        }

        public void editFiles(VirtualFile[] files) {
            PerforceVcs.this.autoEditVFile(files);
        }

        public String getRequestText() {
            return PerforceBundle.message((String)"confirmation.text.open.files.for.edit", (Object[])new Object[0]);
        }
    }
}

