/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsListener;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerGate;
import com.intellij.openapi.vcs.changes.ChangelistBuilder;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScope;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.perforce.application.PerforceUnversionedTracker;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.UnversionedScopeScanner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;

public class PerforceReadOnlyFileStateManager {
    private static final Logger LOG = Logger.getInstance(PerforceReadOnlyFileStateManager.class);
    private final Project myProject;
    private final ProjectLevelVcsManager myVcsManager;
    private final PerforceUnversionedTracker myUnversionedTracker;
    private final Object myLock = new Object();
    private final FrameStateListener myFrameStateListener = new FrameStateListener(){

        public void onFrameDeactivated() {
            PerforceReadOnlyFileStateManager.this.processFocusLost();
        }
    };
    private final Set<VirtualFile> myPreviousAddedSnapshot = new HashSet<VirtualFile>();
    private MessageBusConnection myConnection;
    private volatile boolean myPreviousRescanProblem;
    private volatile boolean myHasLostFocus;

    public PerforceReadOnlyFileStateManager(Project project) {
        this.myProject = project;
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myUnversionedTracker = new PerforceUnversionedTracker(project);
    }

    PerforceUnversionedTracker getUnversionedTracker() {
        return this.myUnversionedTracker;
    }

    public void activate(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            PerforceReadOnlyFileStateManager.$$$reportNull$$$0(0);
        }
        final Runnable scheduleTotalRescan = () -> {
            this.myUnversionedTracker.isActive = false;
            this.myUnversionedTracker.totalRescan();
        };
        this.myConnection = this.myProject.getMessageBus().connect();
        this.myConnection.subscribe(ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED, (Object)new VcsListener(){

            public void directoryMappingChanged() {
                scheduleTotalRescan.run();
            }
        });
        VirtualFileManager.getInstance().addVirtualFileListener((VirtualFileListener)new MyVfsListener(), parentDisposable);
        FrameStateManager.getInstance().addListener(this.myFrameStateListener);
        this.myConnection.subscribe(PerforceSettings.OFFLINE_MODE_EXITED, (Object)scheduleTotalRescan);
    }

    public void deactivate() {
        this.myUnversionedTracker.isActive = false;
        this.myConnection.disconnect();
        FrameStateManager.getInstance().removeListener(this.myFrameStateListener);
        this.myHasLostFocus = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getChanges(VcsDirtyScope dirtyScope, ChangelistBuilder builder, ProgressIndicator progress, ChangeListManagerGate addGate) throws VcsException {
        ThrowableComputable<UnversionedScopeScanner.ScanResult, VcsException> scanner;
        Set<VirtualFile> newAdded = this.getAddedFilesInCurrentChangesView(addGate);
        Object object = this.myLock;
        synchronized (object) {
            progress.checkCanceled();
            this.recheckPreviouslyAddedFiles(newAdded);
            this.recheckWhatUnversionedRefreshNeeded(dirtyScope);
            scanner = this.myUnversionedTracker.createScanner();
        }
        progress.checkCanceled();
        UnversionedScopeScanner.ScanResult result = this.rescan(scanner);
        progress.checkCanceled();
        for (VirtualFile file : result.allLocalFiles) {
            this.myUnversionedTracker.markUnknown(file);
        }
        this.myUnversionedTracker.markUnversioned(result.localOnly);
        dirtyScope.iterateExistingInsideScope(vf -> {
            progress.checkCanceled();
            if (!PerforceReadOnlyFileStateManager.isKnownToPerforce(addGate, vf)) {
                if (this.myUnversionedTracker.isUnversioned((VirtualFile)vf)) {
                    builder.processUnversionedFile(vf);
                } else if (this.myUnversionedTracker.isIgnored((VirtualFile)vf)) {
                    builder.processIgnoredFile(vf);
                }
            }
            return true;
        });
        Set<String> locallyDeleted = PerforceReadOnlyFileStateManager.findLocallyDeletedMissingFiles(addGate, result.missingFiles);
        for (String path : locallyDeleted) {
            builder.processLocallyDeletedFile(VcsUtil.getFilePath((String)path, (boolean)false));
        }
    }

    private static boolean isKnownToPerforce(ChangeListManagerGate addGate, VirtualFile file) {
        FileStatus status = addGate.getStatus(file);
        if (LOG.isDebugEnabled()) {
            LOG.debug("status " + status + " for " + file);
        }
        return status != null;
    }

    private UnversionedScopeScanner.ScanResult rescan(ThrowableComputable<UnversionedScopeScanner.ScanResult, VcsException> scanner) throws VcsException {
        this.myUnversionedTracker.isActive = true;
        this.myPreviousRescanProblem = false;
        try {
            return (UnversionedScopeScanner.ScanResult)scanner.compute();
        }
        catch (VcsException e) {
            this.myPreviousRescanProblem = true;
            throw e;
        }
    }

    private Set<VirtualFile> getAddedFilesInCurrentChangesView(ChangeListManagerGate addGate) {
        HashSet<VirtualFile> set = new HashSet<VirtualFile>();
        for (LocalChangeList list : addGate.getListsCopy()) {
            for (Change change : list.getChanges()) {
                VirtualFile file;
                ContentRevision afterRevision = change.getAfterRevision();
                if (!FileStatus.ADDED.equals(change.getFileStatus()) || afterRevision == null || (file = afterRevision.getFile().getVirtualFile()) == null || !this.fileIsUnderP4Root(file)) continue;
                set.add(file);
            }
        }
        return set;
    }

    private void recheckWhatUnversionedRefreshNeeded(VcsDirtyScope dirtyScope) {
        if (this.myHasLostFocus && dirtyScope.wasEveryThingDirty()) {
            LOG.info("--- recheck missing");
            this.myHasLostFocus = false;
            if (this.myPreviousRescanProblem) {
                this.myUnversionedTracker.totalRescan();
            }
        }
    }

    private void recheckPreviouslyAddedFiles(Set<VirtualFile> newAdded) {
        HashSet<VirtualFile> copy = new HashSet<VirtualFile>(this.myPreviousAddedSnapshot);
        copy.removeAll(newAdded);
        this.myPreviousAddedSnapshot.clear();
        this.myPreviousAddedSnapshot.addAll(newAdded);
        if (!copy.isEmpty()) {
            this.myUnversionedTracker.reportRecheck(copy);
        }
    }

    private static Set<String> findLocallyDeletedMissingFiles(ChangeListManagerGate addGate, Set<String> missingFiles) {
        HashSet<String> locallyDeleted = new HashSet<String>();
        for (String path : missingFiles) {
            if (FileStatus.DELETED.equals(addGate.getStatus(VcsUtil.getFilePath((File)new File(path))))) continue;
            locallyDeleted.add(path);
        }
        return locallyDeleted;
    }

    public void processFocusLost() {
        this.myHasLostFocus = true;
    }

    public void discardUnversioned() {
        this.myUnversionedTracker.totalRescan();
    }

    private boolean fileIsUnderP4Root(VirtualFile file) {
        if (this.myProject.isDisposed()) {
            return false;
        }
        if (ChangeListManager.getInstance((Project)this.myProject).isIgnoredFile(file)) {
            return false;
        }
        AbstractVcs vcs = this.myVcsManager.getVcsFor(file);
        return vcs != null && PerforceVcs.getKey().equals((Object)vcs.getKeyInstanceMethod());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager", "activate"));
    }

    private class MyVfsListener
    implements VirtualFileListener {
        private MyVfsListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            VirtualFile file;
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(0);
            }
            if (PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(file = event.getFile()) && "writable".equals(event.getPropertyName())) {
                PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportRecheck(file);
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            VirtualFile file;
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(1);
            }
            if (PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(file = event.getFile()) && !file.isWritable()) {
                PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportRecheck(file);
            }
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(2);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            this.processCreated(event.getFile());
        }

        private void processCreated(VirtualFile root) {
            PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportRecheck(root);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(3);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            this.processCreated(event.getFile());
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(4);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            this.processCreated(event.getFile());
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(5);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportDelete(event.getFile());
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                MyVfsListener.$$$reportNull$$$0(6);
            }
            if (!PerforceReadOnlyFileStateManager.this.fileIsUnderP4Root(event.getFile())) {
                return;
            }
            PerforceReadOnlyFileStateManager.this.myUnversionedTracker.reportDelete(event.getFile());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "event";
            objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceReadOnlyFileStateManager$MyVfsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "propertyChanged";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "contentsChanged";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCreated";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileMoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "fileCopied";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileDeletion";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeFileMovement";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

