/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ClientData;
import org.jetbrains.idea.perforce.application.ConnectionInfo;
import org.jetbrains.idea.perforce.application.P4RootsInformation;
import org.jetbrains.idea.perforce.perforce.PerforceAuthenticationException;
import org.jetbrains.idea.perforce.perforce.PerforceServerUnavailable;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;

public class PerforceClientRootsChecker
implements P4RootsInformation {
    private static final Logger LOG = Logger.getInstance(PerforceClientRootsChecker.class);
    private final Map<P4Connection, WrongRoots> myMap = new HashMap<P4Connection, WrongRoots>();
    private final MultiMap<P4Connection, VcsException> myErrors = new MultiMap();
    private final Set<P4Connection> myNotAuthorized = new HashSet<P4Connection>();

    public PerforceClientRootsChecker() {
    }

    public PerforceClientRootsChecker(Map<P4Connection, ConnectionInfo> infoAndClient, Map<VirtualFile, P4Connection> map) {
        if (map.containsKey(null)) {
            LOG.info("Null root: " + new LinkedHashMap<VirtualFile, P4Connection>(map));
        }
        MultiMap<P4Connection, VirtualFile> inverse = PerforceClientRootsChecker.invertConnectionMap(map);
        for (P4Connection connection : inverse.keySet()) {
            List<String> clientRoots;
            Collection roots = inverse.get((Object)connection);
            try {
                clientRoots = PerforceClientRootsChecker.getClientRoots(connection, infoAndClient);
            }
            catch (PerforceAuthenticationException e) {
                this.myNotAuthorized.add(connection);
                continue;
            }
            catch (VcsException e) {
                this.myErrors.putValue((Object)connection, (Object)e);
                continue;
            }
            ContainerUtil.putIfNotNull((Object)connection, (Object)PerforceClientRootsChecker.checkRoots(roots, clientRoots), this.myMap);
        }
    }

    @Nullable
    private static WrongRoots checkRoots(Collection<VirtualFile> roots, List<String> clientRoots) {
        WrongRoots wrongRoots = null;
        for (VirtualFile root : roots) {
            if (root == null) continue;
            boolean checkedOk = false;
            File ioFile = new File(root.getPath());
            for (String clientRoot : clientRoots) {
                if ("null".equals(clientRoot)) {
                    checkedOk = true;
                    break;
                }
                File ioRoot = new File(clientRoot);
                if (!PerforceClientRootsChecker.isDirectory(ioRoot) || !FileUtil.isAncestor((File)ioRoot, (File)ioFile, (boolean)false)) continue;
                checkedOk = true;
                break;
            }
            if (checkedOk) continue;
            if (wrongRoots == null) {
                wrongRoots = new WrongRoots(clientRoots);
            }
            wrongRoots.addWrong(root);
        }
        return wrongRoots;
    }

    private static MultiMap<P4Connection, VirtualFile> invertConnectionMap(Map<VirtualFile, P4Connection> map) {
        MultiMap inverse = new MultiMap();
        for (Map.Entry<VirtualFile, P4Connection> entry : map.entrySet()) {
            inverse.putValue((Object)entry.getValue(), (Object)entry.getKey());
        }
        return inverse;
    }

    public boolean isServerUnavailable() {
        return ContainerUtil.findInstance(new ArrayList(this.myErrors.values()), PerforceServerUnavailable.class) != null;
    }

    public static boolean isDirectory(File file) {
        String path;
        if (file.isDirectory()) {
            return true;
        }
        return SystemInfo.isWindows && (path = file.getPath()).length() == 2 && Character.isLetter(path.charAt(0)) && ':' == path.charAt(1);
    }

    private static List<String> getClientRoots(P4Connection connection, Map<P4Connection, ConnectionInfo> infoMap) throws VcsException {
        ClientData clientSpec;
        ConnectionInfo info = infoMap.get(connection);
        ClientData clientData = clientSpec = info == null ? null : info.getClient();
        if (clientSpec == null) {
            throw new VcsException(PerforceBundle.message((String)"error.no.client.specifications.loaded", (Object[])new Object[0]));
        }
        return clientSpec.getAllRoots();
    }

    @Override
    public MultiMap<P4Connection, VcsException> getErrors() {
        return this.myErrors;
    }

    @Override
    public boolean hasAnyErrors() {
        return !this.myMap.isEmpty() || !this.myErrors.isEmpty();
    }

    @Override
    public boolean hasNotAuthorized() {
        return !this.myNotAuthorized.isEmpty();
    }

    @Override
    public Set<P4Connection> getNotAuthorized() {
        return this.myNotAuthorized;
    }

    @Override
    public Map<P4Connection, WrongRoots> getMap() {
        return this.myMap;
    }

    public static class WrongRoots {
        private final List<String> myActualInClientSpec;
        private final List<VirtualFile> myWrong;

        public WrongRoots(List<String> actualInClientSpec) {
            this.myActualInClientSpec = actualInClientSpec;
            this.myWrong = new ArrayList<VirtualFile>();
        }

        public void addWrong(VirtualFile file) {
            this.myWrong.add(file);
        }

        public List<String> getActualInClientSpec() {
            return this.myActualInClientSpec;
        }

        public List<VirtualFile> getWrong() {
            return this.myWrong;
        }
    }
}

