/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.perforce.application;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vcs.CheckinProjectPanel;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.CommitContext;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.ui.RefreshableOnComponent;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.perforce.PerforceBundle;
import org.jetbrains.idea.perforce.application.ConnectionKey;
import org.jetbrains.idea.perforce.application.PerforceVcs;
import org.jetbrains.idea.perforce.application.SplitListIntoConnections;
import org.jetbrains.idea.perforce.operations.P4AddOperation;
import org.jetbrains.idea.perforce.operations.P4DeleteOperation;
import org.jetbrains.idea.perforce.operations.VcsOperationLog;
import org.jetbrains.idea.perforce.perforce.P4File;
import org.jetbrains.idea.perforce.perforce.PerforceChange;
import org.jetbrains.idea.perforce.perforce.PerforceRunner;
import org.jetbrains.idea.perforce.perforce.PerforceSettings;
import org.jetbrains.idea.perforce.perforce.connections.P4Connection;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceCheckinComponent;
import org.jetbrains.idea.perforce.perforce.jobs.PerforceJob;

public class PerforceCheckinEnvironment
implements CheckinEnvironment {
    private static final Logger LOG = Logger.getInstance(PerforceCheckinEnvironment.class);
    public static final Key<List<PerforceJob>> LINKED_JOBS_KEY = Key.create((String)"perforce_linked_jobs");
    private final Project myProject;
    private final PerforceRunner myRunner;
    private final PerforceVcs myVcs;

    public PerforceCheckinEnvironment(Project project, PerforceVcs perforceVcs) {
        this.myProject = project;
        this.myRunner = PerforceRunner.getInstance(project);
        this.myVcs = perforceVcs;
    }

    @Nullable
    public RefreshableOnComponent createCommitOptions(@NotNull CheckinProjectPanel commitPanel, @NotNull CommitContext commitContext) {
        if (commitPanel == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(0);
        }
        if (commitContext == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(1);
        }
        return PerforceSettings.getSettings((Project)this.myProject).USE_PERFORCE_JOBS ? new PerforceCheckinComponent(this.myProject, commitContext) : null;
    }

    public String getHelpId() {
        return null;
    }

    public String getCheckinOperationName() {
        return PerforceBundle.message((String)"operation.name.submit", (Object[])new Object[0]);
    }

    @NotNull
    public List<VcsException> commit(@NotNull List<? extends Change> changes, @NotNull String commitMessage, @NotNull CommitContext commitContext, @NotNull Set<? super String> feedback) {
        if (changes == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(2);
        }
        if (commitMessage == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(3);
        }
        if (commitContext == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(4);
        }
        if (feedback == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(5);
        }
        ArrayList<VcsException> vcsExceptions = new ArrayList<VcsException>();
        try (AccessToken ignored = this.myVcs.writeLockP4();){
            List<SubmitJob> map = this.getSubmitJobs(changes);
            if (map.isEmpty()) {
                vcsExceptions.add(new VcsException(PerforceBundle.message((String)"exception.text.nothing.found.to.submit", (Object[])new Object[0])));
            } else {
                for (SubmitJob job : map) {
                    long submittedRevision = job.submit(commitMessage, PerforceCheckinEnvironment.getLinkedJobs(commitContext));
                    if (submittedRevision <= 0L) continue;
                    feedback.add("Perforce revision #" + submittedRevision);
                }
            }
            LOG.info("updating opened files after commit");
        }
        catch (VcsException e) {
            vcsExceptions.add(e);
        }
        ArrayList<VcsException> arrayList = vcsExceptions;
        if (arrayList == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Nullable
    private static List<PerforceJob> getLinkedJobs(@NotNull CommitContext commitContext) {
        if (commitContext == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(7);
        }
        return (List)commitContext.getUserData(LINKED_JOBS_KEY);
    }

    public List<SubmitJob> getSubmitJobs(Collection<? extends Change> changes) throws VcsException {
        SplitListIntoConnections splitter = new SplitListIntoConnections(this.myProject, connection -> new SubmitJob((P4Connection)connection));
        splitter.execute(changes);
        MultiMap<ConnectionKey, FilePath> filePaths = splitter.getPaths();
        Map byConnectionMap = splitter.getByConnectionMap();
        for (ConnectionKey key : filePaths.keySet()) {
            SubmitJob job = (SubmitJob)byConnectionMap.get(key);
            job.addChanges(this.myRunner.opened(job.getConnection(), filePaths.get((Object)key), false));
        }
        return new ArrayList<SubmitJob>(byConnectionMap.values());
    }

    public List<VcsException> scheduleMissingFileForDeletion(@NotNull List<? extends FilePath> files) {
        if (files == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(8);
        }
        ChangeListManager manager = ChangeListManager.getInstance((Project)this.myProject);
        ArrayList<P4DeleteOperation> operations = new ArrayList<P4DeleteOperation>();
        for (FilePath filePath : files) {
            Change change = manager.getChange(filePath);
            LocalChangeList list = change != null ? manager.getChangeList(change) : manager.getDefaultChangeList();
            operations.add(new P4DeleteOperation(list == null ? manager.getDefaultListName() : list.getName(), filePath));
        }
        VcsOperationLog.getInstance(this.myProject).queueOperations(operations, PerforceBundle.message((String)"file.removing.files", (Object[])new Object[0]), VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption());
        return Collections.emptyList();
    }

    @NotNull
    public List<VcsException> scheduleUnversionedFilesForAddition(@NotNull List<? extends VirtualFile> files) {
        if (files == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(9);
        }
        String activeChangeList = ChangeListManager.getInstance((Project)this.myProject).getDefaultChangeList().getName();
        ArrayList<P4AddOperation> ops = new ArrayList<P4AddOperation>();
        for (VirtualFile virtualFile : files) {
            ops.add(new P4AddOperation(activeChangeList, virtualFile));
        }
        VcsOperationLog.getInstance(this.myProject).queueOperations(ops, PerforceBundle.message((String)"progress.title.running.perforce.commands", (Object[])new Object[0]), VcsConfiguration.getInstance((Project)this.myProject).getAddRemoveOption());
        List<VcsException> list = Collections.emptyList();
        if (list == null) {
            PerforceCheckinEnvironment.$$$reportNull$$$0(10);
        }
        return list;
    }

    public boolean isRefreshAfterCommitNeeded() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitPanel";
                break;
            }
            case 1: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitContext";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changes";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitMessage";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "feedback";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/perforce/application/PerforceCheckinEnvironment";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/perforce/application/PerforceCheckinEnvironment";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "commit";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "scheduleUnversionedFilesForAddition";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createCommitOptions";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "commit";
                break;
            }
            case 6: 
            case 10: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLinkedJobs";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "scheduleMissingFileForDeletion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scheduleUnversionedFilesForAddition";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public class SubmitJob {
        private final P4Connection myConnection;
        private final List<PerforceChange> myChanges;

        public SubmitJob(P4Connection connection) {
            if (connection == null) {
                SubmitJob.$$$reportNull$$$0(0);
            }
            this.myChanges = new ArrayList<PerforceChange>();
            this.myConnection = connection;
        }

        public void addChanges(Collection<PerforceChange> changes) {
            this.myChanges.addAll(changes);
        }

        public P4Connection getConnection() {
            return this.myConnection;
        }

        public long submit(String comment, @Nullable List<PerforceJob> p4jobs) throws VcsException {
            if (this.myChanges.size() == 0) {
                return -1L;
            }
            long changeListID = this.createSingleChangeListForConnection();
            long submittedRevision = PerforceCheckinEnvironment.this.myRunner.submitForConnection(this.myConnection, this.myChanges, changeListID, comment, p4jobs);
            if (changeListID == -1L) {
                PerforceCheckinEnvironment.this.myVcs.clearDefaultAssociated();
            }
            return submittedRevision;
        }

        private long createSingleChangeListForConnection() throws VcsException {
            MultiMap byListMap = new MultiMap();
            for (PerforceChange change2 : this.myChanges) {
                byListMap.putValue((Object)change2.getChangeList(), (Object)change2);
            }
            if (byListMap.size() == 0) {
                return -1L;
            }
            if (byListMap.size() == 1) {
                return (Long)byListMap.keySet().iterator().next();
            }
            for (Long number : byListMap.keySet()) {
                if (number == -1L) continue;
                PerforceCheckinEnvironment.this.myRunner.reopen(this.myConnection, -1L, ContainerUtil.map((Collection)byListMap.get((Object)number), change -> P4File.escapeWildcards(change.getDepotPath())));
                PerforceCheckinEnvironment.this.myRunner.deleteChangeList(this.myConnection, number, false, true, false);
            }
            return -1L;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "org/jetbrains/idea/perforce/application/PerforceCheckinEnvironment$SubmitJob", "<init>"));
        }
    }
}

