/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.quoteHandler;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.plugins.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.psi.tree.IElementType;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\f\n\u0002\b\u0003\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0018\u0010\r\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0013\u0010\u000e\u001a\u00020\u0004*\u0004\u0018\u00010\u000fH\u0002\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0012"}, d2={"Lcom/intellij/docker/dockerFile/quoteHandler/DockerQuoteHandler;", "Lcom/intellij/codeInsight/editorActions/SimpleTokenSetQuoteHandler;", "()V", "isClosingQuote", "", "iterator", "Lcom/intellij/openapi/editor/highlighter/HighlighterIterator;", "offset", "", "isEmptyDoubleQuotes", "start", "charSequence", "", "isOpeningQuote", "isQuote", "", "(Ljava/lang/Character;)Z", "Companion", "intellij.clouds.docker.file"})
public final class DockerQuoteHandler
extends SimpleTokenSetQuoteHandler {
    private static final Set<Character> allowedPrevSymbolsForOpeningQuote;
    @NotNull
    public static final Companion Companion;

    public boolean isClosingQuote(@NotNull HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        int start = iterator.getStart();
        Document document = iterator.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"iterator.document");
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"iterator.document.charsSequence");
        CharSequence charSequence2 = charSequence;
        return super.isClosingQuote(iterator, offset) && !this.isEmptyDoubleQuotes(start, charSequence2);
    }

    public boolean isOpeningQuote(@NotNull HighlighterIterator iterator, int offset) {
        Intrinsics.checkNotNullParameter((Object)iterator, (String)"iterator");
        Document document = iterator.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document, (String)"iterator.document");
        CharSequence charSequence = document.getCharsSequence();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"iterator.document.charsSequence");
        CharSequence charSequence2 = charSequence;
        int start = iterator.getStart();
        return super.isOpeningQuote(iterator, offset) && allowedPrevSymbolsForOpeningQuote.contains(StringsKt.getOrNull((CharSequence)charSequence2, (int)(start - 1)));
    }

    private final boolean isEmptyDoubleQuotes(int start, CharSequence charSequence) {
        return this.isQuote(StringsKt.getOrNull((CharSequence)charSequence, (int)start)) && this.isQuote(StringsKt.getOrNull((CharSequence)charSequence, (int)(start + 1)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isQuote(Character $this$isQuote) {
        Character c = $this$isQuote;
        if (c != null) {
            if (c.charValue() == '\"') return true;
        }
        Character c2 = $this$isQuote;
        if (c2 == null) return false;
        if (c2.charValue() != '\'') return false;
        return true;
    }

    public DockerQuoteHandler() {
        super(new IElementType[]{DockerTokenTypes.QUOTE});
    }

    static {
        Companion = new Companion(null);
        allowedPrevSymbolsForOpeningQuote = SetsKt.setOf((Object[])new Character[]{null, Character.valueOf(' '), Character.valueOf('{'), Character.valueOf('['), Character.valueOf('='), Character.valueOf(','), Character.valueOf(':')});
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\f\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/docker/dockerFile/quoteHandler/DockerQuoteHandler$Companion;", "", "()V", "allowedPrevSymbolsForOpeningQuote", "", "", "intellij.clouds.docker.file"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

