/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile.highlighting.highlight;

import com.intellij.docker.dockerFile.highlighting.highlight.DockerSyntaxHighlighterColors;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiDeclaration;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiVariableReference;
import com.intellij.docker.i18n.DockerBundle;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileFromCommand;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileRegularOption;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class DockerColorAnnotator
implements Annotator {
    private static final String AS_PSEUDO_KEYWORD = "AS";

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        if (element == null) {
            DockerColorAnnotator.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(1);
        }
        if (element instanceof DockerPsiVariableReference) {
            DockerColorAnnotator.annotatePsiNameReference((DockerPsiVariableReference)element, holder);
        } else if (element instanceof DockerPsiDeclaration) {
            DockerColorAnnotator.annotatePsiDeclaration((DockerPsiDeclaration)element, holder);
        } else if (element instanceof DockerFileRegularOption) {
            DockerColorAnnotator.annotateRegularOption((DockerFileRegularOption)element, holder);
        } else if (DockerColorAnnotator.isPseudoKeywordAs(element)) {
            DockerColorAnnotator.annotatePseudoKeyword(holder);
        }
    }

    private static boolean isPseudoKeywordAs(@NotNull PsiElement psi) {
        if (psi == null) {
            DockerColorAnnotator.$$$reportNull$$$0(2);
        }
        return psi.getNode().getElementType() == DockerTokenTypes.IDENTIFIER && StringUtil.equals((CharSequence)psi.getText(), (CharSequence)AS_PSEUDO_KEYWORD) && PsiTreeUtil.getParentOfType((PsiElement)psi, DockerFileFromCommand.class) != null;
    }

    private static void annotatePseudoKeyword(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(3);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).textAttributes(DockerSyntaxHighlighterColors.KEYWORD).create();
    }

    private static void annotatePsiNameReference(@NotNull DockerPsiVariableReference reference, @NotNull AnnotationHolder holder) {
        PsiElement referencedName;
        if (reference == null) {
            DockerColorAnnotator.$$$reportNull$$$0(4);
        }
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(5);
        }
        if ((referencedName = reference.getReferencedName()) == null) {
            return;
        }
        if (reference.resolve() == null) {
            String warning = DockerBundle.message((String)"DockerColorAnnotator.unresolvedVariableRef", (Object[])new Object[]{referencedName.getText()});
            holder.newAnnotation(HighlightSeverity.WEAK_WARNING, warning).range(referencedName).textAttributes(DockerSyntaxHighlighterColors.VARIABLE).create();
        } else {
            holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(referencedName).textAttributes(DockerSyntaxHighlighterColors.VARIABLE).create();
        }
    }

    private static void annotateRegularOption(@NotNull DockerFileRegularOption referenceHost, @NotNull AnnotationHolder holder) {
        PsiReference reference;
        if (referenceHost == null) {
            DockerColorAnnotator.$$$reportNull$$$0(6);
        }
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(7);
        }
        if ((reference = referenceHost.getReference()) == null) {
            return;
        }
        TextRange referencingRange = reference.getRangeInElement().shiftRight(reference.getElement().getTextRange().getStartOffset());
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(referencingRange).textAttributes(DockerSyntaxHighlighterColors.VARIABLE).create();
    }

    private static void annotatePsiDeclaration(@NotNull DockerPsiDeclaration declaration, @NotNull AnnotationHolder holder) {
        if (declaration == null) {
            DockerColorAnnotator.$$$reportNull$$$0(8);
        }
        if (holder == null) {
            DockerColorAnnotator.$$$reportNull$$$0(9);
        }
        holder.newSilentAnnotation(HighlightSeverity.INFORMATION).range(declaration.getDeclaredName()).textAttributes(DockerSyntaxHighlighterColors.VARIABLE).create();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceHost";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaration";
                break;
            }
        }
        objectArray2[1] = "com/intellij/docker/dockerFile/highlighting/highlight/DockerColorAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isPseudoKeywordAs";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePseudoKeyword";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePsiNameReference";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateRegularOption";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "annotatePsiDeclaration";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

