/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.dockerFile;

import com.intellij.docker.dockerFile.DockerPsiFile;
import com.intellij.docker.dockerFile.parser.psi.DockerPsiVariableReference;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.plugins.docker.dockerFile.lexer.DockerTokenTypes;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileAddOrCopyCommand;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileFileOrUrl;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileParametersInJsonForm;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFilePathSegment;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileRegularOption;
import com.intellij.plugins.docker.dockerFile.parser.psi.DockerFileStringLiteral;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.JBIterable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\u001e\u0010\b\u001a\u00020\u00012\u0006\u0010\t\u001a\u00020\n2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u001a\f\u0010\u000b\u001a\u00020\f*\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u0003*\u00020\u000f\u00a8\u0006\u0010"}, d2={"extractPathsToCopyFromFileArgs", "", "arguments", "", "Lcom/intellij/plugins/docker/dockerFile/parser/psi/DockerFileFileOrUrl;", "localPaths", "", "", "extractPathsToCopyFromJson", "jsonParameters", "Lcom/intellij/plugins/docker/dockerFile/parser/psi/DockerFileParametersInJsonForm;", "hasFromOption", "", "Lcom/intellij/plugins/docker/dockerFile/parser/psi/DockerFileAddOrCopyCommand;", "localCopySourcePaths", "Lcom/intellij/docker/dockerFile/DockerPsiFile;", "intellij.clouds.docker.file"})
public final class DockerFileCopyCommandUtilsKt {
    @NotNull
    public static final List<String> localCopySourcePaths(@NotNull DockerPsiFile $this$localCopySourcePaths) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$localCopySourcePaths), (String)"$this$localCopySourcePaths");
        boolean bl = false;
        List pathsToTraverse = new ArrayList();
        JBIterable jBIterable = SyntaxTraverser.psiTraverser((PsiElement)((PsiElement)$this$localCopySourcePaths)).filter(DockerFileAddOrCopyCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"SyntaxTraverser.psiTrave\u2026rCopyCommand::class.java)");
        JBIterable copyCommands = jBIterable;
        for (DockerFileAddOrCopyCommand command : copyCommands) {
            if (PsiTreeUtil.hasErrorElements((PsiElement)command)) continue;
            DockerFileAddOrCopyCommand dockerFileAddOrCopyCommand = command;
            Intrinsics.checkNotNullExpressionValue((Object)dockerFileAddOrCopyCommand, (String)"command");
            if (DockerFileCopyCommandUtilsKt.hasFromOption(dockerFileAddOrCopyCommand)) continue;
            DockerFileParametersInJsonForm jsonParameters = command.getParametersInJsonForm();
            if (jsonParameters != null) {
                DockerFileCopyCommandUtilsKt.extractPathsToCopyFromJson(jsonParameters, pathsToTraverse);
                continue;
            }
            List<DockerFileFileOrUrl> list = command.getFileOrUrlList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"command.fileOrUrlList");
            DockerFileCopyCommandUtilsKt.extractPathsToCopyFromFileArgs(list, pathsToTraverse);
        }
        return pathsToTraverse;
    }

    private static final boolean hasFromOption(DockerFileAddOrCopyCommand $this$hasFromOption) {
        boolean bl;
        block3: {
            List<DockerFileRegularOption> list = $this$hasFromOption.getRegularOptionList();
            Intrinsics.checkNotNullExpressionValue(list, (String)"regularOptionList");
            Iterable $this$any$iv = list;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    DockerFileRegularOption it = (DockerFileRegularOption)element$iv;
                    boolean bl2 = false;
                    DockerFileRegularOption dockerFileRegularOption = it;
                    Intrinsics.checkNotNullExpressionValue((Object)dockerFileRegularOption, (String)"it");
                    PsiElement psiElement = dockerFileRegularOption.getOptionName();
                    if (!(psiElement != null && psiElement.textMatches((CharSequence)"from"))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private static final void extractPathsToCopyFromJson(DockerFileParametersInJsonForm jsonParameters, List<String> localPaths) {
        List<DockerFileStringLiteral> list = jsonParameters.getStringLiteralList();
        Intrinsics.checkNotNullExpressionValue(list, (String)"jsonParameters.stringLiteralList");
        List literals = CollectionsKt.dropLast(list, (int)1);
        for (DockerFileStringLiteral literal : literals) {
            String path = null;
            Iterator iterator = SyntaxTraverser.psiTraverser().children((Object)literal).iterator();
            while (iterator.hasNext()) {
                PsiElement part;
                PsiElement psiElement = part = (PsiElement)iterator.next();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"part");
                ASTNode aSTNode = psiElement.getNode();
                Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"part.node");
                if (aSTNode.getElementType() == DockerTokenTypes.QUOTE) continue;
                if (part instanceof DockerPsiVariableReference) {
                    path = null;
                    break;
                }
                path = StringUtil.unescapeStringCharacters((String)part.getText());
            }
            if (path == null) continue;
            localPaths.add(path);
        }
    }

    private static final void extractPathsToCopyFromFileArgs(List<? extends DockerFileFileOrUrl> arguments, List<String> localPaths) {
        for (DockerFileFileOrUrl argument : CollectionsKt.dropLast(arguments, (int)1)) {
            boolean hasVariableReferences = false;
            for (PsiElement segment : SyntaxTraverser.psiTraverser().children((Object)argument)) {
                if (segment instanceof DockerFilePathSegment && ((DockerFilePathSegment)segment).getVariableRefFull() == null && ((DockerFilePathSegment)segment).getVariableRefSimple() == null) continue;
                hasVariableReferences = true;
                break;
            }
            if (hasVariableReferences) continue;
            String string = argument.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"argument.text");
            localPaths.add(string);
        }
    }
}

