/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.java.jdk;

import com.google.common.hash.Hasher;
import com.google.common.hash.Hashing;
import com.intellij.indexing.shared.java.jdk.JdkAliases;
import com.intellij.indexing.shared.java.jdk.JdkIndexLookupRequest;
import com.intellij.indexing.shared.java.jdk.JdkSupport;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStoreEntry;
import com.intellij.indexing.shared.java.jdk.SharedJdkChunkStoreState;
import com.intellij.openapi.components.BaseState;
import com.intellij.openapi.components.SimplePersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@State(name="shared-index-jdk-hash", storages={@Storage(value="$CACHE_FILE$")}, allowLoadInTests=true)
@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u001bB\u0005\u00a2\u0006\u0002\u0010\u0003J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u001e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0010J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/intellij/indexing/shared/java/jdk/SharedJdkChunkStore;", "Lcom/intellij/openapi/components/SimplePersistentStateComponent;", "Lcom/intellij/indexing/shared/java/jdk/SharedJdkChunkStoreState;", "()V", "doComputeCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "getDoComputeCounter", "()Ljava/util/concurrent/atomic/AtomicInteger;", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "doComputeAliases", "", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "doComputeJdkRequest", "Lcom/intellij/indexing/shared/java/jdk/JdkIndexLookupRequest;", "getOrComputeJdkRequest", "loadState", "", "state", "registerDownloadingJdkRequest", "lookupName", "home", "Lcom/intellij/openapi/vfs/VirtualFile;", "newState", "snapshot", "FileInfo", "intellij.indexing.shared.java"})
public final class SharedJdkChunkStore
extends SimplePersistentStateComponent<SharedJdkChunkStoreState> {
    private final ReentrantLock lock = new ReentrantLock();
    @TestOnly
    @NotNull
    private final AtomicInteger doComputeCounter = new AtomicInteger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadState(@NotNull SharedJdkChunkStoreState state) {
        Intrinsics.checkNotNullParameter((Object)((Object)state), (String)"state");
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            super.loadState((BaseState)state);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void registerDownloadingJdkRequest(@NotNull String lookupName, @NotNull VirtualFile home, @NotNull JdkIndexLookupRequest newState) {
        Intrinsics.checkNotNullParameter((Object)lookupName, (String)"lookupName");
        Intrinsics.checkNotNullParameter((Object)home, (String)"home");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        String string = this.snapshot(home);
        if (string == null) {
            return;
        }
        String snapshotHash = string;
        Lock lock = this.lock;
        boolean bl = false;
        boolean bl2 = false;
        lock.lock();
        try {
            boolean bl3 = false;
            CollectionsKt.removeAll(((SharedJdkChunkStoreState)this.getState()).getEntries(), (Function1)((Function1)new Function1<SharedJdkChunkStoreEntry, Boolean>(this, snapshotHash, lookupName, newState){
                final /* synthetic */ SharedJdkChunkStore this$0;
                final /* synthetic */ String $snapshotHash$inlined;
                final /* synthetic */ String $lookupName$inlined;
                final /* synthetic */ JdkIndexLookupRequest $newState$inlined;
                {
                    this.this$0 = sharedJdkChunkStore;
                    this.$snapshotHash$inlined = string;
                    this.$lookupName$inlined = string2;
                    this.$newState$inlined = jdkIndexLookupRequest;
                    super(1);
                }

                public final boolean invoke(@NotNull SharedJdkChunkStoreEntry it) {
                    Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
                    return Intrinsics.areEqual((Object)it.getSnapshotHash(), (Object)this.$snapshotHash$inlined);
                }
            }));
            ((SharedJdkChunkStoreState)this.getState()).getEntries().add(new SharedJdkChunkStoreEntry(lookupName, snapshotHash, newState));
            ((SharedJdkChunkStoreState)this.getState()).intIncrementModificationCount();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final JdkIndexLookupRequest getOrComputeJdkRequest(@NotNull Sdk sdk) {
        boolean bl;
        boolean bl2;
        Object object;
        Object object2;
        block12: {
            block11: {
                Intrinsics.checkNotNullParameter((Object)sdk, (String)"sdk");
                if (!JdkSupport.isJdk(sdk)) {
                    return null;
                }
                object2 = sdk.getHomeDirectory();
                if (object2 == null) break block11;
                object = object2;
                bl2 = false;
                bl = false;
                VirtualFile it = object;
                boolean bl3 = false;
                VirtualFile virtualFile = it;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"it");
                object2 = this.snapshot(virtualFile);
                if (object2 != null) break block12;
            }
            return null;
        }
        Object snapshotHash = object2;
        object = this.lock;
        bl2 = false;
        bl = false;
        object.lock();
        try {
            Object v2;
            boolean bl4;
            Object bl3;
            block10: {
                boolean bl5 = false;
                bl3 = ((SharedJdkChunkStoreState)this.getState()).getEntries();
                bl4 = false;
                Iterable iterable = bl3;
                boolean bl6 = false;
                for (Object t : iterable) {
                    SharedJdkChunkStoreEntry it = (SharedJdkChunkStoreEntry)((Object)t);
                    boolean bl7 = false;
                    if (!Intrinsics.areEqual((Object)it.getSnapshotHash(), (Object)snapshotHash)) continue;
                    v2 = t;
                    break block10;
                }
                v2 = null;
            }
            SharedJdkChunkStoreEntry sharedJdkChunkStoreEntry = v2;
            if (sharedJdkChunkStoreEntry != null) {
                bl3 = sharedJdkChunkStoreEntry;
                bl4 = false;
                boolean bl8 = false;
                Object it = bl3;
                boolean bl9 = false;
                JdkIndexLookupRequest jdkIndexLookupRequest = ((SharedJdkChunkStoreEntry)((Object)it)).toJdkIndexRequest();
                return jdkIndexLookupRequest;
            }
            JdkIndexLookupRequest newState = this.doComputeJdkRequest(sdk);
            List<SharedJdkChunkStoreEntry> list = ((SharedJdkChunkStoreState)this.getState()).getEntries();
            String string = sdk.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.name");
            list.add(new SharedJdkChunkStoreEntry(string, (String)snapshotHash, newState));
            ((SharedJdkChunkStoreState)this.getState()).intIncrementModificationCount();
            JdkIndexLookupRequest jdkIndexLookupRequest = newState;
            return jdkIndexLookupRequest;
        }
        finally {
            object.unlock();
        }
    }

    private final JdkIndexLookupRequest doComputeJdkRequest(Sdk sdk) {
        if (!JdkSupport.isJdk(sdk)) {
            return null;
        }
        String jdkFingerprint = JdkSupport.computeJdkFingerprint(sdk);
        List<String> aliases = this.doComputeAliases(sdk);
        String string = sdk.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sdk.name");
        CharSequence charSequence = string;
        boolean bl = false;
        return new JdkIndexLookupRequest(charSequence.length() == 0 ? null : sdk.getName(), jdkFingerprint, aliases, null, 8, null);
    }

    @NotNull
    public final AtomicInteger getDoComputeCounter() {
        return this.doComputeCounter;
    }

    private final List<String> doComputeAliases(Sdk sdk) {
        this.doComputeCounter.incrementAndGet();
        return JdkAliases.INSTANCE.computeAliasesForJdk(sdk);
    }

    /*
     * WARNING - void declaration
     */
    private final String snapshot(VirtualFile home) {
        TreeMap allFiles = new TreeMap();
        VfsUtil.visitChildrenRecursively((VirtualFile)home, (VirtualFileVisitor)((VirtualFileVisitor)new VirtualFileVisitor<Unit>(allFiles, new VirtualFileVisitor.Option[0]){
            final /* synthetic */ TreeMap $allFiles;

            public boolean visitFile(@NotNull VirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                if (!file.isDirectory()) {
                    Map map = this.$allFiles;
                    String string = file.getPath();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.path");
                    map.put(string, new FileInfo(file.getLength(), file.getTimeStamp()));
                }
                ProgressManager.checkCanceled();
                return super.visitFile(file);
            }
            {
                this.$allFiles = $captured_local_variable$0;
                super($super_call_param$1);
            }
        }));
        Hasher hasher = Hashing.sha256().newHasher();
        JavaSdk javaSdk = JdkSupport.getSupportedSdkType();
        Intrinsics.checkNotNullExpressionValue((Object)javaSdk, (String)"JdkSupport.getSupportedSdkType()");
        hasher.putUnencodedChars((CharSequence)javaSdk.getName());
        Object object = allFiles;
        boolean bl = false;
        Iterator iterator = object.entrySet().iterator();
        while (iterator.hasNext()) {
            void path;
            Map.Entry entry;
            Map.Entry entry2 = entry = iterator.next();
            boolean bl2 = false;
            object = (String)entry2.getKey();
            entry2 = entry;
            bl2 = false;
            FileInfo info = (FileInfo)entry2.getValue();
            hasher.putUnencodedChars((CharSequence)path);
            hasher.putLong(info.getSize());
            hasher.putLong(info.getTimestamp());
        }
        return hasher.hash().toString();
    }

    public SharedJdkChunkStore() {
        super((BaseState)new SharedJdkChunkStoreState());
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lcom/intellij/indexing/shared/java/jdk/SharedJdkChunkStore$FileInfo;", "", "size", "", "timestamp", "(JJ)V", "getSize", "()J", "getTimestamp", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "intellij.indexing.shared.java"})
    private static final class FileInfo {
        private final long size;
        private final long timestamp;

        public final long getSize() {
            return this.size;
        }

        public final long getTimestamp() {
            return this.timestamp;
        }

        public FileInfo(long size, long timestamp) {
            this.size = size;
            this.timestamp = timestamp;
        }

        public final long component1() {
            return this.size;
        }

        public final long component2() {
            return this.timestamp;
        }

        @NotNull
        public final FileInfo copy(long size, long timestamp) {
            return new FileInfo(size, timestamp);
        }

        public static /* synthetic */ FileInfo copy$default(FileInfo fileInfo, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = fileInfo.size;
            }
            if ((n & 2) != 0) {
                l2 = fileInfo.timestamp;
            }
            return fileInfo.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "FileInfo(size=" + this.size + ", timestamp=" + this.timestamp + ")";
        }

        public int hashCode() {
            return Long.hashCode(this.size) * 31 + Long.hashCode(this.timestamp);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof FileInfo)) break block3;
                    FileInfo fileInfo = (FileInfo)object;
                    if (this.size != fileInfo.size || this.timestamp != fileInfo.timestamp) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

