/*
 * Decompiled with CFR 0.152.
 */
package dk.dren.hunspell;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import dk.dren.hunspell.HunspellLibrary;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class Hunspell
implements HunspellLibrary {
    private static Hunspell hunspell = null;
    private String libFile;
    private HashMap<String, Dictionary> map = new HashMap();
    private HashMap<String, Long> modMap = new HashMap();

    @Override
    public native Pointer Hunspell_create(String var1, String var2);

    @Override
    public native void Hunspell_destroy(Pointer var1);

    @Override
    public native int Hunspell_spell(Pointer var1, byte[] var2);

    @Override
    public native String Hunspell_get_dic_encoding(Pointer var1);

    @Override
    public native int Hunspell_suggest(Pointer var1, PointerByReference var2, byte[] var3);

    @Override
    public native int Hunspell_analyze(Pointer var1, PointerByReference var2, byte[] var3);

    @Override
    public native int Hunspell_stem(Pointer var1, PointerByReference var2, byte[] var3);

    @Override
    public native void Hunspell_free_list(Pointer var1, PointerByReference var2, int var3);

    public native int Hunspell_add(Pointer var1, byte[] var2);

    public native int Hunspell_remove(Pointer var1, byte[] var2);

    public static Hunspell getInstance() throws UnsatisfiedLinkError, UnsupportedOperationException {
        return Hunspell.getInstance(null);
    }

    public static Hunspell getInstance(String libDir) throws UnsatisfiedLinkError, UnsupportedOperationException {
        if (hunspell != null) {
            return hunspell;
        }
        hunspell = new Hunspell(libDir);
        return hunspell;
    }

    protected Hunspell(String libDir) throws UnsatisfiedLinkError, UnsupportedOperationException {
        this.libFile = libDir != null ? libDir + "/" + Hunspell.libName() : Hunspell.libNameBare();
    }

    public String getLibFile() {
        return this.libFile;
    }

    public static String libName() throws UnsupportedOperationException {
        String os = System.getProperty("os.name").toLowerCase();
        if (os.startsWith("windows")) {
            return Hunspell.libNameBare() + ".dll";
        }
        if (os.startsWith("mac os x")) {
            return "lib" + Hunspell.libNameBare() + ".dylib";
        }
        return "lib" + Hunspell.libNameBare() + ".so";
    }

    static String libNameBare() throws UnsupportedOperationException {
        boolean amd64;
        String os = System.getProperty("os.name").toLowerCase();
        String arch = System.getProperty("os.arch").toLowerCase();
        boolean x86 = arch.equals("x86") || arch.equals("i386") || arch.equals("i686");
        boolean bl = amd64 = arch.equals("x86_64") || arch.equals("amd64") || arch.equals("ia64n");
        if (os.startsWith("windows")) {
            if (x86) {
                return "hunspell-win-x86-32";
            }
            if (amd64) {
                return "hunspell-win-x86-64";
            }
        } else if (os.startsWith("mac os x")) {
            if (amd64) {
                return "hunspell-darwin-x86-64";
            }
        } else if (os.startsWith("linux")) {
            if (x86) {
                return "hunspell-linux-x86-32";
            }
            if (amd64) {
                return "hunspell-linux-x86-64";
            }
        } else if (os.startsWith("sunos")) {
            // empty if block
        }
        throw new UnsupportedOperationException("Unknown OS/arch: " + os + "/" + arch);
    }

    public Dictionary getDictionary(String baseFileName) throws FileNotFoundException, UnsupportedEncodingException {
        return this.getDictionary(baseFileName, false);
    }

    public Dictionary getDictionary(String baseFileName, boolean isUpdateAllowed) throws FileNotFoundException, UnsupportedEncodingException {
        Dictionary result = this.map.get(baseFileName);
        if (result == null || isUpdateAllowed) {
            Long lastModified;
            File dicFile = new File(baseFileName + ".dic");
            File affFile = new File(baseFileName + ".aff");
            try {
                lastModified = dicFile.lastModified() + affFile.lastModified();
            }
            catch (SecurityException e) {
                lastModified = 0L;
            }
            if (result != null && !lastModified.equals(this.modMap.get(baseFileName))) {
                this.destroyDictionary(baseFileName);
                result = null;
            }
            if (result == null) {
                result = new Dictionary(baseFileName);
                this.map.put(baseFileName, result);
                this.modMap.put(baseFileName, lastModified);
            }
        }
        return result;
    }

    public void destroyDictionary(String baseFileName) {
        if (this.map.containsKey(baseFileName)) {
            this.map.remove(baseFileName);
            this.modMap.remove(baseFileName);
        }
    }

    static {
        String libFile = Hunspell.libNameBare();
        try {
            Native.register((String)libFile);
        }
        catch (UnsatisfiedLinkError urgh) {
            File lib;
            libFile = Hunspell.libName();
            InputStream is = Hunspell.class.getResourceAsStream("/" + libFile);
            if (is == null) {
                throw new UnsatisfiedLinkError("Can't find " + libFile + " in the filesystem nor in the classpath\n" + urgh);
            }
            FileOutputStream fos = null;
            try {
                int count;
                lib = File.createTempFile("jna", "." + libFile);
                lib.deleteOnExit();
                fos = new FileOutputStream(lib);
                byte[] buf = new byte[1024];
                while ((count = is.read(buf, 0, buf.length)) > 0) {
                    fos.write(buf, 0, count);
                }
            }
            catch (IOException e) {
                throw new Error("Failed to create temporary file for " + libFile, e);
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            Native.register((String)lib.getAbsolutePath());
        }
    }

    public class Dictionary {
        private Pointer hunspellDict = null;
        private String encoding;

        Dictionary(String baseFileName) throws FileNotFoundException, UnsupportedEncodingException {
            File dic = new File(baseFileName + ".dic");
            File aff = new File(baseFileName + ".aff");
            if (!dic.canRead() || !aff.canRead()) {
                throw new FileNotFoundException("The dictionary files " + baseFileName + "(.aff|.dic) could not be read");
            }
            this.hunspellDict = Hunspell.this.Hunspell_create(aff.toString(), dic.toString());
            this.encoding = Hunspell.this.Hunspell_get_dic_encoding(this.hunspellDict);
            Native.toByteArray((String)"test", (String)this.encoding);
        }

        protected void finalize() throws Throwable {
            this.destroy();
            super.finalize();
        }

        public void destroy() {
            if (this.hunspellDict != null) {
                Hunspell.this.Hunspell_destroy(this.hunspellDict);
                this.hunspellDict = null;
            }
        }

        public boolean misspelled(String word) {
            return Hunspell.this.Hunspell_spell(this.hunspellDict, Native.toByteArray((String)word, (String)this.encoding)) == 0;
        }

        public boolean add(String word) {
            return Hunspell.this.Hunspell_add(this.hunspellDict, Native.toByteArray((String)word, (String)this.encoding)) == 0;
        }

        public boolean remove(String word) {
            return Hunspell.this.Hunspell_remove(this.hunspellDict, Native.toByteArray((String)word, (String)this.encoding)) == 0;
        }

        public List<String> suggest(String word) {
            int suggestionsCount = 0;
            PointerByReference suggestions = new PointerByReference();
            suggestionsCount = Hunspell.this.Hunspell_suggest(this.hunspellDict, suggestions, Native.toByteArray((String)word, (String)this.encoding));
            return this.pointerToCStringsToList(suggestions, suggestionsCount);
        }

        public List<String> analyze(String word) {
            int analysesCount = 0;
            PointerByReference analyses = new PointerByReference();
            analysesCount = Hunspell.this.Hunspell_analyze(this.hunspellDict, analyses, Native.toByteArray((String)word, (String)this.encoding));
            return this.pointerToCStringsToList(analyses, analysesCount);
        }

        public List<String> stem(String word) {
            int stemsCount = 0;
            PointerByReference stems = new PointerByReference();
            stemsCount = Hunspell.this.Hunspell_stem(this.hunspellDict, stems, Native.toByteArray((String)word, (String)this.encoding));
            return this.pointerToCStringsToList(stems, stemsCount);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> pointerToCStringsToList(PointerByReference slst, int n) {
            if (n == 0) {
                return Collections.emptyList();
            }
            ArrayList<String> strings = new ArrayList<String>(n);
            try {
                Pointer[] pointerArray = slst.getValue().getPointerArray(0L, n);
                for (int i = 0; i < n; ++i) {
                    long len = pointerArray[i].indexOf(0L, (byte)0);
                    if (len == -1L) continue;
                    if (len > Integer.MAX_VALUE) {
                        throw new RuntimeException("String improperly terminated: " + len);
                    }
                    byte[] data = pointerArray[i].getByteArray(0L, (int)len);
                    strings.add(new String(data, this.encoding));
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
            finally {
                Hunspell.this.Hunspell_free_list(this.hunspellDict, slst, n);
            }
            return strings;
        }
    }
}

