/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.impl;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.daemon.Validator;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.ide.highlighter.XHtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlElementDecl;
import com.intellij.psi.xml.XmlEntityRef;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlMarkupDecl;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.reference.SoftReference;
import com.intellij.xml.actions.validate.ErrorReporter;
import com.intellij.xml.actions.validate.ValidateXmlActionHandler;
import com.intellij.xml.util.XmlResourceResolver;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.SAXParseException;

public class ExternalDocumentValidator {
    private static final Logger LOG = Logger.getInstance(ExternalDocumentValidator.class);
    private static final Key<SoftReference<ExternalDocumentValidator>> validatorInstanceKey = Key.create((String)"validatorInstance");
    @NonNls
    public static final String INSPECTION_SHORT_NAME = "CheckXmlFileWithXercesValidator";
    private ValidateXmlActionHandler myHandler;
    private Validator.ValidationHost myHost;
    private long myModificationStamp;
    private PsiFile myFile;
    @NonNls
    private static final String CANNOT_FIND_DECLARATION_ERROR_PREFIX = "Cannot find the declaration of element";
    @NonNls
    private static final String ELEMENT_ERROR_PREFIX = "Element";
    @NonNls
    private static final String ROOT_ELEMENT_ERROR_PREFIX = "Document root element";
    @NonNls
    private static final String CONTENT_OF_ELEMENT_TYPE_ERROR_PREFIX = "The content of element type";
    @NonNls
    private static final String VALUE_ERROR_PREFIX = "Value ";
    @NonNls
    private static final String ATTRIBUTE_ERROR_PREFIX = "Attribute ";
    @NonNls
    private static final String STRING_ERROR_PREFIX = "The string";
    @NonNls
    private static final String ATTRIBUTE_MESSAGE_PREFIX = "cvc-attribute.";
    private WeakReference<List<ValidationInfo>> myInfos;

    private void runJaxpValidation(XmlElement element, Validator.ValidationHost host) {
        Project project;
        Document document;
        final PsiFile file = element.getContainingFile();
        if (file == null || file.getVirtualFile() == null) {
            return;
        }
        if (this.myFile == file && this.myModificationStamp == file.getModificationStamp() && !ValidateXmlActionHandler.isValidationDependentFilesOutOfDate((XmlFile)file) && SoftReference.dereference(this.myInfos) != null) {
            ExternalDocumentValidator.addAllInfos(host, (List)this.myInfos.get());
            return;
        }
        if (this.myHandler == null) {
            this.myHandler = new ValidateXmlActionHandler(false);
        }
        if ((document = PsiDocumentManager.getInstance((Project)(project = element.getProject())).getDocument(file)) == null) {
            return;
        }
        final LinkedList results = new LinkedList();
        this.myHost = new Validator.ValidationHost(){

            public void addMessage(PsiElement context, String message, @NotNull Validator.ValidationHost.ErrorType type) {
                if (type == null) {
                    1.$$$reportNull$$$0(0);
                }
                ValidationInfo o = new ValidationInfo(context, message, type);
                results.add(o);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/xml/impl/ExternalDocumentValidator$1", "addMessage"));
            }
        };
        this.myHandler.setErrorReporter(new ErrorReporter(this.myHandler){
            int unsupportedSchemeAt;
            {
                super(handler);
                this.unsupportedSchemeAt = -1;
            }

            @Override
            public boolean isStopOnUndeclaredResource() {
                return true;
            }

            @Override
            public void processError(SAXParseException e, ValidateXmlActionHandler.ProblemType warning) {
                try {
                    ApplicationManager.getApplication().runReadAction(() -> {
                        PsiElement currentElement;
                        if (e.getPublicId() != null) {
                            return;
                        }
                        VirtualFile errorFile = this.myHandler.getProblemFile(e);
                        if (!Comparing.equal((Object)errorFile, (Object)file.getVirtualFile()) && errorFile != null) {
                            return;
                        }
                        if (document.getLineCount() < e.getLineNumber() || e.getLineNumber() <= 0) {
                            return;
                        }
                        Validator.ValidationHost.ErrorType problemType = ExternalDocumentValidator.getProblemType(warning);
                        int offset = Math.max(0, document.getLineStartOffset(e.getLineNumber() - 1) + e.getColumnNumber() - 2);
                        if (offset >= document.getTextLength()) {
                            return;
                        }
                        PsiElement originalElement = currentElement = PsiDocumentManager.getInstance((Project)project).getPsiFile(document).findElementAt(offset);
                        String elementText = currentElement.getText();
                        if (elementText.equals("</")) {
                            currentElement = currentElement.getNextSibling();
                        } else if (elementText.equals(">") || elementText.equals("/>") || elementText.equals("=")) {
                            currentElement = currentElement.getPrevSibling();
                        }
                        String localizedMessage = e.getLocalizedMessage();
                        int endIndex = localizedMessage.indexOf(58);
                        if (endIndex < localizedMessage.length() - 1 && localizedMessage.charAt(endIndex + 1) == '/') {
                            endIndex = -1;
                        }
                        String messageId = endIndex != -1 ? localizedMessage.substring(0, endIndex) : "";
                        localizedMessage = localizedMessage.substring(endIndex + 1).trim();
                        if ("cvc-elt.1.a".equals(messageId)) {
                            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlTag.class);
                            if (tag != null && tag.getNamespace().isEmpty()) {
                                return;
                            }
                        } else {
                            if ("SchemeUnsupported".equals(messageId)) {
                                this.unsupportedSchemeAt = offset;
                                return;
                            }
                            if (this.unsupportedSchemeAt == offset && ("An 'include' failed, and no 'fallback' element was found.".equals(localizedMessage) || e.getLocalizedMessage().startsWith("Include operation failed, reverting to fallback."))) {
                                return;
                            }
                        }
                        if (localizedMessage.startsWith(ExternalDocumentValidator.CANNOT_FIND_DECLARATION_ERROR_PREFIX) || localizedMessage.startsWith(ExternalDocumentValidator.ELEMENT_ERROR_PREFIX) || localizedMessage.startsWith(ExternalDocumentValidator.ROOT_ELEMENT_ERROR_PREFIX) || localizedMessage.startsWith(ExternalDocumentValidator.CONTENT_OF_ELEMENT_TYPE_ERROR_PREFIX)) {
                            ExternalDocumentValidator.this.addProblemToTagName(currentElement, originalElement, localizedMessage, warning);
                        } else if (localizedMessage.startsWith(ExternalDocumentValidator.VALUE_ERROR_PREFIX)) {
                            ExternalDocumentValidator.this.addProblemToTagName(currentElement, originalElement, localizedMessage, warning);
                        } else if (messageId.startsWith(ExternalDocumentValidator.ATTRIBUTE_MESSAGE_PREFIX)) {
                            @NonNls String prefix = "of attribute ";
                            int i = localizedMessage.indexOf(prefix);
                            if (i != -1) {
                                int messagePrefixLength = prefix.length() + i;
                                int nextQuoteIndex = localizedMessage.indexOf(localizedMessage.charAt(messagePrefixLength), messagePrefixLength + 1);
                                String attrName = nextQuoteIndex == -1 ? null : localizedMessage.substring(messagePrefixLength + 1, nextQuoteIndex);
                                XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
                                currentElement = parent.getAttribute(attrName, null);
                                if (currentElement != null) {
                                    currentElement = ((XmlAttribute)currentElement).getValueElement();
                                }
                            }
                            if (currentElement != null) {
                                ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
                                ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, problemType);
                            } else {
                                ExternalDocumentValidator.this.addProblemToTagName(originalElement, originalElement, localizedMessage, warning);
                            }
                        } else if (localizedMessage.startsWith(ExternalDocumentValidator.ATTRIBUTE_ERROR_PREFIX)) {
                            int messagePrefixLength = ExternalDocumentValidator.ATTRIBUTE_ERROR_PREFIX.length();
                            if (localizedMessage.charAt(messagePrefixLength) == '\"' || localizedMessage.charAt(messagePrefixLength) == '\'') {
                                int nextQuoteIndex = localizedMessage.indexOf(localizedMessage.charAt(messagePrefixLength), messagePrefixLength + 1);
                                String attrName = nextQuoteIndex == -1 ? null : localizedMessage.substring(messagePrefixLength + 1, nextQuoteIndex);
                                XmlTag parent = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
                                currentElement = parent.getAttribute(attrName, null);
                                if (currentElement != null) {
                                    currentElement = SourceTreeToPsiMap.treeElementToPsi((ASTNode)XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(SourceTreeToPsiMap.psiElementToTree((PsiElement)currentElement)));
                                }
                            } else {
                                currentElement = PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlTag.class, (boolean)false);
                            }
                            if (currentElement != null) {
                                ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
                                ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, problemType);
                            } else {
                                ExternalDocumentValidator.this.addProblemToTagName(originalElement, originalElement, localizedMessage, warning);
                            }
                        } else if (localizedMessage.startsWith(ExternalDocumentValidator.STRING_ERROR_PREFIX)) {
                            if (currentElement != null) {
                                ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, Validator.ValidationHost.ErrorType.WARNING);
                            }
                        } else {
                            currentElement = ExternalDocumentValidator.getNodeForMessage(currentElement != null ? currentElement : originalElement);
                            ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
                            if (currentElement != null) {
                                ExternalDocumentValidator.this.myHost.addMessage(currentElement, localizedMessage, problemType);
                            }
                        }
                    });
                }
                catch (Exception ex) {
                    if (ex instanceof ProcessCanceledException) {
                        throw (ProcessCanceledException)((Object)ex);
                    }
                    if (ex instanceof XmlResourceResolver.IgnoredResourceException) {
                        throw (XmlResourceResolver.IgnoredResourceException)ex;
                    }
                    LOG.error((Throwable)ex);
                }
            }
        });
        this.myHandler.doValidate((XmlFile)file);
        this.myFile = file;
        this.myModificationStamp = this.myFile.getModificationStamp();
        this.myInfos = new WeakReference(results);
        ExternalDocumentValidator.addAllInfos(host, results);
    }

    private static Validator.ValidationHost.ErrorType getProblemType(ValidateXmlActionHandler.ProblemType warning) {
        return warning == ValidateXmlActionHandler.ProblemType.WARNING ? Validator.ValidationHost.ErrorType.WARNING : Validator.ValidationHost.ErrorType.ERROR;
    }

    private static PsiElement getNodeForMessage(PsiElement currentElement) {
        PsiElement parentOfType = PsiTreeUtil.getNonStrictParentOfType((PsiElement)currentElement, (Class[])new Class[]{XmlTag.class, XmlProcessingInstruction.class, XmlElementDecl.class, XmlMarkupDecl.class, XmlEntityRef.class, XmlDoctype.class});
        if (parentOfType == null) {
            parentOfType = currentElement instanceof XmlToken ? currentElement.getParent() : currentElement;
        }
        return parentOfType;
    }

    private static void addAllInfos(Validator.ValidationHost host, List<? extends ValidationInfo> highlightInfos) {
        for (ValidationInfo validationInfo : highlightInfos) {
            host.addMessage(validationInfo.element, validationInfo.message, validationInfo.type);
        }
    }

    private void addProblemToTagName(PsiElement currentElement, PsiElement originalElement, @InspectionMessage String localizedMessage, ValidateXmlActionHandler.ProblemType problemType) {
        if ((currentElement = PsiTreeUtil.getParentOfType((PsiElement)currentElement, XmlTag.class, (boolean)false)) == null) {
            currentElement = PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlElementDecl.class, (boolean)false);
        }
        if (currentElement == null) {
            currentElement = originalElement;
        }
        ExternalDocumentValidator.assertValidElement(currentElement, originalElement, localizedMessage);
        if (currentElement != null) {
            this.myHost.addMessage(currentElement, localizedMessage, ExternalDocumentValidator.getProblemType(problemType));
        }
    }

    private static void assertValidElement(PsiElement currentElement, PsiElement originalElement, String message) {
        if (currentElement == null) {
            XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)originalElement, XmlTag.class);
            LOG.error("The validator message:" + message + " is bound to null node,\ninitial element:" + originalElement.getText() + ",\nparent:" + originalElement.getParent() + ",\ntag:" + (tag != null ? tag.getText() : "null") + ",\noffset in tag: " + (originalElement.getTextOffset() - (tag == null ? 0 : tag.getTextOffset())));
        }
    }

    public static synchronized void doValidation(XmlDocument document, Validator.ValidationHost host) {
        PsiFile containingFile = document.getContainingFile();
        if (containingFile == null) {
            return;
        }
        if (containingFile.getViewProvider() instanceof TemplateLanguageFileViewProvider) {
            return;
        }
        FileType fileType = containingFile.getViewProvider().getFileType();
        if (fileType != XmlFileType.INSTANCE && fileType != XHtmlFileType.INSTANCE) {
            return;
        }
        for (Language lang : containingFile.getViewProvider().getLanguages()) {
            if (!"ANT".equals(lang.getID())) continue;
            return;
        }
        XmlTag rootTag = document.getRootTag();
        if (rootTag == null) {
            return;
        }
        String namespace = rootTag.getNamespace();
        if ("http://ant.apache.org/schema.xsd".equals(namespace)) {
            return;
        }
        Project project = document.getProject();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)project).getCurrentProfile();
        InspectionToolWrapper toolWrapper = profile.getInspectionTool(INSPECTION_SHORT_NAME, (PsiElement)containingFile);
        if (toolWrapper == null) {
            return;
        }
        if (!profile.isToolEnabled(HighlightDisplayKey.find((String)INSPECTION_SHORT_NAME), (PsiElement)containingFile)) {
            return;
        }
        SoftReference validatorReference = (SoftReference)project.getUserData(validatorInstanceKey);
        ExternalDocumentValidator validator = (ExternalDocumentValidator)SoftReference.dereference((Reference)validatorReference);
        if (validator == null) {
            validator = new ExternalDocumentValidator();
            project.putUserData(validatorInstanceKey, (Object)new SoftReference((Object)validator));
        }
        validator.runJaxpValidation((XmlElement)document, host);
    }

    private static final class ValidationInfo {
        final PsiElement element;
        final @InspectionMessage String message;
        final Validator.ValidationHost.ErrorType type;

        private ValidationInfo(PsiElement element, @InspectionMessage String message, Validator.ValidationHost.ErrorType type) {
            this.element = element;
            this.message = message;
            this.type = type;
        }
    }
}

