/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.html.dtd;

import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import com.intellij.html.impl.RelaxedHtmlFromSchemaElementDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.html.dtd.HtmlAttributeDescriptorImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.XmlNSDescriptor;
import com.intellij.xml.impl.dtd.BaseXmlElementDescriptorImpl;
import com.intellij.xml.impl.schema.XmlNSDescriptorImpl;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.HashMap;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class HtmlElementDescriptorImpl
extends BaseXmlElementDescriptorImpl {
    private final Set<String> ourHtml4DeprecatedTags = ContainerUtil.newHashSet((Object[])new String[]{"applet", "basefont", "center", "dir", "font", "frame", "frameset", "isindex", "menu", "noframes", "s", "strike", "u", "xmp"});
    private final XmlElementDescriptor myDelegate;
    private final boolean myRelaxed;
    private final boolean myCaseSensitive;

    public HtmlElementDescriptorImpl(XmlElementDescriptor _delegate, boolean relaxed, boolean caseSensitive) {
        this.myDelegate = _delegate;
        this.myRelaxed = relaxed;
        this.myCaseSensitive = caseSensitive;
    }

    public String getQualifiedName() {
        return this.myDelegate.getQualifiedName();
    }

    public String getDefaultName() {
        return this.myDelegate.getDefaultName();
    }

    @Override
    protected final XmlElementDescriptor[] doCollectXmlDescriptors(XmlTag context) {
        XmlElementDescriptor[] elementsDescriptors = this.myDelegate.getElementsDescriptors(context);
        XmlElementDescriptor[] temp = new XmlElementDescriptor[elementsDescriptors.length];
        for (int i = 0; i < elementsDescriptors.length; ++i) {
            temp[i] = new HtmlElementDescriptorImpl(elementsDescriptors[i], this.myRelaxed, this.myCaseSensitive);
        }
        return temp;
    }

    @Override
    public XmlElementDescriptor getElementDescriptor(XmlTag element, XmlTag contextTag) {
        String name = this.toLowerCaseIfNeeded(element.getName());
        XmlElementDescriptor xmlElementDescriptor = this.getElementDescriptor(name, contextTag);
        if (xmlElementDescriptor == null && "html".equals(this.getName())) {
            XmlElementDescriptor bodyDescriptor;
            XmlElementDescriptor headDescriptor;
            XmlTag head = null;
            XmlTag body = null;
            for (XmlTag child : PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)contextTag, XmlTag.class)) {
                if ("head".equals(child.getName())) {
                    head = child;
                }
                if (!"body".equals(child.getName())) continue;
                body = child;
            }
            if (head == null && (body == null || element.getTextOffset() < body.getTextOffset()) && (headDescriptor = this.getElementDescriptor("head", contextTag)) != null) {
                xmlElementDescriptor = headDescriptor.getElementDescriptor(element, contextTag);
            }
            if (xmlElementDescriptor == null && body == null && (bodyDescriptor = this.getElementDescriptor("body", contextTag)) != null) {
                xmlElementDescriptor = bodyDescriptor.getElementDescriptor(element, contextTag);
            }
        }
        if (xmlElementDescriptor == null && this.myRelaxed) {
            xmlElementDescriptor = RelaxedHtmlFromSchemaElementDescriptor.getRelaxedDescriptor(this, element);
        }
        return xmlElementDescriptor;
    }

    @Override
    protected HashMap<String, XmlElementDescriptor> collectElementDescriptorsMap(XmlTag element) {
        XmlElementDescriptor[] elementDescriptors;
        HashMap<String, XmlElementDescriptor> hashMap = new HashMap<String, XmlElementDescriptor>();
        for (XmlElementDescriptor elementDescriptor : elementDescriptors = this.myDelegate.getElementsDescriptors(element)) {
            hashMap.put(this.toLowerCaseIfNeeded(elementDescriptor.getName((PsiElement)element)), new HtmlElementDescriptorImpl(elementDescriptor, this.myRelaxed, this.myCaseSensitive));
        }
        return hashMap;
    }

    @Override
    protected XmlAttributeDescriptor[] collectAttributeDescriptors(XmlTag context) {
        XmlAttributeDescriptor[] attributesDescriptors = this.myDelegate.getAttributesDescriptors(context);
        XmlAttributeDescriptor[] temp = new XmlAttributeDescriptor[attributesDescriptors.length];
        for (int i = 0; i < attributesDescriptors.length; ++i) {
            temp[i] = new HtmlAttributeDescriptorImpl(attributesDescriptors[i], this.myCaseSensitive);
        }
        return temp;
    }

    @Override
    public XmlAttributeDescriptor getAttributeDescriptor(String attributeName, XmlTag context) {
        XmlNSDescriptor nsdescriptor;
        String prefix;
        String caseSensitiveAttributeName = this.toLowerCaseIfNeeded(attributeName);
        XmlAttributeDescriptor descriptor = super.getAttributeDescriptor(caseSensitiveAttributeName, context);
        if (descriptor == null) {
            descriptor = RelaxedHtmlFromSchemaElementDescriptor.getAttributeDescriptorFromFacelets(attributeName, context);
        }
        if (descriptor == null && "xml".equals(prefix = XmlUtil.findPrefixByQualifiedName(attributeName)) && (nsdescriptor = context.getNSDescriptor("http://www.w3.org/XML/1998/namespace", true)) instanceof XmlNSDescriptorImpl) {
            descriptor = ((XmlNSDescriptorImpl)nsdescriptor).getAttribute(XmlUtil.findLocalNameByQualifiedName(caseSensitiveAttributeName), "http://www.w3.org/XML/1998/namespace", context);
        }
        if (descriptor == null && HtmlUtil.isHtml5Context((XmlElement)context)) {
            descriptor = this.myDelegate.getAttributeDescriptor(attributeName, context);
        }
        return descriptor;
    }

    @Override
    protected HashMap<String, XmlAttributeDescriptor> collectAttributeDescriptorsMap(XmlTag context) {
        XmlAttributeDescriptor[] elementAttributeDescriptors;
        HashMap<String, XmlAttributeDescriptor> hashMap = new HashMap<String, XmlAttributeDescriptor>();
        for (XmlAttributeDescriptor attributeDescriptor : elementAttributeDescriptors = this.myDelegate.getAttributesDescriptors(context)) {
            hashMap.put(this.toLowerCaseIfNeeded(attributeDescriptor.getName((PsiElement)context)), new HtmlAttributeDescriptorImpl(attributeDescriptor, this.myCaseSensitive));
        }
        return hashMap;
    }

    public XmlNSDescriptor getNSDescriptor() {
        return this.myDelegate.getNSDescriptor();
    }

    public int getContentType() {
        return this.myDelegate.getContentType();
    }

    public PsiElement getDeclaration() {
        return this.myDelegate.getDeclaration();
    }

    public String getName(PsiElement context) {
        return this.myDelegate.getName(context);
    }

    public String getName() {
        return this.myDelegate.getName();
    }

    public void init(PsiElement element) {
        this.myDelegate.init(element);
    }

    public Object @NotNull [] getDependencies() {
        Object[] objectArray = this.myDelegate.getDependencies();
        if (objectArray == null) {
            HtmlElementDescriptorImpl.$$$reportNull$$$0(0);
        }
        return objectArray;
    }

    @Override
    public XmlAttributeDescriptor[] getAttributesDescriptors(XmlTag context) {
        return RelaxedHtmlFromSchemaElementDescriptor.addAttrDescriptorsForFacelets(context, this.getDefaultAttributeDescriptors(context));
    }

    public XmlAttributeDescriptor[] getDefaultAttributeDescriptors(XmlTag context) {
        return super.getAttributesDescriptors(context);
    }

    public boolean allowElementsFromNamespace(String namespace, XmlTag context) {
        return true;
    }

    @NotNull
    XmlElementDescriptor getDelegate() {
        XmlElementDescriptor xmlElementDescriptor = this.myDelegate;
        if (xmlElementDescriptor == null) {
            HtmlElementDescriptorImpl.$$$reportNull$$$0(1);
        }
        return xmlElementDescriptor;
    }

    @Override
    public String toString() {
        return this.myDelegate.toString();
    }

    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    public boolean isDeprecated() {
        boolean deprecatedInHtml5;
        boolean html4Deprecated = this.ourHtml4DeprecatedTags.contains(this.myDelegate.getName());
        MdnSymbolDocumentation documentation = (MdnSymbolDocumentation)ObjectUtils.doIfNotNull((Object)this.myDelegate.getDeclaration(), declaration -> MdnDocumentationKt.getHtmlMdnDocumentation(declaration, null));
        boolean bl = deprecatedInHtml5 = documentation != null && documentation.isDeprecated();
        if (!html4Deprecated && !deprecatedInHtml5) {
            return false;
        }
        boolean inHtml5 = HtmlUtil.isHtml5Schema(this.getNSDescriptor());
        return inHtml5 && deprecatedInHtml5 || !inHtml5 && html4Deprecated;
    }

    private String toLowerCaseIfNeeded(String name) {
        return this.isCaseSensitive() ? name : StringUtil.toLowerCase((String)name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/psi/impl/source/html/dtd/HtmlElementDescriptorImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependencies";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDelegate";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

