/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.documentation.mdn;

import com.intellij.documentation.mdn.MdnApiStatus;
import com.intellij.documentation.mdn.MdnDocumentation;
import com.intellij.documentation.mdn.MdnDocumentationKt;
import com.intellij.documentation.mdn.MdnRawSymbolDocumentation;
import com.intellij.documentation.mdn.MdnSymbolDocumentation;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\nH\u0016J \u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\n2\u000e\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0014"}, d2={"Lcom/intellij/documentation/mdn/MdnSymbolDocumentationAdapter;", "Lcom/intellij/documentation/mdn/MdnSymbolDocumentation;", "name", "", "source", "Lcom/intellij/documentation/mdn/MdnDocumentation;", "doc", "Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;", "(Ljava/lang/String;Lcom/intellij/documentation/mdn/MdnDocumentation;Lcom/intellij/documentation/mdn/MdnRawSymbolDocumentation;)V", "isDeprecated", "", "()Z", "url", "getUrl", "()Ljava/lang/String;", "getDocumentation", "withDefinition", "additionalSectionsContent", "Ljava/util/function/Consumer;", "Ljava/lang/StringBuilder;", "intellij.xml.psi.impl"})
public final class MdnSymbolDocumentationAdapter
implements MdnSymbolDocumentation {
    private final String name;
    private final MdnDocumentation source;
    private final MdnRawSymbolDocumentation doc;

    @Override
    @NotNull
    public String getUrl() {
        return MdnDocumentationKt.access$fixMdnUrls(this.doc.getUrl(), this.source.getLang());
    }

    @Override
    public boolean isDeprecated() {
        Set<MdnApiStatus> set = this.doc.getStatus();
        return set != null && set.contains((Object)MdnApiStatus.Deprecated);
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition) {
        return this.getDocumentation(withDefinition, null);
    }

    @Override
    @NotNull
    public String getDocumentation(boolean withDefinition, @Nullable Consumer<StringBuilder> additionalSectionsContent) {
        return MdnDocumentationKt.access$buildDoc(this.doc, this.name, this.source.getLang(), withDefinition, additionalSectionsContent);
    }

    public MdnSymbolDocumentationAdapter(@NotNull String name, @NotNull MdnDocumentation source, @NotNull MdnRawSymbolDocumentation doc) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)doc, (String)"doc");
        this.name = name;
        this.source = source;
        this.doc = doc;
    }
}

