/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.ultimate.project;

import com.intellij.indexing.shared.download.SharedIndexDownloadAuthExtensionKt;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexConfig;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexSetting;
import com.intellij.indexing.shared.ultimate.project.ProjectSharedIndexState;
import com.intellij.indexing.shared.util.UtilKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u001a\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u00042\u0006\u0010\u0006\u001a\u00020\u0007\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "readProjectSettings", "", "Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexConfig;", "project", "Lcom/intellij/openapi/project/Project;", "resolvedProjectSettings", "Lcom/intellij/indexing/shared/ultimate/project/ProjectSharedIndexSetting;", "intellij.indexing.shared.ultimate"})
public final class ProjectSharedIndexSettingsKt {
    private static final Logger LOG;

    private static final List<ProjectSharedIndexConfig> readProjectSettings(Project project) {
        if (project.isDefault()) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        Project $this$service$iv = project;
        boolean $i$f$service = false;
        Object object = $this$service$iv.getService(ProjectSharedIndexState.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(T::class.java)");
        return ((ProjectSharedIndexState)((Object)object)).projectConfig();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<ProjectSharedIndexSetting> resolvedProjectSettings(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Object answer$iv$iv$iv;
        Object key$iv$iv;
        Object $this$groupByTo$iv$iv;
        Iterable $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Iterable $this$mapNotNull$iv = CollectionsKt.distinct((Iterable)ProjectSharedIndexSettingsKt.readProjectSettings(project));
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Object destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ProjectSharedIndexSetting projectSharedIndexSetting;
            Object t;
            Object element$iv$iv = t = iterator.next();
            boolean bl = false;
            ProjectSharedIndexConfig projectConfig = (ProjectSharedIndexConfig)element$iv$iv;
            boolean bl2 = false;
            String serviceUrl = projectConfig.getUrl();
            if (StringsKt.isBlank((CharSequence)serviceUrl)) {
                projectSharedIndexSetting = null;
            } else {
                String authId2 = projectConfig.getAuthId();
                if (authId2 != null && SharedIndexDownloadAuthExtensionKt.resolveIndexDownloadAuthExtension((String)authId2) == null) {
                    projectSharedIndexSetting = null;
                } else {
                    String whenNoAuth = projectConfig.getWhenNoAuth();
                    if (whenNoAuth != null && SharedIndexDownloadAuthExtensionKt.resolveIndexDownloadAuthExtension((String)whenNoAuth) != null) {
                        projectSharedIndexSetting = null;
                    } else {
                        StringBuilder stringBuilder = new StringBuilder().append(project.getLocationHash()).append('-');
                        String string = serviceUrl;
                        boolean bl3 = false;
                        String string2 = string;
                        if (string2 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                        }
                        string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
                        bl3 = false;
                        String string3 = string;
                        if (string3 == null) {
                            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                        }
                        String string4 = string3.toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
                        String indexId = stringBuilder.append(UtilKt.sha256((String)string4)).toString();
                        projectSharedIndexSetting = new ProjectSharedIndexSetting(serviceUrl, indexId, authId2, projectConfig.getResolveCommits());
                    }
                }
            }
            if (projectSharedIndexSetting == null) continue;
            ProjectSharedIndexSetting projectSharedIndexSetting2 = projectSharedIndexSetting;
            boolean bl4 = false;
            boolean bl5 = false;
            ProjectSharedIndexSetting it$iv$iv = projectSharedIndexSetting2;
            boolean bl6 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Iterable $this$groupBy$iv = (List)destination$iv$iv;
        boolean $i$f$groupBy = false;
        $this$mapNotNullTo$iv$iv = $this$groupBy$iv;
        destination$iv$iv = new LinkedHashMap();
        boolean $i$f$groupByTo = false;
        Iterator iterator2 = $this$groupByTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            Object object;
            Object element$iv$iv = iterator2.next();
            ProjectSharedIndexSetting it = (ProjectSharedIndexSetting)element$iv$iv;
            boolean bl = false;
            key$iv$iv = it.getUrl();
            Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
            boolean $i$f$getOrPut = false;
            Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
            if (value$iv$iv$iv == null) {
                boolean bl7 = false;
                answer$iv$iv$iv = new ArrayList();
                $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                object = answer$iv$iv$iv;
            } else {
                object = value$iv$iv$iv;
            }
            List list$iv$iv = (List)object;
            list$iv$iv.add(element$iv$iv);
        }
        Object $this$map$iv = destination$iv$iv;
        boolean $i$f$map = false;
        $this$groupByTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList($this$map$iv.size());
        boolean $i$f$mapTo = false;
        iterator2 = $this$mapTo$iv$iv;
        boolean bl = false;
        for (Map.Entry entry : iterator2.entrySet()) {
            void $dstr$url$entries;
            key$iv$iv = entry;
            Object object = destination$iv$iv;
            boolean bl8 = false;
            void var12_19 = $dstr$url$entries;
            boolean bl9 = false;
            answer$iv$iv$iv = (String)var12_19.getKey();
            var12_19 = $dstr$url$entries;
            bl9 = false;
            List entries = (List)var12_19.getValue();
            if (entries.size() != 1) {
                void url2;
                LOG.warn("Duplicated settings for " + (String)url2);
            }
            ProjectSharedIndexSetting projectSharedIndexSetting = (ProjectSharedIndexSetting)CollectionsKt.first((List)entries);
            object.add(projectSharedIndexSetting);
        }
        return (List)destination$iv$iv;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(ProjectSharedIndexState.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(T::class.java)");
        LOG = logger;
    }
}

