/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.laf.win10;

import com.intellij.ui.components.OnOffButton;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicToggleButtonUI;
import javax.swing.text.View;

public class WinOnOffButtonUI
extends BasicToggleButtonUI {
    private static final Dimension TOGGLE_SIZE = new JBDimension(29, 16);
    private static final Dimension BUTTON_SIZE = new JBDimension(46, 18);
    private static final Border BUTTON_BORDER = JBUI.Borders.empty((int)1, (int)6);

    public static ComponentUI createUI(JComponent c) {
        c.setBorder(BUTTON_BORDER);
        return new WinOnOffButtonUI();
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = new Dimension(BUTTON_SIZE);
        JBInsets.addTo((Dimension)size, (Insets)BUTTON_BORDER.getBorderInsets(c));
        return size;
    }

    @Override
    public Dimension getMaximumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(c instanceof OnOffButton)) {
            return;
        }
        OnOffButton b = (OnOffButton)c;
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            Insets i = c.getInsets();
            Point origin = new Point((c.getWidth() - WinOnOffButtonUI.BUTTON_SIZE.width) / 2 + i.left, (c.getHeight() - WinOnOffButtonUI.BUTTON_SIZE.height) / 2 + i.top);
            Rectangle outerRect = new Rectangle(origin, BUTTON_SIZE);
            g2.setColor(new Color(0xADADAD));
            g2.fill(outerRect);
            g2.setColor(b.isSelected() ? new Color(1154046) : new Color(0xE3E3E3));
            Point location = new Point((b.isSelected() ? JBUIScale.scale((int)16) : JBUIScale.scale((int)1)) + origin.x, JBUIScale.scale((int)1) + origin.y);
            Rectangle innerRect = new Rectangle(location, TOGGLE_SIZE);
            g2.fill(innerRect);
            Rectangle textRect = new Rectangle();
            Rectangle iconRect = new Rectangle();
            Font f = c.getFont();
            FontMetrics fm = g.getFontMetrics();
            g.setFont(f);
            b.setForeground(b.isSelected() ? Color.white : Color.black);
            String text = SwingUtilities.layoutCompoundLabel(c, fm, b.isSelected() ? b.getOnText() : b.getOffText(), null, b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), innerRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
            if (text != null && !text.isEmpty()) {
                View v = (View)c.getClientProperty("html");
                if (v != null) {
                    v.paint(g2, textRect);
                } else {
                    this.paintText((Graphics)g2, (AbstractButton)b, textRect, text);
                }
            }
        }
        finally {
            g2.dispose();
        }
    }
}

