/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.laf.win10;

import com.intellij.ide.ui.laf.PluggableLafInfo;
import com.intellij.ide.ui.laf.SearchTextAreaPainter;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class Win10SearchPainter
implements SearchTextAreaPainter,
Border {
    private final PluggableLafInfo.SearchAreaContext myContext;

    Win10SearchPainter(PluggableLafInfo.SearchAreaContext context) {
        this.myContext = context;
        MouseAdapter ml = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.setHover(true);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                this.setHover(false);
            }

            private void setHover(Boolean hover) {
                JComponent c = Win10SearchPainter.this.myContext.getSearchComponent();
                c.putClientProperty("JTextField.hover", hover);
                c.repaint();
            }
        };
        this.myContext.getTextComponent().addMouseListener(ml);
        this.myContext.getSearchComponent().addMouseListener(ml);
    }

    @NotNull
    public String getLayoutConstraints() {
        JBInsets i = JBUI.insets((int)1, (int)1, (int)2, (int)1);
        String string = "flowx, ins " + i.top + " " + i.left + " " + i.bottom + " " + i.right + ", gapx " + JBUIScale.scale((int)3);
        if (string == null) {
            Win10SearchPainter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getHistoryButtonConstraints() {
        String string = "ay baseline, gaptop " + JBUIScale.scale((int)1);
        if (string == null) {
            Win10SearchPainter.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getIconsPanelConstraints() {
        return "ay baseline";
    }

    @NotNull
    public Border getIconsPanelBorder(int rows) {
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty();
        if (jBEmptyBorder == null) {
            Win10SearchPainter.$$$reportNull$$$0(2);
        }
        return jBEmptyBorder;
    }

    @NotNull
    public Border getBorder() {
        Win10SearchPainter win10SearchPainter = this;
        if (win10SearchPainter == null) {
            Win10SearchPainter.$$$reportNull$$$0(3);
        }
        return win10SearchPainter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(@NotNull Graphics2D g) {
        if (g == null) {
            Win10SearchPainter.$$$reportNull$$$0(4);
        }
        JComponent c = this.myContext.getSearchComponent();
        Rectangle r = new Rectangle(c.getSize());
        JBInsets.removeFrom((Rectangle)r, (Insets)c.getInsets());
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setColor(this.myContext.getTextComponent().getBackground());
            g2.fill(r);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return JBInsets.create((int)1, (int)0).asUIResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g.create();
        JComponent jc = (JComponent)c;
        try {
            Insets i = jc.getInsets();
            g2.translate(x + i.left, y + i.top);
            width -= i.left + i.right;
            height -= i.top + i.bottom;
            if (this.myContext.getTextComponent().hasFocus()) {
                g2.setColor(UIManager.getColor("TextField.focusedBorderColor"));
            } else if (jc.isEnabled() && jc.getClientProperty("JTextField.hover") == Boolean.TRUE) {
                g2.setColor(UIManager.getColor("TextField.hoverBorderColor"));
            } else {
                g2.setColor(UIManager.getColor("TextField.borderColor"));
            }
            int bw = JBUIScale.scale((int)1);
            Path2D.Float border = new Path2D.Float(0);
            border.append(new Rectangle2D.Float(0.0f, 0.0f, width, height), false);
            border.append(new Rectangle2D.Float(bw, bw, width - bw * 2, height - bw * 2), false);
            g2.fill(border);
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/laf/win10/Win10SearchPainter";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLayoutConstraints";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getHistoryButtonConstraints";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getIconsPanelBorder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getBorder";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/laf/win10/Win10SearchPainter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "paint";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

