/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec.run;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.jetbrains.php.PhpIndex;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

final class PhpSpecTestLocator
implements SMTestLocator {
    private static final String PROTOCOL_ID = "phpspec";

    PhpSpecTestLocator() {
    }

    @NotNull
    public List<Location> getLocation(@NotNull String protocol, @NotNull String path, @NotNull Project project, @NotNull GlobalSearchScope scope) {
        List<Location> locations;
        if (protocol == null) {
            PhpSpecTestLocator.$$$reportNull$$$0(0);
        }
        if (path == null) {
            PhpSpecTestLocator.$$$reportNull$$$0(1);
        }
        if (project == null) {
            PhpSpecTestLocator.$$$reportNull$$$0(2);
        }
        if (scope == null) {
            PhpSpecTestLocator.$$$reportNull$$$0(3);
        }
        if (PROTOCOL_ID.equals(protocol) && (locations = PhpSpecTestLocator.findElements(project, path)) != null && !locations.isEmpty()) {
            List<Location> list = locations;
            if (list == null) {
                PhpSpecTestLocator.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<Location> list = Collections.emptyList();
        if (list == null) {
            PhpSpecTestLocator.$$$reportNull$$$0(5);
        }
        return list;
    }

    private static List<Location> findElements(@NotNull Project project, @NotNull String path) {
        String[] location;
        int tokensNumber;
        if (project == null) {
            PhpSpecTestLocator.$$$reportNull$$$0(6);
        }
        if (path == null) {
            PhpSpecTestLocator.$$$reportNull$$$0(7);
        }
        if ((tokensNumber = (location = path.split("::")).length) == 0) {
            return null;
        }
        String classFqn = location[0];
        if (StringUtil.isNotEmpty((String)classFqn) && !DumbService.isDumb((Project)project)) {
            Stream classes = PhpIndex.getInstance((Project)project).getAnyByFQN(classFqn).stream();
            if (tokensNumber == 1) {
                return classes.map(e -> new PsiLocation(project, (PsiElement)e)).collect(Collectors.toList());
            }
            String method = location[1];
            if (StringUtil.isNotEmpty((String)method)) {
                return classes.map(c -> c.findMethodByName((CharSequence)method)).filter(m -> m != null).map(e -> new PsiLocation(project, (PsiElement)e)).collect(Collectors.toList());
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protocol";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/run/PhpSpecTestLocator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/run/PhpSpecTestLocator";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLocation";
                break;
            }
            case 4: 
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findElements";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

