/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.jetbrains.php.lang.PhpCodeUtil;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.phpspec.PhpSpecSettingsManager;
import com.jetbrains.php.phpspec.PhpSpecUtil;
import com.jetbrains.php.phpspec.PhpspecIcons;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.testFramework.PhpTestCreateInfo;
import com.jetbrains.php.testFramework.PhpUnitAbstractTestCreateInfo;
import java.util.Properties;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhpSpecTestCreateInfo
implements PhpTestCreateInfo {
    public static final PhpSpecTestCreateInfo INSTANCE = new PhpSpecTestCreateInfo();
    public static final String PHPSPEC_TEST_METHOD_TEMPLATE_NAME = "PHPSpec Test Method";

    @NotNull
    @NlsSafe
    public String getName() {
        return "PHPSpec";
    }

    @NotNull
    public String getTemplateName() {
        return "PHPSpec Specification";
    }

    @Nullable
    public Icon getIcon() {
        return PhpspecIcons.Phpspec;
    }

    @NotNull
    @NlsSafe
    public String getDefaultTestName(@NotNull String targetClassName) {
        if (targetClassName == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(0);
        }
        String string = targetClassName + "Spec";
        if (string == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String getTestNamespace(@NotNull Project project, @NotNull VirtualFile directory, @NotNull String namespace, @NotNull String fromNamespace, @NotNull String path) {
        if (project == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(2);
        }
        if (directory == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(3);
        }
        if (namespace == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(4);
        }
        if (fromNamespace == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(5);
        }
        if (path == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(6);
        }
        if (FileUtil.pathsEqual((String)directory.getPath(), (String)project.getBasePath())) {
            return fromNamespace;
        }
        PhpSpecSettingsManager.PhpSpecSuiteConfiguration suite = PhpSpecSettingsManager.getInstance(project).getMatchedSuite(fromNamespace, directory.getPath());
        if (suite == null) {
            return null;
        }
        namespace = PhpLangUtil.concat((String)namespace, (String)PhpUnitAbstractTestCreateInfo.getNamespaceSuffix((Project)project, (VirtualFile)directory, (String)namespace, (String)path));
        return PhpLangUtil.toName((String)PhpLangUtil.concat((String)suite.getSpecPrefix(), (String)namespace));
    }

    @Nullable
    public String getTestDirectory(@NotNull Project project, @NotNull SourceFolder sourceFolder, @NotNull String toNamespace, @NotNull String fromNamespace) {
        String folderPrefix;
        VirtualFile file;
        if (project == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(7);
        }
        if (sourceFolder == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(8);
        }
        if (toNamespace == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(9);
        }
        if (fromNamespace == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(10);
        }
        if ((file = sourceFolder.getFile()) == null) {
            return null;
        }
        PhpSpecSettingsManager.PhpSpecSuiteConfiguration suite = PhpSpecSettingsManager.getInstance(project).getMatchedSuite(fromNamespace, file.getPath());
        if (suite == null) {
            return null;
        }
        String namespaceWithoutSpecPrefix = PhpSpecTestCreateInfo.getNamespaceWithoutSpecPrefix(toNamespace, suite.getSpecPrefix());
        return suite.getSuitePath(namespaceWithoutSpecPrefix.startsWith(folderPrefix = PhpDirectoryByPsrProvider.getFolderPrefix((SourceFolder)sourceFolder)) ? PhpDirectoryByPsrProvider.cutPrefix((String)namespaceWithoutSpecPrefix, (String)folderPrefix) : namespaceWithoutSpecPrefix);
    }

    public boolean isConfiguredFolder(@NotNull Project project, @Nullable VirtualFile directory) {
        if (project == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(11);
        }
        return directory != null && PhpSpecSettingsManager.getInstance(project).hasMatchedSuite(directory.getPath());
    }

    @NotNull
    public String getNamespaceWithoutPrefix(@NotNull Project project, @NotNull String namespace, @NotNull String fromNamespace, @Nullable VirtualFile file) {
        if (project == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(12);
        }
        if (namespace == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(13);
        }
        if (fromNamespace == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(14);
        }
        if (file == null) {
            String string = namespace;
            if (string == null) {
                PhpSpecTestCreateInfo.$$$reportNull$$$0(15);
            }
            return string;
        }
        PhpSpecSettingsManager.PhpSpecSuiteConfiguration suite = PhpSpecSettingsManager.getInstance(project).getMatchedSuite(fromNamespace, file.getPath());
        String string = suite != null ? PhpSpecTestCreateInfo.getNamespaceWithoutSpecPrefix(namespace, suite.getSpecPrefix()) : namespace;
        if (string == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(16);
        }
        return string;
    }

    @NotNull
    private static String getNamespaceWithoutSpecPrefix(@NotNull String namespace, @NotNull String prefix) {
        if (namespace == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(17);
        }
        if (prefix == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(18);
        }
        String string = namespace.startsWith(prefix) ? PhpLangUtil.toName((String)((String)ObjectUtils.notNull((Object)StringUtil.substringAfter((String)namespace, (String)prefix), (Object)namespace))) : namespace;
        if (string == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public String getTestMethodText(@NotNull Project project, @NotNull String classFqn, @NotNull String methodName) {
        if (project == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(20);
        }
        if (classFqn == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(21);
        }
        if (methodName == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(22);
        }
        String string = PhpCodeUtil.getCodeTemplate((String)PHPSPEC_TEST_METHOD_TEMPLATE_NAME, (Properties)this.getDefaultProperties(methodName, classFqn), (Project)project);
        if (string == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(23);
        }
        return string;
    }

    public boolean canCreateTestFor(@NotNull PhpClass clazz) {
        if (clazz == null) {
            PhpSpecTestCreateInfo.$$$reportNull$$$0(24);
        }
        return !PhpSpecUtil.isSpecTestClass(clazz.getProject(), clazz.getFQN());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 19: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 19: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetClassName";
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/PhpSpecTestCreateInfo";
                break;
            }
            case 2: 
            case 7: 
            case 11: 
            case 12: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 4: 
            case 13: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 5: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNamespace";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceFolder";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNamespace";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classFqn";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/PhpSpecTestCreateInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultTestName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceWithoutPrefix";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getNamespaceWithoutSpecPrefix";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestMethodText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultTestName";
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 19: 
            case 23: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestNamespace";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getTestDirectory";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguredFolder";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceWithoutPrefix";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getNamespaceWithoutSpecPrefix";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getTestMethodText";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "canCreateTestFor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 15: 
            case 16: 
            case 19: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

