/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phpspec;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.config.interpreters.PhpInterpreter;
import com.jetbrains.php.lang.PhpLangUtil;
import com.jetbrains.php.phpspec.PhpSpecFrameworkType;
import com.jetbrains.php.phpunit.PhpUnitDirectoriesManager;
import com.jetbrains.php.phpunit.codeGeneration.PhpNewTestDialog;
import com.jetbrains.php.roots.PhpDirectoryByPsrProvider;
import com.jetbrains.php.roots.PhpPsrNamespaceRootDetector;
import com.jetbrains.php.roots.PhpSourceRootTemplate;
import com.jetbrains.php.testFramework.PhpTestFrameworkBySdkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfiguration;
import com.jetbrains.php.testFramework.PhpTestFrameworkConfigurationIml;
import com.jetbrains.php.testFramework.PhpTestFrameworkOldConfigHolder;
import com.jetbrains.php.testFramework.PhpTestFrameworkSettingsManager;
import com.jetbrains.php.testFramework.PhpTestFrameworkType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="PHPSpec", storages={@Storage(value="phpspec.xml")})
public final class PhpSpecSettingsManager
implements PersistentStateComponent<State> {
    private static final PhpTestFrameworkType ourFrameworkType = PhpSpecFrameworkType.getInstance();
    private final Project myProject;
    protected State myState;
    @NotNull
    private List<PhpSpecSuiteConfiguration> myDefaultSuites;

    public PhpSpecSettingsManager(@NotNull Project project) {
        if (project == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(0);
        }
        this.myState = new State();
        this.myProject = project;
        this.myDefaultSuites = ContainerUtil.immutableSingletonList((Object)new PhpSpecSuiteConfiguration(StringUtil.notNullize((String)project.getBasePath())));
    }

    public static PhpSpecSettingsManager getInstance(@NotNull Project project) {
        if (project == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(1);
        }
        return (PhpSpecSettingsManager)ServiceManager.getService((Project)project, PhpSpecSettingsManager.class);
    }

    @NotNull
    public List<String> getPrefixes() {
        List list = StreamEx.of(this.getSuites()).map(PhpSpecSuiteConfiguration::getSpecPrefix).toList();
        if (list == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(2);
        }
        return list;
    }

    public List<PhpSpecSuiteConfiguration> getSuites() {
        return !this.myState.getSuites().isEmpty() ? this.myState.getSuites() : this.myDefaultSuites;
    }

    public void setSuites(@NotNull List<PhpSpecSuiteConfiguration> suites) {
        if (suites == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(3);
        }
        this.myState.setSuites(suites);
    }

    public void updateSuites(@NotNull List<PhpSpecSuiteConfiguration> suites) {
        if (suites == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(4);
        }
        this.setSuites(suites);
        PhpPsrNamespaceRootDetector.addSourceRoots((Project)this.myProject, PhpSpecSettingsManager.getTestRoots(this.myProject, suites));
    }

    @NotNull
    private static List<PhpSourceRootTemplate> getTestRoots(@NotNull Project project, @NotNull List<PhpSpecSuiteConfiguration> configurations) {
        if (project == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(5);
        }
        if (configurations == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(6);
        }
        ArrayList<PhpSourceRootTemplate> roots = new ArrayList<PhpSourceRootTemplate>();
        Set filePaths = PhpNewTestDialog.getExistedSourceRootPaths((Project)project);
        for (PhpSpecSuiteConfiguration configuration : configurations) {
            if (PhpUnitDirectoriesManager.hasDirectoryPath((Collection)filePaths, (String)configuration.getPath())) continue;
            roots.add(PhpSourceRootTemplate.psr4((String)configuration.getFullPath(), (String)"", (boolean)true));
        }
        ArrayList<PhpSourceRootTemplate> arrayList = roots;
        if (arrayList == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    public List<PhpSpecSuiteConfiguration> getDefaultSuites() {
        List<PhpSpecSuiteConfiguration> list = this.myDefaultSuites;
        if (list == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void setDefaultSuites(@NotNull List<PhpSpecSuiteConfiguration> suites) {
        if (suites == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(9);
        }
        this.myDefaultSuites = suites;
    }

    @Nullable
    public PhpSpecSuiteConfiguration getMatchedSuite(@NotNull String namespace, @NotNull String path) {
        PhpSpecSuiteConfiguration suite;
        if (namespace == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(10);
        }
        if (path == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(11);
        }
        return (suite = this.getSuiteByNamespace(namespace)) != null && suite.hasPath(path) ? suite : null;
    }

    public boolean hasMatchedSuite(@NotNull String path) {
        if (path == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(12);
        }
        return ContainerUtil.find(this.getSuites(), suite -> suite.hasPath(path)) != null;
    }

    @Nullable
    private PhpSpecSuiteConfiguration getSuiteByNamespace(@NotNull String namespace) {
        PhpSpecSuiteConfiguration suiteWithNamespace;
        if (namespace == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(13);
        }
        if ((suiteWithNamespace = this.getSuiteWithNamespace(namespace)) != null) {
            return suiteWithNamespace;
        }
        suiteWithNamespace = this.getSuiteContainingNamespace(namespace);
        return suiteWithNamespace != null ? suiteWithNamespace : this.getDefaultSuite();
    }

    @Nullable
    private PhpSpecSuiteConfiguration getSuiteWithNamespace(@NotNull String namespace) {
        if (namespace == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(14);
        }
        return (PhpSpecSuiteConfiguration)ContainerUtil.find(this.getSuites(), suite -> suite.hasNamespace(namespace));
    }

    @Nullable
    private PhpSpecSuiteConfiguration getSuiteContainingNamespace(@NotNull String namespace) {
        if (namespace == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(15);
        }
        return (PhpSpecSuiteConfiguration)ContainerUtil.find(this.getSuites(), suite -> suite.containsNamespace(namespace));
    }

    @Nullable
    private PhpSpecSuiteConfiguration getDefaultSuite() {
        return (PhpSpecSuiteConfiguration)ContainerUtil.find(this.getSuites(), PhpSpecSuiteConfiguration::isDefault);
    }

    @Nullable
    public PhpTestFrameworkConfiguration getLocalConfig() {
        return PhpTestFrameworkSettingsManager.getInstance((Project)this.myProject).getLocalConfig(ourFrameworkType);
    }

    public void setLocalConfig(@Nullable PhpTestFrameworkConfiguration localConfig) {
        PhpTestFrameworkSettingsManager.getInstance((Project)this.myProject).setLocalConfig(ourFrameworkType, localConfig);
    }

    @Nullable
    public PhpTestFrameworkConfiguration getConfigByInterpreter(@Nullable PhpInterpreter interpreter) {
        return PhpTestFrameworkSettingsManager.getInstance((Project)this.myProject).getConfigByInterpreter(ourFrameworkType, interpreter);
    }

    @NotNull
    public PhpTestFrameworkConfiguration getOrCreateByInterpreter(@Nullable PhpInterpreter interpreter) {
        PhpTestFrameworkConfiguration phpTestFrameworkConfiguration = PhpTestFrameworkSettingsManager.getInstance((Project)this.myProject).getOrCreateByInterpreter(ourFrameworkType, interpreter);
        if (phpTestFrameworkConfiguration == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(16);
        }
        return phpTestFrameworkConfiguration;
    }

    @NotNull
    public PhpTestFrameworkConfiguration getOrCreateLocal() {
        PhpTestFrameworkConfiguration phpTestFrameworkConfiguration = PhpTestFrameworkSettingsManager.getInstance((Project)this.myProject).getOrCreateByInterpreter(ourFrameworkType, null);
        if (phpTestFrameworkConfiguration == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(17);
        }
        return phpTestFrameworkConfiguration;
    }

    public boolean isEnabled() {
        PhpTestFrameworkConfiguration local = PhpTestFrameworkSettingsManager.getInstance((Project)this.myProject).getLocalConfig(ourFrameworkType);
        return local != null && StringUtil.isNotEmpty((String)local.getExecutablePath());
    }

    @Nullable
    public State getState() {
        return this.myState;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            PhpSpecSettingsManager.$$$reportNull$$$0(18);
        }
        this.myState = state;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phpspec/PhpSpecSettingsManager";
                break;
            }
            case 3: 
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suites";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configurations";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespace";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phpspec/PhpSpecSettingsManager";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPrefixes";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestRoots";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultSuites";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateByInterpreter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateLocal";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setSuites";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "updateSuites";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTestRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultSuites";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getMatchedSuite";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasMatchedSuite";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getSuiteByNamespace";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getSuiteWithNamespace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getSuiteContainingNamespace";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 7: 
            case 8: 
            case 16: 
            case 17: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PhpSpecOldConfigHolder
    extends PhpTestFrameworkOldConfigHolder {
        @NotNull
        public PhpTestFrameworkType getFrameworkType() {
            PhpTestFrameworkType phpTestFrameworkType = ourFrameworkType;
            if (phpTestFrameworkType == null) {
                PhpSpecOldConfigHolder.$$$reportNull$$$0(0);
            }
            return phpTestFrameworkType;
        }

        public List<PhpTestFrameworkConfiguration> getConfigurations(@NotNull Project project) {
            State state;
            if (project == null) {
                PhpSpecOldConfigHolder.$$$reportNull$$$0(1);
            }
            return (state = PhpSpecSettingsManager.getInstance(project).getState()) != null ? state.getConfigurations() : new SmartList();
        }

        public void removeAllConfigurations(@NotNull Project project) {
            State state;
            if (project == null) {
                PhpSpecOldConfigHolder.$$$reportNull$$$0(2);
            }
            if ((state = PhpSpecSettingsManager.getInstance(project).getState()) != null) {
                state.setOldStyleConfigurations(ContainerUtil.emptyList());
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpspec/PhpSpecSettingsManager$PhpSpecOldConfigHolder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFrameworkType";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpspec/PhpSpecSettingsManager$PhpSpecOldConfigHolder";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getConfigurations";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "removeAllConfigurations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class PhpSpecSuiteConfiguration {
        @NotNull
        private static final String RELATIVE_PATH_MACRO = "%paths.config%";
        @NotNull
        private static final String DEFAULT_SPEC_PATH = "";
        @NotNull
        public String myPath;
        @NotNull
        private String mySpecPath;
        @NotNull
        private String mySpecPrefix;
        @NotNull
        private String myNamespace;

        PhpSpecSuiteConfiguration() {
            this(DEFAULT_SPEC_PATH);
        }

        PhpSpecSuiteConfiguration(@NotNull String path) {
            if (path == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(0);
            }
            this.myPath = path;
            this.mySpecPath = DEFAULT_SPEC_PATH;
            this.mySpecPrefix = "spec";
            this.myNamespace = DEFAULT_SPEC_PATH;
        }

        @NotNull
        public String getNamespace() {
            String string = this.myNamespace;
            if (string == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(1);
            }
            return string;
        }

        public void setNamespace(@NotNull String namespace) {
            if (namespace == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(2);
            }
            this.myNamespace = StringUtil.isEmpty((String)namespace) ? DEFAULT_SPEC_PATH : namespace;
        }

        @NotNull
        public String getSpecPrefix() {
            String string = this.mySpecPrefix;
            if (string == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(3);
            }
            return string;
        }

        public void setSpecPrefix(@Nullable String specPrefix) {
            this.mySpecPrefix = StringUtil.isEmpty((String)specPrefix) ? "spec" : specPrefix;
        }

        @NotNull
        public String getSpecPath() {
            String string = this.mySpecPath;
            if (string == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(4);
            }
            return string;
        }

        public void setSpecPath(@Nullable String specPath) {
            this.mySpecPath = FileUtil.toCanonicalPath((String)PhpSpecSuiteConfiguration.expandMacro(specPath));
        }

        @NotNull
        public String getPath() {
            if (FileUtil.isAbsolutePlatformIndependent((String)this.mySpecPath)) {
                String string = this.mySpecPath;
                if (string == null) {
                    PhpSpecSuiteConfiguration.$$$reportNull$$$0(5);
                }
                return string;
            }
            String string = PhpSpecSuiteConfiguration.concatPaths(this.myPath, this.mySpecPath);
            if (string == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(6);
            }
            return string;
        }

        @NotNull
        public String getFullPath() {
            String string = PhpSpecSuiteConfiguration.concatPaths(this.getPath(), this.mySpecPrefix);
            if (string == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(7);
            }
            return string;
        }

        @NotNull
        public String getSuitePath(@NotNull String namespace) {
            if (namespace == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(8);
            }
            String string = PhpSpecSuiteConfiguration.concatPaths(this.getFullPath(), StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)namespace), (String)"\\"));
            if (string == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(9);
            }
            return string;
        }

        public boolean isDefault() {
            return PhpLangUtil.isGlobalNamespaceName((String)this.myNamespace);
        }

        public boolean hasPath(@NotNull String path) {
            if (path == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(10);
            }
            return FileUtil.pathsEqual((String)this.getPath(), (String)path) || FileUtil.pathsEqual((String)this.getFullPath(), (String)path);
        }

        public boolean hasNamespace(@NotNull String namespace) {
            if (namespace == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(11);
            }
            return PhpLangUtil.equalsNamespaceNames((CharSequence)namespace, (CharSequence)this.myNamespace);
        }

        public boolean containsNamespace(@NotNull String prefix) {
            if (prefix == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(12);
            }
            return PhpDirectoryByPsrProvider.containsPrefix((String)prefix, (String)this.myNamespace);
        }

        private static String concatPaths(@NotNull String basePath, @NotNull String suffixPath) {
            if (basePath == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(13);
            }
            if (suffixPath == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(14);
            }
            if (basePath.isEmpty()) {
                return suffixPath;
            }
            return suffixPath.isEmpty() ? basePath : basePath + "/" + suffixPath;
        }

        @NotNull
        private static String expandMacro(@Nullable String path) {
            if (path == null || path.equals(RELATIVE_PATH_MACRO)) {
                return DEFAULT_SPEC_PATH;
            }
            if (path.startsWith(RELATIVE_PATH_MACRO)) {
                List items = FileUtil.splitPath((String)FileUtil.toSystemDependentName((String)path));
                return items.size() > 1 ? StringUtil.join(items.subList(1, items.size() - 1), (String)"/") : DEFAULT_SPEC_PATH;
            }
            String string = path;
            if (string == null) {
                PhpSpecSuiteConfiguration.$$$reportNull$$$0(15);
            }
            return string;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PhpSpecSuiteConfiguration that = (PhpSpecSuiteConfiguration)o;
            return this.mySpecPrefix.equals(that.mySpecPrefix) && this.mySpecPath.equals(that.mySpecPath) && this.myPath.equals(that.myPath) && this.myNamespace.equals(that.myNamespace);
        }

        public int hashCode() {
            return Objects.hash(this.mySpecPrefix, this.mySpecPath, this.myPath, this.myNamespace);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 15: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 15: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpspec/PhpSpecSettingsManager$PhpSpecSuiteConfiguration";
                    break;
                }
                case 2: 
                case 8: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "namespace";
                    break;
                }
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "prefix";
                    break;
                }
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "basePath";
                    break;
                }
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suffixPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpspec/PhpSpecSettingsManager$PhpSpecSuiteConfiguration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNamespace";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpecPrefix";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSpecPath";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPath";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullPath";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuitePath";
                    break;
                }
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "expandMacro";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 15: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setNamespace";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getSuitePath";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "hasPath";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "hasNamespace";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "containsNamespace";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "concatPaths";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 15: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    @Tag(value="settings_by_sdk")
    private static class PhpSpecBySdkConfiguration
    extends PhpTestFrameworkBySdkConfiguration {
        private PhpSpecBySdkConfiguration() {
        }
    }

    @Tag(value="PhpTestFrameworkSettings")
    private static class PhpSpecConfiguration
    extends PhpTestFrameworkConfigurationIml {
        private PhpSpecConfiguration() {
        }
    }

    public static class State {
        @NotNull
        private List<PhpSpecSuiteConfiguration> mySuites = Collections.emptyList();
        private List<PhpTestFrameworkConfiguration> myOldStyleConfigurations = new SmartList();
        private List<PhpTestFrameworkConfiguration> myConfigurations = null;

        @XCollection(elementName="specSuites", style=XCollection.Style.v2)
        @NotNull
        public List<PhpSpecSuiteConfiguration> getSuites() {
            List<PhpSpecSuiteConfiguration> list = this.mySuites;
            if (list == null) {
                State.$$$reportNull$$$0(0);
            }
            return list;
        }

        public void setSuites(@NotNull List<PhpSpecSuiteConfiguration> suites) {
            if (suites == null) {
                State.$$$reportNull$$$0(1);
            }
            this.mySuites = suites;
        }

        @XCollection(propertyElementName="settings", elementTypes={PhpSpecConfiguration.class, PhpSpecBySdkConfiguration.class, PhpTestFrameworkConfigurationIml.class, PhpTestFrameworkBySdkConfiguration.class})
        @NotNull
        public List<PhpTestFrameworkConfiguration> getOldStyleConfigurations() {
            List<PhpTestFrameworkConfiguration> list = this.myOldStyleConfigurations;
            if (list == null) {
                State.$$$reportNull$$$0(2);
            }
            return list;
        }

        public void setOldStyleConfigurations(@NotNull List<PhpTestFrameworkConfiguration> oldStyleConfigurations) {
            if (oldStyleConfigurations == null) {
                State.$$$reportNull$$$0(3);
            }
            PhpTestFrameworkType frameworkType = PhpSpecFrameworkType.getInstance();
            for (PhpTestFrameworkConfiguration config : oldStyleConfigurations) {
                config.setFrameworkType(frameworkType);
            }
            this.myOldStyleConfigurations = oldStyleConfigurations;
        }

        @Transient
        public List<PhpTestFrameworkConfiguration> getConfigurations() {
            if (this.myConfigurations == null) {
                this.myConfigurations = this.myOldStyleConfigurations.stream().map(s -> s instanceof PhpSpecConfiguration || s instanceof PhpSpecBySdkConfiguration ? s.copy() : s).collect(Collectors.toList());
            }
            return this.myConfigurations;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phpspec/PhpSpecSettingsManager$State";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "suites";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "oldStyleConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getSuites";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phpspec/PhpSpecSettingsManager$State";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldStyleConfigurations";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setSuites";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setOldStyleConfigurations";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

