/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.util.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.util.ui.WithDisplayName;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class UIHelper {
    private UIHelper() {
    }

    @NotNull
    public static JPanel createGrowingDownPanelWithHorizontallyStretchedComponent(@NotNull Component upperComponent) {
        if (upperComponent == null) {
            UIHelper.$$$reportNull$$$0(0);
        }
        JPanel panel = new JPanel(new GridBagLayout());
        panel.add(upperComponent, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel empty = UIHelper.createEmptyPanel();
        panel.add((Component)empty, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.emptyInsets(), 0, 0));
        JPanel jPanel = panel;
        if (jPanel == null) {
            UIHelper.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @NotNull
    private static JPanel createEmptyPanel() {
        return new JPanel(new FlowLayout(0, 0, 0));
    }

    @NotNull
    public static ComboBox<WithDisplayName> createCombobox(final @NotNull @Nls String prototypeDisplayValue, @NotNull WithDisplayName displayNameWhenListIsEmpty) {
        if (prototypeDisplayValue == null) {
            UIHelper.$$$reportNull$$$0(2);
        }
        if (displayNameWhenListIsEmpty == null) {
            UIHelper.$$$reportNull$$$0(3);
        }
        ComboBox comboBox = new ComboBox();
        comboBox.setPrototypeDisplayValue((Object)new WithDisplayName(){

            @Override
            public String getDisplayName() {
                return prototypeDisplayValue;
            }
        });
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)displayNameWhenListIsEmpty.getDisplayName(), WithDisplayName::getDisplayName));
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            UIHelper.$$$reportNull$$$0(4);
        }
        return comboBox2;
    }

    @NotNull
    public static <E extends WithDisplayName> ComboBox<E> createCombobox(@NotNull @NlsContexts.Label String displayNameForEmptyList) {
        if (displayNameForEmptyList == null) {
            UIHelper.$$$reportNull$$$0(5);
        }
        ComboBox comboBox = new ComboBox();
        comboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)displayNameForEmptyList, value -> {
            Object text = value.getDisplayName();
            if (((String)text).length() < displayNameForEmptyList.length()) {
                char[] a = new char[2 * (displayNameForEmptyList.length() - ((String)text).length())];
                Arrays.fill(a, ' ');
                text = (String)text + new String(a);
            }
            return text;
        }));
        ComboBox comboBox2 = comboBox;
        if (comboBox2 == null) {
            UIHelper.$$$reportNull$$$0(6);
        }
        return comboBox2;
    }

    @NotNull
    public static JPanel wrapInCenteredPanel(@NotNull @NlsContexts.Label String text) {
        if (text == null) {
            UIHelper.$$$reportNull$$$0(7);
        }
        JBLabel comp = new JBLabel(text);
        comp.setForeground(UIUtil.getInactiveTextColor());
        JPanel listPane = new JPanel();
        listPane.setLayout(new BoxLayout(listPane, 0));
        listPane.add(Box.createHorizontalGlue());
        listPane.add((Component)comp);
        listPane.setBackground(UIUtil.getTableBackground());
        listPane.add(Box.createHorizontalGlue());
        JPanel jPanel = listPane;
        if (jPanel == null) {
            UIHelper.$$$reportNull$$$0(8);
        }
        return jPanel;
    }

    @NotNull
    @Nls
    public static String getUnavailableText() {
        String string = NodeJSBundle.message("node.combobox.unavailable.text", new Object[0]);
        if (string == null) {
            UIHelper.$$$reportNull$$$0(9);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "upperComponent";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/util/ui/UIHelper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prototypeDisplayValue";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayNameWhenListIsEmpty";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "displayNameForEmptyList";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/util/ui/UIHelper";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createGrowingDownPanelWithHorizontallyStretchedComponent";
                break;
            }
            case 4: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createCombobox";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInCenteredPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnavailableText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createGrowingDownPanelWithHorizontallyStretchedComponent";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createCombobox";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapInCenteredPanel";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

