/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.view.models;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.ui.treeStructure.treetable.TreeTableCellRenderer;
import com.intellij.ui.treeStructure.treetable.TreeTableModel;
import com.intellij.util.ui.ColumnInfo;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.cpu.view.TreeTableModelWithCustomRenderer;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEntry;
import com.jetbrains.nodejs.run.profile.heap.view.models.V8HeapContainmentTreeTableModel;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedNodesListNode;
import com.jetbrains.nodejs.run.profile.heap.view.nodes.FixedRetainerNode;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.DirectTreeTableRenderer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchDetailsTreeModel
implements TreeTableModelWithCustomRenderer {
    private final ColumnInfo[] myColumns;
    private final Object myRoot = new Object();
    private final List<List<FixedRetainerNode>> myData;
    private final V8CachingReader myReader;

    public SearchDetailsTreeModel(final Project project, V8CachingReader reader, List<Pair<V8HeapEdge, V8HeapEntry>> nodes) {
        this.myReader = reader;
        this.myData = new ArrayList<List<FixedRetainerNode>>();
        this.myColumns = new ColumnInfo[1];
        this.myColumns[0] = new ColumnInfo<FixedNodesListNode, FixedNodesListNode>(NodeJSBundle.message("profile.search.table.column.object.name", new Object[0])){

            @Nullable
            public FixedNodesListNode valueOf(FixedNodesListNode entry) {
                return entry;
            }

            public TableCellRenderer getCustomizedRenderer(FixedNodesListNode o, TableCellRenderer renderer) {
                if (renderer instanceof TreeTableCellRenderer) {
                    ((TreeTableCellRenderer)renderer).setCellRenderer((TreeCellRenderer)((Object)new DirectTreeTableRenderer(project, SearchDetailsTreeModel.this.myReader)));
                }
                return super.getCustomizedRenderer((Object)o, renderer);
            }
        };
        this.fillData(nodes);
    }

    @Override
    public TableCellRenderer getCustomizedRenderer(int column, Object o, TableCellRenderer renderer) {
        return this.myColumns[column].getCustomizedRenderer(o, renderer);
    }

    public TreePath getPathByNode(@NotNull FixedNodesListNode node) {
        if (node == null) {
            SearchDetailsTreeModel.$$$reportNull$$$0(0);
        }
        List<FixedRetainerNode> nodes = this.myData.get(node.getVariantId());
        Object[] path = new Object[nodes.size() + 1];
        path[0] = new V8HeapContainmentTreeTableModel.NamedEntry(this.myReader.getNode(0L), "", "", -1L);
        for (int i = nodes.size() - 1; i >= 0; --i) {
            FixedNodesListNode pathElement = nodes.get(i);
            path[nodes.size() - i] = pathElement;
        }
        return new TreePath(path);
    }

    private void fillData(List<Pair<V8HeapEdge, V8HeapEntry>> nodes) {
        if (nodes == null) {
            return;
        }
        for (int i = 0; i < nodes.size(); ++i) {
            Pair<V8HeapEdge, V8HeapEntry> pair = nodes.get(i);
            V8HeapEntry heapEntry = (V8HeapEntry)pair.getSecond();
            V8HeapEdge heapEdge = (V8HeapEdge)pair.getFirst();
            List<FixedRetainerNode> nodeList = SearchDetailsTreeModel.getChainToRoot(i, heapEntry, heapEdge, this.myReader);
            Collections.reverse(nodeList);
            for (int j = 0; j < nodeList.size(); ++j) {
                FixedRetainerNode node = nodeList.get(j);
                node.setLevelNum(j);
            }
            if (nodeList.isEmpty()) continue;
            this.myData.add(nodeList);
        }
    }

    public boolean isEmpty() {
        return this.myData.isEmpty();
    }

    public static List<FixedRetainerNode> getChainToRoot(int variantId, V8HeapEntry heapEntry, V8HeapEdge heapEdge, V8CachingReader reader) {
        FixedRetainerNode first;
        V8HeapEntry parent;
        long startWith;
        ArrayList<FixedRetainerNode> nodeList = new ArrayList<FixedRetainerNode>();
        if (heapEdge != null) {
            startWith = heapEdge.getFromIndex();
            parent = reader.getNode(startWith);
            first = new FixedRetainerNode(heapEntry, reader.getString(heapEntry.getNameId()), heapEdge.getPresentation(reader), heapEdge.getFileOffset(), variantId, 0, parent, reader.getString(parent.getNameId()));
        } else {
            startWith = reader.getNodeParent((int)heapEntry.getId());
            parent = reader.getNode(startWith);
            Pair<V8HeapEntry, V8HeapEdge> p = reader.getChildById(parent, heapEntry.getId());
            if (!reader.isShowHidden() && ((V8HeapEntry)p.getFirst()).getSnapshotObjectId() == -1L) {
                FixedRetainerNode retainerNode = new FixedRetainerNode(heapEntry, reader.getString(heapEntry.getNameId()), "", -1L, variantId, 0, null, "");
                retainerNode.setIsUnreachable(true);
                nodeList.add(retainerNode);
                return nodeList;
            }
            first = new FixedRetainerNode(heapEntry, reader.getString(heapEntry.getNameId()), ((V8HeapEdge)p.getSecond()).getPresentation(reader), ((V8HeapEdge)p.getSecond()).getFileOffset(), variantId, 0, parent, reader.getString(parent.getNameId()));
        }
        ArrayList<Long> idsInPath = new ArrayList<Long>();
        SearchDetailsTreeModel.fillPath(startWith, idsInPath, reader);
        V8HeapEntry current = reader.getNode(0L);
        Collections.reverse(idsInPath);
        for (int j = 0; j < idsInPath.size(); ++j) {
            Long pathElement = idsInPath.get(j);
            Pair<V8HeapEntry, V8HeapEdge> p = reader.getChildById(current, pathElement);
            if (!reader.isShowHidden() && ((V8HeapEntry)p.getFirst()).getSnapshotObjectId() == -1L) {
                nodeList.clear();
                nodeList.add(first);
                first.setIsUnreachable(true);
                return nodeList;
            }
            nodeList.add(new FixedRetainerNode((V8HeapEntry)p.getFirst(), reader.getString(((V8HeapEntry)p.getFirst()).getNameId()), ((V8HeapEdge)p.getSecond()).getPresentation(reader), ((V8HeapEdge)p.getSecond()).getFileOffset(), variantId, -1, current, reader.getString(current.getNameId())));
            current = (V8HeapEntry)p.getFirst();
        }
        nodeList.add(first);
        return nodeList;
    }

    private static void fillPath(long id, List<Long> path, V8CachingReader reader) {
        long curId = id;
        while (curId > 0L) {
            path.add(curId);
            curId = reader.getNodeParent((int)curId);
        }
    }

    public int getColumnCount() {
        return this.myColumns.length;
    }

    public String getColumnName(int column) {
        return this.myColumns[column].getName();
    }

    public Class getColumnClass(int column) {
        return column == 0 ? TreeTableModel.class : String.class;
    }

    public Object getValueAt(Object node, int column) {
        return this.myColumns[column].valueOf(node);
    }

    public boolean isCellEditable(Object node, int column) {
        return false;
    }

    public void setValueAt(Object aValue, Object node, int column) {
    }

    public void setTree(JTree tree) {
    }

    public Object getRoot() {
        return this.myRoot;
    }

    public Object getChild(Object parent, int index) {
        if (this.myRoot.equals(parent)) {
            return this.myData.get(index).get(0);
        }
        if (parent instanceof FixedNodesListNode) {
            FixedNodesListNode node = (FixedNodesListNode)parent;
            List<FixedRetainerNode> list = this.myData.get(node.getVariantId());
            return list.size() == node.getLevelNum() + 1 ? null : list.get(node.getLevelNum() + 1);
        }
        return null;
    }

    public int getChildCount(Object parent) {
        if (this.myRoot.equals(parent)) {
            return this.myData.size();
        }
        if (parent instanceof FixedNodesListNode) {
            FixedNodesListNode node = (FixedNodesListNode)parent;
            List<FixedRetainerNode> list = this.myData.get(node.getVariantId());
            return list.size() == node.getLevelNum() + 1 ? 0 : 1;
        }
        return 0;
    }

    public boolean isLeaf(Object node) {
        return this.getChildCount(node) == 0;
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }

    public int getIndexOfChild(Object parent, Object child) {
        if (this.myRoot.equals(parent)) {
            for (int i = 0; i < this.myData.size(); ++i) {
                List<FixedRetainerNode> nodes = this.myData.get(i);
                if (!nodes.get(0).equals(child)) continue;
                return i;
            }
        } else if (parent instanceof FixedNodesListNode && child instanceof FixedNodesListNode) {
            return 0;
        }
        return 0;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/nodejs/run/profile/heap/view/models/SearchDetailsTreeModel", "getPathByNode"));
    }
}

