/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.heap.calculation;

import com.intellij.util.Processor;
import com.jetbrains.nodejs.run.profile.heap.V8CachingReader;
import com.jetbrains.nodejs.run.profile.heap.calculation.Flags;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapEdge;
import com.jetbrains.nodejs.run.profile.heap.data.V8HeapGraphEdgeType;
import com.jetbrains.nodejs.run.profile.heap.io.reverse.LinksReader;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class V8PostOrderBuilder {
    private final IntList myPostOrderToNode;
    private final IntList myNodeToPostOrder;
    private final IntSet myVisited;
    private final ArrayDeque<NodeInfo> myQueue;
    private final int myNodesCnt;
    private final V8CachingReader myReader;
    @NotNull
    private final Flags myFlags;
    private final boolean myShowHiddenData;
    private final LinksReader<? extends V8HeapEdge> myLinksReader;
    private int myPostOrder;
    private final List<String> myWarnings;
    private final IntList myUnreachable;
    private final IntList myOnlyWeak;

    public V8PostOrderBuilder(int nodesCnt, V8CachingReader reader, @NotNull Flags flags, @NotNull LinksReader<? extends V8HeapEdge> reverseLinksReader, boolean showHiddenData) throws FileNotFoundException {
        if (flags == null) {
            V8PostOrderBuilder.$$$reportNull$$$0(0);
        }
        if (reverseLinksReader == null) {
            V8PostOrderBuilder.$$$reportNull$$$0(1);
        }
        this.myNodesCnt = nodesCnt;
        this.myReader = reader;
        this.myFlags = flags;
        this.myShowHiddenData = showHiddenData;
        this.myPostOrderToNode = new IntArrayList(nodesCnt);
        this.myNodeToPostOrder = new IntArrayList(nodesCnt);
        this.myUnreachable = new IntArrayList();
        this.myOnlyWeak = new IntArrayList();
        this.myVisited = new IntOpenHashSet();
        this.myVisited.add(0);
        this.myQueue = new ArrayDeque();
        this.myPostOrder = 0;
        for (int i = 0; i < nodesCnt; ++i) {
            this.myPostOrderToNode.add(-1);
            this.myNodeToPostOrder.add(-1);
        }
        this.myLinksReader = reverseLinksReader;
        this.myWarnings = new ArrayList<String>();
    }

    public void execute() throws IOException {
        this.myQueue.add(new NodeInfo(0, this.myReader.getChildrenByNodeId(0L).size()));
        this.normalIteration();
        if (this.myPostOrder != this.myNodesCnt) {
            this.prepareOnlyReferencedByWeak();
            this.normalIteration();
            if (this.myPostOrder != this.myNodesCnt) {
                this.fixAnyway();
            }
        }
    }

    public IntList getPostOrderToNode() {
        return this.myPostOrderToNode;
    }

    public IntList getNodeToPostOrder() {
        return this.myNodeToPostOrder;
    }

    private void fixAnyway() {
        --this.myPostOrder;
        StringBuilder sb = new StringBuilder("Still found " + (this.myNodesCnt - this.myPostOrder) + " unreachable nodes in heap snapshot:");
        for (int i = 0; i < this.myNodesCnt; ++i) {
            if (this.myVisited.contains(i)) continue;
            sb.append(i).append(' ');
            this.myNodeToPostOrder.set(i, this.myPostOrder);
            this.myPostOrderToNode.set(this.myPostOrder++, i);
            this.myUnreachable.add(i);
        }
        this.myNodeToPostOrder.set(0, this.myPostOrder);
        this.myPostOrderToNode.set(this.myPostOrder++, 0);
        this.myWarnings.add(sb.toString());
    }

    private void prepareOnlyReferencedByWeak() throws IOException {
        --this.myPostOrder;
        this.myQueue.clear();
        this.myQueue.add(new NodeInfo(0, 0));
        StringBuilder sb = new StringBuilder("Heap snapshot: " + (this.myNodesCnt - this.myPostOrder) + " nodes are unreachable from the root. Following nodes have only weak retainers:");
        for (int i = 0; i < this.myNodesCnt; ++i) {
            if (this.myVisited.contains(i)) continue;
            boolean[] hasOnlyWeakRetainers = new boolean[]{true};
            this.myLinksReader.read(i, (Processor<? extends V8HeapEdge>)((Processor)edge -> {
                if (!V8HeapGraphEdgeType.kWeak.equals((Object)edge.getType()) && !V8HeapGraphEdgeType.kShortcut.equals((Object)edge.getType())) {
                    hasOnlyWeakRetainers[0] = false;
                    return false;
                }
                return true;
            }));
            if (!hasOnlyWeakRetainers[0]) continue;
            this.myQueue.add(new NodeInfo(i, this.myReader.getChildrenByNodeId(Long.valueOf(i)).size()));
            this.myVisited.add(i);
            sb.append(i).append(' ');
            this.myOnlyWeak.add(i);
        }
        this.myWarnings.add(sb.toString());
    }

    private void normalIteration() {
        while (!this.myQueue.isEmpty()) {
            int childIndex;
            NodeInfo info = this.myQueue.getLast();
            int nodeId = info.getNodeId();
            int numChildren = info.getChildrenLeft();
            if (numChildren == 0) {
                this.myNodeToPostOrder.set(nodeId, this.myPostOrder);
                this.myPostOrderToNode.set(this.myPostOrder++, nodeId);
                this.myQueue.removeLast();
                continue;
            }
            info.decrementChildren();
            List<V8HeapEdge> edges = this.myReader.getChildrenByNodeId(Long.valueOf(nodeId));
            V8HeapEdge link = edges.get(edges.size() - numChildren);
            if (V8HeapGraphEdgeType.kWeak.equals((Object)link.getType()) || V8HeapGraphEdgeType.kShortcut.equals((Object)link.getType()) || this.myVisited.contains(childIndex = (int)link.getToIndex()) || !this.myShowHiddenData && nodeId != 0 && this.myFlags.isPage(childIndex) && !this.myFlags.isPage(nodeId)) continue;
            this.myQueue.add(new NodeInfo(childIndex, this.myReader.getChildrenByNodeId(link.getToIndex()).size()));
            this.myVisited.add(childIndex);
        }
    }

    public IntList getUnreachable() {
        return this.myUnreachable;
    }

    public IntList getOnlyWeak() {
        return this.myOnlyWeak;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "flags";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "reverseLinksReader";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/nodejs/run/profile/heap/calculation/V8PostOrderBuilder";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class NodeInfo {
        private final int myNodeId;
        private int myChildrenLeft;

        NodeInfo(int nodeId, int childrenLeft) {
            this.myNodeId = nodeId;
            this.myChildrenLeft = childrenLeft;
        }

        public int getNodeId() {
            return this.myNodeId;
        }

        public int getChildrenLeft() {
            return this.myChildrenLeft;
        }

        public void decrementChildren() {
            --this.myChildrenLeft;
        }
    }
}

