/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.view;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.Convertor;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.V8Utils;
import com.jetbrains.nodejs.run.profile.cpu.calculation.V8ProfileLine;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.FlatTopCalls;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CodeScope;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8CpuLogCall;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.ui.FlameColors;
import com.jetbrains.nodejs.run.profile.cpu.view.LineColorProvider;
import com.jetbrains.nodejs.run.profile.cpu.view.PieChartDiagram;
import com.jetbrains.nodejs.run.profile.cpu.view.PieChartLegend;
import com.jetbrains.nodejs.run.profile.cpu.view.V8ProfileLineTreeCellRenderer;
import com.jetbrains.nodejs.run.profile.heap.view.renderers.RightAlignedRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TopCallsSelfDiagram {
    private static final int THRESHOLD = 10;
    @NotNull
    private final Project myProject;
    @NotNull
    private final V8LogCachingReader myReader;
    private final List<Piece> myLines;
    private final LineColorProvider myFileColor;
    private final int myHeight;
    private JComponent myComponent;

    public TopCallsSelfDiagram(@NotNull Project project, @NotNull V8LogCachingReader reader, LineColorProvider fileColor, int height) throws IOException {
        if (project == null) {
            TopCallsSelfDiagram.$$$reportNull$$$0(0);
        }
        if (reader == null) {
            TopCallsSelfDiagram.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myReader = reader;
        this.myFileColor = fileColor;
        this.myHeight = height;
        this.myLines = new ArrayList<Piece>();
        this.fillData(reader);
        this.createUI();
    }

    public JComponent getComponent() {
        return this.myComponent;
    }

    private void createUI() {
        JPanel panel = new JPanel(new GridBagLayout());
        Convertor dataConvertor = o -> o.getTensPercent();
        Convertor colorConvertor = o -> o.getColor();
        PieChartDiagram<Piece> pie = new PieChartDiagram<Piece>(this.myHeight, this.myLines, dataConvertor, colorConvertor).withHoleCoeff(0.5);
        PieChartLegend<Piece> legend = new PieChartLegend<Piece>(this.myLines, dataConvertor, colorConvertor, (TableCellRenderer)((Object)new FirstTableCellRenderer()), (TableCellRenderer)((Object)new RightAlignedRenderer().setDefaultBackground(UIUtil.getPanelBackground())));
        GridBagConstraints gb = new GridBagConstraints();
        gb.anchor = 18;
        gb.fill = 0;
        gb.insets = new Insets(5, 5, 5, 5);
        panel.add(pie, gb);
        ++gb.gridy;
        panel.add(legend, gb);
        this.myComponent = new JPanel(new BorderLayout());
        JBLabel title = new JBLabel(NodeJSBundle.message("node.js.v8.cpu.top.calls.overview.description", new Object[0]));
        title.setBorder(JBUI.Borders.empty((int)3));
        JPanel titleWrapper = TopCallsSelfDiagram.createNorthWrapper((JComponent)title);
        titleWrapper.add((Component)TopCallsSelfDiagram.createNorthWrapper(panel), "West");
        this.myComponent.add((Component)titleWrapper, "West");
    }

    @NotNull
    private static JPanel createNorthWrapper(JComponent component) {
        JPanel wrapper = new JPanel(new BorderLayout());
        wrapper.add((Component)component, "North");
        JPanel jPanel = wrapper;
        if (jPanel == null) {
            TopCallsSelfDiagram.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private void fillData(@NotNull V8LogCachingReader reader) throws IOException {
        int gcPercent;
        if (reader == null) {
            TopCallsSelfDiagram.$$$reportNull$$$0(3);
        }
        long total = reader.getNumTicks();
        int idlePercent = V8Utils.tensPercent(reader.getNumIdleTicks(), total);
        if (idlePercent >= 10) {
            this.myLines.add(new Piece(null, NodeJSBundle.message("profile.top_call_diagram.piece.idle.name", new Object[0]), idlePercent, FlameColors.IDLE_COLOR));
        }
        if ((gcPercent = V8Utils.tensPercent(reader.getNumGcTicks(), total)) >= 10) {
            this.myLines.add(new Piece(null, NodeJSBundle.message("profile.top_call_diagram.piece.gc.name", new Object[0]), gcPercent, FlameColors.getColor(0L, V8CodeScope.gc)));
        }
        FlatTopCalls flat = reader.getFlat();
        this.addLines(flat.getCpp());
        this.addLines(flat.getJavaScript());
        this.addLines(flat.getSharedLibraries());
        this.sortAndAddOther();
    }

    private void sortAndAddOther() {
        int total = 0;
        for (Piece line : this.myLines) {
            total += line.getTensPercent();
        }
        if ((total = 1000 - total) > 1) {
            this.myLines.add(new Piece(null, NodeJSBundle.message("profile.top_call_diagram.piece.other.name", new Object[0]), total, FlameColors.OTHER_COLOR));
        }
        this.myLines.sort(Comparator.comparingInt(Piece::getTensPercent));
    }

    private void addLines(List<V8ProfileLine> list) throws IOException {
        for (V8ProfileLine line : list) {
            if (line.getSelfTensPercent() < 10) continue;
            long id = line.getCall().getStringId();
            Piece piece = new Piece(line, null, line.getSelfTensPercent(), FlameColors.getColor(id, this.myReader.getCodeScopeByStringId(id)));
            this.myLines.add(piece);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/cpu/view/TopCallsSelfDiagram";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/view/TopCallsSelfDiagram";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createNorthWrapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "fillData";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Piece {
        @Nullable
        private final V8ProfileLine myLine;
        @Nullable
        @Nls
        private final String myPresentation;
        private int myTensPercent;
        private final JBColor myColor;

        Piece(@Nullable V8ProfileLine line, @Nls String presentation, int tensPercent, JBColor color) {
            this.myLine = line;
            this.myPresentation = presentation;
            this.myTensPercent = tensPercent;
            this.myColor = color;
        }

        @Nullable
        public V8ProfileLine getLine() {
            return this.myLine;
        }

        @Nls
        public String getPresentation() {
            return this.myPresentation;
        }

        public int getTensPercent() {
            return this.myTensPercent;
        }

        public void setTensPercent(int tensPercent) {
            this.myTensPercent = tensPercent;
        }

        public JBColor getColor() {
            return this.myColor;
        }
    }

    private static class FirstTableCellRenderer
    extends ColoredTableCellRenderer {
        private FirstTableCellRenderer() {
        }

        protected void customizeCellRenderer(@NotNull JTable table, @Nullable Object value, boolean selected, boolean hasFocus, int row, int column) {
            if (table == null) {
                FirstTableCellRenderer.$$$reportNull$$$0(0);
            }
            this.setBackground(UIUtil.getPanelBackground());
            if (value instanceof Piece) {
                if (((Piece)value).getLine() != null) {
                    V8CpuLogCall call = ((Piece)value).getLine().getCall();
                    V8ProfileLineTreeCellRenderer.Attributes attributes = V8ProfileLineTreeCellRenderer.getAttributes(call.isLocal(), call.isNative() || call.isNotNavigatable());
                    this.append(call.getPresentation(false), attributes.getAttributes(false));
                } else {
                    this.append(((Piece)value).getPresentation());
                }
            } else if (value != null) {
                @NlsSafe String fragment = value.toString();
                this.append(fragment);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/jetbrains/nodejs/run/profile/cpu/view/TopCallsSelfDiagram$FirstTableCellRenderer", "customizeCellRenderer"));
        }
    }
}

