/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.cpu.v8log.calculation;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.BeforeAfter;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.containers.BidirectionalMap;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.CodeMap;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.ParserBase;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogIndexesWriter;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogReader;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8LogReaderListener;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8Profile;
import com.jetbrains.nodejs.run.profile.cpu.v8log.calculation.V8ProfileCallback;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.ArgumentType;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.CodeState;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.Counter;
import com.jetbrains.nodejs.run.profile.cpu.v8log.data.V8EventType;
import com.jetbrains.nodejs.run.profile.cpu.v8log.reading.V8LogCachingReader;
import com.jetbrains.nodejs.run.profile.heap.CompositeCloseable;
import com.jetbrains.nodejs.run.profile.heap.IndexFiles;
import com.jetbrains.nodejs.run.profile.heap.calculation.ByteArrayWrapper;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class V8TickProcessor
implements V8LogReaderListener {
    private static final Logger LOG = Logger.getInstance(V8TickProcessor.class);
    private final File myFile;
    private final long myDistortionPerEntryNano;
    private final V8LogIndexesWriter myIndexesWriter;
    private long myDistortionNano;
    private final Map<String, ThrowableConsumer<List<String>, IOException>> myParsers;
    private final Map<TickCounterType, Counter> myTickCounters;
    private final V8Profile myProfile;
    private final Map<String, CodeType> myCodeTypes;
    private final Map<String, V8EventType> myEventTypes;
    private final Map<V8EventType, ArrayDeque<BeforeAfter<Long>>> myEventRanges;
    private long myLastTsMainThread;
    private long myLastTsBackgroundThread;
    private final ArrayDeque<V8EventType> myMainThreadEventStack;
    private final ArrayDeque<V8EventType> myBackgroundThreadEventStack;
    private boolean myWithTimestamp;
    private static final long myLastZippedTs = 0L;
    private static final long myMinRangeLen = 0L;
    private long myZipMoment;
    private static final long zipInterval = 100000000L;
    private static final long pauseTolerance = 5000L;

    /*
     * WARNING - void declaration
     */
    public V8TickProcessor(@NotNull ByteArrayWrapper digest, @NotNull File file, long distortionPerEntryNano, @NotNull IndexFiles<V8LogIndexesWriter.Category> indexFiles) throws IOException {
        void indexFiles2;
        if (digest == null) {
            V8TickProcessor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            V8TickProcessor.$$$reportNull$$$0(1);
        }
        if (indexFiles == null) {
            V8TickProcessor.$$$reportNull$$$0(2);
        }
        this.myLastTsMainThread = -1L;
        this.myLastTsBackgroundThread = -1L;
        this.myWithTimestamp = false;
        this.myZipMoment = 0L;
        this.myFile = file;
        this.myDistortionPerEntryNano = distortionPerEntryNano;
        this.myDistortionNano = 0L;
        this.myParsers = new HashMap<String, ThrowableConsumer<List<String>, IOException>>();
        this.myCodeTypes = new HashMap<String, CodeType>();
        this.myTickCounters = new HashMap<TickCounterType, Counter>();
        for (TickCounterType type : TickCounterType.values()) {
            this.myTickCounters.put(type, new Counter());
        }
        this.myProfile = new V8Profile(this.createCallback());
        this.myIndexesWriter = new V8LogIndexesWriter(this.myFile, digest, (IndexFiles<V8LogIndexesWriter.Category>)indexFiles2);
        this.fillParsers();
        this.myEventTypes = new HashMap<String, V8EventType>();
        this.myEventRanges = new HashMap<V8EventType, ArrayDeque<BeforeAfter<Long>>>();
        this.fillEventTypesAndRanges();
        this.myMainThreadEventStack = new ArrayDeque();
        this.myBackgroundThreadEventStack = new ArrayDeque();
    }

    public V8LogCachingReader execute(@NotNull CompositeCloseable resourses) throws IOException {
        if (resourses == null) {
            V8TickProcessor.$$$reportNull$$$0(3);
        }
        ProgressManager.progress((String)NodeJSBundle.message("progress.text.reading.v8.log", new Object[0]));
        new V8LogReader(this.myFile, this.myParsers).read();
        this.zipTimerEvents(true, 0L);
        ProgressManager.progress((String)NodeJSBundle.message("progress.text.recording.string.index", new Object[0]));
        BidirectionalMap<String, Long> map = this.myProfile.getCodeMap().getStringsMap();
        TreeMap<Long, String> ordered = new TreeMap<Long, String>();
        for (Map.Entry entry : map.entrySet()) {
            ordered.put((Long)entry.getValue(), (String)entry.getKey());
        }
        this.myIndexesWriter.writeStrings(ordered.values());
        this.myIndexesWriter.setTickCounters(this.myTickCounters.get((Object)TickCounterType.idle).getCnt(), this.myTickCounters.get((Object)TickCounterType.gc).getCnt());
        this.myIndexesWriter.writeHeader(Math.max(this.myLastTsBackgroundThread, this.myLastTsMainThread));
        this.myIndexesWriter.close();
        ProgressManager.progress((String)NodeJSBundle.message("progress.text.calculating.calls.durations", new Object[0]));
        this.myIndexesWriter.getDurationWorker().recalculateDurationsWriteDistribution((Long)ordered.pollLastEntry().getKey());
        ProgressManager.progress((String)NodeJSBundle.message("progress.text.calculating.overview.approximations", new Object[0]));
        this.myIndexesWriter.postProcess();
        this.myProfile.postProcess(this.myTickCounters.get((Object)TickCounterType.gc).getCnt(), this.myTickCounters.get((Object)TickCounterType.unaccounted).getCnt(), this.myTickCounters.get((Object)TickCounterType.idle).getCnt(), this.myCodeTypes, (ThrowableConvertor<Long, String, IOException>)((ThrowableConvertor)stringId -> this.myProfile.getCodeMap().getStringByCode((long)stringId)), this.myIndexesWriter.getMaxStackSize());
        return this.myIndexesWriter.createReader(resourses, this.myIndexesWriter.getDurationWorker().getDurationFactory(), this.myProfile.getBottomUpRoot(), this.myProfile.getTopDownRoot(), this.myProfile.getFlatTopCallsRoot(), this.myCodeTypes, this.myIndexesWriter.getDurationWorker().getDistributionFile(), this.myIndexesWriter.getDurationWorker().getSelfDistributionFile());
    }

    public Map<TickCounterType, Counter> getTickCounters() {
        return this.myTickCounters;
    }

    public V8Profile getProfile() {
        return this.myProfile;
    }

    private void fillParsers() {
        this.myParsers.put("shared-library", this.processSharedLibrary());
        this.myParsers.put("code-creation", this.processCodeCreation());
        this.myParsers.put("code-move", this.processCodeMove());
        this.myParsers.put("code-delete", this.processCodeDelete());
        this.myParsers.put("sfi-move", this.processFunctionMove());
        this.myParsers.put("snapshot-pos", ParserBase.EMPTY);
        this.myParsers.put("tick", this.processTick());
        this.myParsers.put("heap-sample-begin", ParserBase.EMPTY);
        this.myParsers.put("heap-sample-end", ParserBase.EMPTY);
        this.myParsers.put("timer-event-start", this.processTimerEventStart());
        this.myParsers.put("timer-event-end", this.processTimerEventEnd());
        this.myParsers.put("profiler", ParserBase.EMPTY);
        this.myParsers.put("function-creation", ParserBase.EMPTY);
        this.myParsers.put("function-move", ParserBase.EMPTY);
        this.myParsers.put("function-delete", ParserBase.EMPTY);
        this.myParsers.put("heap-sample-item", ParserBase.EMPTY);
        this.myParsers.put("code-allocate", ParserBase.EMPTY);
        this.myParsers.put("begin-code-region", ParserBase.EMPTY);
        this.myParsers.put("end-code-region", ParserBase.EMPTY);
        this.myParsers.put("code-disable-optimization", ParserBase.EMPTY);
        this.myParsers.put("code-deopt", ParserBase.EMPTY);
        this.myParsers.put("current-time", ParserBase.EMPTY);
        this.myParsers.put("v8-version", new ParserBase(4, 4, new ArgumentType[]{ArgumentType.str, ArgumentType.number, ArgumentType.number, ArgumentType.number}){

            @Override
            protected void process(List<String> strings) {
                long major = V8TickProcessor.parseNumber(strings.get(0));
                V8TickProcessor.this.myWithTimestamp = major >= 6L;
            }
        });
    }

    private void fillEventTypesAndRanges() {
        for (V8EventType type : V8EventType.values()) {
            this.myEventRanges.put(type, new ArrayDeque());
        }
    }

    private void zipTimerEvents(boolean force, long tick) throws IOException {
        if (!force) {
            if (this.myZipMoment + 100000000L > tick) {
                return;
            }
            if (!this.myBackgroundThreadEventStack.isEmpty() || !this.myMainThreadEventStack.isEmpty()) {
                return;
            }
        }
        this.myZipMoment = tick;
        ArrayList<V8LogIndexesWriter.TimerEvent> writeQueue = new ArrayList<V8LogIndexesWriter.TimerEvent>();
        for (Map.Entry<V8EventType, ArrayDeque<BeforeAfter<Long>>> entry : this.myEventRanges.entrySet()) {
            V8EventType type = entry.getKey();
            ArrayDeque<BeforeAfter<Long>> deque = entry.getValue();
            if (deque.isEmpty()) continue;
            BeforeAfter previous = null;
            for (BeforeAfter beforeAfter : deque) {
                if (previous == null) {
                    previous = beforeAfter;
                    continue;
                }
                if ((Long)previous.getAfter() + 5000L >= (Long)beforeAfter.getBefore()) {
                    previous = new BeforeAfter((Object)((Long)previous.getBefore()), (Object)((Long)beforeAfter.getAfter()));
                    continue;
                }
                writeQueue.add(new V8LogIndexesWriter.TimerEvent((Long)previous.getBefore(), type, (Long)previous.getAfter() - (Long)previous.getBefore()));
                previous = beforeAfter;
            }
            if (previous == null) continue;
            writeQueue.add(new V8LogIndexesWriter.TimerEvent((Long)previous.getBefore(), type, (Long)previous.getAfter() - (Long)previous.getBefore()));
        }
        writeQueue.sort(Comparator.comparingLong(V8LogIndexesWriter.TimerEvent::getStartNanos));
        for (V8LogIndexesWriter.TimerEvent event : writeQueue) {
            this.myIndexesWriter.recordEvent(event);
        }
    }

    private ParserBase processTimerEventStart() {
        return new ParserBase(2, 2, new ArgumentType[]{ArgumentType.str, ArgumentType.number}){

            @Override
            protected void process(List<String> strings) throws IOException {
                V8EventType last;
                V8TickProcessor.this.myDistortionNano += V8TickProcessor.this.myDistortionPerEntryNano;
                String eventName = StringUtil.unquoteString((String)strings.get(0));
                V8EventType type = V8EventType.getByCode(eventName.trim());
                if (type == null) {
                    return;
                }
                ArrayDeque<V8EventType> stack = type.getThreadId() == 0 ? V8TickProcessor.this.myMainThreadEventStack : V8TickProcessor.this.myBackgroundThreadEventStack;
                long lastTs = V8TickProcessor.this.getLastTs(type);
                long tick = V8TickProcessor.parseNumber(strings.get(1)) - V8TickProcessor.this.myDistortionNano;
                tick = Math.max(tick, lastTs + 0L);
                V8EventType v8EventType = last = stack.isEmpty() ? null : stack.getLast();
                if (last != null) {
                    V8TickProcessor.this.myEventRanges.get((Object)last).add((BeforeAfter<Long>)new BeforeAfter((Object)lastTs, (Object)tick));
                }
                stack.addLast(type);
                V8TickProcessor.this.setLastTs(type, tick);
                V8TickProcessor.this.zipTimerEvents(false, tick);
            }
        };
    }

    private long getLastTs(V8EventType type) {
        return type.getThreadId() == 0 ? this.myLastTsMainThread : this.myLastTsBackgroundThread;
    }

    private ParserBase processTimerEventEnd() {
        return new ParserBase(2, 2, new ArgumentType[]{ArgumentType.str, ArgumentType.number}){

            @Override
            protected void process(List<String> strings) throws IOException {
                ArrayDeque<V8EventType> stack;
                V8TickProcessor.this.myDistortionNano += V8TickProcessor.this.myDistortionPerEntryNano;
                String eventName = StringUtil.unquoteString((String)strings.get(0));
                V8EventType type = V8EventType.getByCode(eventName.trim());
                if (type == null) {
                    return;
                }
                long tick = V8TickProcessor.parseNumber(strings.get(1)) - V8TickProcessor.this.myDistortionNano;
                ArrayDeque<V8EventType> arrayDeque = stack = type.getThreadId() == 0 ? V8TickProcessor.this.myMainThreadEventStack : V8TickProcessor.this.myBackgroundThreadEventStack;
                if (stack.isEmpty()) {
                    return;
                }
                V8EventType lastEvent = stack.removeLast();
                while (!type.equals((Object)lastEvent)) {
                    if (stack.isEmpty()) {
                        return;
                    }
                    lastEvent = stack.removeLast();
                }
                V8TickProcessor.this.processEventTypeEnd(type, tick);
            }
        };
    }

    private void processEventTypeEnd(V8EventType type, long tick) throws IOException {
        long lastTs = this.getLastTs(type);
        tick = Math.max(tick, lastTs + 0L);
        this.myEventRanges.get((Object)type).add((BeforeAfter<Long>)new BeforeAfter((Object)lastTs, (Object)tick));
        this.setLastTs(type, tick);
        this.zipTimerEvents(false, tick);
    }

    private void setLastTs(V8EventType type, long tick) {
        if (type.getThreadId() == 0) {
            this.myLastTsMainThread = tick;
        } else {
            this.myLastTsBackgroundThread = tick;
        }
    }

    @Override
    public ParserBase advanceDistortion() {
        return new ParserBase(0, -1, new ArgumentType[0]){

            @Override
            protected void process(List<String> strings) throws IOException {
                V8TickProcessor.this.myDistortionNano += V8TickProcessor.this.myDistortionPerEntryNano;
            }
        };
    }

    @Override
    public ParserBase processTick() {
        return new ParserBase(5, -1, new ArgumentType[]{ArgumentType.address, ArgumentType.number, ArgumentType.number, ArgumentType.address, ArgumentType.number}){

            @Override
            protected void process(List<String> strings) throws IOException {
                CodeMap.CodeEntry funcEntry;
                V8TickProcessor.this.myDistortionNano += V8TickProcessor.this.myDistortionPerEntryNano;
                V8TickProcessor.this.myTickCounters.get((Object)TickCounterType.total).incrementAndGet();
                long vmStateCode = V8TickProcessor.parseNumber(strings.get(4));
                VmState vmState = VmState.fromCode((int)vmStateCode);
                if (VmState.GC.equals((Object)vmState)) {
                    V8TickProcessor.this.myTickCounters.get((Object)TickCounterType.gc).incrementAndGet();
                }
                BigInteger pc = V8TickProcessor.parseAddress(strings.get(0));
                long isExternalCallback = V8TickProcessor.parseNumber(strings.get(2));
                BigInteger tosOrExternalCallback = V8TickProcessor.parseAddress(strings.get(3));
                if (isExternalCallback > 0L) {
                    pc = tosOrExternalCallback;
                    tosOrExternalCallback = null;
                } else if (tosOrExternalCallback != null && !((funcEntry = V8TickProcessor.this.myProfile.findEntry(tosOrExternalCallback)) instanceof CodeMap.DynamicFuncCodeEntry)) {
                    tosOrExternalCallback = null;
                }
                long nanos = V8TickProcessor.parseNumber(strings.get(1));
                long realNanos = nanos - V8TickProcessor.this.myDistortionNano;
                ProgressManager.progress2((String)NodeJSBundle.message("progress.details.processing.tick.at.ms", realNanos / 1000L));
                if (strings.size() > 5) {
                    List<String> stack = strings.subList(5, strings.size());
                    List<BigInteger> parsedStack = V8TickProcessor.processStack(pc, tosOrExternalCallback, stack);
                    List<Long> symbolicStack = V8TickProcessor.this.myProfile.resolveAndFilterFuncs(parsedStack);
                    if (VmState.GC.equals((Object)vmState)) {
                        symbolicStack.add(0, 0L);
                    }
                    V8TickProcessor.this.myIndexesWriter.processTick(realNanos, vmState, symbolicStack);
                    V8TickProcessor.this.myProfile.recordTick(symbolicStack);
                } else {
                    if (VmState.GC.equals((Object)vmState)) {
                        List<Long> stack = Collections.singletonList(0L);
                        V8TickProcessor.this.myIndexesWriter.processTick(realNanos, vmState, stack);
                    } else {
                        V8TickProcessor.this.myTickCounters.get((Object)TickCounterType.idle).incrementAndGet();
                        V8TickProcessor.this.myIndexesWriter.processTick(realNanos, vmState, Collections.emptyList());
                    }
                    V8TickProcessor.this.myProfile.recordTick(Collections.emptyList());
                }
            }
        };
    }

    private static List<BigInteger> processStack(BigInteger pc, BigInteger func, List<String> tail) {
        ArrayList<BigInteger> list = new ArrayList<BigInteger>();
        list.add(pc);
        BigInteger prevFrame = pc;
        if (func != null) {
            list.add(func);
        }
        for (String val : tail) {
            BigInteger addr;
            if (val.startsWith("+")) {
                addr = V8TickProcessor.parseAddressOrNum(val.substring(1));
                if (addr != null) {
                    prevFrame = prevFrame.add(addr);
                    list.add(prevFrame);
                    continue;
                }
                LOG.info("wrong address: " + val);
                continue;
            }
            if (val.startsWith("-")) {
                addr = V8TickProcessor.parseAddressOrNum(val.substring(1));
                if (addr != null) {
                    prevFrame = prevFrame.subtract(addr);
                    list.add(prevFrame);
                    continue;
                }
                LOG.info("wrong address: " + val);
                continue;
            }
            if (val.startsWith("o")) continue;
            BigInteger address = V8TickProcessor.parseAddress(val);
            if (address != null) {
                list.add(address);
                continue;
            }
            LOG.info("wrong address: " + val);
        }
        return list;
    }

    @Override
    public ParserBase processFunctionMove() {
        return new ParserBase(2, 2, new ArgumentType[]{ArgumentType.address, ArgumentType.address}){

            @Override
            protected void process(List<String> strings) {
                BigInteger from = V8TickProcessor.parseAddress(strings.get(0));
                BigInteger to = V8TickProcessor.parseAddress(strings.get(1));
                V8TickProcessor.this.myProfile.moveFunc(from, to);
            }
        };
    }

    @Override
    public ParserBase processCodeDelete() {
        return new ParserBase(1, 1, new ArgumentType[]{ArgumentType.address}){

            @Override
            protected void process(List<String> strings) {
                V8TickProcessor.this.myProfile.deleteCode(V8TickProcessor.parseAddress(strings.get(0)));
            }
        };
    }

    @Override
    public ParserBase processCodeMove() {
        return new ParserBase(2, 2, new ArgumentType[]{ArgumentType.address, ArgumentType.address}){

            @Override
            protected void process(List<String> strings) {
                BigInteger from = V8TickProcessor.parseAddress(strings.get(0));
                BigInteger to = V8TickProcessor.parseAddress(strings.get(1));
                V8TickProcessor.this.myProfile.moveCode(from, to);
            }
        };
    }

    @Override
    public ThrowableConsumer<List<String>, IOException> processCodeCreation() {
        return strings -> {
            ParserBase parserBase = this.myWithTimestamp ? new MyCodeCreationWithTimestampParser() : new MyOldCodeCreationParser();
            parserBase.consume(strings);
        };
    }

    @Override
    public ParserBase processSharedLibrary() {
        return new ParserBase(3, 3, new ArgumentType[]{ArgumentType.str, ArgumentType.address, ArgumentType.address}){

            @Override
            protected void process(List<String> strings) {
                String name = StringUtil.unquoteString((String)strings.get(0));
                BigInteger start = V8TickProcessor.parseAddress(strings.get(1));
                BigInteger end = V8TickProcessor.parseAddress(strings.get(2));
                CodeMap.CodeEntry entry = V8TickProcessor.this.myProfile.addLibrary(name, start, end);
                V8TickProcessor.this.myCodeTypes.put(entry.getName(), CodeType.SHARED_LIB);
            }
        };
    }

    @NotNull
    private V8ProfileCallback createCallback() {
        return new V8ProfileCallback(){

            @Override
            public void onUnknownMove(BigInteger addr) {
                LOG.info("unknown move: " + addr);
            }

            @Override
            public void onUnknownDelete(BigInteger addr) {
                LOG.info("unknown delete: " + addr);
            }

            @Override
            public void onUnknownTick(BigInteger addr, long stackPos) {
                if (stackPos == 0L) {
                    V8TickProcessor.this.myTickCounters.get((Object)TickCounterType.unaccounted).incrementAndGet();
                }
            }

            @Override
            public boolean processFunction(String name) {
                return true;
            }
        };
    }

    private static BigInteger parseAddressOrNum(String s) {
        if (s.startsWith("0x")) {
            return V8TickProcessor.parseAddress(s);
        }
        return BigInteger.valueOf(V8TickProcessor.parseNumber(s));
    }

    public static BigInteger parseAddress(String s) {
        try {
            if (s.startsWith("0x")) {
                return new BigInteger(s.substring(2), 16);
            }
            return new BigInteger(s, 16);
        }
        catch (NumberFormatException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    static long parseNumber(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            return -1L;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "digest";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexFiles";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourses";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/nodejs/run/profile/cpu/v8log/calculation/V8TickProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyCodeCreationWithTimestampParser
    extends ParserBase {
        MyCodeCreationWithTimestampParser() {
            super(6, 8, ArgumentType.str, ArgumentType.number, ArgumentType.number, ArgumentType.address, ArgumentType.number, ArgumentType.str, ArgumentType.address, ArgumentType.str);
        }

        @Override
        protected void process(List<String> strings) {
            String type = StringUtil.unquoteString((String)strings.get(0));
            BigInteger startAddress = V8TickProcessor.parseAddress(strings.get(3));
            int size = (int)V8TickProcessor.parseNumber(strings.get(4));
            String name = StringUtil.unquoteString((String)strings.get(5));
            if (strings.size() > 7) {
                BigInteger funcAddress = V8TickProcessor.parseAddress(strings.get(6));
                String state = StringUtil.notNullize((String)strings.get(7));
                CodeState codeState = CodeState.fromStrState(state);
                codeState = codeState == null ? CodeState.compiled : codeState;
                V8TickProcessor.this.myProfile.addFuncCode(type, name, startAddress, size, funcAddress, codeState);
            } else {
                V8TickProcessor.this.myProfile.addCode(type, name, startAddress, size);
            }
        }
    }

    private class MyOldCodeCreationParser
    extends ParserBase {
        MyOldCodeCreationParser() {
            super(5, 7, ArgumentType.str, ArgumentType.number, ArgumentType.address, ArgumentType.number, ArgumentType.str, ArgumentType.address, ArgumentType.str);
        }

        @Override
        public void consume(List<String> strings) throws IOException {
            if (strings.size() > 5 && strings.get(strings.size() - 1).contains("\"")) {
                strings.set(4, StringUtil.join(strings.subList(4, strings.size()), (String)", "));
                super.consume(strings.subList(0, 5));
            } else {
                super.consume(strings);
            }
        }

        @Override
        protected void process(List<String> strings) {
            String type = StringUtil.unquoteString((String)strings.get(0));
            BigInteger start = V8TickProcessor.parseAddress(strings.get(2));
            int size = (int)V8TickProcessor.parseNumber(strings.get(3));
            String name = StringUtil.unquoteString((String)strings.get(4));
            if (strings.size() > 5 && !strings.get(strings.size() - 1).contains("\"")) {
                BigInteger funcAddress = V8TickProcessor.parseAddress(strings.get(5));
                String state = strings.size() == 7 ? strings.get(6) : "";
                CodeState codeState = CodeState.fromStrState(state);
                codeState = codeState == null ? CodeState.compiled : codeState;
                V8TickProcessor.this.myProfile.addFuncCode(type, name, start, size, funcAddress, codeState);
            } else {
                V8TickProcessor.this.myProfile.addCode(type, name, start, size);
            }
        }
    }

    public static enum VmState {
        JS(0),
        GC(1),
        COMPILER(2),
        OTHER(3),
        EXTERNAL(4),
        IDLE(5);

        private final int myCode;

        private VmState(int code) {
            this.myCode = code;
        }

        public int getCode() {
            return this.myCode;
        }

        @Nullable
        public static VmState fromCode(int code) {
            for (VmState state : VmState.values()) {
                if (state.getCode() != code) continue;
                return state;
            }
            return null;
        }
    }

    public static enum TickCounterType {
        total,
        unaccounted,
        excluded,
        gc,
        idle;

    }

    public static enum CodeType {
        CPP,
        SHARED_LIB;

    }
}

