/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run;

import com.intellij.diagnostic.logging.LogConfigurationPanel;
import com.intellij.execution.CommonProgramRunConfigurationParameters;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RefactoringListenerProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.execution.util.ScriptFileUtil;
import com.intellij.ide.browsers.StartBrowserSettings;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.debugger.JavaScriptDebugProcess;
import com.intellij.javascript.debugger.execution.DebuggableProcessRunConfiguration;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeInterpreterUtil;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.options.SettingsEditorGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.refactoring.listeners.RefactoringElementListener;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.io.PathKt;
import com.intellij.util.net.NetUtils;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.jetbrains.nodeJs.NodeDebugProgramRunnerKt;
import com.jetbrains.nodeJs.NodeJSDebuggableConfiguration;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.execution.NodeCommandLineState;
import com.jetbrains.nodejs.run.NodeJSRunConfigurationExtensionsManager;
import com.jetbrains.nodejs.run.NodeJSStartBrowserRunConfigurationExtension;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationRefactoringHandler;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationState;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationType;
import com.jetbrains.nodejs.run.NodeRunConfigurationEditor;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Map;
import java.util.Objects;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public final class NodeJsRunConfiguration
extends LocatableConfigurationBase<Element>
implements NodeJSDebuggableConfiguration,
RefactoringListenerProvider,
DebuggableProcessRunConfiguration,
PersistentStateComponent<Element>,
JSRunProfileWithCompileBeforeLaunchOption {
    @NotNull
    private StartBrowserSettings myStartBrowserSettings = new StartBrowserSettings();
    @NotNull
    private NodeProfilingSettings myNodeProfilingSettings;
    @NotNull
    private EnvironmentVariablesData myEnvData = EnvironmentVariablesData.DEFAULT;

    NodeJsRunConfiguration(Project project, ConfigurationFactory factory, @Nullable String name) {
        super(project, factory, name);
        this.myNodeProfilingSettings = new NodeProfilingSettings();
    }

    @NotNull
    protected NodeJsRunConfigurationState getOptions() {
        NodeJsRunConfigurationState nodeJsRunConfigurationState = (NodeJsRunConfigurationState)super.getOptions();
        if (nodeJsRunConfigurationState == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(0);
        }
        return nodeJsRunConfigurationState;
    }

    @TestOnly
    public void setNodeInterpreter(@NotNull String path) {
        if (path == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(1);
        }
        this.getOptions().setInterpreterRef(NodeJsInterpreterRef.create((NodeJsInterpreter)new NodeJsLocalInterpreter(path)));
    }

    @Nullable
    public String getWorkingDirectory() {
        return this.getOptions().getWorkingDir();
    }

    public void setWorkingDirectory(@Nullable String value) {
        this.getOptions().setWorkingDir(FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)value)));
    }

    @NotNull
    public StartBrowserSettings getStartBrowserSettings() {
        StartBrowserSettings startBrowserSettings = this.myStartBrowserSettings;
        if (startBrowserSettings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(2);
        }
        return startBrowserSettings;
    }

    public void setStartBrowserSettings(@NotNull StartBrowserSettings settings) {
        if (settings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(3);
        }
        this.myStartBrowserSettings = settings;
    }

    @NotNull
    public NodeProfilingSettings getNodeProfilingSettings() {
        NodeProfilingSettings nodeProfilingSettings = this.myNodeProfilingSettings;
        if (nodeProfilingSettings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(4);
        }
        return nodeProfilingSettings;
    }

    public void setNodeProfilingSettings(@NotNull NodeProfilingSettings nodeProfilingSettings) {
        if (nodeProfilingSettings == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(5);
        }
        this.myNodeProfilingSettings = nodeProfilingSettings;
    }

    public RunConfiguration clone() {
        NodeJsRunConfiguration clone = (NodeJsRunConfiguration)super.clone();
        clone.myNodeProfilingSettings = new NodeProfilingSettings(this.myNodeProfilingSettings);
        return clone;
    }

    public void onNewConfigurationCreated() {
        String workingDir = this.getWorkingDirectory();
        if (StringUtil.isEmptyOrSpaces((String)workingDir)) {
            this.getOptions().setWorkingDir(StringUtil.notNullize((String)this.getProject().getBasePath()));
        }
    }

    @NotNull
    public SettingsEditor<NodeJsRunConfiguration> getConfigurationEditor() {
        SettingsEditorGroup group = new SettingsEditorGroup();
        NodeRunConfigurationEditor settings = new NodeRunConfigurationEditor(this.getProject());
        group.addEditor(NodeJSBundle.message("rc.nodejs.configuration.tab.name", new Object[0]), (SettingsEditor)settings);
        NodeJSRunConfigurationExtensionsManager.getInstance().appendEditorsNode(this, (SettingsEditorGroup<NodeJsRunConfiguration>)group, settings);
        group.addEditor(ExecutionBundle.message((String)"logs.tab.title", (Object[])new Object[0]), (SettingsEditor)new LogConfigurationPanel());
        SettingsEditorGroup settingsEditorGroup = group;
        if (settingsEditorGroup == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(6);
        }
        return settingsEditorGroup;
    }

    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment executionEnvironment) {
        if (executor == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(7);
        }
        if (executionEnvironment == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(8);
        }
        return this.createState(executionEnvironment);
    }

    @NotNull
    private RunProfileState createState(@NotNull ExecutionEnvironment environment) {
        if (environment == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(9);
        }
        return new NodeCommandLineState(environment, this);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        Path workingDir;
        NodeJsInterpreter interpreter = this.getInterpreter();
        NodeInterpreterUtil.checkForRunConfiguration((NodeJsInterpreter)interpreter);
        NodeJSRunConfigurationExtensionsManager.getInstance().checkConfiguration(this);
        String workingDirPath = this.getWorkingDirectory();
        Path path = workingDir = workingDirPath == null ? null : Paths.get(workingDirPath, new String[0]);
        if (workingDir == null || !workingDir.isAbsolute() || !workingDir.toFile().isDirectory()) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("rc.nodejs.error.incorrect.workingDirectory.text", new Object[0]));
        }
        String pathToJsFileWithMacros = this.getInputPath();
        String pathToJsFile = ProgramParametersUtil.expandPathAndMacros((String)pathToJsFileWithMacros, (Module)ProgramParametersUtil.getModule((CommonProgramRunConfigurationParameters)this), (Project)this.getProject());
        if (Objects.equals(pathToJsFile, pathToJsFileWithMacros)) {
            NodeJsRunConfiguration.validatePath(workingDir, pathToJsFile);
        }
        if (this.myStartBrowserSettings.isSelected() && this.myStartBrowserSettings.getUrl() == null) {
            throw new RuntimeConfigurationError(NodeJSBundle.message("rc.nodejs.error.unspecified.url", NodeJSStartBrowserRunConfigurationExtension.getTabTitle()));
        }
        this.myNodeProfilingSettings.check(pathToJsFile);
    }

    private static void validatePath(@NotNull Path workingDir, @Nullable String jsFilePath) throws RuntimeConfigurationError {
        BasicFileAttributes attributes;
        if (workingDir == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(10);
        }
        if (jsFilePath == null) {
            return;
        }
        if (ScriptFileUtil.isMemoryScriptPath((String)jsFilePath)) {
            if (ScriptFileUtil.findScriptFileByPath((String)jsFilePath) == null) {
                throw new RuntimeConfigurationError(NodeJSBundle.message("rc.nodejs.error.script.not.found.text", new Object[0]));
            }
            return;
        }
        Path jsFile = NodeJsRunConfiguration.getPath(jsFilePath);
        if (jsFile != null && jsFile.isAbsolute() && (attributes = PathKt.basicAttributesIfExists((Path)jsFile)) != null && (attributes.isRegularFile() || attributes.isSymbolicLink())) {
            return;
        }
        try {
            jsFile = workingDir.resolve(jsFilePath);
            attributes = PathKt.basicAttributesIfExists((Path)jsFile);
            if (attributes != null && (attributes.isRegularFile() || attributes.isSymbolicLink())) {
                return;
            }
        }
        catch (InvalidPathException invalidPathException) {
            // empty catch block
        }
        throw new RuntimeConfigurationError(NodeJSBundle.message("rc.nodejs.error.incorrect.JavaScript.file.path.text", new Object[0]));
    }

    @Nullable
    private static Path getPath(@Nullable String filePath) {
        if (filePath == null) {
            return null;
        }
        try {
            return Paths.get(filePath, new String[0]);
        }
        catch (InvalidPathException e) {
            return null;
        }
    }

    @Nullable
    public NodeJsInterpreter getInterpreter() {
        return this.getOptions().getInterpreterRef().resolve(this.getProject());
    }

    @NotNull
    public NodeJsInterpreterRef getInterpreterRef() {
        NodeJsInterpreterRef nodeJsInterpreterRef = this.getOptions().getInterpreterRef();
        if (nodeJsInterpreterRef == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(11);
        }
        return nodeJsInterpreterRef;
    }

    public String suggestedName() {
        @NlsSafe String filename = PathUtilRt.getFileName((String)this.getOptions().getPathToJsFile());
        return filename;
    }

    public void loadState(@NotNull Element element) {
        if (element == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(12);
        }
        super.loadState((Object)element);
        this.myEnvData = EnvironmentVariablesData.readExternal((Element)element);
        NodeJSRunConfigurationExtensionsManager.getInstance().readExternal((RunConfigurationBase)this, element);
    }

    public void addCoffeeScriptNodeOptionIfNeeded() {
        String pathToJsFile = this.getOptions().getPathToJsFile();
        if (pathToJsFile == null || !pathToJsFile.endsWith(".coffee")) {
            return;
        }
        String packageName = NodeJsRunConfiguration.guessCoffeeScriptPackage(this.getProject());
        String nodeOption = "--require " + packageName + "/register";
        Object nodeParameters = StringUtil.notNullize((String)this.getOptions().getNodeParameters());
        if (!((String)nodeParameters).contains(nodeOption)) {
            if (!((String)(nodeParameters = StringUtil.trimEnd((String)nodeParameters, (String)" "))).isEmpty()) {
                nodeParameters = (String)nodeParameters + " ";
            }
            this.getOptions().setNodeParameters((String)nodeParameters + nodeOption);
        }
    }

    @NotNull
    private static String guessCoffeeScriptPackage(@NotNull Project project) {
        VirtualFile root;
        VirtualFile packageJson;
        if (project == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(13);
        }
        if ((packageJson = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)(root = project.isDefault() ? null : ProjectUtil.guessProjectDir((Project)project)))) != null) {
            String oldPackageName = "coffee-script";
            if (PackageJsonData.getOrCreate((VirtualFile)packageJson).isDependencyOfAnyType(oldPackageName)) {
                String string = oldPackageName;
                if (string == null) {
                    NodeJsRunConfiguration.$$$reportNull$$$0(14);
                }
                return string;
            }
        }
        return "coffeescript";
    }

    public Element getState() {
        Element element = new Element("state");
        super.writeExternal(element);
        if (!EnvironmentVariablesData.DEFAULT.equals((Object)this.myEnvData)) {
            this.myEnvData.writeExternal(element);
        }
        NodeJSRunConfigurationExtensionsManager.getInstance().writeExternal((RunConfigurationBase)this, element);
        return element;
    }

    @Nullable
    public RefactoringElementListener getRefactoringElementListener(PsiElement element) {
        return NodeJsRunConfigurationRefactoringHandler.createRefactoringElementListener(this, element);
    }

    @Nullable
    public String getProgramParameters() {
        return this.getOptions().getNodeParameters();
    }

    public void setProgramParameters(@Nullable String value) {
        this.getOptions().setNodeParameters(value);
    }

    @Nullable
    public String getApplicationParameters() {
        return this.getOptions().getApplicationParameters();
    }

    public void setApplicationParameters(@Nullable String applicationParameters) {
        this.getOptions().setApplicationParameters(applicationParameters);
    }

    @NotNull
    public Map<String, String> getEnvs() {
        Map map = this.myEnvData.getEnvs();
        if (map == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(15);
        }
        return map;
    }

    public void setEnvs(@NotNull Map<String, String> envs) {
        if (envs == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(16);
        }
        this.myEnvData = EnvironmentVariablesData.create(envs, (boolean)this.myEnvData.isPassParentEnvs());
    }

    public boolean isPassParentEnvs() {
        return this.myEnvData.isPassParentEnvs();
    }

    public void setPassParentEnvs(boolean passParentEnvs) {
        this.myEnvData = EnvironmentVariablesData.create((Map)this.myEnvData.getEnvs(), (boolean)passParentEnvs);
    }

    @NotNull
    public EnvironmentVariablesData getEnvData() {
        EnvironmentVariablesData environmentVariablesData = this.myEnvData;
        if (environmentVariablesData == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(17);
        }
        return environmentVariablesData;
    }

    public void setEnvData(@NotNull EnvironmentVariablesData envData) {
        if (envData == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(18);
        }
        this.myEnvData = envData;
    }

    @Nullable
    public static NodeJsRunConfiguration getDefaultRunConfiguration(@NotNull Project project) {
        if (project == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(19);
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = runManager.getConfigurationTemplate((ConfigurationFactory)NodeJsRunConfigurationType.getInstance());
        return (NodeJsRunConfiguration)((Object)ObjectUtils.tryCast((Object)settings.getConfiguration(), NodeJsRunConfiguration.class));
    }

    @Nullable
    public String getExePath() {
        return PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)this.getRawExePath()));
    }

    public String getRawExePath() {
        NodeJsInterpreter interpreter = this.getInterpreter();
        if (interpreter == null) {
            return "";
        }
        return interpreter.getOldPath();
    }

    @Nullable
    public String getInputPath() {
        return this.getOptions().getPathToJsFile();
    }

    public void setInputPath(@Nullable String value) {
        if ((value = StringUtil.nullize((String)value)) == null) {
            this.getOptions().setPathToJsFile(null);
        } else {
            this.getOptions().setPathToJsFile(FileUtilRt.toSystemIndependentName((String)value));
        }
    }

    @Nullable
    public String getEffectiveExePath() throws ExecutionException {
        NodeJSRemoteInterpreterManager manager;
        NodeJsInterpreter interpreter = this.getInterpreter();
        NodeJsRemoteInterpreter remoteInterpreter = NodeJsRemoteInterpreter.tryCast((NodeJsInterpreter)interpreter);
        if (remoteInterpreter != null && (manager = NodeJSRemoteInterpreterManager.getInstanceOrPrompt((String)NodeJSBundle.message("dialog.title.node.js.run.configuration", new Object[0]))) != null) {
            try {
                if (manager.producesSshSdkCredentials(remoteInterpreter)) {
                    return StringUtil.nullize((String)manager.getCredentialsByInterpreter(remoteInterpreter).getInterpreterPath());
                }
            }
            catch (InterruptedException e) {
                throw new ExecutionException((Throwable)e);
            }
        }
        return StringUtil.nullize((String)this.getRawExePath());
    }

    @Nullable
    public String getEffectiveWorkingDirectory() {
        return PathUtil.toSystemDependentName((String)StringUtil.nullize((String)this.getWorkingDirectory()));
    }

    @NotNull
    public String correctExePath(@NotNull String exePath) {
        if (exePath == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(20);
        }
        String string = exePath;
        if (string == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    public XDebugProcess createDebugProcess(@NotNull InetSocketAddress socketAddress, @NotNull XDebugSession session, @Nullable ExecutionResult executionResult, @NotNull ExecutionEnvironment environment) {
        if (socketAddress == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(22);
        }
        if (session == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(23);
        }
        if (environment == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(24);
        }
        JavaScriptDebugProcess javaScriptDebugProcess = NodeDebugProgramRunnerKt.createDebugProcess((NodeJSDebuggableConfiguration)this, (InetSocketAddress)socketAddress, (XDebugSession)session, (ExecutionResult)executionResult);
        if (javaScriptDebugProcess == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(25);
        }
        return javaScriptDebugProcess;
    }

    public boolean hasConfiguredDebugAddress() {
        return NodeCommandLineUtil.findDebugPort((String)this.getProgramParameters()) != -1;
    }

    @NotNull
    public InetSocketAddress computeDebugAddress(RunProfileState state) throws ExecutionException {
        String host;
        int debugPort = NodeCommandLineUtil.findDebugPort((String)this.getProgramParameters());
        if (debugPort == -1) {
            try {
                debugPort = NetUtils.findAvailableSocketPort();
            }
            catch (IOException e) {
                throw new ExecutionException(XDebuggerBundle.message((String)"error.message.cannot.find.available.port", (Object[])new Object[0]), (Throwable)e);
            }
        }
        if (state instanceof NodeCommandLineState && (host = ((NodeCommandLineState)state).getDebugHost()) != null) {
            return new InetSocketAddress(host, debugPort);
        }
        return new InetSocketAddress(NodeCommandLineUtil.getNodeLoopbackAddress(), debugPort);
    }

    public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
        if (executorId == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(26);
        }
        if (profile == null) {
            NodeJsRunConfiguration.$$$reportNull$$$0(27);
        }
        return this.getOptions().getPathToJsFile() == null || !this.getOptions().getPathToJsFile().endsWith(".coffee");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/NodeJsRunConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeProfilingSettings";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executionEnvironment";
                break;
            }
            case 9: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workingDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 13: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envs";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "envData";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exePath";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socketAddress";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executorId";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getOptions";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/NodeJsRunConfiguration";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartBrowserSettings";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeProfilingSettings";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreterRef";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "guessCoffeeScriptPackage";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvs";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnvData";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "correctExePath";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "createDebugProcess";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setNodeInterpreter";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setStartBrowserSettings";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setNodeProfilingSettings";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createState";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "guessCoffeeScriptPackage";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setEnvs";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setEnvData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultRunConfiguration";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "correctExePath";
                break;
            }
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "createDebugProcess";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "canRun";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 26: 
            case 27: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

