/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.packages;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.net.NetUtils;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import java.util.zip.GZIPOutputStream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NodePackageNamesStandaloneUploader {
    @NonNls
    private static final String DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss Z";
    private static final String NPM_REGISTRY_ALL_URL = "http://registry.npmjs.org/-/all";
    private static final String NAME = "name";

    public static void main(String[] args) throws IOException {
        NodePackageNamesStandaloneUploader.run();
    }

    private static void run() throws IOException {
        File jsonFile = FileUtil.createTempFile((String)"all-node-packages", (String)".json");
        System.out.printf("Downloading %s to %s ...\n", NPM_REGISTRY_ALL_URL, jsonFile.getAbsoluteFile());
        long startNanoTime = System.nanoTime();
        NodePackageNamesStandaloneUploader.download(NPM_REGISTRY_ALL_URL, jsonFile);
        System.out.printf("%s has been downloaded to %s in %.1f seconds\n", NPM_REGISTRY_ALL_URL, jsonFile.getAbsolutePath(), Float.valueOf((float)TimeoutUtil.getDurationMillis((long)startNanoTime) / 1000.0f));
        File namesFile = FileUtil.createTempFile((String)"all-node-package-names-json", (String)".gzip");
        List<String> names = NodePackageNamesStandaloneUploader.extractNames(jsonFile);
        if (names.size() < 100) {
            throw new RuntimeException("Too few packages " + names + ", uploading skipped");
        }
        Collections.sort(names);
        NodePackageNamesStandaloneUploader.writeNames(names, namesFile);
        System.out.println("Package names have been written to " + namesFile.getAbsolutePath());
        NodePackageNamesStandaloneUploader.uploadToFtp(namesFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeNames(@NotNull List<String> names, @NotNull File namesFile) throws IOException {
        if (names == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(0);
        }
        if (namesFile == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(1);
        }
        try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)new GZIPOutputStream(new FileOutputStream(namesFile)), StandardCharsets.UTF_8));){
            writer.setIndent(" ");
            writer.beginObject();
            SimpleDateFormat df = new SimpleDateFormat(DATE_FORMAT);
            writer.name("_updated").value(df.format(new Date()));
            writer.name("_total_package_count").value((long)names.size());
            writer.name("package_names");
            writer.beginArray();
            for (String name : names) {
                writer.value(name);
            }
            writer.endArray();
            writer.endObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> extractNames(@NotNull File jsonFile) throws IOException {
        if (jsonFile == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(2);
        }
        long startNanoTime = System.nanoTime();
        JsonReader reader = new JsonReader((Reader)new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(jsonFile), StandardCharsets.UTF_8), 524288));
        ArrayList<String> names = new ArrayList<String>();
        try {
            reader.beginObject();
            while (reader.hasNext()) {
                String key = reader.nextName();
                if ("_updated".equalsIgnoreCase(key)) {
                    reader.skipValue();
                    continue;
                }
                String name = NodePackageNamesStandaloneUploader.readPackageName(reader);
                if (name == null) {
                    System.err.println("Cannot parse info for node package '" + key + "'");
                    continue;
                }
                names.add(name);
            }
            reader.endObject();
            System.out.printf("%d package names extracted in %d ms\n", names.size(), TimeoutUtil.getDurationMillis((long)startNanoTime));
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return names;
    }

    @Nullable
    private static String readPackageName(@NotNull JsonReader reader) throws IOException {
        if (reader == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(3);
        }
        reader.beginObject();
        String name = null;
        while (reader.hasNext()) {
            String key = reader.nextName();
            if (NAME.equals(key)) {
                name = reader.nextString();
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return name;
    }

    private static void download(@NotNull String location, @NotNull File outFile) throws IOException {
        if (location == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(4);
        }
        if (outFile == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(5);
        }
        HttpRequests.request((String)location).saveToFile(outFile, null);
    }

    private static void uploadToFtp(@NotNull File fileToUpload) throws IOException {
        if (fileToUpload == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(6);
        }
        String path = "/etc/intellij-nodejs-ftp-auth.properties";
        Properties auth = NodePackageNamesStandaloneUploader.loadAuthProperties(new File(path));
        NodePackageNamesStandaloneUploader.uploadToFtp(fileToUpload, auth.getProperty("host"), Integer.parseInt(auth.getProperty("port")), auth.getProperty("username"), auth.getProperty("password"), auth.getProperty("uploadPath"), auth.getProperty("baseHttpUrl"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Properties loadAuthProperties(@NotNull File file) throws IOException {
        if (file == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(7);
        }
        FileInputStream inputStream = new FileInputStream(file);
        Properties prop = new Properties();
        prop.load(inputStream);
        Properties properties = prop;
        Properties properties2 = properties;
        if (properties2 == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(8);
        }
        return properties2;
        finally {
            ((InputStream)inputStream).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void uploadToFtp(@NotNull File fileToUpload, @NotNull String host, int port, @NotNull String username, @NotNull String password, @NotNull String uploadPath, @NotNull String baseHttpUrl) throws IOException {
        if (fileToUpload == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(9);
        }
        if (host == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(10);
        }
        if (username == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(11);
        }
        if (password == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(12);
        }
        if (uploadPath == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(13);
        }
        if (baseHttpUrl == null) {
            NodePackageNamesStandaloneUploader.$$$reportNull$$$0(14);
        }
        String ftpUrl = "ftp://" + username + ":" + password + "@" + host + ":" + port + uploadPath;
        System.out.println("Uploading " + fileToUpload.getAbsolutePath() + " to " + ftpUrl + " ...");
        FileInputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            URL url = new URL(ftpUrl);
            URLConnection conn = url.openConnection();
            outputStream = conn.getOutputStream();
            inputStream = new FileInputStream(fileToUpload);
            NetUtils.copyStreamContent(null, (InputStream)inputStream, (OutputStream)outputStream, (int)((int)fileToUpload.length()));
            System.out.println("File uploaded correctly, will be available soon at " + baseHttpUrl + uploadPath);
        }
        catch (Throwable throwable) {
            NodePackageNamesStandaloneUploader.closeStream(outputStream);
            NodePackageNamesStandaloneUploader.closeStream(inputStream);
            throw throwable;
        }
        NodePackageNamesStandaloneUploader.closeStream(outputStream);
        NodePackageNamesStandaloneUploader.closeStream(inputStream);
    }

    private static void closeStream(@Nullable Closeable closeable) throws IOException {
        if (closeable != null) {
            closeable.close();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "names";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namesFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsonFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outFile";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToUpload";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/packages/NodePackageNamesStandaloneUploader";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "username";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "password";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uploadPath";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseHttpUrl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/packages/NodePackageNamesStandaloneUploader";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAuthProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeNames";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "extractNames";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "readPackageName";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "download";
                break;
            }
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "uploadToFtp";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadAuthProperties";
                break;
            }
            case 8: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

