/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.nodeunit.execution;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.NodeConsoleAdditionalFilter;
import com.intellij.javascript.nodejs.NodeStackTraceFilter;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.testing.JsTestConsoleProperties;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.util.config.AbstractProperty;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitRunConfiguration;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitSettings;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestLocationProvider;
import com.jetbrains.nodejs.nodeunit.execution.NodeunitTestType;
import com.jetbrains.nodejs.util.NodeJsCodeLocator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class NodeunitRunProfileState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    private final ExecutionEnvironment myEnvironment;
    private final NodeunitSettings mySettings;

    protected NodeunitRunProfileState(@NotNull ExecutionEnvironment environment, @NotNull NodeunitSettings settings) {
        if (environment == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(1);
        }
        this.myEnvironment = environment;
        this.mySettings = settings;
    }

    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsInterpreter interpreter = this.mySettings.getInterpreterRef().resolve(this.myEnvironment.getProject());
        NodeJsLocalInterpreter localInterpreter = NodeJsLocalInterpreter.castAndValidate((NodeJsInterpreter)interpreter);
        ProcessHandler processHandler = this.startProcess(localInterpreter, debugPort);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        File workingDir = new File(this.mySettings.getWorkingDirectory());
        ConsoleView consoleView = NodeunitRunProfileState.createConsole(processHandler, this.myEnvironment, new NodeunitTestLocationProvider(workingDir));
        consoleView.addMessageFilter((Filter)new NodeStackTraceFilter(this.myEnvironment.getProject(), workingDir));
        consoleView.addMessageFilter((Filter)new NodeConsoleAdditionalFilter(this.myEnvironment.getProject(), workingDir));
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, processHandler);
        executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(2);
        }
        return defaultExecutionResult;
    }

    @NotNull
    private ProcessHandler startProcess(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) throws ExecutionException {
        if (interpreter == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(3);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.withCharset(StandardCharsets.UTF_8);
        this.mySettings.getEnvData().configureCommandLine(commandLine, true);
        commandLine.withWorkDirectory(this.mySettings.getWorkingDirectory());
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptionsForDebugging((GeneralCommandLine)commandLine, Collections.emptyList(), (int)debugPort, (boolean)true, (NodeJsInterpreter)interpreter, (boolean)true);
        File mainFile = NodeunitRunProfileState.getNodeunitMainFile();
        commandLine.addParameter(mainFile.getAbsolutePath());
        commandLine.addParameter(this.mySettings.getNodeunitPackage().getSystemDependentPath());
        NodeunitTestType testType = this.mySettings.getTestType();
        if (testType == NodeunitTestType.DIRECTORY) {
            commandLine.addParameter(this.mySettings.getDirectory());
        } else {
            commandLine.addParameter(this.mySettings.getJsFile());
        }
        OSProcessHandler oSProcessHandler = NodeCommandLineUtil.createProcessHandler((GeneralCommandLine)commandLine, (boolean)false);
        if (oSProcessHandler == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(4);
        }
        return oSProcessHandler;
    }

    @NotNull
    public static File getNodeunitMainFile() throws ExecutionException {
        File file;
        String relativePath = "nodeunit/nodeunit-intellij-starter.js";
        try {
            file = NodeJsCodeLocator.getFileRelativeToJsDir(relativePath);
        }
        catch (IOException e) {
            throw new ExecutionException(NodeJSBundle.message("rc.nodeunit.cannot_find_intellij_starter.error.message", relativePath), (Throwable)e);
        }
        if (file == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static ConsoleView createConsole(@NotNull ProcessHandler processHandler, @NotNull ExecutionEnvironment env, @NotNull SMTestLocator locator) {
        if (processHandler == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(6);
        }
        if (env == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(7);
        }
        if (locator == null) {
            NodeunitRunProfileState.$$$reportNull$$$0(8);
        }
        NodeunitRunConfiguration runConfiguration = (NodeunitRunConfiguration)env.getRunProfile();
        NodeunitConsoleProperties consoleProperties = new NodeunitConsoleProperties(runConfiguration, env.getExecutor(), locator);
        SMTRunnerConsoleView testsOutputConsoleView = SMTestRunnerConnectionUtil.createConsole((SMTRunnerConsoleProperties)consoleProperties);
        testsOutputConsoleView.attachToProcess(processHandler);
        return testsOutputConsoleView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "locator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "startProcess";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeunitMainFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConsole";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class NodeunitConsoleProperties
    extends JsTestConsoleProperties {
        private final SMTestLocator myLocator;

        NodeunitConsoleProperties(@NotNull NodeunitRunConfiguration configuration, @NotNull Executor executor, @NotNull SMTestLocator locator) {
            if (configuration == null) {
                NodeunitConsoleProperties.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                NodeunitConsoleProperties.$$$reportNull$$$0(1);
            }
            if (locator == null) {
                NodeunitConsoleProperties.$$$reportNull$$$0(2);
            }
            super((RunConfiguration)configuration, "Nodeunit", executor);
            this.myLocator = locator;
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
            this.setPrintTestingStartedTime(false);
        }

        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "locator";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/nodejs/nodeunit/execution/NodeunitRunProfileState$NodeunitConsoleProperties";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

