/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.ConfigurationFromContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.ide.DataManager;
import com.intellij.ide.actions.runAnything.RunAnythingAction;
import com.intellij.ide.actions.runAnything.activity.RunAnythingProviderBase;
import com.intellij.ide.actions.runAnything.items.RunAnythingHelpItem;
import com.intellij.javascript.nodejs.execution.NodeRunConfigurationLocationFilterKt;
import com.intellij.lang.javascript.library.JSLibraryUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.impl.SimpleDataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.util.ObjectUtils;
import com.jetbrains.nodejs.run.ContextInfo;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationProducer;
import com.jetbrains.nodejs.run.NodeJsRunConfigurationProducerKt;
import icons.JavaScriptLanguageIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeRunAnythingProvider
extends RunAnythingProviderBase<RunInfo> {
    private static final Logger LOG = Logger.getInstance(NodeRunAnythingProvider.class);
    private static final String PREFIX = "node";

    @NotNull
    public Collection<RunInfo> getValues(@NotNull DataContext dataContext, @NotNull String pattern) {
        Project project;
        if (dataContext == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(1);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(dataContext)) == null || project.isDefault()) {
            List<RunInfo> list = Collections.emptyList();
            if (list == null) {
                NodeRunAnythingProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (!NodeRunAnythingProvider.hasNodePrefix(pattern)) {
            List<RunInfo> list = Collections.emptyList();
            if (list == null) {
                NodeRunAnythingProvider.$$$reportNull$$$0(3);
            }
            return list;
        }
        VirtualFile root = ProjectUtil.guessProjectDir((Project)project);
        if (root == null) {
            List<RunInfo> list = Collections.emptyList();
            if (list == null) {
                NodeRunAnythingProvider.$$$reportNull$$$0(4);
            }
            return list;
        }
        Collection collection = NodeRunAnythingProvider.listFilesInProject(project).stream().map(file -> VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)root)).filter(Objects::nonNull).sorted().map(path -> new RunInfo((String)path, null)).collect(Collectors.toList());
        if (collection == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    public RunInfo findMatchingValue(@NotNull DataContext dataContext, @NotNull String pattern) {
        VirtualFile root;
        if (dataContext == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(6);
        }
        if (pattern == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(7);
        }
        if (!NodeRunAnythingProvider.hasNodePrefix(pattern)) {
            return null;
        }
        String pathAndArgs = pattern.substring(PREFIX.length()).trim();
        int pathEndInd = pathAndArgs.indexOf(32);
        if (pathEndInd == -1) {
            pathEndInd = pathAndArgs.length();
        }
        RunInfo runInfo = new RunInfo(pathAndArgs.substring(0, pathEndInd).trim(), pathAndArgs.substring(pathEndInd).trim());
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        VirtualFile virtualFile = root = project != null ? ProjectUtil.guessProjectDir((Project)project) : null;
        if (root == null) {
            return null;
        }
        VirtualFile file = root.findFileByRelativePath(FileUtil.toSystemIndependentName((String)runInfo.myRelativePath));
        return file != null && file.isValid() && !file.isDirectory() ? runInfo : null;
    }

    private static boolean hasNodePrefix(@NotNull String pattern) {
        if (pattern == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(8);
        }
        return pattern.startsWith(PREFIX) && (pattern.length() == PREFIX.length() || pattern.charAt(PREFIX.length()) == ' ');
    }

    public void execute(@NotNull DataContext dataContext, @NotNull RunInfo value) {
        Executor executor;
        ExecutionEnvironmentBuilder builder;
        DataContext updatedDataContext;
        if (dataContext == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(9);
        }
        if (value == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(10);
        }
        if ((updatedDataContext = NodeRunAnythingProvider.createDataContext(dataContext, value)) == null) {
            return;
        }
        Project project = Objects.requireNonNull((Project)CommonDataKeys.PROJECT.getData(updatedDataContext));
        DataProvider extraDataProvider = dataId -> {
            VirtualFile workingDirectory = (VirtualFile)dataContext.getData(CommonDataKeys.VIRTUAL_FILE);
            if (NodeJsRunConfigurationProducerKt.getCONTEXT_INFO().is(dataId)) {
                return new ContextInfo(workingDirectory, value.myAppParams);
            }
            return null;
        };
        Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
        RunnerAndConfigurationSettings settings = NodeRunAnythingProvider.computeWithExtraDataContext(component, extraDataProvider, () -> {
            ConfigurationContext context = ConfigurationContext.getFromContext((DataContext)updatedDataContext);
            NodeJsRunConfigurationProducer producer = (NodeJsRunConfigurationProducer)RunConfigurationProducer.getInstance(NodeJsRunConfigurationProducer.class);
            return NodeRunAnythingProvider.getOrCreate(project, producer, context);
        });
        if (settings != null && (builder = ExecutionEnvironmentBuilder.createOrNull((Executor)(executor = (Executor)ObjectUtils.chooseNotNull((Object)((Executor)updatedDataContext.getData(RunAnythingAction.EXECUTOR_KEY)), (Object)DefaultRunExecutor.getRunExecutorInstance())), (RunnerAndConfigurationSettings)settings)) != null) {
            ExecutionManager.getInstance((Project)project).restartRunProfile(builder.build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static <T> T computeWithExtraDataContext(@Nullable Component component, @NotNull DataProvider extraDataProvider, @NotNull Supplier<T> supplier) {
        JComponent c;
        if (extraDataProvider == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(11);
        }
        if (supplier == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(12);
        }
        if ((c = (JComponent)ObjectUtils.tryCast((Object)component, JComponent.class)) == null) {
            LOG.info("Cannot use data component: " + component);
            return supplier.get();
        }
        DataProvider oldProvider = DataManager.getDataProvider((JComponent)c);
        try {
            DataManager.registerDataProvider((JComponent)c, dataId -> {
                Object data = extraDataProvider.getData(dataId);
                if (data != null) {
                    return data;
                }
                return oldProvider != null ? oldProvider.getData(dataId) : null;
            });
            T t = supplier.get();
            return t;
        }
        finally {
            if (oldProvider != null) {
                DataManager.registerDataProvider((JComponent)c, (DataProvider)oldProvider);
            }
        }
    }

    @Nullable
    private static RunnerAndConfigurationSettings getOrCreate(@NotNull Project project, @NotNull NodeJsRunConfigurationProducer producer, @NotNull ConfigurationContext context) {
        if (project == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(13);
        }
        if (producer == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(14);
        }
        if (context == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(15);
        }
        RunManager runManager = RunManager.getInstance((Project)project);
        RunnerAndConfigurationSettings settings = producer.findExistingConfiguration(context);
        if (settings == null) {
            ConfigurationFromContext configurationFromContext = producer.findOrCreateConfigurationFromContext(context);
            if (configurationFromContext == null) {
                return null;
            }
            settings = configurationFromContext.getConfigurationSettings();
            settings.setTemporary(true);
            runManager.setUniqueNameIfNeeded(settings);
            runManager.addConfiguration(settings);
        }
        runManager.setSelectedConfiguration(settings);
        return settings;
    }

    @Nullable
    private static DataContext createDataContext(@NotNull DataContext parentDataContext, @NotNull RunInfo runInfo) {
        Project project;
        VirtualFile root;
        if (parentDataContext == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(16);
        }
        if (runInfo == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(17);
        }
        VirtualFile virtualFile = root = (project = (Project)CommonDataKeys.PROJECT.getData(parentDataContext)) != null ? ProjectUtil.guessProjectDir((Project)project) : null;
        if (root == null) {
            return null;
        }
        VirtualFile file = root.findFileByRelativePath(FileUtil.toSystemIndependentName((String)runInfo.myRelativePath));
        if (file == null || file.isDirectory() || !file.isValid()) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null || !psiFile.isValid()) {
            return null;
        }
        return SimpleDataContext.getSimpleContext((DataKey)Location.DATA_KEY, (Object)PsiLocation.fromPsiElement((PsiElement)psiFile), (DataContext)parentDataContext);
    }

    @NotNull
    private static List<VirtualFile> listFilesInProject(@NotNull Project project) {
        if (project == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(18);
        }
        GlobalSearchScope contentScope = ProjectScope.getContentScope((Project)project);
        GlobalSearchScope scope = contentScope.intersectWith(GlobalSearchScope.notScope((GlobalSearchScope)ProjectScope.getLibrariesScope((Project)project)));
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        ReadAction.run(() -> {
            for (FileType type : NodeRunConfigurationLocationFilterKt.getAllRegisteredFileTypes()) {
                Collection files = FileTypeIndex.getFiles((FileType)type, (GlobalSearchScope)scope);
                for (VirtualFile file : files) {
                    if (file == null || !file.isValid() || file.isDirectory() || JSLibraryUtil.isProbableLibraryFile((VirtualFile)file)) continue;
                    result.add(file);
                }
            }
        });
        ArrayList<VirtualFile> arrayList = result;
        if (arrayList == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(19);
        }
        return arrayList;
    }

    @NotNull
    public String getCommand(@NotNull RunInfo value) {
        if (value == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(20);
        }
        String string = "node " + FileUtil.toSystemDependentName((String)value.myRelativePath);
        if (string == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(21);
        }
        return string;
    }

    @Nullable
    public String getCompletionGroupTitle() {
        return "Node.js";
    }

    @Nullable
    public String getHelpGroupTitle() {
        return "Node.js";
    }

    @Nullable
    public String getHelpCommand() {
        return "node <script path>";
    }

    @Nullable
    public Icon getHelpIcon() {
        return JavaScriptLanguageIcons.Nodejs.Nodejs;
    }

    @Nullable
    public Icon getIcon(@NotNull RunInfo value) {
        if (value == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(22);
        }
        return JavaScriptLanguageIcons.Nodejs.Nodejs;
    }

    @Nullable
    public RunAnythingHelpItem getHelpItem(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            NodeRunAnythingProvider.$$$reportNull$$$0(23);
        }
        return super.getHelpItem(dataContext);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 1: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/execution/NodeRunAnythingProvider";
                break;
            }
            case 10: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extraDataProvider";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "supplier";
                break;
            }
            case 13: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDataContext";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/execution/NodeRunAnythingProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getValues";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "listFilesInProject";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getValues";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 21: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findMatchingValue";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "hasNodePrefix";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "computeWithExtraDataContext";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreate";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createDataContext";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "listFilesInProject";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getCommand";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getIcon";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getHelpItem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RunInfo {
        private final String myRelativePath;
        private final String myAppParams;

        private RunInfo(@NotNull String relativePath, @Nullable String appParams) {
            if (relativePath == null) {
                RunInfo.$$$reportNull$$$0(0);
            }
            this.myRelativePath = relativePath;
            this.myAppParams = StringUtil.nullize((String)StringUtil.notNullize((String)appParams).trim());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/jetbrains/nodejs/execution/NodeRunAnythingProvider$RunInfo", "<init>"));
        }
    }
}

