/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.rsa;

import a.j.lb;
import java.math.BigInteger;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class RSAEncoder {
    private final BigInteger g;
    private final BigInteger e;
    private final int d;
    private final int a;
    private int c = 0;
    private final BigInteger f;
    private final boolean b;
    private static final long h = lb.a(-4751079297242719652L, 3218930309807367120L, null).a(18439998366520L);

    public RSAEncoder(BigInteger privateExponent, BigInteger privateModulus, int alphabetSize, boolean addDashes) {
        this.g = privateExponent;
        this.e = privateModulus;
        this.b = addDashes;
        int n2 = privateModulus.bitLength();
        this.f = new BigInteger(String.valueOf(alphabetSize));
        int n3 = (int)Math.ceil((double)n2 / Math.log(alphabetSize) * Math.log(2.0));
        if (n3 % 5 != 0) {
            n3 = (n3 / 5 + 1) * 5;
        }
        this.a = n3;
        this.d = n2 / 8 - 1;
    }

    public String encode(byte[] data) {
        byte[] byArray;
        long l2 = h ^ 0x3FF28FFBA31EL;
        long l4 = l2 ^ 0x55A69E190D76L;
        int n2 = data.length % this.d;
        if (n2 == 0) {
            byArray = data;
        } else {
            byArray = new byte[data.length + this.d - n2];
            System.arraycopy(data, 0, byArray, this.d - n2, data.length);
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < byArray.length; i10 += this.d) {
            this.a(byArray, stringBuilder, i10, this.d, l4);
        }
        return stringBuilder.toString();
    }

    private void a(byte[] byArray, StringBuilder stringBuilder, int n2, int n3, long l2) {
        l2 = h ^ l2;
        if (n3 == 0) {
            return;
        }
        byte[] byArray2 = new byte[this.d];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        BigInteger bigInteger = new BigInteger(1, byArray2);
        if (bigInteger.compareTo(this.e) >= 0) {
            throw new IllegalArgumentException("result is too long");
        }
        BigInteger bigInteger2 = bigInteger.modPow(this.g, this.e);
        this.a(stringBuilder, this.a(bigInteger2));
    }

    private void a(StringBuilder stringBuilder, CharSequence charSequence) {
        for (int i10 = 0; i10 < charSequence.length(); ++i10) {
            this.a(stringBuilder);
            stringBuilder.append(charSequence.charAt(i10));
        }
    }

    private CharSequence a(BigInteger bigInteger) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i10 = 0; i10 < this.a; ++i10) {
            stringBuilder.append(RSAEncoder.a(bigInteger.mod(this.f)));
            bigInteger = bigInteger.divide(this.f);
        }
        return new ReverseCharSequence(stringBuilder);
    }

    private void a(StringBuilder stringBuilder) {
        if (this.c > 0 && this.c % 5 == 0) {
            if (this.c % 30 == 0) {
                stringBuilder.append('\n');
            } else if (this.b) {
                stringBuilder.append('-');
            }
        }
        ++this.c;
    }

    private static char a(BigInteger bigInteger) {
        int n2 = bigInteger.intValue();
        char c10 = n2 < 10 ? (char)(48 + n2) : (n2 < 36 ? (char)(65 + n2 - 10) : (n2 < 62 ? (char)(97 + n2 - 36) : (char)(33 + n2 - 62)));
        return c10;
    }

    private static class ReverseCharSequence
    implements CharSequence {
        private final CharSequence a;

        public ReverseCharSequence(CharSequence sequence) {
            this.a = sequence;
        }

        public int length() {
            return this.a.length();
        }

        public char charAt(int index) {
            return this.a.charAt(this.a.length() - index - 1);
        }

        public CharSequence subSequence(int start2, int end) {
            int n2 = this.a.length();
            return new ReverseCharSequence(this.a.subSequence(n2 - end, n2 - start2));
        }
    }
}

