/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui.download;

import a.j.lb;
import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.download.DownloadableFileSetVersions;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ui.download.AdditionalDownloadableLibraryProvider;
import com.intellij.webcore.libraries.ui.download.DefaultDownloadableWebLibrariesSource;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import com.intellij.webcore.libraries.ui.download.DownloadableWebLibrariesSource;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.lang.invoke.MethodHandles;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DownloadWebLibraryDialog
extends DialogWrapper {
    private JPanel a;
    private JBTable d;
    private JLabel c;
    private DownloadableFileSetDescriptionWithUrl b;
    private static final long e = lb.a(-3270475679910691058L, -2272177550787000957L, MethodHandles.lookup().lookupClass()).a(6286439765770L);

    public DownloadWebLibraryDialog(@NotNull Project project, LangScriptingContextProvider provider) {
        long l2 = e ^ 0x183407DBD97BL;
        if (project == null) {
            DownloadWebLibraryDialog.a(0);
        }
        super(project);
        Object[] objectArray = new Object[]{};
        this.a();
        this.setTitle(WebCoreBundle.message((String)"library.download.dialog.title", (Object[])objectArray));
        this.setOKButtonText(WebCoreBundle.message((String)"library.download.dialog.ok.text", (Object[])new Object[0]));
        this.setCancelButtonText(WebCoreBundle.message((String)"library.download.dialog.cancel.text", (Object[])new Object[0]));
        this.setOKActionEnabled(false);
        this.d.setSelectionMode(0);
        DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource> defaultComboBoxModel = new DefaultComboBoxModel<DefaultDownloadableWebLibrariesSource>();
        defaultComboBoxModel.addElement(new DefaultDownloadableWebLibrariesSource(project, provider));
        DownloadableWebLibrariesSource downloadableWebLibrariesSource = AdditionalDownloadableLibraryProvider.getLibrary(project);
        if (downloadableWebLibrariesSource != null) {
            this.c.setText(downloadableWebLibrariesSource.getName());
            this.a(project, downloadableWebLibrariesSource, provider);
        }
        this.init();
        TableColumnModel tableColumnModel = this.d.getColumnModel();
        int[] nArray = new int[]{100, 20, 300};
        for (int i10 = 0; i10 < tableColumnModel.getColumnCount(); ++i10) {
            tableColumnModel.getColumn(i10).setPreferredWidth(nArray[i10]);
        }
        new TableSpeedSearch((JTable)this.d).setComparator(new SpeedSearchComparator(true));
        this.d.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                TableModel tableModel = DownloadWebLibraryDialog.this.d.getModel();
                if (tableModel instanceof MyLibraryTableModel) {
                    DownloadWebLibraryDialog.this.setOKActionEnabled(true);
                    DownloadWebLibraryDialog.this.b = ((MyLibraryTableModel)tableModel).getDescriptionAt(DownloadWebLibraryDialog.this.d.getSelectedRow());
                }
            }
        });
    }

    private void a(final @NotNull Project project, final @NotNull DownloadableWebLibrariesSource downloadableWebLibrariesSource, final @NotNull LangScriptingContextProvider langScriptingContextProvider) {
        long l2 = e ^ 0xE6F0E3B957CL;
        if (project == null) {
            DownloadWebLibraryDialog.a(1);
        }
        if (downloadableWebLibrariesSource == null) {
            DownloadWebLibraryDialog.a(2);
        }
        if (langScriptingContextProvider == null) {
            DownloadWebLibraryDialog.a(3);
        }
        final DefaultTableModel defaultTableModel = new DefaultTableModel(new Object[]{WebCoreBundle.message((String)"library.download.dialog.fetching.text", (Object[])new Object[0])}, 1){

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.setOKActionEnabled(false);
        this.d.setModel((TableModel)defaultTableModel);
        defaultTableModel.setRowCount(15);
        ApplicationManager.getApplication().executeOnPooledThread(() -> downloadableWebLibrariesSource.prepareTableModel(new DownloadableFileSetVersions.FileSetVersionsCallback<DownloadableFileSetDescriptionWithUrl>(){
            private static final long a = lb.a(-981289869265613434L, -1096785672174449535L, MethodHandles.lookup().lookupClass()).a(127863448941451L);

            public void onSuccess(@NotNull List<? extends DownloadableFileSetDescriptionWithUrl> versions) {
                if (versions == null) {
                    3.a(0);
                }
                if (versions.size() > 0) {
                    langScriptingContextProvider.filterExistingLibraries(project, versions);
                    ApplicationManager.getApplication().invokeLater(() -> DownloadWebLibraryDialog.this.d.setModel((TableModel)new MyLibraryTableModel(versions, downloadableWebLibrariesSource.includeVersionColumn())), ModalityState.any());
                }
            }

            public void onError(@NotNull String errorMessage) {
                if (errorMessage == null) {
                    3.a(1);
                }
                ApplicationManager.getApplication().invokeLater(() -> defaultTableModel.setColumnIdentifiers(new Object[]{"Error while fetching list of libraries: " + errorMessage}), ModalityState.any());
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                long l2 = a ^ 0x66F1E06F5141L;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "versions";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorMessage";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog$3";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onSuccess";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onError";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        }));
    }

    @Nullable
    protected String getHelpId() {
        long l2 = e ^ 0x23CF1AC17A4EL;
        return "JavaScript.Libraries";
    }

    protected JComponent createCenterPanel() {
        return this.a;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.a;
    }

    @Nullable
    public DownloadableFileSetDescriptionWithUrl getSelection() {
        return this.b;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = e ^ 0x2817BE61DBC9L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesSource";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
        }
        objectArray2[1] = "com/intellij/webcore/libraries/ui/download/DownloadWebLibraryDialog";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "populate";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private /* synthetic */ void a() {
        JLabel jLabel;
        JBTable jBTable;
        JPanel jPanel;
        long l2 = e ^ 0x120DDD217BB7L;
        this.a = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel2.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.d = jBTable = new JBTable();
        jBTable.setAutoResizeMode(2);
        jBTable.setStriped(true);
        jBScrollPane.setViewportView((Component)jBTable);
        this.c = jLabel = new JLabel();
        this.a(jLabel, DynamicBundle.getBundle((String)"messages/WebCoreBundle", DownloadWebLibraryDialog.class).getString("library.download.no_libraries_available.text"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.a;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c10);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private static class MyLibraryTableModel
    extends AbstractTableModel {
        private final int a;
        private final int b;
        private final int c;
        private final List<? extends DownloadableFileSetDescriptionWithUrl> e;
        private final boolean d;
        private static final long f = lb.a(-5592633385962350567L, 6108162237944728546L, MethodHandles.lookup().lookupClass()).a(109316691045076L);

        MyLibraryTableModel(List<? extends DownloadableFileSetDescriptionWithUrl> descriptions, boolean includeVersionColumn) {
            this.e = descriptions;
            this.d = includeVersionColumn;
            this.a = 0;
            this.b = this.d ? 1 : -1;
            this.c = this.d ? 2 : 1;
            this.e.sort((downloadableFileSetDescription, downloadableFileSetDescription2) -> {
                if (downloadableFileSetDescription.getName().equals(downloadableFileSetDescription2.getName())) {
                    return downloadableFileSetDescription.getVersionString().compareTo(downloadableFileSetDescription2.getVersionString());
                }
                return downloadableFileSetDescription.getName().compareToIgnoreCase(downloadableFileSetDescription2.getName());
            });
        }

        @Override
        public int getRowCount() {
            return this.e.size();
        }

        @Override
        public int getColumnCount() {
            return this.d ? 3 : 2;
        }

        @Override
        @Nullable
        public Object getValueAt(int rowIndex, int columnIndex) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = this.e.get(rowIndex);
            if (columnIndex == this.a) {
                return downloadableFileSetDescriptionWithUrl.getName();
            }
            if (columnIndex == this.b) {
                return downloadableFileSetDescriptionWithUrl.getVersionString();
            }
            if (columnIndex == this.c) {
                return downloadableFileSetDescriptionWithUrl.getUrl();
            }
            return null;
        }

        @Override
        @Nullable
        public String getColumnName(int column) {
            long l2 = f ^ 0x2F54CF0F335BL;
            if (column == this.a) {
                return WebCoreBundle.message((String)"library.download.dialog.table.name_column.label", (Object[])new Object[0]);
            }
            if (column == this.b) {
                return WebCoreBundle.message((String)"library.download.dialog.table.version_column.label", (Object[])new Object[0]);
            }
            if (column == this.c) {
                return WebCoreBundle.message((String)"library.download.dialog.table.url_column.label", (Object[])new Object[0]);
            }
            return "";
        }

        @Nullable
        public DownloadableFileSetDescriptionWithUrl getDescriptionAt(int rowIndex) {
            if (rowIndex < 0 || rowIndex >= this.e.size()) {
                return null;
            }
            return this.e.get(rowIndex);
        }
    }
}

