/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import a.j.lb;
import com.intellij.DynamicBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.intellij.webcore.ModuleHelper;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ui.EditLibraryDialog;
import com.intellij.webcore.libraries.ui.ModuleScopeSelectionDialog;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxEditor;
import com.intellij.webcore.libraries.ui.PartlySelectedCheckBoxRenderer;
import com.intellij.webcore.libraries.ui.PerFileMappingsDialogWrapper;
import com.intellij.webcore.libraries.ui.ScriptingContextsConfigurable;
import com.intellij.webcore.libraries.ui.ScriptingLibraryTableModel;
import com.intellij.webcore.libraries.ui.download.DownloadWebLibraryDialog;
import com.intellij.webcore.libraries.ui.download.DownloadableFileSetDescriptionWithUrl;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class ScriptingLibrariesPanel {
    private JPanel n;
    private JButton c;
    private JButton a;
    private JButton l;
    private JPanel f;
    private JBTable b;
    private JButton k;
    private JButton i;
    private boolean m;
    private final Project g;
    private final LangScriptingContextProvider d;
    private final ScriptingLibraryManager j;
    private final ScriptingLibraryMappings h;
    private final ScriptingLibraryTableModel e;
    private static final long o = lb.a(4388802028397754159L, -7064820011026264321L, MethodHandles.lookup().lookupClass()).a(214396913365588L);

    public ScriptingLibrariesPanel(@NotNull LangScriptingContextProvider provider, @NotNull Project project, @NotNull ScriptingLibraryManager libraryManager) {
        long l2 = o ^ 0x4FC2E99D5ECCL;
        if (provider == null) {
            ScriptingLibrariesPanel.a(0);
        }
        if (project == null) {
            ScriptingLibrariesPanel.a(1);
        }
        if (libraryManager == null) {
            ScriptingLibrariesPanel.a(2);
        }
        this.m = false;
        this.g = project;
        this.d = provider;
        this.b();
        this.h = provider.getLibraryMappings(project);
        this.j = libraryManager;
        this.b.setShowGrid(false);
        this.e = new ScriptingLibraryTableModel(libraryManager, this.h);
        this.b.setModel((TableModel)this.e);
        this.b.setRowHeight((int)((double)this.b.getRowHeight() * 1.2));
        JTableHeader jTableHeader = this.b.getTableHeader();
        jTableHeader.setReorderingAllowed(false);
        TableColumn tableColumn = this.b.getColumnModel().getColumn(0);
        ScriptingLibrariesPanel.setColumnWidth(tableColumn, ScriptingLibrariesPanel.a(jTableHeader, tableColumn));
        tableColumn.setCellRenderer(new PartlySelectedCheckBoxRenderer());
        tableColumn.setCellEditor(new PartlySelectedCheckBoxEditor(this));
        this.b.getColumnModel().getColumn(1).setCellRenderer(new LibraryNameCellRenderer());
        SwingHelper.setNoBorderCellRendererFor((TableColumn)this.b.getColumnModel().getColumn(1));
        int n2 = this.b.getFontMetrics(this.b.getFont()).stringWidth(ScriptingLibraryTableModel.getLongestLibraryLevelName()) + JBUIScale.scale((int)10);
        ScriptingLibrariesPanel.setColumnWidth(this.b.getColumnModel().getColumn(2), n2);
        this.b.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyTyped(KeyEvent e10) {
                if (e10.getKeyChar() == ' ') {
                    int[] nArray = ScriptingLibrariesPanel.this.b.getSelectedRows();
                    boolean bl2 = true;
                    for (int n2 : nArray) {
                        if (ScriptingLibraryTableModel.EnabledState.ON == ScriptingLibrariesPanel.this.e.getValueAt(n2, 0)) continue;
                        bl2 = false;
                    }
                    for (int n2 : nArray) {
                        if (!bl2 && ScriptingLibraryTableModel.EnabledState.ON != ScriptingLibrariesPanel.this.e.getValueAt(n2, 0)) {
                            ScriptingLibrariesPanel.this.e.setValueAt(Boolean.TRUE, n2, 0);
                            continue;
                        }
                        if (!bl2) continue;
                        ScriptingLibrariesPanel.this.e.setValueAt(Boolean.FALSE, n2, 0);
                    }
                }
            }
        });
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                ScriptingLibrariesPanel.this.a(ScriptingLibrariesPanel.this.getPanel());
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                ScriptingLibrariesPanel.this.e();
            }
        });
        this.f.setBorder((Border)IdeBorderFactory.createTitledBorder((String)WebCoreBundle.message((String)"library.table.border.title", (Object[])new Object[0]), (boolean)false, (Insets)JBUI.insetsTop((int)8)).setShowLine(false));
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                ScriptingLibraryModel scriptingLibraryModel = ScriptingLibrariesPanel.this.a();
                if (scriptingLibraryModel != null) {
                    ScriptingLibrariesPanel.this.selectLibrary(scriptingLibraryModel.getName());
                }
            }
        });
        this.a.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                int[] nArray = ScriptingLibrariesPanel.this.b.getSelectedRows();
                ArrayList<ScriptingLibraryModel> arrayList = new ArrayList<ScriptingLibraryModel>();
                for (int n2 : nArray) {
                    ScriptingLibraryModel scriptingLibraryModel = ScriptingLibrariesPanel.this.e.getLibraryAt(n2);
                    if (scriptingLibraryModel == null || scriptingLibraryModel.isPredefined()) continue;
                    arrayList.add(scriptingLibraryModel);
                }
                Object object = arrayList.iterator();
                while (object.hasNext()) {
                    ScriptingLibraryModel scriptingLibraryModel = (ScriptingLibraryModel)object.next();
                    ScriptingLibrariesPanel.this.b(scriptingLibraryModel.getName());
                }
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                String string = ScriptingLibrariesPanel.this.e.getLibNameAt(ScriptingLibrariesPanel.this.b.getSelectedRow());
                ScriptingLibrariesPanel.this.a(string);
            }
        });
        this.a.setEnabled(false);
        this.l.setEnabled(false);
        this.b.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e10) {
                ScriptingLibrariesPanel.this.c();
            }
        });
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e10) {
                ScriptingLibraryModel scriptingLibraryModel;
                int n2;
                if (e10.getClickCount() == 2 && (n2 = ScriptingLibrariesPanel.this.b.getSelectedRow()) != -1 && (scriptingLibraryModel = ScriptingLibrariesPanel.this.e.getLibraryAt(ScriptingLibrariesPanel.this.b.getSelectedRow())) != null && !scriptingLibraryModel.isPredefined()) {
                    ScriptingLibrariesPanel.this.a(scriptingLibraryModel.getName());
                }
            }
        });
    }

    private static int a(@NotNull JTableHeader jTableHeader, @NotNull TableColumn tableColumn) {
        TableCellRenderer tableCellRenderer;
        if (jTableHeader == null) {
            ScriptingLibrariesPanel.a(3);
        }
        if (tableColumn == null) {
            ScriptingLibrariesPanel.a(4);
        }
        if ((tableCellRenderer = tableColumn.getHeaderRenderer()) == null) {
            tableCellRenderer = jTableHeader.getDefaultRenderer();
        }
        Component component2 = tableCellRenderer.getTableCellRendererComponent(jTableHeader.getTable(), tableColumn.getHeaderValue(), false, false, -1, tableColumn.getModelIndex());
        int n2 = component2.getPreferredSize().width;
        if (component2 instanceof JComponent) {
            Insets insets = ((JComponent)component2).getInsets();
            n2 += Math.max(0, insets.left - insets.right);
        }
        return n2;
    }

    static void setColumnWidth(@NotNull TableColumn column, int width) {
        if (column == null) {
            ScriptingLibrariesPanel.a(5);
        }
        column.setPreferredWidth(width);
        column.setMaxWidth(width);
    }

    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.n;
        if (jPanel == null) {
            ScriptingLibrariesPanel.a(6);
        }
        return jPanel;
    }

    private void b(String string) {
        ApplicationManager.getApplication().runWriteAction(() -> this.e.removeLibrary(string));
    }

    private ScriptingLibraryModel a() {
        long l2 = o ^ 0x4733F7E13A06L;
        EditLibraryDialog editLibraryDialog = new EditLibraryDialog(WebCoreBundle.message((String)"library.table.new.dialog.title", (Object[])new Object[0]), this.d, this.g);
        if (editLibraryDialog.showAndGet()) {
            ScriptingLibraryModel scriptingLibraryModel = this.e.createLibrary(editLibraryDialog.getLibName(), VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, editLibraryDialog.getDocUrls(), editLibraryDialog.getLibraryLevel(), false);
            scriptingLibraryModel.setSourceFileUrls(editLibraryDialog.getSourceFileUrls());
            scriptingLibraryModel.setCompactFileUrls(editLibraryDialog.getCompactFileUrls());
            scriptingLibraryModel.setFrameworkDescriptor(editLibraryDialog.getSelectedFramework());
            return scriptingLibraryModel;
        }
        return null;
    }

    private void c() {
        int[] nArray;
        boolean bl2;
        int n2 = this.b.getSelectedRowCount();
        boolean bl3 = bl2 = n2 == 1;
        if (bl2) {
            ScriptingLibraryModel scriptingLibraryModel = this.e.getLibraryAt(this.b.getSelectedRow());
            bl2 = scriptingLibraryModel != null && !scriptingLibraryModel.isPredefined();
        }
        this.l.setEnabled(bl2);
        boolean bl4 = n2 > 0;
        for (int n3 : nArray = this.b.getSelectedRows()) {
            ScriptingLibraryModel scriptingLibraryModel = this.e.getLibraryAt(n3);
            if (scriptingLibraryModel == null || !scriptingLibraryModel.isPredefined()) continue;
            bl4 = false;
            break;
        }
        this.a.setEnabled(bl4);
    }

    private void a(String string) {
        ScriptingLibraryModel scriptingLibraryModel;
        EditLibraryDialog editLibraryDialog;
        long l2 = o ^ 0x36534746F80DL;
        if (string == null) {
            return;
        }
        ScriptingLibraryModel scriptingLibraryModel2 = this.e.getLibrary(string);
        if (scriptingLibraryModel2 != null && (editLibraryDialog = new EditLibraryDialog(WebCoreBundle.message((String)"library.table.edit.dialog.title", (Object[])new Object[0]), this.d, this.g, scriptingLibraryModel2)).showAndGet() && (scriptingLibraryModel = this.e.updateLibrary(string, editLibraryDialog.getLibName(), VirtualFile.EMPTY_ARRAY, VirtualFile.EMPTY_ARRAY, editLibraryDialog.getDocUrls())) != null) {
            scriptingLibraryModel.setSourceFileUrls(editLibraryDialog.getSourceFileUrls());
            scriptingLibraryModel.setCompactFileUrls(editLibraryDialog.getCompactFileUrls());
            scriptingLibraryModel.setFrameworkDescriptor(editLibraryDialog.getSelectedFramework());
            scriptingLibraryModel.setLibraryLevel(editLibraryDialog.getLibraryLevel());
        }
    }

    public boolean isModified() {
        return this.e.isChanged() || this.m;
    }

    public void resetTable() {
        this.e.resetTable();
        this.m = false;
    }

    public void apply() {
        this.h.updateAssociations(() -> this.a());
    }

    private void a() {
        this.e.applyChanges();
        Map map2 = this.h.getMappings();
        for (ScriptingLibraryModel scriptingLibraryModel : map2.values()) {
            if (!(scriptingLibraryModel instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ((ScriptingLibraryMappings.CompoundLibrary)scriptingLibraryModel).applyChanges();
        }
    }

    private void a(@NotNull Component component2) {
        DownloadWebLibraryDialog downloadWebLibraryDialog;
        if (component2 == null) {
            ScriptingLibrariesPanel.a(7);
        }
        if ((downloadWebLibraryDialog = new DownloadWebLibraryDialog(this.g, this.d)).showAndGet()) {
            DownloadableFileSetDescriptionWithUrl downloadableFileSetDescriptionWithUrl = downloadWebLibraryDialog.getSelection();
            if (downloadableFileSetDescriptionWithUrl == null) {
                return;
            }
            if (this.isModified()) {
                WriteAction.run(() -> {
                    this.apply();
                    this.j.commitChanges();
                });
            }
            downloadableFileSetDescriptionWithUrl.downloadLibrary(this.g, this.d, component2, () -> this.a((DownloadableFileSetDescription)downloadableFileSetDescriptionWithUrl));
        }
    }

    private void a(DownloadableFileSetDescription downloadableFileSetDescription) {
        this.e.fireLibTableChanged(true);
        String string = LangScriptingContextProvider.getIdeLibraryName(downloadableFileSetDescription);
        this.selectLibrary(string);
        if (ModuleHelper.getModules((Project)this.g).length > 1) {
            this.configureModules();
        }
    }

    protected void selectLibrary(String libName) {
        int n2 = this.e.getLibraryIndex(libName);
        if (n2 >= 0) {
            this.b.getSelectionModel().setSelectionInterval(n2, n2);
        }
    }

    private void e() {
        long l2 = o ^ 0x5B72E02305DAL;
        this.e.applyMappings();
        ScriptingContextsConfigurable scriptingContextsConfigurable = new ScriptingContextsConfigurable(this.g, this.h);
        PerFileMappingsDialogWrapper perFileMappingsDialogWrapper = new PerFileMappingsDialogWrapper(this.getPanel(), scriptingContextsConfigurable);
        perFileMappingsDialogWrapper.setTitle(WebCoreBundle.message((String)"library.usage_scope.dialog.title", (Object[])new Object[]{this.d.getLanguage().getDisplayName()}));
        if (perFileMappingsDialogWrapper.showAndGet() && scriptingContextsConfigurable.isModified()) {
            this.m = true;
            this.e.fireLibTableChanged(false);
        }
    }

    int configureModules() {
        String string;
        ScriptingLibraryModel scriptingLibraryModel;
        if (ModuleHelper.getModules((Project)this.g).length == 1) {
            return -1;
        }
        int n2 = this.b.getSelectedRow();
        if (n2 >= 0 && (scriptingLibraryModel = this.j.getLibraryByName(string = this.e.getLibNameAt(n2))) != null) {
            if (scriptingLibraryModel.isPredefined()) {
                return -1;
            }
            ModuleScopeSelectionDialog moduleScopeSelectionDialog = new ModuleScopeSelectionDialog(this.g, scriptingLibraryModel.getAssociatedModules(), null, scriptingLibraryModel.getName());
            if (moduleScopeSelectionDialog.showAndGet()) {
                Set<Module> set = moduleScopeSelectionDialog.getSelectedModules();
                if (!scriptingLibraryModel.getAssociatedModules().equals(set)) {
                    scriptingLibraryModel.setAssociatedModules(set);
                    this.h.updateMappings();
                    this.m = true;
                }
                return set.size();
            }
            return scriptingLibraryModel.getAssociatedModules().size();
        }
        return -1;
    }

    private static boolean a(@Nullable ScriptingLibraryModel scriptingLibraryModel) {
        if (scriptingLibraryModel == null) {
            return false;
        }
        return scriptingLibraryModel.getSourceFilePointers().stream().allMatch(virtualFilePointer -> virtualFilePointer.getFile() != null) && scriptingLibraryModel.getCompactFilePointers().stream().allMatch(virtualFilePointer -> virtualFilePointer.getFile() != null);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = o ^ 0x1E33AADC6391L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryManager";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableHeader";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "column";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationAreaComponent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/ScriptingLibrariesPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getMinimumWidthToFitColumnTitle";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setColumnWidth";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "showDownloadDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void b() {
        JButton jButton;
        JButton jButton2;
        JButton jButton3;
        JButton jButton4;
        JButton jButton5;
        JBTable jBTable;
        JPanel jPanel;
        JPanel jPanel2;
        long l2 = o ^ 0x677DF5243444L;
        this.n = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.f = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(7, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel2.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 7, 1, 0, 3, 7, 7, null, null, null));
        this.b = jBTable = new JBTable();
        jBTable.setShowHorizontalLines(false);
        jBTable.setShowVerticalLines(false);
        jBTable.setStriped(false);
        jBScrollPane.setViewportView((Component)jBTable);
        this.c = jButton5 = new JButton();
        this.a(jButton5, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("scripting.lib.add"));
        jPanel.add((Component)jButton5, new GridConstraints(0, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.a = jButton4 = new JButton();
        this.a(jButton4, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("scripting.lib.remove"));
        jPanel.add((Component)jButton4, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.l = jButton3 = new JButton();
        this.a(jButton3, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("scripting.lib.edit"));
        jPanel.add((Component)jButton3, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.k = jButton2 = new JButton();
        this.a(jButton2, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("library.action.download.name"));
        jButton2.setToolTipText(ResourceBundle.getBundle("messages/WebCoreBundle").getString("library.action.download.tooltip"));
        jPanel.add((Component)jButton2, new GridConstraints(3, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        this.i = jButton = new JButton();
        this.a(jButton, DynamicBundle.getBundle((String)"messages/WebCoreBundle", ScriptingLibrariesPanel.class).getString("library.action.manage_scopes.name"));
        jPanel.add((Component)jButton, new GridConstraints(5, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 0, null, new Dimension(-1, 10), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.n;
    }

    private /* synthetic */ void a(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c10 = '\u0000';
        int n2 = -1;
        for (int i10 = 0; i10 < string.length(); ++i10) {
            if (string.charAt(i10) == '&') {
                if (++i10 == string.length()) break;
                if (!bl2 && string.charAt(i10) != '&') {
                    bl2 = true;
                    c10 = string.charAt(i10);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i10));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl2) {
            abstractButton.setMnemonic(c10);
            abstractButton.setDisplayedMnemonicIndex(n2);
        }
    }

    private class LibraryNameCellRenderer
    extends DefaultTableCellRenderer {
        private LibraryNameCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            ScriptingLibraryModel scriptingLibraryModel;
            boolean bl2;
            this.setForeground(null);
            Component component2 = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (row >= 0 && row < ScriptingLibrariesPanel.this.e.getRowCount() && !(bl2 = ScriptingLibrariesPanel.a(scriptingLibraryModel = ScriptingLibrariesPanel.this.e.getLibraryAt(row))) && !isSelected) {
                this.setForeground((Color)JBColor.red);
            }
            return component2;
        }
    }
}

