/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import a.j.lb;
import com.intellij.formatting.FormatterTagHandler;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LineCommentLineDataBuilder
extends CommentLineDataBuilder {
    private final PsiComment b;
    private final IElementType g;
    private static final String d = "//";
    private TextRange h;
    private final CommonCodeStyleSettings.IndentOptions f;
    @Nullable
    private final TextRange e;
    private int c;
    private static final long j = lb.a(-6645975518014679924L, -2898651284959315663L, MethodHandles.lookup().lookupClass()).a(18158282570134L);

    public LineCommentLineDataBuilder(@NotNull PsiComment comment, IElementType lineCommentType, @NotNull CommonCodeStyleSettings settings, @Nullable TextRange enabledRange) {
        if (comment == null) {
            LineCommentLineDataBuilder.a(0);
        }
        if (settings == null) {
            LineCommentLineDataBuilder.a(1);
        }
        super(settings.getRootSettings());
        this.b = comment;
        this.g = lineCommentType;
        this.f = settings.getIndentOptions() != null ? settings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
        this.e = enabledRange;
    }

    public boolean canMerge(@NotNull PsiComment comment) {
        if (comment == null) {
            LineCommentLineDataBuilder.a(2);
        }
        return this.getFormatterTag(comment) == FormatterTagHandler.FormatterTag.NONE;
    }

    public boolean isMergedWithPrevious(@NotNull PsiComment comment) {
        if (comment == null) {
            LineCommentLineDataBuilder.a(3);
        }
        if (this.isAfterNonEmptyLine(comment.getNode())) {
            return false;
        }
        PsiElement psiElement = comment.getPrevSibling();
        if (psiElement instanceof PsiWhiteSpace) {
            PsiElement psiElement2 = psiElement;
            if ((psiElement = psiElement.getPrevSibling()) != null && psiElement.getNode().getElementType() == this.g && LineCommentLineDataBuilder.countLineBreaks(psiElement2.getNode()) == 1) {
                int n2;
                if (this.e != null && psiElement.getTextRange().getEndOffset() < this.e.getStartOffset() || psiElement instanceof PsiComment && this.getFormatterTag((PsiComment)psiElement) != FormatterTagHandler.FormatterTag.NONE) {
                    return false;
                }
                int n3 = this.calcBlockLineIndent(comment.getNode());
                return n3 == (n2 = this.calcBlockLineIndent(psiElement.getNode()));
            }
        }
        return false;
    }

    @Override
    public List<CommentLineData> getLines() {
        ArrayList<CommentLineData> arrayList = new ArrayList<CommentLineData>();
        int n2 = this.b.getTextRange().getStartOffset();
        int n3 = this.b.getTextRange().getEndOffset();
        int n4 = this.calcBlockLineIndent(this.b.getNode());
        this.a(arrayList, (PsiElement)this.b, n4, true);
        for (PsiElement psiElement = this.b.getNextSibling(); psiElement != null && (this.e == null || psiElement.getTextRange().getStartOffset() <= this.e.getEndOffset()); psiElement = psiElement.getNextSibling()) {
            if (psiElement.getNode().getElementType() == this.g) {
                int n5;
                if (psiElement instanceof PsiComment && this.getFormatterTag((PsiComment)psiElement) != FormatterTagHandler.FormatterTag.NONE || (n5 = this.calcBlockLineIndent(psiElement.getNode())) != n4) break;
                n3 = psiElement.getTextRange().getEndOffset();
                this.a(arrayList, psiElement, n4, false);
                continue;
            }
            if (!(psiElement instanceof PsiWhiteSpace) || LineCommentLineDataBuilder.countLineBreaks(psiElement.getNode()) > 1) break;
        }
        this.h = new TextRange(n2, n3);
        return arrayList;
    }

    public TextRange getCommentBlockRange() {
        return this.h;
    }

    private void a(List<CommentLineData> list2, @NotNull PsiElement psiElement, int n2, boolean bl2) {
        if (psiElement == null) {
            LineCommentLineDataBuilder.a(4);
        }
        String string = new String(CharArrayUtil.fromSequence((CharSequence)psiElement.getNode().getChars()));
        LineCommentLineData lineCommentLineData = (LineCommentLineData)this.parseLine(string);
        lineCommentLineData.b = n2;
        lineCommentLineData.c = bl2;
        list2.add(lineCommentLineData);
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String line) {
        int n2;
        long l2 = j ^ 0x8D9B67272AFL;
        if (line == null) {
            LineCommentLineDataBuilder.a(5);
        }
        LineCommentLineData lineCommentLineData = new LineCommentLineData(line);
        lineCommentLineData.commentOffset = LineCommentLineDataBuilder.nextNonWhitespace(line, 0);
        if (lineCommentLineData.commentOffset >= 0 && (n2 = lineCommentLineData.commentOffset + d.length()) < line.length()) {
            lineCommentLineData.textStartOffset = LineCommentLineDataBuilder.nextNonWhitespace(line, n2);
        }
        LineCommentLineData lineCommentLineData2 = lineCommentLineData;
        if (lineCommentLineData2 == null) {
            LineCommentLineDataBuilder.a(6);
        }
        return lineCommentLineData2;
    }

    public boolean isAfterNonEmptyLine(@NotNull ASTNode node2) {
        ASTNode aSTNode;
        if (node2 == null) {
            LineCommentLineDataBuilder.a(7);
        }
        if (node2.getElementType() == this.g && (aSTNode = node2.getTreePrev()) != null) {
            return !(aSTNode.getPsi() instanceof PsiWhiteSpace) || !aSTNode.textContains('\n');
        }
        return false;
    }

    public static int countLineBreaks(@NotNull ASTNode node2) {
        if (node2 == null) {
            LineCommentLineDataBuilder.a(8);
        }
        CharSequence charSequence = node2.getChars();
        int n2 = 0;
        for (int i10 = 0; i10 < charSequence.length(); ++i10) {
            if (charSequence.charAt(i10) != '\n') continue;
            ++n2;
        }
        return n2;
    }

    public int calcBlockLineIndent(@NotNull ASTNode node2) {
        ASTNode aSTNode;
        long l2 = j ^ 0x1B32F13A46B1L;
        if (node2 == null) {
            LineCommentLineDataBuilder.a(9);
        }
        int n2 = 0;
        for (aSTNode = node2.getTreePrev(); aSTNode != null && !aSTNode.textContains('\n'); aSTNode = aSTNode.getTreePrev()) {
            n2 += aSTNode.getTextLength();
        }
        if (aSTNode != null) {
            int n3 = 0;
            CharSequence charSequence = aSTNode.getChars();
            int n4 = CharArrayUtil.shiftBackwardUntil((CharSequence)charSequence, (int)(aSTNode.getTextLength() - 1), (String)"\r\n");
            if (n4 >= 0) {
                n3 += aSTNode.getTextLength() - n4 - 1;
            }
            char[] cArray = CharArrayUtil.fromSequence((CharSequence)charSequence, (int)(aSTNode.getTextLength() - n3), (int)aSTNode.getTextLength());
            this.c = 0;
            boolean bl2 = cArray.length > 0 && cArray[0] == '\t';
            for (char c10 : cArray) {
                if (c10 == '\t' && bl2) {
                    n2 += this.f.TAB_SIZE;
                    ++this.c;
                    continue;
                }
                bl2 = false;
                ++n2;
            }
        }
        return n2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = j ^ 0x371418842627L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "canMerge";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isMergedWithPrevious";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addLineDataFromComment";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isAfterNonEmptyLine";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "countLineBreaks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "calcBlockLineIndent";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class LineCommentLineData
    extends CommentLineData {
        private int b;
        private boolean c;
        private static final long e = lb.a(-8674918469881578402L, 6855938883232872029L, MethodHandles.lookup().lookupClass()).a(266735575387511L);

        LineCommentLineData(String line) {
            if (line == null) {
                LineCommentLineData.b(0);
            }
            super(line);
        }

        @Override
        public int getLineLength() {
            return this.b + super.getLineLength();
        }

        @Override
        protected int calcWrapPos(int rightMargin) {
            if (this.b < rightMargin) {
                return super.calcWrapPos(rightMargin - this.b);
            }
            return -1;
        }

        public String getIndentString() {
            if (!LineCommentLineDataBuilder.this.f.USE_TAB_CHARACTER) {
                return StringUtil.repeatSymbol((char)' ', (int)this.b);
            }
            int n2 = LineCommentLineDataBuilder.this.f.SMART_TABS ? LineCommentLineDataBuilder.this.c : (LineCommentLineDataBuilder.this.f.TAB_SIZE > 0 ? this.b / LineCommentLineDataBuilder.this.f.TAB_SIZE : 0);
            int n3 = this.b - n2 * LineCommentLineDataBuilder.this.f.TAB_SIZE;
            return StringUtil.repeatSymbol((char)'\t', (int)n2) + StringUtil.repeatSymbol((char)' ', (int)n3);
        }

        @Override
        @Nullable
        public Pair<String, String> splitLine(int rightMargin) {
            Pair<String, String> pair = super.splitLine(rightMargin);
            if (pair != null && !this.c && this.b > 0) {
                return Pair.create((Object)(this.getIndentString() + (String)pair.first), (Object)((String)pair.second));
            }
            return pair;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            String string = (this.b > 0 ? this.getIndentString() : this.line.substring(0, this.commentOffset)) + LineCommentLineDataBuilder.d;
            if (string == null) {
                LineCommentLineData.b(1);
            }
            return string;
        }

        @Override
        protected int getTabSize() {
            return LineCommentLineDataBuilder.this.f.TAB_SIZE;
        }

        @Override
        @NotNull
        public String getLine() {
            Object object = this.b > 0 && !this.c ? this.getIndentString() + this.line : this.line;
            if (object == null) {
                LineCommentLineData.b(2);
            }
            return object;
        }

        @Override
        public boolean canBeMergedWithPrevious() {
            return true;
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = e ^ 0x1CCB92F6C3CFL;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/formatter/comments/LineCommentLineDataBuilder$LineCommentLineData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinePrefix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLine";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

