/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.structuralsearch.plugin.ui;

import a.j.lb;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.impl.TemplateEditorUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.structuralsearch.MatchOptions;
import com.intellij.structuralsearch.MatchVariableConstraint;
import com.intellij.structuralsearch.PatternContext;
import com.intellij.structuralsearch.ReplacementVariableDefinition;
import com.intellij.structuralsearch.SSRBundle;
import com.intellij.structuralsearch.StructuralSearchProfile;
import com.intellij.structuralsearch.StructuralSearchUtil;
import com.intellij.structuralsearch.plugin.StructuralSearchAction;
import com.intellij.structuralsearch.plugin.replace.ReplaceOptions;
import com.intellij.structuralsearch.plugin.ui.Configuration;
import com.intellij.structuralsearch.plugin.ui.SearchConfiguration;
import com.intellij.structuralsearch.plugin.ui.SearchContext;
import com.intellij.ui.EditorTextField;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.lang.invoke.MethodHandles;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class UIUtil {
    @NonNls
    private static final String a = "structuralsearchgroup";
    @NonNls
    public static final String SSR_NOTIFICATION_GROUP_ID = "Structural Search";
    @NonNls
    public static final String TEXT = "TEXT";
    @NonNls
    public static final String TEXT_HIERARCHY = "TEXT HIERARCHY";
    @NonNls
    public static final String REFERENCE = "REFERENCE";
    @NonNls
    public static final String TYPE = "TYPE";
    @NonNls
    public static final String TYPE_REGEX = "TYPE REGEX";
    @NonNls
    public static final String EXPECTED_TYPE = "EXPECTED TYPE";
    @NonNls
    public static final String MINIMUM_ZERO = "MINIMUM ZERO";
    @NonNls
    public static final String MAXIMUM_UNLIMITED = "MAXIMUM UNLIMITED";
    @NonNls
    public static final String CONTEXT = "CONTEXT";
    private static final long b = lb.a(6026597774204481897L, -7450147807414032475L, MethodHandles.lookup().lookupClass()).a(121341083993648L);

    private UIUtil() {
    }

    @NotNull
    public static Editor createEditor(@NotNull Document doc, Project project, boolean editable, @Nullable TemplateContextType contextType) {
        if (doc == null) {
            UIUtil.a(0);
        }
        Editor editor = editable ? EditorFactory.getInstance().createEditor(doc, project) : EditorFactory.getInstance().createViewer(doc, project);
        EditorSettings editorSettings = editor.getSettings();
        editorSettings.setVirtualSpace(false);
        editorSettings.setLineMarkerAreaShown(false);
        editorSettings.setIndentGuidesShown(false);
        editorSettings.setLineNumbersShown(false);
        editorSettings.setFoldingOutlineShown(false);
        editorSettings.setCaretRowShown(false);
        if (!editable) {
            EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
            Color color = editorColorsScheme.getColor(EditorColors.READONLY_BACKGROUND_COLOR);
            if (color == null) {
                color = editorColorsScheme.getDefaultBackground();
            }
            ((EditorEx)editor).setBackgroundColor(color);
        } else {
            ((EditorEx)editor).setEmbeddedIntoDialogWrapper(true);
        }
        TemplateEditorUtil.setHighlighter((Editor)editor, (TemplateContextType)contextType);
        Editor editor2 = editor;
        if (editor2 == null) {
            UIUtil.a(1);
        }
        return editor2;
    }

    public static void setContent(@NotNull Editor editor, String text2) {
        long l2 = b ^ 0x5EDE0984CC14L;
        if (editor == null) {
            UIUtil.a(2);
        }
        String string = text2 != null ? text2 : "";
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)a, () -> document.replaceString(0, document.getTextLength(), (CharSequence)string), (PsiFile[])new PsiFile[0]);
    }

    public static void setContent(@NotNull EditorTextField editor, @NotNull String text2) {
        long l2 = b ^ 0x32BE4BC0A9C3L;
        if (editor == null) {
            UIUtil.a(3);
        }
        if (text2 == null) {
            UIUtil.a(4);
        }
        Document document = editor.getDocument();
        WriteCommandAction.runWriteCommandAction((Project)editor.getProject(), (String)SSRBundle.message("modify.editor.content.command.name", new Object[0]), (String)a, () -> document.replaceString(0, document.getTextLength(), (CharSequence)text2), (PsiFile[])new PsiFile[0]);
    }

    public static void invokeAction(@NotNull Configuration config, @NotNull SearchContext context) {
        if (config == null) {
            UIUtil.a(5);
        }
        if (context == null) {
            UIUtil.a(6);
        }
        StructuralSearchAction.triggerAction(config, context, !(config instanceof SearchConfiguration));
    }

    @NotNull
    public static MatchVariableConstraint getOrAddVariableConstraint(@NotNull String varName, @NotNull Configuration configuration) {
        MatchOptions matchOptions;
        MatchVariableConstraint matchVariableConstraint;
        if (varName == null) {
            UIUtil.a(7);
        }
        if (configuration == null) {
            UIUtil.a(8);
        }
        if ((matchVariableConstraint = (matchOptions = configuration.getMatchOptions()).getVariableConstraint(varName)) != null) {
            MatchVariableConstraint matchVariableConstraint2 = matchVariableConstraint;
            if (matchVariableConstraint2 == null) {
                UIUtil.a(9);
            }
            return matchVariableConstraint2;
        }
        MatchVariableConstraint matchVariableConstraint3 = configuration.getMatchOptions().addNewVariableConstraint(varName);
        if (matchVariableConstraint3 == null) {
            UIUtil.a(10);
        }
        return matchVariableConstraint3;
    }

    @NotNull
    public static ReplacementVariableDefinition getOrAddReplacementVariable(@NotNull String varName, @NotNull Configuration configuration) {
        ReplaceOptions replaceOptions;
        ReplacementVariableDefinition replacementVariableDefinition;
        if (varName == null) {
            UIUtil.a(11);
        }
        if (configuration == null) {
            UIUtil.a(12);
        }
        if ((replacementVariableDefinition = (replaceOptions = configuration.getReplaceOptions()).getVariableDefinition(varName)) != null) {
            ReplacementVariableDefinition replacementVariableDefinition2 = replacementVariableDefinition;
            if (replacementVariableDefinition2 == null) {
                UIUtil.a(13);
            }
            return replacementVariableDefinition2;
        }
        ReplacementVariableDefinition replacementVariableDefinition3 = replaceOptions.addNewVariableDefinition(varName);
        if (replacementVariableDefinition3 == null) {
            UIUtil.a(14);
        }
        return replacementVariableDefinition3;
    }

    public static boolean isTarget(@NotNull String varName, @NotNull MatchOptions matchOptions) {
        long l2 = b ^ 0x3EA2BDCFA394L;
        if (varName == null) {
            UIUtil.a(15);
        }
        if (matchOptions == null) {
            UIUtil.a(16);
        }
        if ("__context__".equals(varName)) {
            for (String string : matchOptions.getVariableConstraintNames()) {
                if (string.equals("__context__") || !matchOptions.getVariableConstraint(string).isPartOfSearchResults()) continue;
                return false;
            }
            return true;
        }
        MatchVariableConstraint matchVariableConstraint = matchOptions.getVariableConstraint(varName);
        if (matchVariableConstraint == null) {
            return false;
        }
        return matchVariableConstraint.isPartOfSearchResults();
    }

    @NotNull
    public static EditorTextField createTextComponent(@NotNull String text2, @NotNull Project project) {
        long l2 = b ^ 0x49FCCA3F7D23L;
        if (text2 == null) {
            UIUtil.a(17);
        }
        if (project == null) {
            UIUtil.a(18);
        }
        return UIUtil.createEditorComponent(text2, "1.txt", project);
    }

    @NotNull
    public static EditorTextField createRegexComponent(@NotNull String text2, @NotNull Project project) {
        long l2 = b ^ 0x46273EC139B3L;
        if (text2 == null) {
            UIUtil.a(19);
        }
        if (project == null) {
            UIUtil.a(20);
        }
        return UIUtil.createEditorComponent(text2, "1.regexp", project);
    }

    @NotNull
    public static EditorTextField createScriptComponent(@NotNull String text2, @NotNull Project project) {
        long l2 = b ^ 0x337D37C2C6E9L;
        if (text2 == null) {
            UIUtil.a(21);
        }
        if (project == null) {
            UIUtil.a(22);
        }
        return UIUtil.createEditorComponent(text2, "1.groovy", project);
    }

    @NotNull
    public static EditorTextField createEditorComponent(@NotNull String text2, @NotNull String fileName, @NotNull Project project) {
        if (text2 == null) {
            UIUtil.a(23);
        }
        if (fileName == null) {
            UIUtil.a(24);
        }
        if (project == null) {
            UIUtil.a(25);
        }
        FileType fileType = UIUtil.a(fileName);
        Document document = UIUtil.createDocument(fileType, text2, project);
        return new EditorTextField(document, project, fileType);
    }

    @NotNull
    public static Document createDocument(@NotNull FileType fileType, @NotNull String text2, @NotNull Project project) {
        if (fileType == null) {
            UIUtil.a(26);
        }
        if (text2 == null) {
            UIUtil.a(27);
        }
        if (project == null) {
            UIUtil.a(28);
        }
        PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("Dummy." + fileType.getDefaultExtension(), fileType, (CharSequence)text2, -1L, true);
        Document document = PsiDocumentManager.getInstance((Project)project).getDocument(psiFile);
        assert (document != null);
        Document document2 = document;
        if (document2 == null) {
            UIUtil.a(29);
        }
        return document2;
    }

    @NotNull
    private static FileType a(@NotNull String string) {
        FileType fileType;
        if (string == null) {
            UIUtil.a(30);
        }
        if ((fileType = FileTypeManager.getInstance().getFileTypeByFileName(string)) == FileTypes.UNKNOWN) {
            fileType = FileTypes.PLAIN_TEXT;
        }
        FileType fileType2 = fileType;
        if (fileType2 == null) {
            UIUtil.a(31);
        }
        return fileType2;
    }

    @NotNull
    public static LanguageFileType detectFileType(@NotNull SearchContext searchContext) {
        Language language;
        StructuralSearchProfile structuralSearchProfile;
        if (searchContext == null) {
            UIUtil.a(32);
        }
        PsiFile psiFile = searchContext.getFile();
        PsiElement psiElement = null;
        Editor editor = searchContext.getEditor();
        if (editor != null && psiFile != null) {
            int n2 = editor.getCaretModel().getOffset();
            psiElement = InjectedLanguageManager.getInstance((Project)searchContext.getProject()).findInjectedElementAt(psiFile, n2);
            if (psiElement == null) {
                psiElement = psiFile.findElementAt(n2);
            }
            if (psiElement != null) {
                psiElement = psiElement.getParent();
            }
            if (psiElement == null) {
                psiElement = psiFile;
            }
        }
        if (psiElement != null && (structuralSearchProfile = StructuralSearchUtil.getProfileByLanguage(language = psiElement.getLanguage())) != null) {
            LanguageFileType languageFileType = structuralSearchProfile.detectFileType(psiElement);
            if (languageFileType == null) {
                languageFileType = language.getAssociatedFileType();
            }
            if (languageFileType != null) {
                LanguageFileType languageFileType2 = languageFileType;
                if (languageFileType2 == null) {
                    UIUtil.a(33);
                }
                return languageFileType2;
            }
        }
        LanguageFileType languageFileType = StructuralSearchUtil.getDefaultFileType();
        if (languageFileType == null) {
            UIUtil.a(34);
        }
        return languageFileType;
    }

    @NotNull
    public static Document createDocument(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, PatternContext patternContext, @NotNull String text2, @NotNull StructuralSearchProfile profile) {
        String string;
        PsiCodeFragment psiCodeFragment;
        long l2 = b ^ 0x55B0C97AFFFBL;
        if (project == null) {
            UIUtil.a(35);
        }
        if (fileType == null) {
            UIUtil.a(36);
        }
        if (text2 == null) {
            UIUtil.a(37);
        }
        if (profile == null) {
            UIUtil.a(38);
        }
        if ((psiCodeFragment = profile.createCodeFragment(project, text2, string = patternContext == null ? null : patternContext.getId())) == null) {
            psiCodeFragment = UIUtil.a(project, fileType, dialect, text2);
        }
        if (psiCodeFragment != null) {
            Document document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)psiCodeFragment);
            assert (document != null) : "code fragment element should be physical";
            Document document2 = document;
            if (document2 == null) {
                UIUtil.a(39);
            }
            return document2;
        }
        Document document = EditorFactory.getInstance().createDocument((CharSequence)text2);
        if (document == null) {
            UIUtil.a(40);
        }
        return document;
    }

    @NotNull
    public static Editor createEditor(@NotNull Project project, @NotNull LanguageFileType fileType, Language dialect, @NotNull String text2, boolean editable, @NotNull StructuralSearchProfile profile) {
        Document document;
        PsiCodeFragment psiCodeFragment;
        long l2 = b ^ 0x375355B3CE32L;
        if (project == null) {
            UIUtil.a(41);
        }
        if (fileType == null) {
            UIUtil.a(42);
        }
        if (text2 == null) {
            UIUtil.a(43);
        }
        if (profile == null) {
            UIUtil.a(44);
        }
        if ((psiCodeFragment = profile.createCodeFragment(project, text2, null)) == null) {
            psiCodeFragment = UIUtil.a(project, fileType, dialect, text2);
        }
        if (psiCodeFragment != null) {
            document = PsiDocumentManager.getInstance((Project)project).getDocument((PsiFile)psiCodeFragment);
            assert (document != null) : "code fragment element should be physical";
            DaemonCodeAnalyzer.getInstance((Project)project).setHighlightingEnabled((PsiFile)psiCodeFragment, false);
        } else {
            document = EditorFactory.getInstance().createDocument((CharSequence)"");
        }
        return UIUtil.createEditor(document, project, editable, UIUtil.getTemplateContextType(profile));
    }

    private static PsiFile a(@NotNull Project project, @NotNull LanguageFileType languageFileType, Language language, @NotNull String string) {
        if (project == null) {
            UIUtil.a(45);
        }
        if (languageFileType == null) {
            UIUtil.a(46);
        }
        if (string == null) {
            UIUtil.a(47);
        }
        String string2 = "__dummy." + languageFileType.getDefaultExtension();
        PsiFileFactory psiFileFactory = PsiFileFactory.getInstance((Project)project);
        return language == null ? psiFileFactory.createFileFromText(string2, (FileType)languageFileType, (CharSequence)string, LocalTimeCounter.currentTime(), true, true) : psiFileFactory.createFileFromText(string2, language, (CharSequence)string, true, true);
    }

    public static TemplateContextType getTemplateContextType(@NotNull StructuralSearchProfile profile) {
        if (profile == null) {
            UIUtil.a(48);
        }
        Class<? extends TemplateContextType> clazz = profile.getTemplateContextTypeClass();
        return (TemplateContextType)ContainerUtil.findInstance((Object[])((TemplateContextType[])TemplateContextType.EP_NAME.getExtensions()), clazz);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = b ^ 0x4AC81D16001DL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "doc";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 17: 
            case 19: 
            case 21: 
            case 23: 
            case 27: 
            case 37: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "varName";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matchOptions";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 25: 
            case 28: 
            case 35: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 26: 
            case 36: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileType";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchContext";
                break;
            }
            case 38: 
            case 44: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/structuralsearch/plugin/ui/UIUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrAddVariableConstraint";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrAddReplacementVariable";
                break;
            }
            case 29: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "createDocument";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileType";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "detectFileType";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createEditor";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setContent";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invokeAction";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrAddVariableConstraint";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrAddReplacementVariable";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isTarget";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createTextComponent";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createRegexComponent";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createScriptComponent";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "createEditorComponent";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "createDocument";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "getFileType";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "detectFileType";
                break;
            }
            case 45: 
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "createFileFragment";
                break;
            }
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "getTemplateContextType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 29: 
            case 31: 
            case 33: 
            case 34: 
            case 39: 
            case 40: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

