/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import a.j.lb;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.MutableRemoteCredentialsEx;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.ForceDisconnectListener;
import com.intellij.ssh.RemoteCredentialsUtil;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.SshConnectionUtil;
import com.intellij.ssh.SshTransportException;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshCredentialsVerifier;
import com.intellij.ssh.ui.SshCredentialsEditorBase;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Producer;
import com.intellij.util.concurrency.Semaphore;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SshCredentialsEditorEx
extends SshCredentialsEditorBase<MutableRemoteCredentialsEx> {
    private static final Logger k;
    private static final long m;

    public SshCredentialsEditorEx(@Nullable Producer<? extends Pair<String, String>> actualHostPortProducer, @NotNull Disposable parent) {
        if (parent == null) {
            SshCredentialsEditorEx.b(0);
        }
        super(true, true, false, actualHostPortProducer, parent);
        this.myTestButton.addActionListener(new ActionListener(){
            private static final long a = lb.a(5466547324299136902L, 6503367245869058944L, MethodHandles.lookup().lookupClass()).a(183518075698867L);

            @Override
            public void actionPerformed(ActionEvent event) {
                long l2 = a ^ 0x240C736F4704L;
                SshUiData sshUiData = new SshUiData(new SshConfig(true), false);
                SshCredentialsEditorEx.this.applyEditorTo(sshUiData);
                ErrorMessageAndField errorMessageAndField = sshUiData.validate(SshCredentialsVerifier.ValidationMode.WITHOUT_SLOW_KEY_CHECKS);
                if (errorMessageAndField != null) {
                    Messages.showErrorDialog((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message("ssh.editor.invalid.setting.0", StringUtil.decapitalize((String)((String)errorMessageAndField.first))), (String)SshBundle.message("ssh.editor.message.title.unable.to.connect", new Object[0]));
                    return;
                }
                AtomicBoolean atomicBoolean = new AtomicBoolean(false);
                Ref ref = new Ref(null);
                Runnable runnable = () -> {
                    ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                    Semaphore semaphore = new Semaphore();
                    semaphore.down();
                    EventDispatcher eventDispatcher = EventDispatcher.create(ForceDisconnectListener.class);
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        long l2 = a ^ 0x3F9856EAA685L;
                        try {
                            progressIndicator.setText(IdeBundle.message((String)"progress.message.connecting.to", (Object[])new Object[]{sshUiData.getConfig().getPresentableFullName()}));
                            atomicBoolean.set(RemoteCredentialsUtil.connectionBuilder((RemoteCredentials)sshUiData, null).withDisconnectTrigger((EventDispatcher<ForceDisconnectListener>)eventDispatcher).withConnectionTimeout(10L, TimeUnit.SECONDS).checkCanAuthenticate(true));
                        }
                        catch (SshTransportException sshTransportException) {
                            k.warn((Throwable)((Object)sshTransportException));
                            ref.set((Object)sshTransportException);
                            atomicBoolean.set(false);
                        }
                        finally {
                            semaphore.up();
                        }
                    });
                    while (!semaphore.waitFor(10000L)) {
                        if (!progressIndicator.isCanceled()) continue;
                        ((ForceDisconnectListener)eventDispatcher.getMulticaster()).forceDisconnect();
                        break;
                    }
                };
                String string = SshBundle.message("ssh.editor.title.connection.to.0", sshUiData.getConfig().getPresentableFullName());
                boolean bl2 = ProgressManager.getInstance().runProcessWithProgressSynchronously(runnable, string, true, null, SshCredentialsEditorEx.this.getComponent());
                if (!bl2) {
                    throw new ProcessCanceledException();
                }
                if (atomicBoolean.get()) {
                    Messages.showInfoMessage((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message("ssh.editor.successfully.connected", new Object[0]), (String)string);
                } else {
                    String string2;
                    String string3 = string2 = !ref.isNull() ? SshConnectionUtil.getMessage((Throwable)ref.get(), false) : null;
                    if (string2 == null) {
                        Messages.showErrorDialog((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message("ssh.editor.can.t.connect.to.remote.host", new Object[0]), (String)string);
                    } else {
                        Messages.showErrorDialog((Component)SshCredentialsEditorEx.this.getComponent(), (String)SshBundle.message("ssh.editor.can.t.connect.to.remote.host.0", string2), (String)string);
                    }
                }
            }
        });
        this.myPrivateKeyFileField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){
            private static final long a = lb.a(4389462641685401767L, -4998205402697074847L, MethodHandles.lookup().lookupClass()).a(46272111906121L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    2.a(0);
                }
                SshCredentialsEditorEx.this.h();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x55E37A056C0AL;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/unified/SshCredentialsEditorEx$2", "textChanged"));
            }
        });
    }

    @Override
    public void resetEditorFrom(@NotNull MutableRemoteCredentialsEx credentials) {
        if (credentials == null) {
            SshCredentialsEditorEx.b(1);
        }
        super.resetEditorFrom(credentials);
        this.myLocalPortField.setText(credentials.getLocalPort() == 0 ? null : credentials.getLiteralLocalPort());
        this.h();
    }

    @Override
    public void applyEditorTo(@NotNull MutableRemoteCredentialsEx credentials) {
        if (credentials == null) {
            SshCredentialsEditorEx.b(2);
        }
        super.applyEditorTo(credentials);
        credentials.setLiteralLocalPort(this.getLocalPortText());
    }

    @Override
    public boolean isModified(@NotNull MutableRemoteCredentialsEx credentials) {
        if (credentials == null) {
            SshCredentialsEditorEx.b(3);
        }
        if (super.isModified(credentials)) {
            return true;
        }
        return !StringUtil.equals((CharSequence)StringUtil.nullize((String)credentials.getLiteralLocalPort()), (CharSequence)StringUtil.nullize((String)this.getLocalPortText()));
    }

    public void addListenerForNameDefiningFields(final @NotNull Runnable updater) {
        if (updater == null) {
            SshCredentialsEditorEx.b(4);
        }
        DocumentAdapter documentAdapter = new DocumentAdapter(){
            private static final long a = lb.a(-1377615813516952021L, -2361790488195780180L, MethodHandles.lookup().lookupClass()).a(99125305179007L);

            protected void textChanged(@NotNull DocumentEvent e10) {
                if (e10 == null) {
                    3.a(0);
                }
                updater.run();
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x2E02C80724D3L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ssh/ui/unified/SshCredentialsEditorEx$3", "textChanged"));
            }
        };
        this.myUsernameField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myHostField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myPortField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myLocalPortField.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.myAuthTypeCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e10) {
                updater.run();
            }
        });
    }

    private void h() {
        String string = this.myPrivateKeyFileField.getText();
        boolean bl2 = true;
        try {
            bl2 = StringUtil.isEmpty((String)string) || (Boolean)SshCredentialsVerifier.runWithTimeout(SshCredentialsVerifier.SLOW_VALIDATION_TIMEOUT_MS, () -> !Ssh.isPrivateKeyNotEncrypted(string, SshBackendLibrary.get())) != false;
        }
        catch (TimeoutException timeoutException) {
            k.warn("Failed to check key for passphrase: " + string);
        }
        if (bl2) {
            if (!this.myPassphraseField.isEnabled()) {
                this.myPassphraseField.setText(null);
                this.myPassphraseField.setEnabled(true);
                this.mySavePassphraseCheckbox.setEnabled(true);
            }
        } else {
            this.myPassphraseField.setText(null);
            this.myPassphraseField.setEnabled(false);
            this.mySavePassphraseCheckbox.setSelected(false);
            this.mySavePassphraseCheckbox.setEnabled(false);
        }
    }

    static {
        m = lb.a(-1300016798282053409L, -9000628373149081705L, MethodHandles.lookup().lookupClass()).a(166134113370554L);
        k = Logger.getInstance(SshCredentialsEditorEx.class);
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = m ^ 0x363D85871191L;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/ui/unified/SshCredentialsEditorEx";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "resetEditorFrom";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "applyEditorTo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isModified";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "addListenerForNameDefiningFields";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

