/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import a.j.lb;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remote.AuthType;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigConfigurable;
import com.intellij.ssh.ui.unified.SshEntityConfigurable;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.Producer;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SshConfigsMasterComponent
extends MasterDetailsComponent {
    private final MyNamer a;
    private final Cloner<SshUiData> b;
    protected final List<SshUiData> myItems;
    private List<SshUiData> e;
    @NotNull
    protected final Project myProject;
    private final SshConfigConfigurable.Visibility c;
    private Producer<Pair<String, String>> d;
    private static final long g = lb.a(4844367634088124934L, -7735798743028776196L, MethodHandles.lookup().lookupClass()).a(261817254869745L);

    SshConfigsMasterComponent(@NotNull Project project, @NotNull SshConfigConfigurable.Visibility defaultVisibility, @Nullable Producer<Pair<String, String>> actualHostPortProducer) {
        long l2 = g ^ 0x1F4696FF94DBL;
        if (project == null) {
            SshConfigsMasterComponent.a(0);
        }
        if (defaultVisibility == null) {
            SshConfigsMasterComponent.a(1);
        }
        this.myItems = new ArrayList<SshUiData>();
        LOG.assertTrue(!project.isDefault() || defaultVisibility == SshConfigConfigurable.Visibility.App, (Object)"Project-level visibility needs a project");
        this.myProject = project;
        this.c = defaultVisibility;
        this.a = new MyNamer();
        this.b = new MyCloner();
        this.d = actualHostPortProducer;
        this.initTree();
    }

    protected void initTree() {
        super.initTree();
        this.myTree.setShowsRootHandles(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){
            private static final long a = lb.a(-8708807765261916696L, 4539180416376311356L, MethodHandles.lookup().lookupClass()).a(1386384590279L);

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.a(0);
                }
                if (!(value instanceof MasterDetailsComponent.MyNode)) {
                    return;
                }
                this.setIconOnTheRight(false);
                MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)value;
                Font font = UIUtil.getTreeFont();
                this.setFont(font.deriveFont(0));
                NamedConfigurable namedConfigurable = myNode.getConfigurable();
                if (namedConfigurable instanceof SshEntityConfigurable) {
                    SshUiData sshUiData = ((SshEntityConfigurable)namedConfigurable).applyToNewDefaultSshDataIfPossible(SshConfigsMasterComponent.this.isInitialized(namedConfigurable));
                    SshConfigsMasterComponent.renderData(sshUiData, (SimpleColoredComponent)this);
                } else {
                    this.append(myNode.getDisplayName(), myNode.isDisplayInBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x29D1408D9915L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$1", "customizeCellRenderer"));
            }
        });
    }

    @Nullable
    @Nls
    protected String getEmptySelectionString() {
        long l2 = g ^ 0x2A08BCC953EEL;
        return this.myItems.isEmpty() ? SshBundle.message("ssh.master.component.please.add.an.ssh.configuration", new Object[0]) : SshBundle.message("ssh.master.component.please.select.ssh.configuration", new Object[0]);
    }

    void resetFromData(@NotNull SshConfigManager.ConfigsData lastSavedAndCurrentData) {
        if (lastSavedAndCurrentData == null) {
            SshConfigsMasterComponent.a(2);
        }
        if (this.myProject.isDefault()) {
            for (SshUiData sshUiData : lastSavedAndCurrentData.getCurrentData()) {
                LOG.assertTrue(!sshUiData.getConfig().isProjectLevel());
            }
            for (SshUiData sshUiData : lastSavedAndCurrentData.getLastSavedData()) {
                LOG.assertTrue(!sshUiData.getConfig().isProjectLevel());
            }
        }
        Iterator<SshUiData> iterator2 = this.getSelectedItem();
        this.e = lastSavedAndCurrentData.getLastSavedData();
        this.a(lastSavedAndCurrentData.getCurrentData());
        this.selectItem((SshUiData)((Object)iterator2));
    }

    public void reset() {
        SshUiData sshUiData = this.getSelectedItem();
        this.a(this.e);
        this.selectItem(sshUiData);
    }

    private void a(@NotNull List<SshUiData> list2) {
        if (list2 == null) {
            SshConfigsMasterComponent.a(3);
        }
        this.myItems.clear();
        this.clearChildren();
        for (SshUiData sshUiData : list2) {
            this.a((SshUiData)this.b.cloneOf((Object)sshUiData));
        }
        super.reset();
    }

    public boolean isModified() {
        if (this.e.size() != this.myItems.size()) {
            return true;
        }
        for (int i10 = 0; i10 < this.myItems.size(); ++i10) {
            if (this.myItems.get(i10).equals(this.e.get(i10))) continue;
            return true;
        }
        return super.isModified();
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.e = new ArrayList<SshUiData>(this.myItems);
        SshConfigManager.getInstance(this.myProject).applyData(this.myItems, null);
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    public void setActualHostPortProducer(@Nullable Producer<Pair<String, String>> actualHostPortProducer) {
        this.d = actualHostPortProducer;
    }

    @Nullable
    protected SshUiData findByName(String name) {
        for (SshUiData sshUiData : this.myItems) {
            if (!Objects.equals(name, this.a.getName(sshUiData))) continue;
            return sshUiData;
        }
        return null;
    }

    @Nullable
    protected List<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        arrayList.add((AnAction)new AddAction(this));
        arrayList.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        arrayList.add((AnAction)new CopyAction(this));
        arrayList.add((AnAction)new RenameAction(this));
        return arrayList;
    }

    private void a(@NotNull SshUiData sshUiData) {
        if (sshUiData == null) {
            SshConfigsMasterComponent.a(4);
        }
        this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)this.createConfigurable(sshUiData, this.a.canRename(sshUiData), this.TREE_UPDATER)), this.myRoot);
        this.myItems.add(sshUiData);
    }

    protected void onItemDeleted(Object item) {
        this.myItems.remove((SshUiData)item);
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            SshConfigsMasterComponent.a(5);
        }
        return project;
    }

    public SshUiData getSelectedItem() {
        return (SshUiData)this.getSelectedObject();
    }

    public void selectItem(@Nullable SshUiData exampleItem) {
        SshUiData sshUiData = null;
        if (exampleItem != null) {
            for (SshUiData sshUiData2 : this.myItems) {
                if (!exampleItem.getName().equals(sshUiData2.getName())) continue;
                sshUiData = sshUiData2;
                break;
            }
        }
        this.selectNodeInTree(sshUiData);
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        super.updateSelection(configurable);
        if (configurable instanceof SshEntityConfigurable && ((SshEntityConfigurable)configurable).isRequestFocusOnSelection()) {
            JComponent jComponent = configurable.getPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)jComponent).requestFocus((Component)jComponent, false);
            ((SshEntityConfigurable)configurable).setRequestFocusOnSelection(false);
        }
    }

    protected void onItemCreated(@NotNull SshUiData newItem) {
        if (newItem == null) {
            SshConfigsMasterComponent.a(6);
        }
        this.b(newItem);
    }

    private void b(@NotNull SshUiData sshUiData) {
        if (sshUiData == null) {
            SshConfigsMasterComponent.a(7);
        }
        this.a(sshUiData);
        this.selectNodeInTree(sshUiData);
        NamedConfigurable namedConfigurable = this.getSelectedConfigurable();
        if (namedConfigurable instanceof SshEntityConfigurable) {
            ((SshEntityConfigurable)namedConfigurable).setRequestFocusOnSelection(true);
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        long l2 = g ^ 0x371DB6A74CF8L;
        return SshBundle.message("ssh.configurable.title", new Object[0]);
    }

    protected SshEntityConfigurable createConfigurable(@NotNull SshUiData item, boolean nameEditable, Runnable updater) {
        if (item == null) {
            SshConfigsMasterComponent.a(8);
        }
        LOG.assertTrue(!item.getConfig().isProjectLevel() || !this.myProject.isDefault());
        return new SshEntityConfigurable(item, nameEditable, updater, this.d, this.myProject.isDefault());
    }

    public void disposeUIResources() {
        SshConfigManager.getInstance(this.myProject).disposeCurrentData();
        super.disposeUIResources();
    }

    public static void renderData(@NotNull SshUiData data, @NotNull SimpleColoredComponent renderer2) {
        if (data == null) {
            SshConfigsMasterComponent.a(9);
        }
        if (renderer2 == null) {
            SshConfigsMasterComponent.a(10);
        }
        renderer2.append(data.getConfig().getPresentableShortName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer2.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        @Nls String string = data.getConfig().getPresentableAddition();
        if (string != null) {
            renderer2.append(string, SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        }
    }

    private String a(SshUiData sshUiData, @NotNull @NlsContexts.DialogTitle String string) {
        long l2 = g ^ 0x4BB773ACBFC9L;
        if (string == null) {
            SshConfigsMasterComponent.a(11);
        }
        final String string2 = sshUiData.getConfig().getPresentableFullName();
        final HashSet<String> hashSet = new HashSet<String>();
        for (SshUiData sshUiData2 : this.myItems) {
            hashSet.add(sshUiData2.getName());
        }
        return Messages.showInputDialog((Component)this.getTree(), (String)SshBundle.message("ssh.master.component.rename.new.name", new Object[0]), (String)string, null, (String)string2, (InputValidator)new InputValidatorEx(){
            private static final long a = lb.a(2220498308013255337L, -399014226456438080L, MethodHandles.lookup().lookupClass()).a(209972932136078L);

            @Nullable
            public String getErrorText(String inputString) {
                long l2 = a ^ 0x1241F74752DAL;
                if (StringUtil.isEmptyOrSpaces((String)inputString)) {
                    return SshBundle.message("ssh.master.component.rename.provide.a.name.for.the.ssh.configuration", new Object[0]);
                }
                if (this.a(inputString)) {
                    return SshBundle.message("ssh.master.component.rename.server.or.group.named.0.already.exists", inputString);
                }
                return null;
            }

            public boolean checkInput(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString) && !this.a(inputString);
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString) && !this.a(inputString);
            }

            private boolean a(@NotNull String string) {
                if (string == null) {
                    2.a(0);
                }
                return !string.equals(string2) && hashSet.contains(string);
            }

            private static /* synthetic */ void a(int n2) {
                long l2 = a ^ 0x28BDF28F824L;
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$2", "banned"));
            }
        });
    }

    @Nullable
    private SshEntityConfigurable a() {
        TreePath[] treePathArray = this.myTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length != 1) {
            return null;
        }
        MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)treePathArray[0].getLastPathComponent();
        NamedConfigurable namedConfigurable = myNode.getConfigurable();
        if (!(namedConfigurable instanceof SshEntityConfigurable)) {
            return null;
        }
        return (SshEntityConfigurable)namedConfigurable;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = g ^ 0x7538E3AD2BL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultVisibility";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastSavedAndCurrentData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetFromData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNewNode";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onItemCreated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAndSelect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "renderData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNewName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class MainSshConfigsMasterComponent
    extends SshConfigsMasterComponent
    implements SshConfigManager.Listener {
        private HierarchyListener f;
        private static final long h = lb.a(2600386945668907258L, -5224074353753412549L, MethodHandles.lookup().lookupClass()).a(219765255904757L);

        MainSshConfigsMasterComponent(@NotNull Project project) {
            if (project == null) {
                MainSshConfigsMasterComponent.b(0);
            }
            super(project, MainSshConfigsMasterComponent.a(project), null);
        }

        @NotNull
        private static SshConfigConfigurable.Visibility a(@NotNull Project project) {
            if (project == null) {
                MainSshConfigsMasterComponent.b(1);
            }
            SshConfigConfigurable.Visibility visibility = PlatformUtils.isPhpStorm() && !project.isDefault() ? SshConfigConfigurable.Visibility.Project : SshConfigConfigurable.Visibility.App;
            if (visibility == null) {
                MainSshConfigsMasterComponent.b(2);
            }
            return visibility;
        }

        @NotNull
        public JComponent createComponent() {
            JComponent jComponent = super.createComponent();
            this.f = new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e10) {
                    if ((e10.getChangeFlags() & 4L) == 0L) {
                        return;
                    }
                    if (e10.getComponent().isShowing()) {
                        this.addNotify();
                        return;
                    }
                    SshConfigManager.getInstance(myProject).setCurrentData(this.a(), this);
                }
            };
            this.myWholePanel.addHierarchyListener(this.f);
            JComponent jComponent2 = jComponent;
            if (jComponent2 == null) {
                MainSshConfigsMasterComponent.b(3);
            }
            return jComponent2;
        }

        @NotNull
        private List<SshUiData> a() {
            ArrayList<SshUiData> arrayList = new ArrayList<SshUiData>();
            for (MasterDetailsComponent.MyNode myNode : TreeUtil.treeNodeTraverser((TreeNode)this.myRoot).filter(MasterDetailsComponent.MyNode.class)) {
                NamedConfigurable namedConfigurable = myNode.getConfigurable();
                if (!(namedConfigurable instanceof SshEntityConfigurable)) continue;
                SshUiData sshUiData = ((SshEntityConfigurable)namedConfigurable).applyToNewDefaultSshDataIfPossible(this.isInitialized(namedConfigurable));
                arrayList.add(sshUiData);
            }
            ArrayList<SshUiData> arrayList2 = arrayList;
            if (arrayList2 == null) {
                MainSshConfigsMasterComponent.b(4);
            }
            return arrayList2;
        }

        @Override
        public void disposeUIResources() {
            if (this.f != null && this.myWholePanel != null) {
                this.myWholePanel.removeHierarchyListener(this.f);
                this.f = null;
            }
            super.disposeUIResources();
        }

        @Override
        public void sshConfigsChanged() {
            this.resetFromData(SshConfigManager.getInstance(this.myProject).getLastSavedAndCurrentData());
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            long l2 = h ^ 0x7E89AF1A26B0L;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$MainSshConfigsMasterComponent";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$MainSshConfigsMasterComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultVisibilityInSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultVisibilityInSettings";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private final class RenameAction
    extends DumbAwareAction {
        final /* synthetic */ SshConfigsMasterComponent this$0;
        private static final long a = lb.a(-3197683021662812002L, 7717503549258656997L, MethodHandles.lookup().lookupClass()).a(229222743321765L);

        private RenameAction(SshConfigsMasterComponent sshConfigsMasterComponent) {
            long l2 = a ^ 0x43E02F68DB0AL;
            this.this$0 = sshConfigsMasterComponent;
            super(SshBundle.message("ssh.master.component.rename.action", new Object[0]), SshBundle.message("ssh.master.component.rename.action", new Object[0]), AllIcons.Actions.EditSource);
            this.registerCustomShortcutSet(CommonShortcuts.getRename(), (JComponent)sshConfigsMasterComponent.myTree);
        }

        public void update(@NotNull AnActionEvent e10) {
            if (e10 == null) {
                RenameAction.a(0);
            }
            TreePath[] treePathArray = this.this$0.myTree.getSelectionPaths();
            e10.getPresentation().setEnabled(treePathArray != null && treePathArray.length == 1);
        }

        public void actionPerformed(@NotNull AnActionEvent e10) {
            SshEntityConfigurable sshEntityConfigurable;
            long l2 = a ^ 0x739153A96BF7L;
            if (e10 == null) {
                RenameAction.a(1);
            }
            if ((sshEntityConfigurable = this.this$0.a()) == null) {
                return;
            }
            SshUiData sshUiData = sshEntityConfigurable.getEditableObject();
            String string = this.this$0.a(sshUiData, SshBundle.message("ssh.master.component.rename.action", new Object[0]));
            if (string == null || string.equals(sshUiData.getName())) {
                return;
            }
            sshEntityConfigurable.setCustomName(string);
            this.this$0.TREE_UPDATER.run();
        }

        private static /* synthetic */ void a(int n2) {
            Object[] objectArray;
            long l2 = a ^ 0x7FC1E1EBDE46L;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$RenameAction";
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class CopyAction
    extends DumbAwareAction {
        final /* synthetic */ SshConfigsMasterComponent this$0;
        private static final long a = lb.a(-2192606978695068451L, 510217050984413956L, MethodHandles.lookup().lookupClass()).a(186629697578448L);

        private CopyAction(SshConfigsMasterComponent sshConfigsMasterComponent) {
            long l2 = a ^ 0x161927D5CC83L;
            this.this$0 = sshConfigsMasterComponent;
            super(SshBundle.message("ssh.master.component.copy.action", new Object[0]), SshBundle.message("ssh.master.component.copy.action", new Object[0]), COPY_ICON);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(68, 128)), (JComponent)sshConfigsMasterComponent.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            SshEntityConfigurable sshEntityConfigurable;
            long l2 = a ^ 0x4B0C096D6D8BL;
            if (event == null) {
                CopyAction.a(0);
            }
            if ((sshEntityConfigurable = this.this$0.a()) == null) {
                return;
            }
            SshUiData sshUiData = sshEntityConfigurable.getEditableObject();
            SshUiData sshUiData2 = sshUiData.clone();
            sshUiData2.getConfig().setId(UUID.randomUUID().toString());
            String string = this.this$0.a(sshUiData, SshBundle.message("ssh.master.component.copy.action", new Object[0]));
            if (string == null) {
                return;
            }
            sshUiData2.getConfig().setCustomName(string);
            this.this$0.b(sshUiData2);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x47C9D5EBED92L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$CopyAction", "actionPerformed"));
        }
    }

    private class AddAction
    extends DumbAwareAction {
        final /* synthetic */ SshConfigsMasterComponent this$0;
        private static final long a = lb.a(-621953041662531115L, 1411188727600139147L, MethodHandles.lookup().lookupClass()).a(36227853465327L);

        AddAction(SshConfigsMasterComponent sshConfigsMasterComponent) {
            long l2 = a ^ 0x56ED87D343B9L;
            this.this$0 = sshConfigsMasterComponent;
            super(SshBundle.message("ssh.master.component.add.action", new Object[0]), SshBundle.message("ssh.master.component.add.action", new Object[0]), IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)sshConfigsMasterComponent.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                AddAction.a(0);
            }
            SshConfig sshConfig = new SshConfig(true);
            sshConfig.setAuthType(AuthType.PASSWORD);
            sshConfig.setProjectLevel(this.this$0.c == SshConfigConfigurable.Visibility.Project);
            SshUiData sshUiData = new SshUiData(sshConfig, false);
            sshUiData.setStorePassword(true);
            sshUiData.setStorePassphrase(true);
            this.this$0.onItemCreated(sshUiData);
        }

        private static /* synthetic */ void a(int n2) {
            long l2 = a ^ 0x1907F0AE5E97L;
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$AddAction", "actionPerformed"));
        }
    }

    private static class MyCloner
    implements Cloner<SshUiData> {
        private MyCloner() {
        }

        public SshUiData cloneOf(SshUiData data) {
            return data.clone();
        }

        public SshUiData copyOf(SshUiData data) {
            return data.copy();
        }
    }

    private static class MyNamer
    implements Namer<SshUiData> {
        private static final long a = lb.a(-2886144856356777724L, 7529202788243596576L, MethodHandles.lookup().lookupClass()).a(214574811390231L);

        private MyNamer() {
        }

        public String getName(SshUiData data) {
            return data.getConfig().getPresentableFullName();
        }

        public boolean canRename(SshUiData item) {
            return false;
        }

        public void setName(SshUiData data, String name) {
            long l2 = a ^ 0x2754013F0B62L;
            throw new IllegalStateException("SshUIData is not designed to rename");
        }
    }
}

