/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config.unified;

import a.j.lb;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.AuthType;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.AnalyzeKeyPairResult;
import com.intellij.ssh.InvalidKeyPair;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.SshBackendLibrary;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.ValidKeyPair;
import com.intellij.ssh.config.unified.ErrorMessageAndField;
import com.intellij.util.concurrency.Semaphore;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SshCredentialsVerifier {
    private static final Logger a;
    public static final int SLOW_VALIDATION_TIMEOUT_MS;
    private static final long b;

    private SshCredentialsVerifier() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField verify(boolean checkSsh, @NonNls String accessTypeName, boolean fast, long msTimeout, boolean checkUserName, String host, int port2, String username, AuthType authType, String privateKeyFile, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        ErrorMessageAndField errorMessageAndField;
        long l2 = b ^ 0x264EAE87B1D5L;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.a(0);
        }
        if ((errorMessageAndField = SshCredentialsVerifier.validateWithoutAuth(accessTypeName, host, port2)) != null) {
            return errorMessageAndField;
        }
        if (checkUserName && StringUtil.isEmpty((String)username)) {
            return new ErrorMessageAndField(SshBundle.message("credentials.username.is.empty", new Object[0]), "USERNAME");
        }
        if (checkSsh && authType == AuthType.KEY_PAIR) {
            if (StringUtil.isEmpty((String)privateKeyFile)) {
                return new ErrorMessageAndField(SshBundle.message("credentials.private.key.empty", new Object[0]), "PRIVATE_KEY_FILE");
            }
            if (!fast) {
                void backendLibrary;
                return (ErrorMessageAndField)((Object)SshCredentialsVerifier.runWithTimeout(msTimeout, () -> SshCredentialsVerifier.a(privateKeyFile, (SshBackendLibrary)backendLibrary)));
            }
        }
        return null;
    }

    @Nullable
    public static ErrorMessageAndField validateWithoutAuth(@NonNls String accessTypeName, String host, int port2) {
        URI uRI;
        long l2 = b ^ 0x30449655D3D7L;
        if (StringUtil.isEmpty((String)host)) {
            return new ErrorMessageAndField(SshBundle.message("credentials.host.is.empty", accessTypeName), "HOST");
        }
        String string = host.replaceAll("_", "a");
        if (!string.startsWith("[")) {
            uRI = SshCredentialsVerifier.a(string);
            if (uRI == null || uRI.getScheme() == null) {
                uRI = SshCredentialsVerifier.a("ftp://" + string);
            }
        } else {
            uRI = SshCredentialsVerifier.a("ftp://" + string);
            if (uRI == null || uRI.getScheme() == null) {
                uRI = SshCredentialsVerifier.a(string);
            }
        }
        if (uRI == null || uRI.getHost() == null) {
            if (host.contains(":")) {
                boolean bl2 = true;
                for (int i10 = 0; i10 < host.length(); ++i10) {
                    char c10 = host.charAt(i10);
                    if (c10 >= '0' && c10 <= '9' || c10 == ':' || c10 == '[' || c10 == ']') continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    return new ErrorMessageAndField(SshBundle.message("credentials.host.is.invalid.try.ip6", accessTypeName), "HOST");
                }
            }
            if (!StringUtils.isAsciiPrintable((CharSequence)host)) {
                return new ErrorMessageAndField(SshBundle.message("credentials.host.is.invalid.try.type", accessTypeName), "HOST");
            }
            return new ErrorMessageAndField(SshBundle.message("credentials.host.is.invalid", accessTypeName), "HOST");
        }
        if (port2 <= 0) {
            return new ErrorMessageAndField(SshBundle.message("credentials.port.is.invalid", accessTypeName), "PORT");
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validate(ValidationMode mode, RemoteCredentials credentials, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        void backendLibrary;
        ErrorMessageAndField errorMessageAndField;
        long l2 = b ^ 0x3602490CBD4FL;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.a(1);
        }
        if ((errorMessageAndField = SshCredentialsVerifier.validateWithoutAuth("SSH", credentials.getHost(), credentials.getPort())) != null) {
            return errorMessageAndField;
        }
        return SshCredentialsVerifier.validateAuthDataProvided(mode, credentials.getUserName(), credentials.getAuthType(), credentials.getPassword(), credentials.getPrivateKeyFile(), credentials.getPassphrase(), msTimeout, (SshBackendLibrary)backendLibrary);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validateAuthDataProvided(RemoteCredentials credentials, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        void backendLibrary;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.a(2);
        }
        return SshCredentialsVerifier.validateAuthDataProvided(credentials.getUserName(), credentials.getAuthType(), credentials.getPassword(), credentials.getPrivateKeyFile(), credentials.getPassphrase(), msTimeout, (SshBackendLibrary)backendLibrary);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validateAuthDataProvided(String username, @NotNull AuthType authType, String password, String keyPath, String passphrase, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        void backendLibrary;
        if (authType == null) {
            SshCredentialsVerifier.a(3);
        }
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.a(4);
        }
        return SshCredentialsVerifier.validateAuthDataProvided(ValidationMode.FULL, username, authType, password, keyPath, passphrase, msTimeout, (SshBackendLibrary)backendLibrary);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public static ErrorMessageAndField validateAuthDataProvided(ValidationMode mode, String username, @NotNull AuthType authType, String password, String keyPath, String passphrase, long msTimeout, @NotNull SshBackendLibrary sshBackendLibrary) throws TimeoutException {
        long l2 = b ^ 0x7253FD332C46L;
        if (authType == null) {
            SshCredentialsVerifier.a(5);
        }
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.a(6);
        }
        if (StringUtil.isEmpty((String)username)) {
            return new ErrorMessageAndField(SshBundle.message("credentials.username.is.empty", new Object[0]), "USERNAME");
        }
        switch (authType) {
            case OPEN_SSH: {
                return null;
            }
            case PASSWORD: {
                if (StringUtil.isEmpty((String)password)) {
                    return new ErrorMessageAndField(SshBundle.message("credentials.password.is.not.specified", new Object[0]), "PASSWORD");
                }
                return null;
            }
            case KEY_PAIR: {
                void backendLibrary;
                if (StringUtil.isEmpty((String)keyPath)) {
                    return new ErrorMessageAndField(SshBundle.message("credentials.private.key.empty", new Object[0]), "PRIVATE_KEY_FILE");
                }
                if (mode == ValidationMode.WITHOUT_SLOW_KEY_CHECKS) {
                    return null;
                }
                return (ErrorMessageAndField)((Object)SshCredentialsVerifier.runWithTimeout(msTimeout, () -> SshCredentialsVerifier.a(keyPath, (SshBackendLibrary)backendLibrary, passphrase)));
            }
        }
        return null;
    }

    @Nullable
    private static ErrorMessageAndField b(String string, @NotNull SshBackendLibrary sshBackendLibrary) {
        File file;
        long l2 = b ^ 0x164877A0CD65L;
        if (sshBackendLibrary == null) {
            SshCredentialsVerifier.a(7);
        }
        if (!(file = new File(string)).isFile() || !file.canRead()) {
            return new ErrorMessageAndField(SshBundle.message("credentials.private.key.file.not.found", string), "PRIVATE_KEY_FILE");
        }
        AnalyzeKeyPairResult analyzeKeyPairResult = Ssh.analyzeKeyPair(file, sshBackendLibrary);
        if (analyzeKeyPairResult instanceof ValidKeyPair) {
            return null;
        }
        String string2 = ((InvalidKeyPair)analyzeKeyPairResult).getErrorMessage();
        if (string2 != null) {
            return new ErrorMessageAndField(SshBundle.message("credentials.invalid.keypair.massage", string, string2), "PRIVATE_KEY_FILE");
        }
        return new ErrorMessageAndField(SshBundle.message("credentials.invalid.keypair", string), "PRIVATE_KEY_FILE");
    }

    private static URI a(@NonNls String string) {
        try {
            return new URI(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            a.info("Invalid URI " + string + ": " + uRISyntaxException.getMessage());
            return null;
        }
    }

    public static <T> T runWithTimeout(long timeout, Computable<T> computable) throws TimeoutException {
        if (timeout <= 0L) {
            return (T)computable.compute();
        }
        Ref ref = new Ref();
        Semaphore semaphore = new Semaphore();
        semaphore.down();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                ref.set(computable.compute());
            }
            finally {
                semaphore.up();
            }
        });
        if (!semaphore.waitFor(timeout)) {
            throw new TimeoutException();
        }
        return (T)ref.get();
    }

    @Nullable
    public static ValidationInfo wrapValidation(@NotNull ThrowableComputable<@Nls String, ? extends TimeoutException> validate2) {
        Object object;
        block4: {
            long l2 = b ^ 0x833D6AF894BL;
            if (validate2 == null) {
                SshCredentialsVerifier.a(8);
            }
            try {
                object = (String)validate2.compute();
            }
            catch (TimeoutException timeoutException) {
                object = SshBundle.message("ssh.verifier.message.connection.timeout", new Object[0]);
                if (timeoutException.getMessage() == null) break block4;
                object = (String)object + ":" + timeoutException.getMessage();
            }
        }
        if (object != null) {
            return new ValidationInfo((String)object);
        }
        return null;
    }

    private static /* synthetic */ ErrorMessageAndField a(String string, SshBackendLibrary sshBackendLibrary, String string2) {
        boolean bl2;
        long l2 = b ^ 0x6145FBB5DFACL;
        ErrorMessageAndField errorMessageAndField = SshCredentialsVerifier.b(string, sshBackendLibrary);
        if (errorMessageAndField != null) {
            return errorMessageAndField;
        }
        if (StringUtil.isEmpty((String)string2) && (bl2 = Ssh.isPassphraseMayBeRequired(string, sshBackendLibrary))) {
            return new ErrorMessageAndField(SshBundle.message("credentials.provided.private.key.requires.a.passphrase", new Object[0]), "PASSPHRASE");
        }
        return null;
    }

    private static /* synthetic */ ErrorMessageAndField a(String string, SshBackendLibrary sshBackendLibrary) {
        return SshCredentialsVerifier.b(string, sshBackendLibrary);
    }

    static {
        b = lb.a(-6110975525355715261L, -1496913529219323850L, MethodHandles.lookup().lookupClass()).a(183924644379827L);
        long l2 = b ^ 0x1AA793F09B06L;
        a = Logger.getInstance(SshCredentialsVerifier.class);
        SLOW_VALIDATION_TIMEOUT_MS = Math.max(10, Integer.getInteger("com.jetbrains.ssh.validation.timeout.ms", 400));
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        long l2 = b ^ 0x257A64E68DAAL;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendLibrary";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "authType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "validate";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ssh/config/unified/SshCredentialsVerifier";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "verify";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "validate";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "validateAuthDataProvided";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "doSshSlowCheck";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "wrapValidation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class ValidationMode
    extends Enum<ValidationMode> {
        public static final /* enum */ ValidationMode WITHOUT_SLOW_KEY_CHECKS;
        public static final /* enum */ ValidationMode FULL;
        private static final /* synthetic */ ValidationMode[] a;

        public static ValidationMode[] values() {
            return (ValidationMode[])a.clone();
        }

        public static ValidationMode valueOf(String name) {
            return Enum.valueOf(ValidationMode.class, name);
        }

        static {
            long l2 = lb.a(1789431013846019915L, -2112937894645796129L, MethodHandles.lookup().lookupClass()).a(97224781072449L) ^ 0xCD364990E7FL;
            WITHOUT_SLOW_KEY_CHECKS = new ValidationMode();
            FULL = new ValidationMode();
            a = new ValidationMode[]{WITHOUT_SLOW_KEY_CHECKS, FULL};
        }
    }
}

