/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.treetable;

import a.j.lb;
import com.intellij.openapi.Disposable;
import com.intellij.ui.CellRendererPanel;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MouseAwareTreeCellRendererPanel
extends CellRendererPanel
implements TreeCellRenderer,
Disposable {
    protected final JTree tree;
    protected boolean isUpdateCursor = true;
    private final HighlightState a = new HighlightState();
    private final MouseAdapter b = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent e10) {
            if (MouseAwareTreeCellRendererPanel.this.a.b != null) {
                MouseAwareTreeCellRendererPanel.this.mousePressed(e10);
                MouseAwareTreeCellRendererPanel.this.a(e10.getPoint());
            }
        }

        @Override
        public void mouseClicked(MouseEvent e10) {
            if (MouseAwareTreeCellRendererPanel.this.a.b != null) {
                MouseAwareTreeCellRendererPanel.this.mouseClicked(e10);
                MouseAwareTreeCellRendererPanel.this.a(e10.getPoint());
            }
        }

        @Override
        public void mouseReleased(MouseEvent e10) {
            if (MouseAwareTreeCellRendererPanel.this.a.b != null) {
                MouseAwareTreeCellRendererPanel.this.mouseReleased(e10);
                MouseAwareTreeCellRendererPanel.this.a(e10.getPoint());
            }
        }

        @Override
        public void mouseEntered(MouseEvent e10) {
            MouseAwareTreeCellRendererPanel.this.a(Objects.requireNonNull(e10).getPoint());
        }

        @Override
        public void mouseExited(MouseEvent e10) {
            MouseAwareTreeCellRendererPanel.this.a(Objects.requireNonNull(e10).getPoint());
        }

        @Override
        public void mouseMoved(MouseEvent e10) {
            MouseAwareTreeCellRendererPanel.this.a(Objects.requireNonNull(e10).getPoint());
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e10) {
            MouseAwareTreeCellRendererPanel.this.tree.getParent().dispatchEvent(e10);
            MouseAwareTreeCellRendererPanel.this.update();
        }
    };
    private static final long p = lb.a(-2598158060089044340L, 3431284089194822867L, MethodHandles.lookup().lookupClass()).a(264517159272872L);

    protected MouseAwareTreeCellRendererPanel(JTree tree) {
        this.tree = tree;
        this.tree.addMouseListener(this.b);
        this.tree.addMouseMotionListener(this.b);
        this.tree.addMouseWheelListener(this.b);
    }

    public int getHighlightedRow() {
        return this.a.d;
    }

    @Nullable
    public Object getHighlightedValue() {
        return this.a.a;
    }

    @Nullable
    public JComponent getHighlightedComponent() {
        return this.a.b;
    }

    protected void mousePressed(MouseEvent event) {
    }

    protected void mouseClicked(MouseEvent event) {
    }

    protected void mouseReleased(MouseEvent event) {
    }

    public boolean isHighlightEnabled(int row, Object value) {
        return true;
    }

    public void update() {
        Point point = MouseInfo.getPointerInfo().getLocation();
        SwingUtilities.convertPointFromScreen(point, this.tree);
        this.a(point);
    }

    protected abstract JComponent @NotNull [] getHighlightables();

    public void dispose() {
        this.tree.removeMouseListener(this.b);
        this.tree.removeMouseMotionListener(this.b);
        this.tree.removeMouseWheelListener(this.b);
    }

    private void a(@NotNull Point point) {
        TreePath treePath;
        int n2;
        long l2 = p ^ 0x70D6E10C0CE9L;
        if (point == null) {
            MouseAwareTreeCellRendererPanel.a(0);
        }
        if ((n2 = this.tree.getRowForPath(treePath = this.tree.getClosestPathForLocation(point.x, point.y))) >= 0 && this.isHighlightEnabled(n2, Objects.requireNonNull(treePath).getLastPathComponent())) {
            boolean bl2;
            boolean bl3;
            boolean bl4 = this.tree.isRowSelected(n2);
            boolean bl5 = this.tree.isExpanded(n2);
            Object object = Objects.requireNonNull(treePath).getLastPathComponent();
            Component component2 = this.getTreeCellRendererComponent(this.tree, object, bl4, bl5, bl3 = this.tree.getModel().isLeaf(object), n2, bl2 = this.tree.hasFocus());
            if (component2 != this) {
                throw new IllegalStateException("MouseAwareTreeCellRendererPanel must return itself");
            }
            Rectangle rectangle = this.tree.getRowBounds(n2);
            component2.setBounds(rectangle);
            component2.validate();
            for (JComponent jComponent : this.getHighlightables()) {
                Rectangle rectangle2 = jComponent.getBounds();
                rectangle2.x += rectangle.x;
                rectangle2.y += rectangle.y;
                if (!rectangle2.contains(point)) continue;
                if (!this.a.equalsTo(jComponent, rectangle2, object, n2)) {
                    this.a.repaint(this.tree);
                    this.a.setComponent(jComponent, rectangle2, object, n2);
                    if (this.isUpdateCursor) {
                        this.tree.setCursor(Cursor.getPredefinedCursor(12));
                    }
                    this.tree.repaint(rectangle2);
                }
                return;
            }
        }
        this.a.repaint(this.tree);
        this.a.clear();
        if (this.isUpdateCursor && this.tree.getRowCount() > 0) {
            this.tree.setCursor(Cursor.getDefaultCursor());
        }
    }

    private static /* synthetic */ void a(int n2) {
        long l2 = p ^ 0x7B10E23D3AADL;
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mousePosition", "com/intellij/profiler/ui/treetable/MouseAwareTreeCellRendererPanel", "processMouseMovements"));
    }

    private static final class HighlightState {
        private JComponent b;
        private final Rectangle c = new Rectangle();
        private Object a;
        private int d = -1;

        private HighlightState() {
        }

        public void setComponent(JComponent component2, Rectangle componentBounds, Object value, int row) {
            this.b = component2;
            this.c.setBounds(componentBounds);
            this.a = value;
            this.d = row;
        }

        public void clear() {
            this.b = null;
            this.c.setBounds(0, 0, 0, 0);
            this.a = null;
            this.d = -1;
        }

        public boolean equalsTo(JComponent component2, Rectangle componentBounds, Object value, int row) {
            return row == this.d && component2 == this.b && Objects.equals(componentBounds, this.c) && Objects.equals(value, this.a);
        }

        public void repaint(JTree tree) {
            if (this.b != null) {
                tree.repaint(this.c);
            }
        }
    }
}

