/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import a.j.lb;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeCursor;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.impl.builder.ComparableEdge;
import com.intellij.openapi.graph.impl.builder.ComparableNode;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.util.Key;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.ContainerUtil;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class GraphImplUtil {
    @NotNull
    public static final Key<?> NODE_DRAGGED_INFO;
    private static final long a;

    private GraphImplUtil() {
    }

    @RequiresReadLock
    @Nullable
    public static <N, E> Node getExistedNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (dataMaps == null) {
            GraphImplUtil.a(0);
        }
        if (name == null) {
            GraphImplUtil.a(1);
        }
        if (equalityObjects == null) {
            GraphImplUtil.a(2);
        }
        ComparableNode comparableNode = GraphImplUtil.a(name, equalityObjects);
        Map<Node, ComparableNode> map2 = dataMaps.getNodeEqualityDataMap();
        return (Node)ContainerUtil.find(map2.keySet(), node2 -> comparableNode.equals(map2.get(node2)));
    }

    @RequiresReadLock
    @Nullable
    public static <N, E> Edge getExistedEdge(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node1, @NotNull Node node2, @NotNull String name, Object ... equalityObjects) {
        if (dataMaps == null) {
            GraphImplUtil.a(3);
        }
        if (node1 == null) {
            GraphImplUtil.a(4);
        }
        if (node2 == null) {
            GraphImplUtil.a(5);
        }
        if (name == null) {
            GraphImplUtil.a(6);
        }
        if (equalityObjects == null) {
            GraphImplUtil.a(7);
        }
        ComparableEdge comparableEdge = GraphImplUtil.a(dataMaps, name, node1, node2, equalityObjects);
        Map<Edge, ComparableEdge> map2 = dataMaps.getEdgeEqualityDataMap();
        return (Edge)ContainerUtil.find(map2.keySet(), edge -> comparableEdge.equals(map2.get(edge)));
    }

    @RequiresReadLock
    @NotNull
    public static List<Node> getNodes(@NotNull Graph graph) {
        if (graph == null) {
            GraphImplUtil.a(8);
        }
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Node> arrayList = new ArrayList<Node>(Arrays.asList(graph.getNodeArray()));
        Arrays.stream(graph.getNodeArray()).filter(node2 -> hierarchyManager.isFolderNode(node2)).flatMap(node2 -> GraphImplUtil.getNodes(hierarchyManager.getInnerGraph(node2)).stream()).forEach(arrayList::add);
        ArrayList<Node> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.a(9);
        }
        return arrayList2;
    }

    @RequiresReadLock
    @NotNull
    public static List<Edge> getEdges(@NotNull Graph graph) {
        if (graph == null) {
            GraphImplUtil.a(10);
        }
        HierarchyManager hierarchyManager = HierarchyManager.Statics.getInstance((Graph)graph);
        ArrayList<Edge> arrayList = new ArrayList<Edge>(Arrays.asList(graph.getEdgeArray()));
        Arrays.stream(graph.getNodeArray()).filter(node2 -> hierarchyManager.isFolderNode(node2)).flatMap(node2 -> GraphImplUtil.getEdges(hierarchyManager.getInnerGraph(node2)).stream()).forEach(arrayList::add);
        ArrayList<Edge> arrayList2 = arrayList;
        if (arrayList2 == null) {
            GraphImplUtil.a(11);
        }
        return arrayList2;
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Node createNode(@NotNull Graph graph, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (graph == null) {
            GraphImplUtil.a(12);
        }
        if (dataMaps == null) {
            GraphImplUtil.a(13);
        }
        if (name == null) {
            GraphImplUtil.a(14);
        }
        if (equalityObjects == null) {
            GraphImplUtil.a(15);
        }
        return GraphImplUtil.createNode(graph, null, dataMaps, name, equalityObjects);
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Node createNode(@NotNull Graph rootGraph, @Nullable Graph innerGraph, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull String name, Object ... equalityObjects) {
        if (rootGraph == null) {
            GraphImplUtil.a(16);
        }
        if (dataMaps == null) {
            GraphImplUtil.a(17);
        }
        if (name == null) {
            GraphImplUtil.a(18);
        }
        if (equalityObjects == null) {
            GraphImplUtil.a(19);
        }
        Node node2 = innerGraph == null ? rootGraph.createNode() : innerGraph.createNode();
        GraphImplUtil.setNodeName(dataMaps, node2, name);
        dataMaps.getNodeEqualityDataMap().put(node2, GraphImplUtil.a(name, equalityObjects));
        Node node3 = node2;
        if (node3 == null) {
            GraphImplUtil.a(20);
        }
        return node3;
    }

    @NotNull
    private static ComparableNode a(@NotNull String string, Object ... objectArray) {
        if (string == null) {
            GraphImplUtil.a(21);
        }
        if (objectArray == null) {
            GraphImplUtil.a(22);
        }
        return new ComparableNode("", objectArray);
    }

    @NotNull
    private static <N, E> ComparableEdge a(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull String string, @NotNull Node node2, @NotNull Node node3, Object ... objectArray) {
        if (graphDataMaps == null) {
            GraphImplUtil.a(23);
        }
        if (string == null) {
            GraphImplUtil.a(24);
        }
        if (node2 == null) {
            GraphImplUtil.a(25);
        }
        if (node3 == null) {
            GraphImplUtil.a(26);
        }
        if (objectArray == null) {
            GraphImplUtil.a(27);
        }
        return new ComparableEdge(string, GraphImplUtil.b(graphDataMaps, node2), GraphImplUtil.b(graphDataMaps, node3), objectArray);
    }

    @NotNull
    private static <N, E> ComparableNode b(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node2) {
        if (graphDataMaps == null) {
            GraphImplUtil.a(28);
        }
        if (node2 == null) {
            GraphImplUtil.a(29);
        }
        return GraphImplUtil.a(GraphImplUtil.getNodeName(graphDataMaps, node2), GraphImplUtil.a(graphDataMaps, node2));
    }

    @RequiresReadLock
    @NotNull
    public static <N, E> String getNodeName(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node2) {
        String string;
        if (graphDataMaps == null) {
            GraphImplUtil.a(30);
        }
        if (node2 == null) {
            GraphImplUtil.a(31);
        }
        String string2 = (string = graphDataMaps.getNodeNameDataMap().get(node2)) == null ? "" : string;
        if (string2 == null) {
            GraphImplUtil.a(32);
        }
        return string2;
    }

    @RequiresEdt
    public static <N, E> void setNodeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node2, @NotNull String name) {
        if (dataMaps == null) {
            GraphImplUtil.a(33);
        }
        if (node2 == null) {
            GraphImplUtil.a(34);
        }
        if (name == null) {
            GraphImplUtil.a(35);
        }
        dataMaps.getNodeNameDataMap().put(node2, name);
    }

    @RequiresEdt
    public static <N, E> void setNodeObject(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node2, @NotNull N nodeObject) {
        if (graphDataMaps == null) {
            GraphImplUtil.a(36);
        }
        if (node2 == null) {
            GraphImplUtil.a(37);
        }
        if (nodeObject == null) {
            GraphImplUtil.a(38);
        }
        graphDataMaps.getNodeObjectDataBiMap().forcePut((Object)node2, nodeObject);
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Node getOrCreateGroupNode(@NotNull Graph2D graph, @NotNull HierarchyManager hierarchyManager, @NotNull NodesGroup group2, @NotNull GraphDataMaps<N, E> dataMaps) {
        Node node2;
        if (graph == null) {
            GraphImplUtil.a(39);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.a(40);
        }
        if (group2 == null) {
            GraphImplUtil.a(41);
        }
        if (dataMaps == null) {
            GraphImplUtil.a(42);
        }
        if ((node2 = GraphImplUtil.a(graph, group2, hierarchyManager, dataMaps)) != null) {
            Node node3 = node2;
            if (node3 == null) {
                GraphImplUtil.a(43);
            }
            return node3;
        }
        NodesGroup nodesGroup = group2.getParent();
        if (nodesGroup != null) {
            Node node4 = GraphImplUtil.a(graph, nodesGroup, hierarchyManager, dataMaps);
            if (node4 == null) {
                node4 = GraphImplUtil.getOrCreateGroupNode(graph, hierarchyManager, group2.getParent(), dataMaps);
            }
            return GraphImplUtil.a(hierarchyManager, graph, group2, node4, dataMaps);
        }
        return GraphImplUtil.a(hierarchyManager, graph, group2, dataMaps);
    }

    @RequiresReadLock
    @Nullable
    public static <N, E> NodesGroup getGroup(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node groupNode) {
        if (dataMaps == null) {
            GraphImplUtil.a(44);
        }
        if (groupNode == null) {
            GraphImplUtil.a(45);
        }
        return dataMaps.getGroupNodeDataMap().get(groupNode);
    }

    @NotNull
    private static <N, E> Node a(@NotNull HierarchyManager hierarchyManager, @NotNull Graph2D graph2D, @NotNull NodesGroup nodesGroup, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (hierarchyManager == null) {
            GraphImplUtil.a(46);
        }
        if (graph2D == null) {
            GraphImplUtil.a(47);
        }
        if (nodesGroup == null) {
            GraphImplUtil.a(48);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.a(49);
        }
        return GraphImplUtil.a(hierarchyManager, graph2D, nodesGroup, null, graphDataMaps);
    }

    @NotNull
    private static <N, E> Node a(@NotNull HierarchyManager hierarchyManager, @NotNull Graph2D graph2D, @NotNull NodesGroup nodesGroup, @Nullable Node node2, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (hierarchyManager == null) {
            GraphImplUtil.a(50);
        }
        if (graph2D == null) {
            GraphImplUtil.a(51);
        }
        if (nodesGroup == null) {
            GraphImplUtil.a(52);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.a(53);
        }
        Node node3 = node2 != null ? hierarchyManager.createGroupNode(node2) : hierarchyManager.createGroupNode((Graph)graph2D);
        graph2D.setLabelText(node3, nodesGroup.getGroupName());
        if (nodesGroup.getGroupNodeRealizer() != null) {
            graph2D.setRealizer(node3, (NodeRealizer)nodesGroup.getGroupNodeRealizer());
        }
        graphDataMaps.getGroupNodeDataMap().put(node3, nodesGroup);
        Node node4 = node3;
        if (node4 == null) {
            GraphImplUtil.a(54);
        }
        return node4;
    }

    @Nullable
    private static <N, E> Node a(@NotNull Graph2D graph2D, @NotNull NodesGroup nodesGroup, @NotNull HierarchyManager hierarchyManager, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (graph2D == null) {
            GraphImplUtil.a(55);
        }
        if (nodesGroup == null) {
            GraphImplUtil.a(56);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.a(57);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.a(58);
        }
        for (Node node2 : graph2D.getNodeArray()) {
            if (!hierarchyManager.isFolderNode(node2) && !hierarchyManager.isGroupNode(node2)) continue;
            if (nodesGroup.equals(GraphImplUtil.getGroupNode(graphDataMaps, node2))) {
                return node2;
            }
            Node node3 = GraphImplUtil.a(nodesGroup, hierarchyManager, hierarchyManager.getChildren(node2), graphDataMaps);
            if (node3 == null) continue;
            return node3;
        }
        return null;
    }

    @Nullable
    private static <N, E> Node a(@NotNull NodesGroup nodesGroup, @NotNull HierarchyManager hierarchyManager, @NotNull NodeCursor nodeCursor, @NotNull GraphDataMaps<N, E> graphDataMaps) {
        if (nodesGroup == null) {
            GraphImplUtil.a(59);
        }
        if (hierarchyManager == null) {
            GraphImplUtil.a(60);
        }
        if (nodeCursor == null) {
            GraphImplUtil.a(61);
        }
        if (graphDataMaps == null) {
            GraphImplUtil.a(62);
        }
        while (nodeCursor.ok()) {
            Node node2 = nodeCursor.node();
            if (nodesGroup.equals(GraphImplUtil.getGroupNode(graphDataMaps, node2))) {
                return node2;
            }
            Node node3 = GraphImplUtil.a(nodesGroup, hierarchyManager, hierarchyManager.getChildren(node2), graphDataMaps);
            if (node3 != null) {
                return node3;
            }
            nodeCursor.next();
        }
        return null;
    }

    @RequiresReadLock
    @Nullable
    public static <N, E> NodesGroup getGroupNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node2) {
        if (dataMaps == null) {
            GraphImplUtil.a(63);
        }
        if (node2 == null) {
            GraphImplUtil.a(64);
        }
        return dataMaps.getGroupNodeDataMap().get(node2);
    }

    @RequiresReadLock
    public static <N, E> boolean isGroupNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node2) {
        if (dataMaps == null) {
            GraphImplUtil.a(65);
        }
        if (node2 == null) {
            GraphImplUtil.a(66);
        }
        return dataMaps.getGroupNodeDataMap().get(node2) != null;
    }

    @RequiresEdt
    public static <N, E> void setEdgeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge, @NotNull E edgeObject) {
        if (dataMaps == null) {
            GraphImplUtil.a(67);
        }
        if (edge == null) {
            GraphImplUtil.a(68);
        }
        if (edgeObject == null) {
            GraphImplUtil.a(69);
        }
        dataMaps.getEdgeObjectDataBiMap().forcePut((Object)edge, edgeObject);
    }

    @RequiresReadLock
    @Nullable
    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull E e10) {
        if (dataMaps == null) {
            GraphImplUtil.a(70);
        }
        if (e10 == null) {
            GraphImplUtil.a(71);
        }
        return dataMaps.getEdgeNameDataMap().get(GraphImplUtil.getEdge(dataMaps, e10));
    }

    @RequiresReadLock
    @NotNull
    public static <N, E> String getEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        String string;
        if (dataMaps == null) {
            GraphImplUtil.a(72);
        }
        if (edge == null) {
            GraphImplUtil.a(73);
        }
        String string2 = (string = dataMaps.getEdgeNameDataMap().get(edge)) == null ? "" : string;
        if (string2 == null) {
            GraphImplUtil.a(74);
        }
        return string2;
    }

    @RequiresEdt
    public static <N, E> void setEdgeName(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge, @NotNull String name) {
        if (dataMaps == null) {
            GraphImplUtil.a(75);
        }
        if (edge == null) {
            GraphImplUtil.a(76);
        }
        if (name == null) {
            GraphImplUtil.a(77);
        }
        dataMaps.getEdgeNameDataMap().put(edge, name);
    }

    @RequiresEdt
    @NotNull
    public static <N, E> Edge createEdge(@NotNull Graph2D graph, @NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node1, @NotNull Node node2, @NotNull String name, Object @NotNull [] equalityObjects) {
        if (graph == null) {
            GraphImplUtil.a(78);
        }
        if (dataMaps == null) {
            GraphImplUtil.a(79);
        }
        if (node1 == null) {
            GraphImplUtil.a(80);
        }
        if (node2 == null) {
            GraphImplUtil.a(81);
        }
        if (name == null) {
            GraphImplUtil.a(82);
        }
        if (equalityObjects == null) {
            GraphImplUtil.a(83);
        }
        Edge edge = HierarchyManager.Statics.getInstance((Graph)graph).createEdge(node1, node2);
        GraphImplUtil.setEdgeName(dataMaps, edge, name);
        dataMaps.getEdgeEqualityDataMap().put(edge, GraphImplUtil.a(dataMaps, name, node1, node2, equalityObjects));
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphImplUtil.a(84);
        }
        return edge2;
    }

    @RequiresReadLock
    @Nullable
    public static <N, E> N getNodeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node2) {
        if (dataMaps == null) {
            GraphImplUtil.a(85);
        }
        if (node2 == null) {
            GraphImplUtil.a(86);
        }
        return (N)dataMaps.getNodeObjectDataBiMap().get((Object)node2);
    }

    @RequiresReadLock
    @Nullable
    public static <N, E> E getEdgeObject(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Edge edge) {
        if (dataMaps == null) {
            GraphImplUtil.a(87);
        }
        if (edge == null) {
            GraphImplUtil.a(88);
        }
        return (E)dataMaps.getEdgeObjectDataBiMap().get((Object)edge);
    }

    @RequiresReadLock
    @Nullable
    public static <N, E> Node getNode(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull N node2) {
        if (dataMaps == null) {
            GraphImplUtil.a(89);
        }
        if (node2 == null) {
            GraphImplUtil.a(90);
        }
        return (Node)dataMaps.getNodeObjectDataBiMap().inverse().get(node2);
    }

    @RequiresReadLock
    @Nullable
    public static <N, E> Edge getEdge(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull E edge) {
        if (dataMaps == null) {
            GraphImplUtil.a(91);
        }
        if (edge == null) {
            GraphImplUtil.a(92);
        }
        return (Edge)dataMaps.getEdgeObjectDataBiMap().inverse().get(edge);
    }

    @RequiresEdt
    public static <N, E> void setNodeWasDragged(@NotNull GraphDataMaps<N, E> dataMaps, @NotNull Node node2) {
        if (dataMaps == null) {
            GraphImplUtil.a(93);
        }
        if (node2 == null) {
            GraphImplUtil.a(94);
        }
        dataMaps.getDraggedNodesList().add(node2);
    }

    @RequiresEdt
    public static <N, E> void updateDraggedNodesInfo(@NotNull GraphBuilderImpl<N, E> builder) {
        if (builder == null) {
            GraphImplUtil.a(95);
        }
        GraphDataMaps<N, E> graphDataMaps = builder.getDataMaps();
        for (Node node2 : builder.getGraph().getNodeArray()) {
            if (!graphDataMaps.getDraggedNodesList().contains(node2)) continue;
            if ((builder.getGraphUpdateModel().isNodeWasUpdated(node2) || builder.getGraphUpdateModel().isNodeWasCreated(node2)) && !GraphImplUtil.a(builder, node2)) {
                builder.getGraphUpdateModel().setNodeWasViewed(node2);
                graphDataMaps.getDraggedNodesList().remove(node2);
                continue;
            }
            GraphImplUtil.a(builder, node2);
        }
    }

    private static <N, E> boolean a(@NotNull GraphBuilderImpl<N, E> graphBuilderImpl, @NotNull Node node2) {
        if (graphBuilderImpl == null) {
            GraphImplUtil.a(96);
        }
        if (node2 == null) {
            GraphImplUtil.a(97);
        }
        return NODE_DRAGGED_INFO.equals(graphBuilderImpl.getGraphUpdateModel().getNodeUpdatesDataMap().get((Object)node2));
    }

    private static <N, E> void a(@NotNull GraphBuilderImpl<N, E> graphBuilderImpl, @NotNull Node node2) {
        if (graphBuilderImpl == null) {
            GraphImplUtil.a(98);
        }
        if (node2 == null) {
            GraphImplUtil.a(99);
        }
        graphBuilderImpl.getGraphUpdateModel().getNodeUpdatesDataMap().set((Object)node2, NODE_DRAGGED_INFO);
    }

    @Nullable
    private static <N, E> ComparableNode a(@NotNull GraphDataMaps<N, E> graphDataMaps, @NotNull Node node2) {
        if (graphDataMaps == null) {
            GraphImplUtil.a(100);
        }
        if (node2 == null) {
            GraphImplUtil.a(101);
        }
        return graphDataMaps.getNodeEqualityDataMap().get(node2);
    }

    static {
        a = lb.a(-4819706979847683177L, -5857634834719834182L, MethodHandles.lookup().lookupClass()).a(30369899444609L);
        long l2 = a ^ 0x51C20AFE68EDL;
        NODE_DRAGGED_INFO = Key.create((String)"NODE_DRAGGED_INFO");
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = a ^ 0x6336EE16F04EL;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 11: 
            case 20: 
            case 32: 
            case 43: 
            case 54: 
            case 74: 
            case 84: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 9: 
            case 11: 
            case 20: 
            case 32: 
            case 43: 
            case 54: 
            case 74: 
            case 84: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataMaps";
                break;
            }
            case 1: 
            case 6: 
            case 14: 
            case 18: 
            case 21: 
            case 24: 
            case 35: 
            case 77: 
            case 82: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 7: 
            case 15: 
            case 19: 
            case 22: 
            case 27: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "equalityObjects";
                break;
            }
            case 4: 
            case 80: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 5: 
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 8: 
            case 10: 
            case 12: 
            case 23: 
            case 39: 
            case 47: 
            case 51: 
            case 55: 
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 9: 
            case 11: 
            case 20: 
            case 32: 
            case 43: 
            case 54: 
            case 74: 
            case 84: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootGraph";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromNode";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toNode";
                break;
            }
            case 30: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphDataMaps";
                break;
            }
            case 31: 
            case 34: 
            case 37: 
            case 64: 
            case 66: 
            case 86: 
            case 90: 
            case 94: 
            case 97: 
            case 99: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject";
                break;
            }
            case 40: 
            case 46: 
            case 50: 
            case 57: 
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchyManager";
                break;
            }
            case 41: 
            case 48: 
            case 52: 
            case 56: 
            case 59: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupNode";
                break;
            }
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 68: 
            case 73: 
            case 76: 
            case 88: 
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edge";
                break;
            }
            case 69: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeObject";
                break;
            }
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 95: 
            case 96: 
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphImplUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "createNode";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 43: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateGroupNode";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupNode";
                break;
            }
            case 74: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeName";
                break;
            }
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdge";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getExistedNode";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExistedEdge";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
            case 9: 
            case 11: 
            case 20: 
            case 32: 
            case 43: 
            case 54: 
            case 74: 
            case 84: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getEdges";
                break;
            }
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createComparableNode";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "createComparableEdge";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getComparableNode";
                break;
            }
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 33: 
            case 34: 
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "setNodeName";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "setNodeObject";
                break;
            }
            case 39: 
            case 40: 
            case 41: 
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateGroupNode";
                break;
            }
            case 44: 
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getGroup";
                break;
            }
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "createGroupNode";
                break;
            }
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "findGroupNode";
                break;
            }
            case 59: 
            case 60: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "findChildrenGroupNode";
                break;
            }
            case 63: 
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "getGroupNode";
                break;
            }
            case 65: 
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "isGroupNode";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeObject";
                break;
            }
            case 70: 
            case 71: 
            case 72: 
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeName";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "setEdgeName";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 85: 
            case 86: {
                objectArray = objectArray;
                objectArray[2] = "getNodeObject";
                break;
            }
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "getEdgeObject";
                break;
            }
            case 89: 
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "getEdge";
                break;
            }
            case 93: 
            case 94: {
                objectArray = objectArray;
                objectArray[2] = "setNodeWasDragged";
                break;
            }
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "updateDraggedNodesInfo";
                break;
            }
            case 96: 
            case 97: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedNodeWasDragged";
                break;
            }
            case 98: 
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "setDraggedUpdateInfo";
                break;
            }
            case 100: 
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "getNodeComparableObject";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 11: 
            case 20: 
            case 32: 
            case 43: 
            case 54: 
            case 74: 
            case 84: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

