/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.graph.base.DataProvider;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.BasicPopupMode;
import com.intellij.openapi.graph.impl.builder.GraphBuilderImpl;
import com.intellij.openapi.graph.impl.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.HitInfo;
import com.intellij.openapi.graph.view.NodeCellRendererPainter;
import com.intellij.openapi.graph.view.NodeRealizer;
import com.intellij.openapi.graph.view.PopupMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import java.awt.event.MouseEvent;
import java.util.EventObject;

public class GraphEditModeFactoryImpl
extends GraphEditModeFactory {
    @Override
    public <N, E> EditMode createEditMode(final GraphBuilderImpl<N, E> builder) {
        final GraphPresentationModel<N, E> graphPresentationModel = builder.getGraphPresentationModel();
        return new EditMode(){

            public String getNodeTip(Node node2) {
                Object n2 = builder.getNodeObject(node2);
                return n2 == null ? null : graphPresentationModel.getNodeTooltip(n2);
            }

            public String getEdgeTip(Edge edge) {
                Object e10 = builder.getEdgeObject(edge);
                return e10 == null ? null : graphPresentationModel.getEdgeTooltip(e10);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    if (!builder.isUpdating()) {
                        HitInfo hitInfo = this.getHitInfo(mouseEvent);
                        Node node2 = hitInfo.getHitNode();
                        Edge edge = hitInfo.getHitEdge();
                        if (node2 != null) {
                            Graph2D graph2D = builder.getGraph();
                            NodeRealizer nodeRealizer = graph2D.getRealizer(node2);
                            if (nodeRealizer instanceof GroupNodeRealizer) {
                                GroupNodeRealizer groupNodeRealizer = (GroupNodeRealizer)nodeRealizer;
                                NodesGroup nodesGroup = GraphImplUtil.getGroup(builder.getDataMaps(), node2);
                                if (builder.getHierarchyManager().isFolderNode(node2)) {
                                    builder.getHierarchyManager().openFolder(node2);
                                    groupNodeRealizer.setGroupClosed(false);
                                    if (nodesGroup != null) {
                                        nodesGroup.setClosed(false);
                                    }
                                } else {
                                    builder.getHierarchyManager().closeGroup(node2);
                                    groupNodeRealizer.setGroupClosed(true);
                                    if (nodesGroup != null) {
                                        nodesGroup.setClosed(true);
                                    }
                                    GraphViewUtil.setRenderedNodeSizes((Graph2D)builder.getGraph(), (Graph2DView)builder.getView(), (Node)node2);
                                }
                                GraphViewUtil.updateWorldRect((Graph2DView)builder.getView());
                                builder.getGraph().updateViews();
                            }
                            super.mouseClicked(mouseEvent);
                        } else if (edge != null) {
                            graphPresentationModel.editEdge(builder.getEdgeObject(edge));
                        }
                    }
                } else {
                    super.mouseClicked(mouseEvent);
                }
            }

            public boolean editNode(Node node2, EventObject eventObject) {
                Object n2 = builder.getNodeObject(node2);
                return graphPresentationModel.editNode(n2) || super.editNode(node2, eventObject);
            }
        };
    }

    @Override
    public <N, E> PopupMode createPopupMode(final GraphBuilderImpl<N, E> builder) {
        final GraphPresentationModel<N, E> graphPresentationModel = builder.getGraphPresentationModel();
        return new BasicPopupMode(graphPresentationModel){

            @Override
            protected DefaultActionGroup getNodeActions(Node node2) {
                return graphPresentationModel.getNodeActionGroup(builder.getNodeObject(node2));
            }

            @Override
            protected DefaultActionGroup getEdgeActions(Edge edge) {
                return graphPresentationModel.getEdgeActionGroup(builder.getEdgeObject(edge));
            }

            @Override
            protected DefaultActionGroup getPaperPopupActions() {
                return graphPresentationModel.getPaperActionGroup();
            }
        };
    }

    @Override
    public <N, E> CellEditorMode createCellEditorMode(GraphBuilderImpl<N, E> builder) {
        return new CellEditorMode(GraphEditModeFactoryImpl.a(builder), NodeCellRendererPainter.USER_DATA_MAP){};
    }

    private static <N, E> DataProvider a(final GraphBuilderImpl<N, E> graphBuilderImpl) {
        return new DataProvider(){

            public Object get(Object dataHolder) {
                return graphBuilderImpl.getGraphPresentationModel().getCustomNodeCellEditor(graphBuilderImpl.getNodeObject((Node)dataHolder));
            }

            public int getInt(Object dataHolder) {
                return 0;
            }

            public double getDouble(Object dataHolder) {
                return 0.0;
            }

            public boolean getBool(Object dataHolder) {
                return false;
            }
        };
    }
}

