/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.graph.impl.builder;

import a.j.lb;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.graph.GraphDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.GraphUtil;
import com.intellij.openapi.graph.base.Edge;
import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.base.Node;
import com.intellij.openapi.graph.base.NodeList;
import com.intellij.openapi.graph.builder.CustomGraphUpdater;
import com.intellij.openapi.graph.builder.DeleteProvider;
import com.intellij.openapi.graph.builder.GraphBuilder;
import com.intellij.openapi.graph.builder.GraphDataModel;
import com.intellij.openapi.graph.builder.GraphPresentationModel;
import com.intellij.openapi.graph.builder.NodesGroup;
import com.intellij.openapi.graph.builder.components.BasicGraphPresentationModel;
import com.intellij.openapi.graph.builder.event.GraphBuilderEvent;
import com.intellij.openapi.graph.builder.event.GraphBuilderListener;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.impl.builder.EdgeCreationPolicyAdapter;
import com.intellij.openapi.graph.impl.builder.GraphDataMaps;
import com.intellij.openapi.graph.impl.builder.GraphEditModeFactory;
import com.intellij.openapi.graph.impl.builder.GraphImplUtil;
import com.intellij.openapi.graph.impl.builder.GraphUpdateModel;
import com.intellij.openapi.graph.impl.builder.GraphViewController;
import com.intellij.openapi.graph.impl.builder.YBundlesInitializer;
import com.intellij.openapi.graph.view.BridgeCalculator;
import com.intellij.openapi.graph.view.CellEditorMode;
import com.intellij.openapi.graph.view.DefaultGraph2DRenderer;
import com.intellij.openapi.graph.view.EdgeLabel;
import com.intellij.openapi.graph.view.EdgeRealizer;
import com.intellij.openapi.graph.view.EditMode;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.graph.view.Graph2DRenderer;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.MagnifierViewMode;
import com.intellij.openapi.graph.view.NavigationMode;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.graph.view.View2DConstants;
import com.intellij.openapi.graph.view.ViewMode;
import com.intellij.openapi.graph.view.hierarchy.GroupNodeRealizer;
import com.intellij.openapi.graph.view.hierarchy.HierarchyManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.MathUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.DefaultFocusTraversalPolicy;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class GraphBuilderImpl<N, E>
extends GraphBuilder<N, E> {
    @NotNull
    private static final Logger d;
    @NotNull
    private final Project r;
    @NotNull
    private final Graph2DView i;
    @NotNull
    private final Graph2D m;
    @NotNull
    private final HierarchyManager g;
    @NotNull
    private final GraphDataMaps<N, E> n;
    @NotNull
    private final GraphUpdateModel o;
    @NotNull
    private final GraphDataModel<N, E> b;
    @NotNull
    private final GraphPresentationModel<N, E> f;
    @NotNull
    private final MergingUpdateQueue a;
    @NotNull
    private final AtomicBoolean h;
    @NotNull
    private final AtomicBoolean l;
    @NotNull
    private final AtomicBoolean p;
    @NotNull
    private final NotNullLazyValue<Overview> q;
    @NotNull
    private final EditMode c;
    @NotNull
    private ViewMode k;
    @NotNull
    private final Set<CustomGraphUpdater> j;
    @NotNull
    private final EventDispatcher<GraphBuilderListener> e;
    private static final long s;

    public GraphBuilderImpl(@NotNull Project project, @NotNull Graph2D graph, @NotNull Graph2DView view, @NotNull GraphDataModel<N, E> graphDataModel, @NotNull GraphPresentationModel<N, E> graphPresentationModel) {
        long l2 = s ^ 0xC9B0D5283B6L;
        if (project == null) {
            GraphBuilderImpl.a(0);
        }
        if (graph == null) {
            GraphBuilderImpl.a(1);
        }
        if (view == null) {
            GraphBuilderImpl.a(2);
        }
        if (graphDataModel == null) {
            GraphBuilderImpl.a(3);
        }
        if (graphPresentationModel == null) {
            GraphBuilderImpl.a(4);
        }
        this.h = new AtomicBoolean(false);
        this.l = new AtomicBoolean(false);
        this.p = new AtomicBoolean(false);
        this.j = new HashSet<CustomGraphUpdater>();
        this.e = EventDispatcher.create(GraphBuilderListener.class);
        this.r = project;
        this.m = graph;
        this.i = view;
        this.q = NotNullLazyValue.atomicLazy(this::createOverview);
        this.n = new GraphDataMaps();
        this.g = GraphManager.getGraphManager().createHierarchyManager((Graph)this.getGraph());
        this.b = graphDataModel;
        this.f = graphPresentationModel;
        this.o = new GraphUpdateModel((Graph)graph);
        this.a = new MergingUpdateQueue("YFiles", 100, true, this.i.getJComponent(), (Disposable)this, null, true);
        this.j();
        Disposer.register((Disposable)this, this.b);
        Disposer.register((Disposable)this, this.f);
        Disposer.register((Disposable)this, (Disposable)this.a);
        this.c = (EditMode)WriteAction.computeAndWait(() -> {
            this.i.setGraph2D(this.getGraph());
            this.i.getJComponent().setFocusTraversalPolicy(new DefaultFocusTraversalPolicy());
            EditMode editMode = this.createEditMode();
            MagnifierViewMode magnifierViewMode = new MagnifierViewMode();
            magnifierViewMode.setMagnifierRadius(200);
            GraphViewController.setupFor(this, this.e, editMode, new NavigationMode(), magnifierViewMode);
            return editMode;
        });
        this.k = this.c;
    }

    public final void initialize() {
        if (this.h.compareAndSet(false, true)) {
            WriteAction.runAndWait(() -> {
                this.c();
                this.updateGraph();
            });
        }
    }

    @RequiresEdt
    public void updateGraph(boolean doLayout) {
        try {
            this.updateDataModel();
            this.updateView(doLayout);
        }
        catch (ProcessCanceledException processCanceledException) {
            this.queueUpdate();
        }
    }

    @RequiresEdt
    public void updateDataModel() {
        if (!this.a()) {
            this.initialize();
        }
        this.f();
        GraphImplUtil.updateDraggedNodesInfo(this);
        this.a((Graph)this.getGraph());
        this.b((Graph)this.getGraph());
    }

    private void b(@NotNull Graph graph) {
        if (graph == null) {
            GraphBuilderImpl.a(5);
        }
        Set set = this.getDataMaps().getEdgeObjectDataBiMap().keySet();
        for (Edge edge : set.toArray(new Edge[0])) {
            if (this.isEdgeWasUpdated(edge)) continue;
            this.getDataMaps().removeEdge(edge);
        }
        for (Edge edge : graph.getEdgeArray()) {
            if (this.isEdgeWasUpdated(edge) || !graph.contains(edge)) continue;
            graph.removeEdge(edge);
        }
    }

    private void a(@NotNull Graph graph) {
        if (graph == null) {
            GraphBuilderImpl.a(6);
        }
        for (Node node2 : graph.getNodeArray()) {
            if (!this.isNodeWasUpdated(node2) && !this.a(node2)) {
                this.getDataMaps().removeNode(node2);
                graph.removeNode(node2);
            }
            if (!this.getHierarchyManager().isFolderNode(node2)) continue;
            this.a(this.getHierarchyManager().getInnerGraph(node2));
            this.b(this.getHierarchyManager().getInnerGraph(node2));
        }
    }

    private void c() {
        WriteAction.runAndWait(() -> {
            this.b();
            this.getGraphPresentationModel().customizeSettings(this.getView(), this.c);
        });
    }

    @RequiresEdt
    private void b() {
        long l2 = s ^ 0x47C0320D7D5AL;
        this.c.allowResizeNodes(false);
        this.c.allowNodeCreation(false);
        this.c.showNodeTips(true);
        this.c.showEdgeTips(true);
        this.c.allowEdgeCreation(true);
        this.c.allowMoveLabels(false);
        this.c.allowMovePorts(false);
        this.c.allowMoveSelection(true);
        Graph2DView graph2DView = this.getView();
        graph2DView.setAntialiasedPainting(Registry.is((String)"diagrams.rendering.antialiasing"));
        graph2DView.setFitContentOnResize(true);
        graph2DView.setGridVisible(false);
        graph2DView.setGridResolution(35.0);
        graph2DView.setGridColor((Color)JBColor.LIGHT_GRAY);
        graph2DView.setGridType(View2DConstants.GRID_POINTS);
    }

    @RequiresEdt
    @Nullable
    protected Overview createOverview() {
        Overview overview = GraphManager.getGraphManager().createOverview(this.getView());
        overview.getCanvasComponent().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e10) {
                GraphBuilderImpl.this.i.requestFocus();
            }
        });
        return overview;
    }

    @Nullable
    public Overview getOverview() {
        return (Overview)this.q.getValue();
    }

    @RequiresEdt
    @NotNull
    protected EditMode createEditMode() {
        GraphEditModeFactory graphEditModeFactory = (GraphEditModeFactory)ServiceManager.getService((Project)this.getProject(), GraphEditModeFactory.class);
        EditMode editMode = graphEditModeFactory.createEditMode(this);
        editMode.setPopupMode((ViewMode)graphEditModeFactory.createPopupMode(this));
        editMode.setCreateEdgeMode(new EdgeCreationPolicyAdapter(this.getGraphPresentationModel().getEdgeCreationPolicy(), this));
        CellEditorMode cellEditorMode = graphEditModeFactory.createCellEditorMode(this);
        editMode.assignNodeLabel(false);
        editMode.setEditNodeMode((ViewMode)cellEditorMode);
        EditMode editMode2 = editMode;
        if (editMode2 == null) {
            GraphBuilderImpl.a(7);
        }
        return editMode2;
    }

    @RequiresEdt
    public void updateView(boolean doLayout) {
        this.updateRealizers(false);
        this.i();
        this.e();
        this.h();
        for (CustomGraphUpdater customGraphUpdater : this.j) {
            customGraphUpdater.update(this.getGraph(), this.getView());
        }
        if (doLayout) {
            this.k();
        }
        this.getGraph().updateViews();
    }

    @RequiresEdt
    public void updateRealizers(boolean updateAllNodes) {
        for (Node node2 : GraphImplUtil.getNodes((Graph)this.getGraph())) {
            if (!GraphImplUtil.isGroupNode(this.getDataMaps(), node2) && (updateAllNodes || this.isNodeWasCreated(node2))) {
                this.getGraph().setRealizer(node2, this.getGraphPresentationModel().getNodeRealizer(this.getNodeObject(node2)));
            }
            GraphViewUtil.setRenderedNodeSizes((Graph2D)this.getGraph(), (Graph2DView)this.getView(), (Node)node2);
        }
        for (Edge edge : this.getGraph().getEdgeArray()) {
            if (this.isEdgeWasCreated(edge)) {
                this.getGraph().setRealizer(edge, this.getGraphPresentationModel().getEdgeRealizer(this.getEdgeObject(edge)));
                continue;
            }
            this.getGraph().setRealizer(edge, this.getGraph().getRealizer(edge));
        }
    }

    private void i() {
        for (Edge edge : this.getGraph().getEdgeArray()) {
            EdgeLabel[] edgeLabelArray;
            EdgeRealizer edgeRealizer = this.getGraph().getRealizer(edge);
            GraphBuilderImpl.a(edgeRealizer);
            for (EdgeLabel edgeLabel : edgeLabelArray = this.getGraphPresentationModel().getEdgeLabels(this.getEdgeObject(edge), GraphImplUtil.getEdgeName(this.getDataMaps(), edge))) {
                edgeRealizer.addLabel(edgeLabel);
            }
        }
    }

    private void e() {
        Graph2DView graph2DView = this.getView();
        Graph2DRenderer graph2DRenderer = graph2DView.getGraph2DRenderer();
        GraphPresentationModel<N, E> graphPresentationModel = this.getGraphPresentationModel();
        if (graph2DRenderer instanceof DefaultGraph2DRenderer && graphPresentationModel instanceof BasicGraphPresentationModel) {
            DefaultGraph2DRenderer defaultGraph2DRenderer = (DefaultGraph2DRenderer)graph2DRenderer;
            BasicGraphPresentationModel basicGraphPresentationModel = (BasicGraphPresentationModel)graphPresentationModel;
            BridgeCalculator bridgeCalculator = basicGraphPresentationModel.isShowBridges() ? basicGraphPresentationModel.createBridgeCalculator() : null;
            defaultGraph2DRenderer.setBridgeCalculator(bridgeCalculator);
        }
    }

    private static void a(@NotNull EdgeRealizer edgeRealizer) {
        if (edgeRealizer == null) {
            GraphBuilderImpl.a(8);
        }
        for (int i10 = 0; i10 < edgeRealizer.labelCount(); ++i10) {
            edgeRealizer.removeLabel(edgeRealizer.getLabel(i10));
        }
        edgeRealizer.setLabelText("");
    }

    private void k() {
        if (this.getGraph().nodeCount() > 0) {
            GraphUtil.doLayout((GraphBuilder)this);
            GraphViewUtil.updateWorldRect((Graph2DView)this.getView());
            this.getGraph().updateViews();
        }
    }

    public final boolean isUpdating() {
        return this.p.get();
    }

    public final void queueUpdate() {
        if (this.p.compareAndSet(false, true)) {
            ApplicationManager.getApplication().invokeLater(() -> {
                long l2 = s ^ 0x89E1F70D429L;
                final Cursor cursor = this.i.getJComponent().getCursor();
                this.i.getJComponent().setCursor(Cursor.getPredefinedCursor(3));
                this.a.queue(new Update("Update"){

                    public void run() {
                        GraphBuilderImpl.this.updateGraph(true);
                        GraphBuilderImpl.this.i.getJComponent().setCursor(cursor);
                        GraphBuilderImpl.this.p.set(false);
                    }
                });
            });
        }
    }

    @NotNull
    public GraphDataModel<N, E> getGraphDataModel() {
        GraphDataModel<N, E> graphDataModel = this.b;
        if (graphDataModel == null) {
            GraphBuilderImpl.a(9);
        }
        return graphDataModel;
    }

    @NotNull
    public String getNodeName(@NotNull Node node2) {
        if (node2 == null) {
            GraphBuilderImpl.a(10);
        }
        String string = GraphImplUtil.getNodeName(this.getDataMaps(), node2);
        if (string == null) {
            GraphBuilderImpl.a(11);
        }
        return string;
    }

    @Nullable
    public N getNodeObject(@Nullable Node node2) {
        return node2 != null ? (N)GraphImplUtil.getNodeObject(this.getDataMaps(), node2) : null;
    }

    @Nullable
    public E getEdgeObject(@Nullable Edge edge) {
        return edge != null ? (E)GraphImplUtil.getEdgeObject(this.getDataMaps(), edge) : null;
    }

    private void f() {
        this.getGraphUpdateModel().clearUpdateModel();
        GraphDataModel<N, E> graphDataModel = this.getGraphDataModel();
        for (Object e10 : graphDataModel.getNodes()) {
            this.addNode(graphDataModel.getNodeName(e10), e10);
        }
        for (Object e10 : graphDataModel.getEdges()) {
            this.addEdge(graphDataModel.getSourceNode(e10), graphDataModel.getTargetNode(e10), graphDataModel.getEdgeName(e10), e10);
        }
    }

    private void h() {
        NodeList nodeList;
        Object object3;
        Node node2;
        NodesGroup nodesGroup2;
        Object object22;
        Collection<N> collection = this.getNodeObjects();
        GraphManager graphManager = GraphManager.getGraphManager();
        HashMap hashMap = new HashMap();
        for (Object object22 : collection) {
            nodesGroup2 = this.getGraphDataModel().getGroup(object22);
            if (nodesGroup2 == null) {
                Graph graph;
                node2 = this.getNode(object22);
                if (node2 == null || this.getHierarchyManager().isRootGraph(node2.getGraph()) || (object3 = this.getHierarchyManager().getParentNode(node2)) == null) continue;
                if (this.getHierarchyManager().isFolderNode(object3)) {
                    graph = node2.getGraph();
                    nodeList = graphManager.createNodeList();
                    for (Node node3 : graph.getNodeArray()) {
                        if (this.a(node3)) continue;
                        nodeList.add((Object)node3);
                    }
                    this.getHierarchyManager().unfoldSubgraph(graph, nodeList);
                    continue;
                }
                if (!this.getHierarchyManager().isGroupNode(object3)) continue;
                graph = graphManager.createNodeList();
                graph.add((Object)node2);
                this.getHierarchyManager().ungroupSubgraph((NodeList)graph);
                continue;
            }
            if (hashMap.get(nodesGroup2) == null) {
                hashMap.put(nodesGroup2, new ArrayList());
            }
            ((ArrayList)hashMap.get(nodesGroup2)).add(object22);
        }
        ArrayList arrayList = new ArrayList();
        for (NodesGroup nodesGroup2 : hashMap.keySet()) {
            boolean bl2;
            node2 = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.g, nodesGroup2, this.getDataMaps());
            this.getGraphUpdateModel().setNodeWasViewed(node2);
            object3 = GraphImplUtil.getGroup(this.getDataMaps(), node2);
            boolean bl3 = bl2 = object3 != null ? object3.isClosed() : nodesGroup2.isClosed();
            if (bl2 && this.getHierarchyManager().isGroupNode(node2)) {
                arrayList.add(node2);
            }
            nodeList = graphManager.createNodeList();
            for (Object e10 : (ArrayList)hashMap.get(nodesGroup2)) {
                nodeList.add((Object)this.getNode(e10));
            }
            if (nodeList.size() <= 0 || !this.g.isGroupNode(node2)) continue;
            this.g.groupSubgraph(nodeList, node2);
        }
        object22 = arrayList.iterator();
        while (object22.hasNext()) {
            nodesGroup2 = (Node)object22.next();
            try {
                this.g.closeGroup((Node)nodesGroup2);
                node2 = this.getGraph().getRealizer((Node)nodesGroup2);
                if (!(node2 instanceof GroupNodeRealizer)) continue;
                ((GroupNodeRealizer)node2).setGroupClosed(true);
                object3 = this.g.getInnerGraph((Node)nodesGroup2);
                if (!(object3 instanceof Graph2D)) continue;
                this.k();
            }
            catch (Throwable throwable) {
                d.error(throwable);
            }
        }
        for (Object object3 : this.getGraph().getNodeArray()) {
            if (this.isNodeWasUpdated((Node)object3) || !this.a((Node)object3)) continue;
            this.getGraph().removeNode(object3);
        }
    }

    private boolean a(@NotNull Node node2) {
        if (node2 == null) {
            GraphBuilderImpl.a(12);
        }
        return this.g.isFolderNode(node2) || this.g.isGroupNode(node2);
    }

    public void addNode(N nodeObject) {
        String string = this.getGraphDataModel().getNodeName(nodeObject);
        this.addNode(string, nodeObject);
    }

    public void addNode(@NotNull String name, N nodeObject) {
        if (name == null) {
            GraphBuilderImpl.a(13);
        }
        this.addNode(name, nodeObject, nodeObject);
    }

    @RequiresEdt
    public void addNode(@NotNull String name, N nodeObject, Object ... equalityObjects) {
        Node node2;
        if (name == null) {
            GraphBuilderImpl.a(14);
        }
        if ((node2 = GraphImplUtil.getExistedNode(this.getDataMaps(), name, equalityObjects)) != null) {
            if (!this.getGraphUpdateModel().isNodeWasCreated(node2)) {
                this.getGraphUpdateModel().setNodeWasViewed(node2);
                GraphImplUtil.setNodeName(this.getDataMaps(), node2, name);
            }
        } else {
            node2 = GraphImplUtil.createNode((Graph)this.getGraph(), this.a(nodeObject), this.getDataMaps(), name, equalityObjects);
            this.getGraphUpdateModel().setNodeWasCreated(node2);
        }
        GraphImplUtil.setNodeObject(this.getDataMaps(), node2, nodeObject);
    }

    @Nullable
    private Graph a(N n2) {
        NodesGroup nodesGroup = this.getGraphDataModel().getGroup(n2);
        if (nodesGroup != null) {
            Node node2 = GraphImplUtil.getOrCreateGroupNode(this.getGraph(), this.getHierarchyManager(), nodesGroup, this.getDataMaps());
            if (this.getHierarchyManager().isFolderNode(node2)) {
                return this.getHierarchyManager().getInnerGraph(node2);
            }
        }
        return null;
    }

    @NotNull
    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(15);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(16);
        }
        Edge edge = this.addEdge(nodeObject1, nodeObject2, "", edgeObject);
        if (edge == null) {
            GraphBuilderImpl.a(17);
        }
        return edge;
    }

    @RequiresEdt
    @NotNull
    public Edge addEdge(@NotNull N nodeObject1, @NotNull N nodeObject2, @NotNull String name, E edgeObject) {
        if (nodeObject1 == null) {
            GraphBuilderImpl.a(18);
        }
        if (nodeObject2 == null) {
            GraphBuilderImpl.a(19);
        }
        if (name == null) {
            GraphBuilderImpl.a(20);
        }
        return this.a(nodeObject1, nodeObject2, name, edgeObject, edgeObject);
    }

    @NotNull
    private Edge a(@NotNull N n2, @NotNull N n3, @NotNull String string, E e10, Object ... objectArray) {
        if (n2 == null) {
            GraphBuilderImpl.a(21);
        }
        if (n3 == null) {
            GraphBuilderImpl.a(22);
        }
        if (string == null) {
            GraphBuilderImpl.a(23);
        }
        Node node2 = this.a(n2);
        Node node3 = this.a(n3);
        return this.a(node2, node3, string, e10, objectArray);
    }

    @NotNull
    private Edge a(@NotNull Node node2, @NotNull Node node3, @NotNull String string, E e10, Object ... objectArray) {
        Edge edge;
        if (node2 == null) {
            GraphBuilderImpl.a(24);
        }
        if (node3 == null) {
            GraphBuilderImpl.a(25);
        }
        if (string == null) {
            GraphBuilderImpl.a(26);
        }
        if ((edge = GraphImplUtil.getExistedEdge(this.getDataMaps(), node2, node3, string, objectArray)) != null) {
            if (!this.getGraphUpdateModel().isEdgeWasCreated(edge)) {
                this.getGraphUpdateModel().setEdgeWasViewed(edge);
            }
        } else {
            edge = GraphImplUtil.createEdge(this.getGraph(), this.getDataMaps(), node2, node3, string, objectArray);
            this.getGraphUpdateModel().setEdgeWasCreated(edge);
        }
        GraphImplUtil.setEdgeObject(this.getDataMaps(), edge, e10);
        Edge edge2 = edge;
        if (edge2 == null) {
            GraphBuilderImpl.a(27);
        }
        return edge2;
    }

    @NotNull
    private Node a(N n2) {
        Node node2 = this.getNode(n2);
        if (node2 == null) {
            this.addNode(n2);
            node2 = this.getNode(n2);
        }
        if (node2 == null) {
            d.error("null node for " + n2 + " in " + this.b);
        }
        Node node3 = node2;
        if (node3 == null) {
            GraphBuilderImpl.a(28);
        }
        return node3;
    }

    public void dispose() {
        if (this.l.compareAndSet(false, true)) {
            this.a.cancelAllUpdates();
            this.n.dispose();
        }
    }

    @Nullable
    public String getNodeName(@Nullable N nodeObject) {
        Node node2 = this.getNode(nodeObject);
        return node2 == null ? null : GraphImplUtil.getNodeName(this.getDataMaps(), node2);
    }

    @Nullable
    public String getEdgeName(@Nullable E edgeObject) {
        Edge edge = this.getEdge(edgeObject);
        return edge == null ? null : GraphImplUtil.getEdgeName(this.getDataMaps(), edge);
    }

    @Nullable
    public Node getNode(@Nullable N nodeObject) {
        return nodeObject == null ? null : GraphImplUtil.getNode(this.getDataMaps(), nodeObject);
    }

    @Nullable
    public Edge getEdge(@Nullable E edgeObject) {
        return edgeObject != null ? GraphImplUtil.getEdge(this.getDataMaps(), edgeObject) : null;
    }

    public boolean isNodeWasCreated(@Nullable Node node2) {
        return node2 != null && this.getGraphUpdateModel().isNodeWasCreated(node2);
    }

    public boolean isEdgeWasCreated(@Nullable Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasCreated(edge);
    }

    public boolean isNodeWasUpdated(@Nullable Node node2) {
        return node2 != null && this.getGraphUpdateModel().isNodeWasUpdated(node2);
    }

    public boolean isEdgeWasUpdated(@Nullable Edge edge) {
        return edge != null && this.getGraphUpdateModel().isEdgeWasUpdated(edge);
    }

    @RequiresReadLock
    @NotNull
    public final Graph2D getGraph() {
        Graph2D graph2D = this.m;
        if (graph2D == null) {
            GraphBuilderImpl.a(29);
        }
        return graph2D;
    }

    @RequiresReadLock
    @NotNull
    public Graph2DView getView() {
        Graph2DView graph2DView = this.i;
        if (graph2DView == null) {
            GraphBuilderImpl.a(30);
        }
        return graph2DView;
    }

    @NotNull
    public Project getProject() {
        Project project = this.r;
        if (project == null) {
            GraphBuilderImpl.a(31);
        }
        return project;
    }

    @NotNull
    public GraphUpdateModel getGraphUpdateModel() {
        GraphUpdateModel graphUpdateModel = this.o;
        if (graphUpdateModel == null) {
            GraphBuilderImpl.a(32);
        }
        return graphUpdateModel;
    }

    @NotNull
    public GraphPresentationModel<N, E> getGraphPresentationModel() {
        GraphPresentationModel<N, E> graphPresentationModel = this.f;
        if (graphPresentationModel == null) {
            GraphBuilderImpl.a(33);
        }
        return graphPresentationModel;
    }

    @RequiresReadLock
    public double getZoom() {
        return this.getView().getZoom();
    }

    public void setZoom(double zoom) {
        this.setZoom(zoom, true);
    }

    @RequiresEdt
    public void setZoom(double zoom, boolean fireEvents) {
        Graph2DView graph2DView;
        double d10;
        double d11 = MathUtil.clamp((double)zoom, (double)0.1, (double)20.0);
        if (Math.abs(d11 - (d10 = (graph2DView = this.getView()).getZoom())) > 0.01) {
            if (fireEvents) {
                this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
            }
            graph2DView.setZoom(d11);
            graph2DView.updateView();
            if (fireEvents) {
                this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
            }
        }
    }

    @RequiresEdt
    public void fitContent() {
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, true);
        Graph2DView graph2DView = this.getView();
        graph2DView.fitContent();
        graph2DView.updateView();
        this.fireEvent(GraphBuilderEvent.ZOOM_CHANGED, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireEvent(@NotNull GraphBuilderEvent event, boolean before) {
        if (event == null) {
            GraphBuilderImpl.a(34);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.e;
        synchronized (eventDispatcher) {
            if (before) {
                ((GraphBuilderListener)this.e.getMulticaster()).beforeActionPerformed((GraphBuilder)this, event);
            } else {
                ((GraphBuilderListener)this.e.getMulticaster()).actionPerformed((GraphBuilder)this, event);
            }
        }
    }

    private boolean a() {
        return this.h.get();
    }

    private void j() {
        GraphViewUtil.addDataProvider((Graph2DView)this.getView(), string -> {
            if (DeleteProvider.DELETE_PROVIDER.is(string)) {
                return this.getGraphPresentationModel().getDeleteProvider();
            }
            if (GraphDataKeys.GRAPH_BUILDER.is(string)) {
                return this;
            }
            return null;
        });
    }

    @NotNull
    public HierarchyManager getHierarchyManager() {
        HierarchyManager hierarchyManager = this.g;
        if (hierarchyManager == null) {
            GraphBuilderImpl.a(35);
        }
        return hierarchyManager;
    }

    public void addCustomUpdater(@NotNull CustomGraphUpdater updater) {
        if (updater == null) {
            GraphBuilderImpl.a(36);
        }
        this.j.add(updater);
    }

    @NotNull
    public EditMode getEditMode() {
        EditMode editMode = (EditMode)ReadAction.compute(() -> this.c);
        if (editMode == null) {
            GraphBuilderImpl.a(37);
        }
        return editMode;
    }

    @NotNull
    public ViewMode getActiveMode() {
        ViewMode viewMode = this.k;
        if (viewMode == null) {
            GraphBuilderImpl.a(38);
        }
        return viewMode;
    }

    @RequiresEdt
    void setActiveMode(@NotNull ViewMode activeMode) {
        if (activeMode == null) {
            GraphBuilderImpl.a(39);
        }
        this.k = activeMode;
    }

    @RequiresReadLock
    public boolean isCellEditing() {
        ViewMode viewMode = this.c.getEditNodeMode();
        return viewMode instanceof CellEditorMode && ((CellEditorMode)viewMode).isCellEditing();
    }

    @NotNull
    public GraphDataMaps<N, E> getDataMaps() {
        GraphDataMaps<N, E> graphDataMaps = this.n;
        if (graphDataMaps == null) {
            GraphBuilderImpl.a(40);
        }
        return graphDataMaps;
    }

    @RequiresReadLock
    @NotNull
    public Collection<N> getNodeObjects() {
        Collection collection = Collections.unmodifiableCollection(this.getDataMaps().getNodeObjectDataBiMap().values());
        if (collection == null) {
            GraphBuilderImpl.a(41);
        }
        return collection;
    }

    @RequiresReadLock
    @NotNull
    public Collection<E> getEdgeObjects() {
        Collection collection = Collections.unmodifiableCollection(this.getDataMaps().getEdgeObjectDataBiMap().values());
        if (collection == null) {
            GraphBuilderImpl.a(42);
        }
        return collection;
    }

    @RequiresEdt
    public boolean removeNode(@Nullable N n2) {
        Node node2 = this.getNode(n2);
        if (node2 != null) {
            node2.getGraph().removeNode(node2);
            this.getDataMaps().removeNode(node2);
            return true;
        }
        return false;
    }

    @RequiresEdt
    public boolean removeEdge(@Nullable E e10) {
        Edge edge = this.getEdge(e10);
        if (edge != null) {
            this.getGraph().removeEdge(edge);
            this.getDataMaps().removeEdge(edge);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addGraphBuilderListener(@NotNull GraphBuilderListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            GraphBuilderImpl.a(43);
        }
        if (parent == null) {
            GraphBuilderImpl.a(44);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.e;
        synchronized (eventDispatcher) {
            this.e.addListener((EventListener)listener, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeGraphBuilderListener(@NotNull GraphBuilderListener listener) {
        if (listener == null) {
            GraphBuilderImpl.a(45);
        }
        EventDispatcher<GraphBuilderListener> eventDispatcher = this.e;
        synchronized (eventDispatcher) {
            this.e.removeListener((EventListener)listener);
        }
    }

    static {
        s = lb.a(6773209022869958547L, 4384276412551321172L, MethodHandles.lookup().lookupClass()).a(278224005026553L);
        d = Logger.getInstance(GraphBuilderImpl.class);
        YBundlesInitializer.init();
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = s ^ 0x4FE0F8B34F73L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphDataModel";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graphPresentationModel";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "edgeRealizer";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 13: 
            case 14: 
            case 20: 
            case 23: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject1";
                break;
            }
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeObject2";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "updater";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeMode";
                break;
            }
            case 43: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/graph/impl/builder/GraphBuilderImpl";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditMode";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphDataModel";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeName";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "addEdge";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "createEdge";
                break;
            }
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateNode";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraph";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getView";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphUpdateModel";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphPresentationModel";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getHierarchyManager";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditMode";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveMode";
                break;
            }
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getDataMaps";
                break;
            }
            case 41: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeObjects";
                break;
            }
            case 42: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdgeObjects";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeOutdatedEdges";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeOutdatedNodes";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "clearLabels";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getNodeName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "isGroupNode";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "addNode";
                break;
            }
            case 15: 
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "fireEvent";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "addCustomUpdater";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "setActiveMode";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "addGraphBuilderListener";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "removeGraphBuilderListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 17: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: 
            case 37: 
            case 38: 
            case 40: 
            case 41: 
            case 42: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

