/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.psi.PsiElement;
import java.util.List;

public class TreePsiFragment
extends PsiFragment {
    private final NodeSpecificHasher h;

    public TreePsiFragment(NodeSpecificHasher hasher, PsiElement root, int cost) {
        super(root, cost);
        this.h = hasher;
    }

    public TreePsiFragment(NodeSpecificHasher hasher, List<? extends PsiElement> element2, int from, int to) {
        super(element2, from, to);
        this.h = hasher;
    }

    @Override
    public boolean isEqual(PsiElement[] elements, int discardCost) {
        if (elements.length != this.myElementAnchors.length) {
            return false;
        }
        for (int i10 = 0; i10 < this.myElementAnchors.length; ++i10) {
            PsiElement psiElement = this.myElementAnchors[i10].retrieve();
            PsiElement psiElement2 = elements[i10];
            if (psiElement != null && psiElement2 != null && this.h.areTreesEqual(psiElement, psiElement2, discardCost)) continue;
            return false;
        }
        return true;
    }
}

