/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator.treeHash;

import a.j.lb;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.NodeSpecificHasher;
import com.intellij.dupLocator.iterators.FilteringNodeIterator;
import com.intellij.dupLocator.iterators.SiblingNodeIterator;
import com.intellij.dupLocator.treeHash.DuplicatesMatchingVisitor;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.TreeHasherBase;
import com.intellij.dupLocator.util.DuplocatorUtil;
import com.intellij.dupLocator.util.NodeFilter;
import com.intellij.lang.Language;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeSpecificHasherBase
extends NodeSpecificHasher {
    private final TreeHasherBase a;
    private final DuplocatorSettings c;
    private final DuplicatesProfileBase d;
    private final NodeFilter b;
    protected final boolean myForIndexing;
    private static final long f = lb.a(7517732876166212146L, -2646207684339575366L, MethodHandles.lookup().lookupClass()).a(38236139569412L);

    private boolean a(PsiElement psiElement) {
        return this.b(psiElement) && !this.d.getDuplocatorState(this.d.getLanguage(psiElement)).distinguishLiterals();
    }

    public NodeSpecificHasherBase(@NotNull DuplocatorSettings settings, @NotNull FragmentsCollector callback2, @NotNull DuplicatesProfileBase duplicatesProfile) {
        if (settings == null) {
            NodeSpecificHasherBase.b(0);
        }
        if (callback2 == null) {
            NodeSpecificHasherBase.b(1);
        }
        if (duplicatesProfile == null) {
            NodeSpecificHasherBase.b(2);
        }
        this(settings, callback2, duplicatesProfile, false);
    }

    public NodeSpecificHasherBase(@NotNull DuplocatorSettings settings, @NotNull FragmentsCollector callback2, @NotNull DuplicatesProfileBase duplicatesProfile, boolean forIndexing) {
        if (settings == null) {
            NodeSpecificHasherBase.b(3);
        }
        if (callback2 == null) {
            NodeSpecificHasherBase.b(4);
        }
        if (duplicatesProfile == null) {
            NodeSpecificHasherBase.b(5);
        }
        this.b = new NodeFilter(){

            @Override
            public boolean accepts(PsiElement element2) {
                return DuplocatorUtil.isIgnoredNode(element2) || NodeSpecificHasherBase.this.a(element2);
            }
        };
        this.a = new TreeHasherBase(callback2, duplicatesProfile, forIndexing ? 0 : -1, forIndexing);
        this.c = settings;
        this.d = duplicatesProfile;
        this.myForIndexing = forIndexing;
    }

    @NotNull
    public NodeFilter getNodeFilter() {
        NodeFilter nodeFilter = this.b;
        if (nodeFilter == null) {
            NodeSpecificHasherBase.b(6);
        }
        return nodeFilter;
    }

    @Override
    public int getNodeHash(PsiElement node2) {
        if (node2 == null) {
            return 0;
        }
        if (node2 instanceof PsiWhiteSpace || node2 instanceof PsiErrorElement) {
            return 0;
        }
        if (node2 instanceof LeafElement) {
            if (this.a(node2)) {
                return 0;
            }
            return node2.getText().hashCode();
        }
        return node2.getClass().getName().hashCode();
    }

    private boolean b(PsiElement psiElement) {
        if (psiElement instanceof LeafElement) {
            IElementType iElementType = ((LeafElement)psiElement).getElementType();
            if (this.d.getLiterals().contains(iElementType)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getNodeCost(PsiElement node2) {
        return node2 != null ? this.d.getNodeCost(node2) : 0;
    }

    @Override
    public List<PsiElement> getNodeChildren(PsiElement node2) {
        ArrayList<PsiElement> arrayList = new ArrayList<PsiElement>();
        FilteringNodeIterator filteringNodeIterator = new FilteringNodeIterator(SiblingNodeIterator.create(node2.getFirstChild()), this.b);
        while (filteringNodeIterator.hasNext()) {
            arrayList.add(filteringNodeIterator.current());
            filteringNodeIterator.advance();
        }
        return arrayList;
    }

    @Override
    public boolean areNodesEqual(@NotNull PsiElement node1, @NotNull PsiElement node2) {
        if (node1 == null) {
            NodeSpecificHasherBase.b(7);
        }
        if (node2 == null) {
            NodeSpecificHasherBase.b(8);
        }
        return false;
    }

    @Override
    public boolean areTreesEqual(@NotNull PsiElement root1, @NotNull PsiElement root2, int discardCost) {
        if (root1 == null) {
            NodeSpecificHasherBase.b(9);
        }
        if (root2 == null) {
            NodeSpecificHasherBase.b(10);
        }
        if (root1 == root2) {
            return true;
        }
        return new DuplicatesMatchingVisitor(this, this.b, discardCost).match(root1, root2);
    }

    @NotNull
    public DuplicatesProfileBase getDuplicatesProfile() {
        DuplicatesProfileBase duplicatesProfileBase = this.d;
        if (duplicatesProfileBase == null) {
            NodeSpecificHasherBase.b(11);
        }
        return duplicatesProfileBase;
    }

    @Override
    public boolean checkDeep(PsiElement node1, PsiElement node2) {
        return true;
    }

    @Override
    public void visitNode(@NotNull PsiElement node2) {
        FileType fileType;
        if (node2 == null) {
            NodeSpecificHasherBase.b(12);
        }
        Language language = null;
        if (node2 instanceof PsiFile && (fileType = ((PsiFile)node2).getFileType()) instanceof LanguageFileType) {
            language = ((LanguageFileType)fileType).getLanguage();
        }
        if (language == null) {
            language = node2.getLanguage();
        }
        if ((this.myForIndexing || this.c.SELECTED_PROFILES.contains(language.getDisplayName())) && this.d.isMyLanguage(language)) {
            this.a.hash(node2, this);
        }
    }

    @Override
    public void hashingFinished() {
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        long l2 = f ^ 0x2F02266AE988L;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 6: 
            case 11: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "duplicatesProfile";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node1";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node2";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root2";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/treeHash/NodeSpecificHasherBase";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodeFilter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDuplicatesProfile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: 
            case 11: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "areNodesEqual";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "areTreesEqual";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitNode";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

