/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.settings;

import com.intellij.DynamicBundle;
import com.intellij.facet.impl.ui.FacetErrorPanel;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.ValidationResult;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.JoomlaExtensionType;
import com.jetbrains.php.joomla.JoomlaUtil;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JoomlaSettingsPanel
extends JPanel {
    private JPanel myMainPanel;
    private TextFieldWithBrowseButton myJoomlaPathField;
    private JPanel myErrorPanel;
    private ComboBox<JoomlaExtensionType> myVersionComboBox;
    private JBLabel myVersionLabel;
    private TextFieldWithBrowseButton myJoomlaConfigPathField;
    private FacetErrorPanel myFacetErrorPanel;
    private boolean myEnabled;
    private final Project myProject;

    public JoomlaSettingsPanel(@Nullable Project project, boolean internalValidation, boolean onCreate) {
        super(new BorderLayout());
        this.myProject = project;
        this.$$$setupUI$$$();
        this.add(this.myMainPanel);
        EnumComboBoxModel model = new EnumComboBoxModel(JoomlaExtensionType.class);
        if (!onCreate) {
            this.myVersionComboBox.setVisible(false);
            this.myVersionLabel.setVisible(false);
        }
        this.myVersionComboBox.setModel((ComboBoxModel)model);
        this.myVersionComboBox.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((String)"", value -> value.getText()));
        FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myJoomlaPathField.addBrowseFolderListener(JoomlaBundle.message("joomla.settings.select.joomla.directory", new Object[0]), JoomlaBundle.message("joomla.settings.select.joomla.root.directory", new Object[0]), project, folderDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor();
        this.myJoomlaConfigPathField.addBrowseFolderListener(JoomlaBundle.message("joomla.settings.select.joomla.config", new Object[0]), JoomlaBundle.message("joomla.settings.select.joomla.config.description", new Object[0]), project, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT);
        this.myEnabled = this.isEnabled();
        if (internalValidation) {
            this.initErrorValidation();
        }
    }

    private void initErrorValidation() {
        this.myFacetErrorPanel = new FacetErrorPanel();
        this.myErrorPanel.add((Component)this.myFacetErrorPanel.getComponent(), "Center");
        this.myFacetErrorPanel.getValidatorsManager().registerValidator(new FacetEditorValidator(){

            @NotNull
            public ValidationResult check() {
                String result = JoomlaSettingsPanel.this.getValidationMessage();
                if (result != null) {
                    return new ValidationResult(result);
                }
                ValidationResult validationResult = ValidationResult.OK;
                if (validationResult == null) {
                    1.$$$reportNull$$$0(0);
                }
                return validationResult;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/joomla/settings/JoomlaSettingsPanel$1", "check"));
            }
        }, new JComponent[]{this.myJoomlaPathField.getTextField(), this.myJoomlaConfigPathField.getTextField(), this.myVersionComboBox});
        this.myFacetErrorPanel.getValidatorsManager().validate();
    }

    @Nullable
    @NlsContexts.DialogMessage
    public String getValidationMessage() {
        if (!this.myEnabled) {
            return null;
        }
        String result = JoomlaUtil.validateJoomlaFolder(this.myJoomlaPathField.getText());
        if (result != null) {
            return result;
        }
        result = JoomlaUtil.validateJoomlaConfigFile(this.myProject, this.myJoomlaConfigPathField.getText());
        if (result != null) {
            return result;
        }
        return null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myEnabled = enabled;
        if (this.myFacetErrorPanel != null) {
            this.myFacetErrorPanel.getValidatorsManager().validate();
        }
    }

    @Nullable
    public JComponent createMainPanel() {
        return this.myMainPanel;
    }

    public boolean isModified(JoomlaDataService service) {
        if (!Comparing.strEqual((String)this.myJoomlaPathField.getText(), (String)service.getJoomlaPath())) {
            return true;
        }
        if (!Comparing.strEqual((String)this.myJoomlaConfigPathField.getText(), (String)service.getJoomlaConfigPath())) {
            return true;
        }
        JoomlaExtensionType oldExtensionType = service.getJoomlaExtensionType();
        JoomlaExtensionType currentExtensionType = (JoomlaExtensionType)((Object)this.myVersionComboBox.getSelectedItem());
        if (oldExtensionType == null && currentExtensionType == null) {
            return false;
        }
        return oldExtensionType != currentExtensionType;
    }

    public void apply(JoomlaDataService.State state) {
        state.setJoomlaPath(this.myJoomlaPathField.getText());
        state.setJoomlaConfigPath(this.myJoomlaConfigPathField.getText());
        state.setJoomlaExtensionType((JoomlaExtensionType)((Object)this.myVersionComboBox.getSelectedItem()));
    }

    public void reset(JoomlaDataService service) {
        this.myJoomlaPathField.setText(service.getJoomlaPath());
        this.myJoomlaConfigPathField.setText(service.getJoomlaConfigPath());
        this.myVersionComboBox.setSelectedItem((Object)service.getJoomlaExtensionType());
    }

    public void setPath(@NlsSafe String path) {
        this.myJoomlaPathField.setText(path);
    }

    public void setJoomlaConfigPathField(@NlsSafe String path) {
        this.myJoomlaConfigPathField.setText(path);
    }

    public void addComponentChangesListener(final Runnable listener, final String joomlaConfigPath) {
        this.myJoomlaPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                VirtualFile relativePath;
                VirtualFile file;
                String myJoomlaConfigPathFieldText;
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (((myJoomlaConfigPathFieldText = JoomlaSettingsPanel.this.myJoomlaConfigPathField.getText()).isEmpty() || myJoomlaConfigPathFieldText.equals(joomlaConfigPath)) && (file = LocalFileSystem.getInstance().findFileByPath(JoomlaSettingsPanel.this.myJoomlaPathField.getText())) != null && (relativePath = file.findFileByRelativePath("configuration.php")) != null) {
                    JoomlaSettingsPanel.this.myJoomlaConfigPathField.getTextField().setText(relativePath.getPath());
                }
                listener.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/settings/JoomlaSettingsPanel$2", "textChanged"));
            }
        });
        this.myJoomlaConfigPathField.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    3.$$$reportNull$$$0(0);
                }
                listener.run();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/php/joomla/settings/JoomlaSettingsPanel$3", "textChanged"));
            }
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JBLabel jBLabel;
        ComboBox comboBox;
        JPanel jPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel2;
        this.myMainPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myJoomlaPathField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/JoomlaBundle", JoomlaSettingsPanel.class).getString("label.joomla.installation.path"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myErrorPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel2.add((Component)jPanel, new GridConstraints(3, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        this.myVersionComboBox = comboBox = new ComboBox();
        jPanel2.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 2, 0, new Dimension(50, -1), null, null));
        this.myVersionLabel = jBLabel = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel, DynamicBundle.getBundle((String)"messages/JoomlaBundle", JoomlaSettingsPanel.class).getString("label.project.type"));
        jPanel2.add((Component)jBLabel, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        this.$$$loadLabelText$$$((JLabel)jBLabel2, DynamicBundle.getBundle((String)"messages/JoomlaBundle", JoomlaSettingsPanel.class).getString("label.path.to.jconfig"));
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myJoomlaConfigPathField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel2.add((Component)textFieldWithBrowseButton, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 0, null, null, null));
        jLabel.setLabelFor((Component)textFieldWithBrowseButton2);
        jBLabel.setLabelFor((Component)comboBox);
        jBLabel2.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

