/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.settings;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.joomla.JoomlaExtensionType;
import com.jetbrains.php.joomla.init.JoomlaContentConfigurationManager;
import com.jetbrains.php.joomla.init.JoomlaFileTemplatesManager;
import com.jetbrains.php.joomla.init.JoomlaFormattingManager;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@com.intellij.openapi.components.State(name="JoomlaConfiguration", storages={@Storage(value="$WORKSPACE_FILE$")})
public class JoomlaDataService
implements PersistentStateComponent<State> {
    public static final String JOS = "jos_";
    public static final String PREFIX = "#__";
    private static final String JOOMLA_PATH_PROPERTY = "joomla.support.joomlaPath";
    private static final String JOOMLA_PATH_CONFIG_PROPERTY = "joomla.support.joomlaConfigPath";
    public static final String J_DATABASE_QUERY = "\\JDatabaseQuery";
    public static final String J_DATABASE_DRIVER = "\\JDatabaseDriver";
    public static final String DATABASE_QUERY = "\\Joomla\\Database\\DatabaseQuery";
    public static final String DATABASE_DRIVER = "\\Joomla\\Database\\DatabaseDriver";
    @NotNull
    private final Project myProject;
    private boolean isEnabled;
    private boolean myDoNotAskAgain;
    private boolean myDoNotAskContentConfigurationAgain;
    private String myJoomlaPath;
    private String myJoomlaConfigPath;
    private JoomlaExtensionType myJoomlaExtensionType;

    public JoomlaDataService(@NotNull Project project) {
        if (project == null) {
            JoomlaDataService.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public boolean doNotAskAgain() {
        return this.myDoNotAskAgain;
    }

    public static JoomlaDataService getInstance(Project project) {
        return (JoomlaDataService)ServiceManager.getService((Project)project, JoomlaDataService.class);
    }

    public static String getDbPrefix(Project project) {
        PsiElement defaultValue;
        Field dbPrefix;
        PhpClass configClass = JoomlaContentConfigurationManager.getInstance().getConfigurationClass(project);
        if (configClass != null && (dbPrefix = configClass.findFieldByName((CharSequence)"dbprefix", false)) != null && (defaultValue = dbPrefix.getDefaultValue()) != null) {
            return PhpCodeInsightUtil.toString((PsiElement)defaultValue);
        }
        return JOS;
    }

    @Nullable
    public static String getLastJoomlaPath() {
        return PropertiesComponent.getInstance().getValue(JOOMLA_PATH_PROPERTY);
    }

    @Nullable
    public State getState() {
        return new State(this.isEnabled, this.myJoomlaPath, this.myJoomlaConfigPath, this.myDoNotAskAgain, this.myDoNotAskContentConfigurationAgain);
    }

    public void setEnabled(boolean enabled) {
        this.isEnabled = enabled;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            JoomlaDataService.$$$reportNull$$$0(1);
        }
        this.isEnabled = state.isEnabled();
        this.myJoomlaPath = state.getJoomlaPath();
        this.myJoomlaConfigPath = state.getJoomlaConfigPath();
        this.myDoNotAskAgain = state.isDoNotAskAgain();
        this.myJoomlaExtensionType = state.getJoomlaExtensionType();
        this.myDoNotAskContentConfigurationAgain = state.isDoNotAskContentConfigAgain();
    }

    public void setDoNotAskContentConfigurationAgain(boolean doNotAskContentConfigurationAgain) {
        this.myDoNotAskContentConfigurationAgain = doNotAskContentConfigurationAgain;
    }

    public void setState(State state) {
        State oldState = this.getState();
        this.loadState(state);
        this.notifyListeners(state, oldState);
    }

    private void notifyListeners(State newState, State oldState) {
        if (newState.equals(oldState)) {
            return;
        }
        JoomlaContentConfigurationManager.getInstance().refreshIncludePaths(newState, this.myProject);
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            JoomlaFormattingManager.offerJoomlaFormatting(newState, oldState, this.myProject);
        }
        JoomlaFileTemplatesManager myTemplatesManager = new JoomlaFileTemplatesManager(this.myProject);
        myTemplatesManager.offerJoomlaFileTemplates(newState, oldState);
    }

    @NlsSafe
    public String getJoomlaPath() {
        return this.myJoomlaPath;
    }

    @NlsSafe
    public String getJoomlaConfigPath() {
        return this.myJoomlaConfigPath;
    }

    public void setDoNotAskAgain(boolean doNotAskAgain) {
        this.myDoNotAskAgain = doNotAskAgain;
    }

    public JoomlaExtensionType getJoomlaExtensionType() {
        return this.myJoomlaExtensionType;
    }

    public static String getLastJoomlaConfigPath() {
        return PropertiesComponent.getInstance().getValue(JOOMLA_PATH_CONFIG_PROPERTY);
    }

    public static boolean isDbDriverClass(@Nullable PhpClass phpClass) {
        return phpClass != null && (phpClass.getFQN().equals(J_DATABASE_DRIVER) || phpClass.getFQN().equals(DATABASE_DRIVER));
    }

    public static boolean isQueryClass(@Nullable PhpClass phpClass) {
        return phpClass != null && (phpClass.getFQN().equals(J_DATABASE_QUERY) || phpClass.getFQN().equals(DATABASE_QUERY));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/php/joomla/settings/JoomlaDataService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @Tag
    public static class State {
        private boolean isEnabled;
        private String myJoomlaPath;
        private String myJoomlaConfigPath;
        private boolean myDoNotAskAgain;
        private boolean myDoNotAskContentConfigAgain;
        private JoomlaExtensionType myJoomlaExtensionType;

        public State() {
        }

        public State(boolean enabled, String joomlaPath, String joomlaConfigPath, boolean doNotAskAgain, boolean doNotAskContentConfigAgain) {
            this.isEnabled = enabled;
            this.myJoomlaPath = joomlaPath;
            this.myJoomlaConfigPath = joomlaConfigPath;
            this.myDoNotAskAgain = doNotAskAgain;
            this.myDoNotAskContentConfigAgain = doNotAskContentConfigAgain;
        }

        @Attribute(value="enabled")
        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setEnabled(boolean enabled) {
            this.isEnabled = enabled;
        }

        @Tag(value="joomlaPath")
        public String getJoomlaPath() {
            return this.myJoomlaPath;
        }

        public void setJoomlaPathPath(String joomlaPath) {
            this.myJoomlaPath = joomlaPath;
        }

        @Tag(value="joomlaConfigPath")
        public String getJoomlaConfigPath() {
            return this.myJoomlaConfigPath;
        }

        public void setJoomlaConfigPath(String joomlaConfigPath) {
            this.myJoomlaConfigPath = joomlaConfigPath;
            if (!StringUtil.isEmptyOrSpaces((String)this.myJoomlaConfigPath)) {
                PropertiesComponent.getInstance().setValue(JoomlaDataService.JOOMLA_PATH_CONFIG_PROPERTY, this.myJoomlaConfigPath);
            }
        }

        @Attribute(value="doNotAskAgain")
        public boolean isDoNotAskAgain() {
            return this.myDoNotAskAgain;
        }

        public void setDoNotAskAgain(boolean doNotAskAgain) {
            this.myDoNotAskAgain = doNotAskAgain;
        }

        @Attribute(value="doNotAskConfigAgain")
        public boolean isDoNotAskContentConfigAgain() {
            return this.myDoNotAskContentConfigAgain;
        }

        @Attribute(value="joomlaExtensionType")
        public JoomlaExtensionType getJoomlaExtensionType() {
            return this.myJoomlaExtensionType;
        }

        public void setJoomlaExtensionType(JoomlaExtensionType joomlaExtensionType) {
            this.myJoomlaExtensionType = joomlaExtensionType;
        }

        public void setDoNotAskContentConfigAgain(boolean doNotAskContentConfigAgain) {
            this.myDoNotAskContentConfigAgain = doNotAskContentConfigAgain;
        }

        public void setJoomlaPath(String joomlaPath) {
            this.myJoomlaPath = joomlaPath;
            if (!StringUtil.isEmptyOrSpaces((String)this.myJoomlaPath)) {
                PropertiesComponent.getInstance().setValue(JoomlaDataService.JOOMLA_PATH_PROPERTY, this.myJoomlaPath);
            }
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.isEnabled == state.isEnabled && this.myDoNotAskAgain == state.myDoNotAskAgain && this.myDoNotAskContentConfigAgain == state.myDoNotAskContentConfigAgain && Objects.equals(this.myJoomlaPath, state.myJoomlaPath) && Objects.equals(this.myJoomlaConfigPath, state.myJoomlaConfigPath) && this.myJoomlaExtensionType == state.myJoomlaExtensionType;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.isEnabled, this.myJoomlaPath, this.myJoomlaConfigPath, this.myDoNotAskAgain, this.myDoNotAskContentConfigAgain, this.myJoomlaExtensionType});
        }
    }
}

