/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.jetbrains.php.joomla.JoomlaBundle;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.documentation.phpdoc.PhpDocUtil;
import com.jetbrains.php.lang.documentation.phpdoc.psi.PhpDocComment;
import com.jetbrains.php.lang.inspections.PhpInspection;
import com.jetbrains.php.lang.psi.elements.Field;
import com.jetbrains.php.lang.psi.elements.Function;
import com.jetbrains.php.lang.psi.elements.Method;
import com.jetbrains.php.lang.psi.elements.PhpClass;
import com.jetbrains.php.lang.psi.elements.PhpNamedElement;
import com.jetbrains.php.lang.psi.visitors.PhpElementVisitor;
import org.jetbrains.annotations.NotNull;

public class MissingSinceTagDocInspection
extends PhpInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            MissingSinceTagDocInspection.$$$reportNull$$$0(0);
        }
        JoomlaDataService service = JoomlaDataService.getInstance(holder.getProject());
        final boolean serviceEnabled = service.isEnabled();
        return new PhpElementVisitor(){

            public void visitPhpFunction(Function function) {
                this.checkElement((PhpNamedElement)function, holder, JoomlaBundle.message("joomla.inspection.missing.since.tag.function", new Object[0]));
            }

            public void visitPhpMethod(Method method) {
                this.checkElement((PhpNamedElement)method, holder, JoomlaBundle.message("joomla.inspection.missing.since.tag.method", new Object[0]));
            }

            public void visitPhpField(Field field) {
                this.checkElement((PhpNamedElement)field, holder, JoomlaBundle.message("joomla.inspection.missing.since.tag.property", new Object[0]));
            }

            public void visitPhpClass(PhpClass clazz) {
                this.checkElement((PhpNamedElement)clazz, holder, JoomlaBundle.message("joomla.inspection.missing.since.tag.class", new Object[0]));
            }

            private void checkElement(PhpNamedElement namedElement, ProblemsHolder holder2, @InspectionMessage String message) {
                if (!serviceEnabled) {
                    return;
                }
                PhpDocComment docComment = namedElement.getDocComment();
                if (docComment != null && !PhpDocUtil.hasDocTagWithName((PhpDocComment)docComment, (String)"@since")) {
                    holder2.registerProblem((PsiElement)docComment, message, new LocalQuickFix[0]);
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/jetbrains/php/joomla/inspections/MissingSinceTagDocInspection", "buildVisitor"));
    }
}

