/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.joomla.injection.builder;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.php.codeInsight.PhpCodeInsightUtil;
import com.jetbrains.php.codeInsight.PhpScopeHolder;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlow;
import com.jetbrains.php.codeInsight.controlFlow.PhpControlFlowUtil;
import com.jetbrains.php.codeInsight.controlFlow.PhpInstructionProcessor;
import com.jetbrains.php.codeInsight.controlFlow.instructions.PhpCallInstruction;
import com.jetbrains.php.joomla.injection.JDatabaseQueryInjector;
import com.jetbrains.php.joomla.injection.JoomlaSQLCaches;
import com.jetbrains.php.joomla.injection.builder.JDatabaseQuery;
import com.jetbrains.php.joomla.injection.builder.JDbQueryElement;
import com.jetbrains.php.joomla.settings.JoomlaDataService;
import com.jetbrains.php.lang.parser.PhpElementTypes;
import com.jetbrains.php.lang.psi.PhpPsiUtil;
import com.jetbrains.php.lang.psi.elements.ArrayCreationExpression;
import com.jetbrains.php.lang.psi.elements.ConcatenationExpression;
import com.jetbrains.php.lang.psi.elements.FunctionReference;
import com.jetbrains.php.lang.psi.elements.MethodReference;
import com.jetbrains.php.lang.psi.elements.PhpExpression;
import com.jetbrains.php.lang.psi.elements.PhpReference;
import com.jetbrains.php.lang.psi.elements.StringLiteralExpression;
import com.jetbrains.php.lang.psi.elements.impl.MemberReferenceImpl;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JDbQueryAnalyzer {
    public static final JDbQueryAnalyzer INSTANCE = new JDbQueryAnalyzer();
    private static final Condition<PsiElement> ARRAY_VALUE = element -> PhpPsiUtil.isOfType((PsiElement)element, (IElementType)PhpElementTypes.ARRAY_VALUE);

    public JDatabaseQuery doQuery(final @NotNull MethodReference reference) {
        JDatabaseQuery cachedQuery;
        if (reference == null) {
            JDbQueryAnalyzer.$$$reportNull$$$0(0);
        }
        final JDatabaseQuery query = new JDatabaseQuery();
        if (MemberReferenceImpl.getDepth((PhpExpression)reference) == 100) {
            return query;
        }
        PhpExpression classReference = this.getQueryBuilderClassReference(reference);
        PsiElement declaration = this.getDeclaration(classReference);
        JDatabaseQuery jDatabaseQuery = cachedQuery = declaration != null ? JoomlaSQLCaches.getInstance((Project)reference.getProject()).SQL_CACHE.get(declaration) : null;
        if (cachedQuery == null) {
            PhpScopeHolder scopeHolder = PhpPsiUtil.getScopeHolder((PsiElement)reference);
            if (scopeHolder != null) {
                PhpControlFlowUtil.processFlow((PhpControlFlow)scopeHolder.getControlFlow(), (PhpInstructionProcessor)new PhpInstructionProcessor(){

                    public boolean processPhpCallInstruction(PhpCallInstruction instruction) {
                        FunctionReference functionReference = instruction.getFunctionReference();
                        if (functionReference instanceof MethodReference && JDatabaseQueryInjector.isQueryClassMethodReference((MethodReference)functionReference)) {
                            String name;
                            MethodReference methodReference = (MethodReference)functionReference;
                            PhpExpression classRef = JDbQueryAnalyzer.this.getQueryBuilderClassReference(methodReference);
                            PsiElement declaration1 = JDbQueryAnalyzer.this.getDeclaration(classRef);
                            PhpExpression classRef1 = JDbQueryAnalyzer.this.getQueryBuilderClassReference(reference);
                            PsiElement declaration2 = JDbQueryAnalyzer.this.getDeclaration(classRef1);
                            if (declaration1 != null && declaration1.equals(declaration2) && (name = methodReference.getName()) != null) {
                                JDbQueryElement set;
                                JDbQueryElement update;
                                PsiElement[] parameters;
                                if (name.equalsIgnoreCase("from") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.setFrom(new JDbQueryElement("from", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("join") && (parameters = methodReference.getParameters()).length > 1) {
                                    String text = parameters[0].getText();
                                    query.addJoin(new JDbQueryElement(text.substring(1, text.length() - 1) + " join", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[1]))));
                                }
                                if (name.equalsIgnoreCase("innerjoin") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.addJoin(new JDbQueryElement("inner join", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("outerjoin") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.addJoin(new JDbQueryElement("outer join", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("leftjoin") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.addJoin(new JDbQueryElement("left join", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("rightjoin") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.addJoin(new JDbQueryElement("right join", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("select") && (parameters = methodReference.getParameters()).length > 0) {
                                    if (query.getSelect() == null) {
                                        query.setSelect(new JDbQueryElement("select", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                    } else {
                                        query.getSelect().myElements.add(new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0])));
                                    }
                                }
                                if (name.equalsIgnoreCase("columns") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.setColumns(new JDbQueryElement("()", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("insert") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.setInsert(new JDbQueryElement("insert into", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("values") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.setValues(new JDbQueryElement("()", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("where") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.setWhere(new JDbQueryElement("where", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("delete") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.setDelete(new JDbQueryElement("delete"));
                                    query.setFrom(new JDbQueryElement("from", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("order") && (parameters = methodReference.getParameters()).length > 0) {
                                    query.setOrder(new JDbQueryElement("order by", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("group") && (parameters = methodReference.getParameters()).length > 0) {
                                    JDbQueryElement group = query.getGroup();
                                    if (group != null) {
                                        group.myElements.add(new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0])));
                                    } else {
                                        query.setGroup(new JDbQueryElement("group by", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                    }
                                }
                                if (name.equalsIgnoreCase("update") && (parameters = methodReference.getParameters()).length > 0 && (update = query.getUpdate()) == null) {
                                    query.setUpdate(new JDbQueryElement("update", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                                if (name.equalsIgnoreCase("set") && (parameters = methodReference.getParameters()).length > 0 && (set = query.getSet()) == null) {
                                    query.setSet(new JDbQueryElement("set", new JDbQueryElement(JDbQueryAnalyzer.convertToNames(parameters[0]))));
                                }
                            }
                        }
                        return true;
                    }
                });
            }
            if (declaration != null) {
                JoomlaSQLCaches.getInstance((Project)reference.getProject()).SQL_CACHE.put(declaration, query);
            }
            return query;
        }
        return cachedQuery;
    }

    @Nullable
    public PsiElement getDeclaration(@Nullable PhpExpression classReference) {
        Object declaration = classReference instanceof PhpReference ? ((PhpReference)classReference).resolve() : classReference;
        return declaration;
    }

    @Nullable
    public PhpExpression getQueryBuilderClassReference(@NotNull MethodReference reference) {
        if (reference == null) {
            JDbQueryAnalyzer.$$$reportNull$$$0(1);
        }
        PhpExpression classReferenceExpression = reference.getClassReference();
        while (classReferenceExpression instanceof MethodReference && JDatabaseQueryInjector.isQueryClassMethodReference((MethodReference)classReferenceExpression)) {
            classReferenceExpression = ((MethodReference)classReferenceExpression).getClassReference();
        }
        return classReferenceExpression;
    }

    private static String convertToNames(PsiElement parameter) {
        if ((parameter = JDbQueryAnalyzer.unwrapQuoteMethod(parameter)) instanceof ArrayCreationExpression) {
            ArrayCreationExpression arrayCreationExpression = (ArrayCreationExpression)parameter;
            return PhpPsiUtil.getChildren((PsiElement)arrayCreationExpression, ARRAY_VALUE).stream().map(i -> PhpCodeInsightUtil.toString((PsiElement)i.getFirstChild())).collect(Collectors.joining(", "));
        }
        if (parameter instanceof ConcatenationExpression) {
            PsiElement rightOperand = ((ConcatenationExpression)parameter).getRightOperand();
            PsiElement leftOperand = ((ConcatenationExpression)parameter).getLeftOperand();
            return JDbQueryAnalyzer.convertToNames(leftOperand) + JDbQueryAnalyzer.convertToNames(rightOperand);
        }
        return JDbQueryAnalyzer.convertToTableNamesSingle(parameter);
    }

    private static PsiElement unwrapQuoteMethod(PsiElement parameter) {
        PsiElement firstParameter;
        if (parameter instanceof MethodReference && JDatabaseQueryInjector.isDbDriverQuote((MethodReference)parameter) && (firstParameter = ((MethodReference)parameter).getParameter(0)) != null) {
            return firstParameter;
        }
        return parameter;
    }

    private static String convertToTableNamesSingle(PsiElement parameter) {
        if ((parameter = JDbQueryAnalyzer.unwrapQuoteMethod(parameter)) instanceof StringLiteralExpression) {
            String string = PhpCodeInsightUtil.toString((PsiElement)parameter);
            return string != null ? string.replaceAll("#__", JoomlaDataService.getDbPrefix(parameter.getProject())) : "";
        }
        if (parameter != null) {
            return "${" + parameter.getText() + "}";
        }
        return "${}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "reference";
        objectArray2[1] = "com/jetbrains/php/joomla/injection/builder/JDbQueryAnalyzer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doQuery";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getQueryBuilderClassReference";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

